/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.nfa.restful.model.ApiKeyObject;
import com.huawei.atic.secservice.nfa.restful.model.BgpObject;
import com.huawei.atic.secservice.nfa.restful.model.BinLogObject;
import com.huawei.atic.secservice.nfa.restful.model.ClusterComKey;
import com.huawei.atic.secservice.nfa.restful.model.ClusterObject;
import com.huawei.atic.secservice.nfa.restful.model.DefinedFilter;
import com.huawei.atic.secservice.nfa.restful.model.DelayTimeObject;
import com.huawei.atic.secservice.nfa.restful.model.DiverterObject;
import com.huawei.atic.secservice.nfa.restful.model.FlowObject;
import com.huawei.atic.secservice.nfa.restful.model.FlowspecObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaBaselineObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.OutboundObject;
import com.huawei.atic.secservice.nfa.restful.model.PeerObject;
import com.huawei.atic.secservice.nfa.restful.model.RequestObject;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.model.SnmpObject;
import com.huawei.atic.secservice.nfa.restful.model.SyslogObject;
import com.huawei.atic.secservice.nfa.restful.model.ZoneInfoObject;
import com.huawei.atic.secservice.nfa.restful.model.ZoneIpObject;
import com.huawei.atic.secservice.nfa.restful.model.ZonePolicyObject;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import com.huawei.atic.secservice.nfa.restful.util.HttpsClient;
import com.huawei.atic.util.CommonUtil;
import java.io.IOException;

public class RestfulNfaServiceImpl
implements IRestfulNfaService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REST_NFA);
    private HttpsClient httpsClient = HttpsClient.getInstance();
    private IAticDeviceService aticDeviceService;
    private IDataProtectService dataProtectService;

    @Override
    public Result addZoneOnNFA(ZoneInfoObject zoneInfoObject, NfaInfoForm nfaInfoForm) {
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_info");
        requestObject.setOperation("add");
        requestObject.setData(zoneInfoObject);
        Result result = null;
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            result = new Result();
            if (e.getMessage().contains("Connection timed out: connect")) {
                result.setJson("Connection timed out: connect");
            } else {
                result.setJson(e.getMessage());
            }
            this.logger.error((Object)("addZoneOnNFA method is exception," + e));
        }
        return result;
    }

    @Override
    public Result anthApiKeyOnNfa(NfaInfoForm nfaInfoForm) {
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("version");
        Result result = null;
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            result = new Result();
            if (e.getMessage().contains("Connection timed out: connect")) {
                result.setJson("Connection timed out");
            } else {
                result.setJson(e.getMessage());
            }
            this.logger.error((Object)("anthApiKeyOnNfa method is exception," + e));
        }
        return result;
    }

    @Override
    public Result deleteZoneOnNFA(ZoneInfoObject zoneInfoObject, NfaInfoForm nfaInfoForm) {
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_info");
        requestObject.setOperation("delete");
        requestObject.setData(zoneInfoObject);
        Result result = null;
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            result = new Result();
            if (e.getMessage().contains("Connection timed out: connect")) {
                result.setJson("Connection timed out: connect");
            } else {
                result.setJson(e.getMessage());
            }
            this.logger.error((Object)("deleteZoneOnNFA method is exception," + e));
        }
        return result;
    }

    @Override
    public Result deleteAllZoneOnNFA(NfaInfoForm nfaInfoForm) {
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_info");
        requestObject.setOperation("deleteAll");
        requestObject.setData(null);
        Result result = null;
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("DeleteAllZoneOnNFA method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result modifyZoneOnNFA(ZoneInfoObject zoneInfoObject, NfaInfoForm nfaInfoForm) {
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_info");
        requestObject.setOperation("modify");
        requestObject.setData(zoneInfoObject);
        Result result = null;
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("modifyZoneOnNFA method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaFlowConfig(FlowObject[] flowObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("flow_src");
        requestObject.setOperation("modify");
        requestObject.setData(flowObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaFlowConfig method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaSnmpConfig(SnmpObject snmpObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        this.sdpDecryptSnmp(snmpObject);
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("snmp");
        requestObject.setOperation("modify");
        requestObject.setData(snmpObject);
        nfaInfoForm.setUrlPost("/restapi/system/config/post");
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaSnmpConfig method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    private void sdpDecryptSnmp(SnmpObject snmpObject) {
        if (null != snmpObject.getReadCommunity() && !"".equals(snmpObject.getReadCommunity())) {
            snmpObject.setReadCommunity(DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpObject.getReadCommunity()).toString());
        }
        if (null != snmpObject.getWriteCommunity() && !"".equals(snmpObject.getWriteCommunity())) {
            snmpObject.setWriteCommunity(DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpObject.getWriteCommunity()).toString());
        }
        if (null != snmpObject.getV3EncryKey() && !"".equals(snmpObject.getV3EncryKey())) {
            snmpObject.setV3EncryKey(DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpObject.getV3EncryKey()).toString());
        }
        if (null != snmpObject.getV3AuthKey() && !"".equals(snmpObject.getV3AuthKey())) {
            snmpObject.setV3AuthKey(DataProtectServiceConst.sdpDecryptLocalBuffer((String)snmpObject.getV3AuthKey()).toString());
        }
    }

    @Override
    public Result restNfaSyslogConfig(SyslogObject syslogObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("syslog");
        requestObject.setOperation("modify");
        requestObject.setData(syslogObject);
        nfaInfoForm.setUrlPost("/restapi/system/config/post");
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaSyslogConfig method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaZonePolicy(ZonePolicyObject zonePolicyObject, NfaInfoForm nfaInfoForm) {
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_policy");
        requestObject.setOperation("modify");
        requestObject.setData(zonePolicyObject);
        Result result = null;
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            result = new Result();
            if (e.getMessage().contains("Connection timed out: connect")) {
                result.setJson("Connection timed out: connect");
            } else {
                result.setJson(e.getMessage());
            }
            this.logger.error((Object)("restNfaZonePolicy method is exception," + e));
        }
        return result;
    }

    @Override
    public Result restNfaAddDefinedFilter(DefinedFilter definedFilter, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("filter");
        requestObject.setOperation("add");
        requestObject.setData(definedFilter);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaAddDefinedFilter method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaDelDefinedFilter(DefinedFilter definedFilter, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("filter");
        requestObject.setOperation("delete");
        requestObject.setData(definedFilter);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaDelDefinedFilter method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaModifyDefinedFilter(DefinedFilter definedFilter, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("filter");
        requestObject.setOperation("delete");
        requestObject.setData(definedFilter);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaModifyDefinedFilter method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaAddZoneIp(ZoneIpObject zoneIpObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_ip");
        requestObject.setOperation("add");
        requestObject.setData(zoneIpObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)"restNfaAddZoneIp method is exception", (Throwable)e);
        }
        if (null == result) {
            return new Result();
        }
        return result;
    }

    @Override
    public Result restNfaDelZoneIp(ZoneIpObject zoneIpObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_ip");
        requestObject.setOperation("delete");
        requestObject.setData(zoneIpObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaDelZoneIp method is exception," + e));
        }
        if (null == result) {
            return new Result();
        }
        return result;
    }

    @Override
    public Result restNfaDelALLZoneIp(ZoneInfoObject zoneInfoObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_ip");
        requestObject.setOperation("deleteAll");
        requestObject.setData(zoneInfoObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaDelZoneIp method is exception," + e));
        }
        if (null == result) {
            return new Result();
        }
        return result;
    }

    @Override
    public Result restNfaConfBinLog(BinLogObject binLogObject, NfaInfoForm nfaInfoForm) {
        AticDevice device;
        Result result = null;
        if (nfaInfoForm.getFlag().booleanValue() && null != (device = this.aticDeviceService.getDeviceByMoid(nfaInfoForm.getDeviceId()))) {
            StringBuffer logPwdKey = this.dataProtectService.sdpDecrypt(binLogObject.getEncryKey(), 0L);
            if (!CommonUtil.isNewDevice(device)) {
                binLogObject.setEncryKey(logPwdKey.substring(0, 32));
            } else {
                binLogObject.setEncryKey(logPwdKey.toString());
            }
            binLogObject.setEncryptType(binLogObject.getEncryptType());
        }
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("binlog");
        requestObject.setOperation("modify");
        requestObject.setData(binLogObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaConfBinLog method is exception," + e));
        }
        if (null == result) {
            return new Result();
        }
        return result;
    }

    @Override
    public Result restNfaModifyApiKey(ApiKeyObject apiKeyObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        nfaInfoForm.setUrlPost("/restapi/apikey/import");
        apiKeyObject.setUpdateApiKey(DataProtectServiceConst.sdpDecryptLocalBuffer((String)apiKeyObject.getUpdateApiKey()).toString());
        try {
            result = this.httpsClient.doHttpsPost(apiKeyObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaConfBinLog method is exception," + e));
        }
        if (null == result) {
            return new Result();
        }
        return result;
    }

    @Override
    public Result restNfaResetConfig(NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("all");
        requestObject.setOperation("reset");
        nfaInfoForm.setUrlPost("/restapi/system/config/post");
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaResetConfig method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaGetVersion(NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("version");
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaGetVersion method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaGetStatus(NfaInfoForm nfaInfoForm) {
        Result result = null;
        Boolean writeLog = false;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("are_you_ok");
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm, writeLog);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaGetStatus method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaModifyBaseline(NfaBaselineObject baselineObj, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("zone_baseline");
        requestObject.setOperation("modify");
        requestObject.setData(baselineObj);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaModifyBaseline method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaClusterInfo(ClusterObject[] clusterObject, NfaInfoForm nfaInfoForm, String operation) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("cluster_info");
        requestObject.setOperation(operation);
        requestObject.setData(clusterObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaClusterInfo method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaFlowspecObject(NfaInfoForm nfaInfoForm, FlowspecObject flowspecObject) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("diverter_info");
        requestObject.setOperation("modify");
        requestObject.setData(flowspecObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaClusterCommuKey method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaOutboundObject(NfaInfoForm nfaInfoForm, OutboundObject outboundObject) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("outbound_enable");
        requestObject.setOperation("modify");
        requestObject.setData(outboundObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaClusterCommuKey method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaDelayTimeConfig(DelayTimeObject delayTimeObject, NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("abn_delay");
        requestObject.setOperation("modify");
        requestObject.setData(delayTimeObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaDelayTimeConfig method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaClusterCommuKey(NfaInfoForm nfaInfoForm, ClusterComKey clusterKey) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("clusterkey");
        requestObject.setOperation("modify");
        requestObject.setData(clusterKey);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaClusterCommuKey method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaDeleteFlow(NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("flow_src");
        requestObject.setOperation("delete");
        requestObject.setData(null);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaDeleteFlow method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaBgp(NfaInfoForm nfaInfoForm, BgpObject bgpObject) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("bgp_info");
        requestObject.setOperation("add");
        requestObject.setData(bgpObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaClusterCommuKey method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaDeleteBgp(NfaInfoForm nfaInfoForm) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("bgp_info");
        requestObject.setOperation("delete");
        requestObject.setData(null);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaDeleteFlow method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaOutboundDivertTactics(NfaInfoForm nfaInfoForm, DiverterObject[] divertObjects, String operation) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("routing_info");
        requestObject.setOperation(operation);
        requestObject.setData(divertObjects);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaOutboundDivertTactics method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaPeer(NfaInfoForm nfaInfoForm, PeerObject peerObject) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("peer_info");
        requestObject.setOperation("add");
        requestObject.setData(peerObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaClusterCommuKey method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    @Override
    public Result restNfaDeletePeer(NfaInfoForm nfaInfoForm, PeerObject peerObject) {
        Result result = null;
        RequestObject requestObject = new RequestObject();
        requestObject.setConfType("peer_info");
        requestObject.setOperation("delete");
        requestObject.setData(peerObject);
        try {
            result = this.httpsClient.doHttpsPost(requestObject, nfaInfoForm);
        }
        catch (IOException e) {
            this.logger.error((Object)("restNfaDeleteFlow method is exception," + e));
        }
        if (null == result) {
            result = new Result();
        }
        return result;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }
}

