/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.sdk.service.VtyConfigService;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VtyConfigServiceImpl
implements VtyConfigService {
    private static int vtyNum = 3;
    private static long timeOut = 30L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private final String filePath = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "neVTY" + File.separator + "vtyConfig.xml";

    public VtyConfigServiceImpl() {
        this.getConfigData();
    }

    @Override
    public int getVtyNum() {
        return vtyNum;
    }

    @Override
    public long getTimeOut() {
        return timeOut;
    }

    private static void setVtyNumValue(int num) {
        vtyNum = num > 15 ? 15 : num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConfigData() {
        InputStream iStream = null;
        try {
            this.logger.info((Object)"------begin to load vtyConfig.xml-------");
            String pathName = AticInstallUtil.getInstance().getAticInstallPath() + this.filePath;
            Properties properties = new Properties();
            iStream = new FileInputStream(pathName);
            properties.loadFromXML(iStream);
            String vtyNumStr = properties.getProperty("ne.vty.num");
            String timeOutStr = properties.getProperty("ne.vty.timeout");
            int vtyNumInt = Integer.parseInt(vtyNumStr);
            timeOut = Long.parseLong(timeOutStr);
            VtyConfigServiceImpl.setVtyNumValue(vtyNumInt);
            this.logger.info((Object)"------end to load vtyConfig.xml-------");
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"------load vtyConfig.xml  occur exception-------");
        }
        catch (IOException e) {
            this.logger.error((Object)"------load vtyConfig.xml  occur exception-------");
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"------load vtyConfig.xml  occur exception-------");
        }
        finally {
            try {
                if (null != iStream) {
                    iStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"InputStream close is error.");
            }
        }
    }
}

