/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secservice.ddos.restful.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.common.StringUtils;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.ddos.restful.model.RequestURLForm;
import com.huawei.atic.secservice.ddos.restful.model.RestErrorInfo;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import sun.misc.BASE64Encoder;

public class RestDdosUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    private RestDdosUtil() {
    }

    public static String getURI(RequestURLForm requestURIForm) {
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append(requestURIForm.getProtocolType());
        urlBuffer.append(":");
        urlBuffer.append("//");
        urlBuffer.append(requestURIForm.getIpAdress());
        urlBuffer.append(":");
        urlBuffer.append(requestURIForm.getPort());
        urlBuffer.append(requestURIForm.getUrl());
        String url = urlBuffer.toString();
        return url;
    }

    public static String getBASE64Encoder(RequestURLForm requestURIForm) {
        String userName = requestURIForm.getUserName();
        String passWord = requestURIForm.getPassword();
        String msg = userName + ":" + passWord;
        BASE64Encoder encoder = new BASE64Encoder();
        String auth = null;
        try {
            auth = encoder.encode(msg.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"getBASE64Encoder happened error. ", (Throwable)e);
        }
        String base64Code = "Basic " + auth;
        return base64Code;
    }

    public static RequestURLForm getRequestURLForm(AticDevice device) {
        RequestURLForm requestURLForm = new RequestURLForm();
        if (0 == device.getRestfulType()) {
            requestURLForm.setProtocolType("https");
        } else {
            requestURLForm.setProtocolType("http");
        }
        requestURLForm.setIpAdress(device.getRestfulIp());
        requestURLForm.setPort(device.getRestfulPort());
        requestURLForm.setUserName(device.getRestfulUser());
        requestURLForm.setPassword(DataProtectServiceConst.sdpDecryptLocal((String)device.getRestfulPassword()));
        return requestURLForm;
    }

    public static RestErrorInfo translateResult(Result result) throws DocumentException {
        RestErrorInfo errorInfo = new RestErrorInfo();
        if (null != result && !StringUtils.isEmpty(result.getJson())) {
            Document document = null;
            try {
                document = DocumentHelper.parseText((String)result.getJson());
                Element root = document.getRootElement();
                Element interError = root.element("error");
                String errorType = interError.elementText("error-type");
                String errorTag = interError.elementText("error-tag");
                String errorSeverity = interError.elementText("error-severity");
                String errorPath = interError.elementText("error-path");
                String errorMessage = interError.elementText("error-message");
                errorInfo.setErrorType(StringUtils.replaceNulltoBlank(errorType));
                errorInfo.setErrorTag(StringUtils.replaceNulltoBlank(errorTag));
                errorInfo.setErrorSeverity(StringUtils.replaceNulltoBlank(errorSeverity));
                errorInfo.setErrorPath(StringUtils.replaceNulltoBlank(errorPath));
                errorInfo.setErrorMessage(StringUtils.replaceNulltoBlank(errorMessage));
            }
            catch (DocumentException e) {
                logger.error((Object)("translate result happen error, and msg = " + result.getJson()), (Throwable)e);
                throw e;
            }
        }
        return errorInfo;
    }

    public static boolean isOpenRestful(AticDevice device) {
        if (null != device && 1 == device.getDeviceType() && null != device.getRestfulEnable()) {
            return device.getRestfulEnable();
        }
        return false;
    }

    public static boolean isOpenRestful(Long deviceId) {
        ServiceContext serviceContext = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)serviceContext.getService("aticDeviceService", IAticDeviceService.class);
        AticDevice device = aticDeviceService.getDeviceByMoid(deviceId);
        if (null != device && 1 == device.getDeviceType() && null != device.getRestfulEnable()) {
            return device.getRestfulEnable();
        }
        return false;
    }

    public static String packageResultJson(String msg) {
        String xmlDivert = "";
        Document document = DocumentHelper.createDocument();
        Element rootErrors = document.addElement("errors");
        Element error = rootErrors.addElement("error");
        Element errorMessage = error.addElement("error-message");
        errorMessage.setText(msg);
        xmlDivert = document.asXML();
        return xmlDivert;
    }
}

