/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secservice.policyengine.commandengine;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secservice.policyengine.commandbean.Command;
import com.huawei.atic.secservice.policyengine.commandbean.CommandTemplate;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import com.huawei.atic.secservice.policyengine.commandutil.CommandUtil;
import com.huawei.atic.secservice.policyengine.commandutil.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandTranslate {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private CommandUtil commandUtil = new CommandUtil();

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public List<String> translate(CommandTemplate commandTemplateBean, List<CmdParam> paramList) {
        LOGGER.info((Object)"Enter CommandTranslate.translate : ");
        HashMap tempMap = null;
        String cliStr = "";
        ArrayList<String> cliList = new ArrayList<String>();
        Command commandBean = null;
        for (int i = 0; i < paramList.size(); ++i) {
            CmdParam cmdParam = paramList.get(i);
            String cmdID = cmdParam.getCmdID();
            if (cmdID == null || cmdID.trim().equals("")) {
                LOGGER.info((Object)"cmdId is null");
                throw new ParseException(200, "cmdId is null or empty");
            }
            commandBean = commandTemplateBean.getCommand(cmdID);
            if (commandBean == null) {
                LOGGER.info((Object)("Template item ID is not exist in the template : " + cmdID));
                throw new ParseException(200, "Template item ID is not exist in the template : " + cmdID);
            }
            LOGGER.info((Object)("cmdId : " + cmdID + "cmdParams passed in : " + this.getcleanedMessage(cmdParam.getParams().toString())));
            Map<String, String> params = cmdParam.getParams();
            if (!(params instanceof HashMap)) {
                LOGGER.error((Object)"params is not HashMap.");
                continue;
            }
            tempMap = (HashMap)params;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (Map.Entry entry : tempMap.entrySet()) {
                String tempKey = ((String)entry.getKey()).toLowerCase(Locale.ENGLISH);
                paramMap.put(tempKey, (String)entry.getValue());
            }
            LOGGER.info((Object)("paramsMap after lowercase : " + this.getcleanedMessage(((Object)paramMap).toString())));
            LOGGER.info((Object)("current template item : " + this.getcleanedMessage(commandBean.getCommandContent())));
            cliStr = this.translateCommand(commandBean, paramMap);
            cliStr = this.dealLineSeparator(cliStr);
            cliStr = this.dealHiddenSytem(cliStr);
            cliStr = this.dealHiddenView(cliStr);
            if ("".equals(cliStr.trim())) continue;
            cliList.add(cliStr);
        }
        LOGGER.info((Object)"Leave CommandTranslate.translate");
        return cliList;
    }

    private String dealLineSeparator(String cmdStr) {
        String separator = System.getProperty("line.separator");
        String cmd = cmdStr.replaceAll("lineseparatortmp", separator);
        return cmd;
    }

    private String dealHiddenSytem(String cmdStr) {
        String separator = System.getProperty("line.separator");
        String hiddensystemCmd = "_" + separator + "_Security" + separator + "system";
        String cmd = cmdStr.replaceAll("hiddensystem", hiddensystemCmd);
        return cmd;
    }

    private String dealHiddenView(String cmdStr) {
        String separator = System.getProperty("line.separator");
        String hiddensystemCmd = "_" + separator + "_Security";
        String cmd = cmdStr.replaceAll("hiddenview", hiddensystemCmd);
        return cmd;
    }

    private String replaceVariable(String commandStr, Map<String, String> paramMap) {
        String commandTplStr = commandStr;
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            String keyStr = entry.getKey();
            if (!keyStr.matches("^[a-zA-Z][a-zA-Z0-9_-]{0,63}$")) {
                LOGGER.info((Object)"variable name is illegal which must begin with char\u3001number\u3001-_ and the length must not greater than 64");
                throw new ParseException(109, "variable name is illegal which must begin with char\u3001number\u3001-_ and the length must not greater than 64");
            }
            commandTplStr = commandTplStr.replace("$" + keyStr.toLowerCase(Locale.ENGLISH) + " ", this.commandUtil.charEncode(entry.getValue()) + " ");
            commandTplStr = commandTplStr.replace("$" + keyStr.toLowerCase(Locale.ENGLISH) + "]", this.commandUtil.charEncode(entry.getValue()) + "]");
            commandTplStr = commandTplStr.replace("$" + keyStr.toLowerCase(Locale.ENGLISH) + "}", this.commandUtil.charEncode(entry.getValue()) + "}");
            commandTplStr = commandTplStr.replace("$" + keyStr.toLowerCase(Locale.ENGLISH) + "|", this.commandUtil.charEncode(entry.getValue()) + "|");
        }
        return commandTplStr;
    }

    private String translateCommand(Command commandBean, Map<String, String> paramMap) {
        String commandTplStr = commandBean.getCommandContent();
        commandTplStr = commandTplStr + " ";
        StringBuffer tplBuffer = null;
        commandTplStr = this.commandUtil.changeTabToSpace(commandTplStr);
        commandTplStr = commandTplStr.toLowerCase(Locale.ENGLISH);
        this.commandUtil.validNeedVar(commandTplStr, paramMap);
        commandTplStr = this.replaceVariable(commandTplStr, paramMap);
        Pattern pEdge = Pattern.compile("\\[\\s*\\]");
        Matcher mEdge = pEdge.matcher(commandTplStr);
        while (mEdge.find()) {
            int startIndex = mEdge.start();
            int endIndex = mEdge.end();
            tplBuffer = new StringBuffer(commandTplStr.substring(0, startIndex));
            commandTplStr = tplBuffer.append(commandTplStr.substring(endIndex)).toString();
        }
        String cliStr = this.delUnreplacedVariable(commandTplStr);
        cliStr = this.commandUtil.charDecode(cliStr);
        LOGGER.info((Object)("current cliStr : " + this.getcleanedMessage(cliStr)));
        return cliStr;
    }

    private String delInnerBracket(String commandStr) {
        Matcher mBig;
        String commandTplStr = commandStr;
        Pattern pMidBracket = Pattern.compile("\\[[^\\[\\]\\{\\}]+\\]");
        Pattern pBigBracket = Pattern.compile("\\{[^\\[\\]\\{\\}]+\\}");
        Matcher mMid = pMidBracket.matcher(commandTplStr);
        if (mMid.find()) {
            commandTplStr = this.delMidBracket(mMid, commandTplStr);
        }
        if ((mBig = pBigBracket.matcher(commandTplStr)).find()) {
            commandTplStr = this.delBigBracket(mBig, commandTplStr);
        }
        return commandTplStr;
    }

    private String delBigBracket(Matcher mBig, String commandTplStr) {
        int startIndex = mBig.start();
        int endIndex = mBig.end();
        String mg = mBig.group();
        String tmpMg = mg.substring(1, mg.length() - 1);
        String[] strArr = tmpMg.split("\\|");
        boolean hasConst = false;
        StringBuffer tempConstAll = new StringBuffer("");
        ArrayList<String> tempConst = new ArrayList<String>();
        for (int i = 0; i < strArr.length; ++i) {
            if (strArr[i].indexOf("$") != -1) continue;
            hasConst = true;
            tempConst.add(strArr[i]);
        }
        if (hasConst) {
            for (int m = 0; m < tempConst.size(); ++m) {
                tempConstAll.append((String)tempConst.get(m));
            }
            StringBuffer tplStrBuffer = new StringBuffer(commandTplStr.substring(0, startIndex));
            commandTplStr = tplStrBuffer.append(tempConstAll).append(commandTplStr.substring(endIndex)).toString();
        } else {
            StringBuffer tmpBuffer = new StringBuffer("$tmpVar");
            commandTplStr = commandTplStr.replace(mg, tmpBuffer.append(String.valueOf(new Date().getTime()).substring(5)).toString());
        }
        return commandTplStr;
    }

    private String delMidBracket(Matcher mMid, String commandTplStr) {
        int startIndex = mMid.start();
        int endIndex = mMid.end();
        String mg = mMid.group();
        String tmpMg = mg.substring(1, mg.length() - 1);
        String[] strArr = tmpMg.split("\\|");
        boolean hasConst = false;
        StringBuffer tempConstAll = new StringBuffer();
        StringBuffer pipeline = new StringBuffer();
        if (strArr[0].trim().equals("")) {
            pipeline.append("| ");
        }
        for (int i = 0; i < strArr.length; ++i) {
            if (strArr[i].indexOf("$") != -1) continue;
            hasConst = true;
            if (0 != pipeline.length()) {
                tempConstAll.append(pipeline);
                pipeline = new StringBuffer();
            }
            tempConstAll.append(strArr[i]);
        }
        if (hasConst) {
            StringBuffer tplStrBuffer = new StringBuffer(commandTplStr.substring(0, startIndex));
            commandTplStr = tplStrBuffer.append(tempConstAll).append(commandTplStr.substring(endIndex)).toString();
        } else {
            commandTplStr = commandTplStr.replace(mg, "");
        }
        return commandTplStr;
    }

    private String delUnreplacedVariable(String commandStr) {
        String commandTplStr = commandStr;
        if (commandTplStr.indexOf("[") == -1 && commandTplStr.indexOf("{") == -1) {
            return commandTplStr;
        }
        commandTplStr = this.delInnerBracket(commandTplStr);
        commandTplStr = this.delUnreplacedVariable(commandTplStr);
        return commandTplStr;
    }
}

