/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import com.hs.lego.core.sdk.log.Log;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.util.CapaUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public final class CommonUtil {
    private static final ArrayList<String> OLD_VERSIONLIST = new ArrayList();

    private CommonUtil() {
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static String convertListToString(List<String> list) {
        StringBuffer sb = new StringBuffer();
        for (String temp : list) {
            sb.append(temp);
        }
        return sb.toString();
    }

    public static void printException(Log logger, Exception e, String preface) {
        StackTraceElement[] stackTraceElements;
        logger.error((Object)(preface + ":" + e));
        for (StackTraceElement stackTraceElement : stackTraceElements = e.getStackTrace()) {
            logger.error((Object)stackTraceElement);
        }
    }

    public static String transformNumber(String number, String unit) {
        if (CommonUtil.isNull(number)) {
            return number;
        }
        DecimalFormat df = new DecimalFormat("###,###");
        String numberBuf = "";
        try {
            numberBuf = df.format(Double.parseDouble(number));
        }
        catch (NumberFormatException e) {
            numberBuf = "";
        }
        if (!CommonUtil.isNull(unit)) {
            numberBuf = numberBuf + unit;
        }
        return numberBuf;
    }

    public static boolean includesV1R1(List<AticDevice> aticDeviceList) {
        boolean flag = false;
        if (null == aticDeviceList || aticDeviceList.isEmpty()) {
            return flag;
        }
        for (AticDevice device : aticDeviceList) {
            if (null == device) continue;
            if (null != device.getVersion() && device.getVersion().contains("V100R001")) {
                flag = true;
                break;
            }
            if (null == device.getVersion() || !device.getVersion().contains("V500R001C00")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isV5R1C20OrAfterVersion(Long deviceId) {
        AticDevice aticDevice = CapaUtil.getAticDeviceService().getDeviceByMoid(deviceId);
        String version = null;
        if (null == aticDevice || null == aticDevice.getVersion()) {
            return false;
        }
        version = aticDevice.getVersion();
        return !version.contains("V100R001") && !version.contains("V500R001C00");
    }

    public static boolean isNewDevice(AticDevice aticDevice) {
        String[] deviceVersion;
        String version = aticDevice.getVersion();
        return !(aticDevice.getDeviceType() == 1 ? version.contains("SPC") && (OLD_VERSIONLIST.contains((deviceVersion = version.split("SPC"))[0]) || version.contains("V1")) : aticDevice.getDeviceType() == 5 && "V100R001C00".equals(version));
    }

    static {
        OLD_VERSIONLIST.add("V500R001C00");
        OLD_VERSIONLIST.add("V500R001C20");
        OLD_VERSIONLIST.add("V500R001C30");
        OLD_VERSIONLIST.add("V500R001C50");
    }
}

