/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfa;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceNfaService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.nfa.restful.model.ClusterObject;
import com.huawei.atic.secservice.nfa.restful.model.NfaInfoForm;
import com.huawei.atic.secservice.nfa.restful.model.Result;
import com.huawei.atic.secservice.nfa.restful.sdk.service.IRestfulNfaService;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;

public final class NfaFilterUtil {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    private NfaFilterUtil() {
    }

    public static NfaInfoForm getNfaInfoFormByDeviceId(Long deviceId) {
        IAticDeviceNfaService aticDeviceNfaService = (IAticDeviceNfaService)ServiceContext.getInstance().getService("aticDeviceNfaService", IAticDeviceNfaService.class);
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        IClusterService clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
        if (null == aticDeviceNfaService) {
            return null;
        }
        if (null == aticDeviceService) {
            return null;
        }
        if (null == clusterService) {
            return null;
        }
        AticDevice aticDevice = aticDeviceService.getDeviceByMoid(deviceId);
        if (null == aticDevice || aticDevice.getDeviceType() != 5) {
            return null;
        }
        Long clusterId = null;
        try {
            if (clusterService.isBelongCluster(deviceId)) {
                AticDeviceNfaCluster nfaCluster = clusterService.getClusterByNfaId(deviceId);
                clusterId = nfaCluster.getClusterId();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get AticDeviceNfaCluster error ,deviceId is " + deviceId));
            return null;
        }
        NfaInfoForm nfaInfoForm = new NfaInfoForm();
        AticDeviceNfa aticDeviceNfa = aticDeviceNfaService.findByMoid(aticDevice.getMoId());
        if (null == aticDeviceNfa) {
            return null;
        }
        nfaInfoForm.setDeviceId(aticDeviceNfa.getMoId());
        nfaInfoForm.setApiKey(aticDeviceNfa.getApiKey());
        nfaInfoForm.setPort(aticDeviceNfa.getRestfulPort());
        nfaInfoForm.setClusterId(clusterId);
        nfaInfoForm.setIpAdress(aticDevice.getIpAddress());
        return nfaInfoForm;
    }

    public static Result deployNFAClusterInfo(NfaInfoForm nfaInfoForm, String clusterIp, String operation, List<Long> idList) {
        Result result = null;
        try {
            IRestfulNfaService restfulNfaService = (IRestfulNfaService)ServiceContext.getInstance().getService("restfulNfaService", IRestfulNfaService.class);
            if (null == restfulNfaService) {
                logger.error((Object)"deployNFAClusterInfo is failed, restfulNfaService is null");
                throw new LegoCheckedException(570506L);
            }
            IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
            if (null == aticDeviceService) {
                logger.error((Object)"deployNFAClusterInfo is failed, aticDeviceService is null");
                throw new LegoCheckedException(570506L);
            }
            ClusterObject[] clusterObjects = null;
            ClusterObject obj = null;
            AticDevice dev = null;
            ArrayList<Long> nfaIdList = new ArrayList<Long>();
            if (null != idList && !idList.isEmpty()) {
                for (Long id : idList) {
                    dev = aticDeviceService.getDeviceByMoid(id);
                    if (null == dev || 5 != dev.getDeviceType()) continue;
                    nfaIdList.add(id);
                }
                clusterObjects = new ClusterObject[nfaIdList.size()];
                for (int i = 0; i < nfaIdList.size(); ++i) {
                    Long id;
                    id = (Long)nfaIdList.get(i);
                    obj = new ClusterObject();
                    obj.setClusterIp(clusterIp);
                    dev = aticDeviceService.getDeviceByMoid(id);
                    if (null == dev) continue;
                    obj.setNfaIp(dev.getIpAddress());
                    obj.setNfaState(aticDeviceService.getStatusByMoid(id) == 0 ? 1 : 0);
                    clusterObjects[i] = obj;
                }
            }
            result = restfulNfaService.restNfaClusterInfo(clusterObjects, nfaInfoForm, operation);
        }
        catch (RuntimeException e) {
            logger.error((Object)"deployNFAClusterInfo failed");
        }
        return result;
    }

    public static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public static boolean isRestFulSucess(Result result) {
        if (null == result) {
            return false;
        }
        int statusCode = result.getStatusCode();
        if (statusCode == 200) {
            JSONObject json = JSONObject.fromObject((Object)result.getJson());
            return "ok".equalsIgnoreCase((String)json.get("errDesc"));
        }
        return false;
    }

    public static boolean isNumber(String str) {
        String regex = "^[0-9]*$";
        return !AticUtil.isNull((String)str) && str.matches(regex);
    }
}

