/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.com.south.snmp;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.mediation.synchronize.snmp.util.SnmpSynchronizeUtil;
import com.huawei.atic.south.model.SnmpPara;
import com.huawei.lego.com.south.snmp.listener.SnmpTrapListener;
import com.huawei.lego.nem.fault.sdk.model.SnmpTrapPDU;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class SnmpTrapReceiver
implements CommandResponder {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final int TRAP_THREAD_POOL_SIZE = 2;
    private MultiThreadedMessageDispatcher dispatcher;
    private ThreadPool threadPool;
    private SnmpPara snmpPara;
    private Snmp snmp = null;
    private int snmpPort = 161;
    private Map<String, SnmpTrapListener> snmpTrapListerMap = new HashMap<String, SnmpTrapListener>();

    public SnmpTrapReceiver(int port) {
        this.snmpPort = port;
    }

    public void setSnmpPara(SnmpPara snmpPara) {
        this.snmpPara = snmpPara;
    }

    public void addTrapListener(String name, SnmpTrapListener listener) {
        this.snmpTrapListerMap.put(name, listener);
    }

    public void removeTrapListener(String name) {
        this.snmpTrapListerMap.remove(name);
    }

    public SnmpPara getSnmpPara() {
        return this.snmpPara;
    }

    public void run() {
        this.initSnmpListen();
        this.snmp.addCommandResponder((CommandResponder)this);
    }

    public void close() {
        try {
            this.snmp.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"close snmp failed");
        }
    }

    private void initSnmpListen() {
        try {
            this.threadPool = ThreadPool.create((String)"TrapPool", (int)2);
            this.dispatcher = new MultiThreadedMessageDispatcher((WorkerPool)this.threadPool, (MessageDispatcher)new MessageDispatcherImpl());
            UdpAddress listenAddress = new UdpAddress("0.0.0.0/" + this.snmpPort);
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(listenAddress);
            this.snmp = new Snmp((MessageDispatcher)this.dispatcher, (TransportMapping)transport);
            if (this.snmpPara != null && this.snmpPara.getVersion() == 3) {
                USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
                UsmUser user = SnmpSynchronizeUtil.getInstance().createUsmUser(this.snmpPara);
                if (this.snmpPara.getContextEngineId() != null) {
                    this.snmp.getUSM().addUser(SnmpSynchronizeUtil.getInstance().getOctString(this.snmpPara.getSecurityName()), SnmpSynchronizeUtil.getInstance().getOctString(this.snmpPara.getContextEngineId()), user);
                } else {
                    this.snmp.getUSM().addUser(SnmpSynchronizeUtil.getInstance().getOctString(this.snmpPara.getSecurityName()), null, user);
                }
                this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3());
            } else {
                this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
                this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
            }
            this.snmp.listen();
        }
        catch (IOException e) {
            LOGGER.error((Object)"init snmp failed");
        }
    }

    private SnmpTrapPDU createSnmpTrapPdu(CommandResponderEvent event) {
        SnmpTrapPDU snmpPdu = new SnmpTrapPDU();
        String address = event.getPeerAddress().toString();
        String[] addressVar = address.split("/");
        snmpPdu.setRemoteHost(addressVar[0]);
        snmpPdu.setRemotePort((int)Long.parseLong(addressVar[1]));
        Vector vbVect = event.getPDU().getVariableBindings();
        snmpPdu.setSnmpVariableBinds(vbVect);
        return snmpPdu;
    }

    public void processPdu(CommandResponderEvent event) {
        if (event == null || event.getPDU() == null) {
            LOGGER.error((Object)"event or pdu is null");
            return;
        }
        if (!this.snmpTrapListerMap.isEmpty()) {
            Set<Map.Entry<String, SnmpTrapListener>> entrySet = this.snmpTrapListerMap.entrySet();
            for (Map.Entry<String, SnmpTrapListener> temp : entrySet) {
                temp.getValue().applySnmpTrap(this.createSnmpTrapPdu(event));
            }
        } else {
            this.createSnmpTrapPdu(event);
            LOGGER.info((Object)("begin to praser event: " + event.getPeerAddress().toString()));
            Vector vbVect = event.getPDU().getVariableBindings();
            for (VariableBinding vb : vbVect) {
                LOGGER.info((Object)(vb.getOid() + " = " + vb.getVariable()));
            }
            LOGGER.info((Object)"end of praser event");
        }
    }
}

