/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.xbean.spring.context.impl.PropertyEditorHelper;
import org.apache.xbean.spring.context.impl.QNameReflectionParams;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.w3c.dom.Element;

public class QNameReflectionHelper {
    protected static Method coerceMethod;
    protected static Method createMethod;

    public static void coerceNamespaceAwarePropertyValues(AbstractBeanDefinition beanDefinition, Element element, PropertyDescriptor[] descriptors, int index) {
        QNameReflectionParams params = new QNameReflectionParams(beanDefinition, element, descriptors, index);
        if (coerceMethod == null) {
            coerceMethod = QNameReflectionHelper.findMethod("coerceQNamePropertyValues");
        }
        if (coerceMethod != null) {
            try {
                coerceMethod.invoke(null, params);
            }
            catch (Exception e) {
                throw new BeanDefinitionStoreException("Failed to invoke method: " + coerceMethod + " via reflection: " + e, e);
            }
        }
    }

    public static Object createQName(Element element, String text) {
        if (createMethod == null) {
            createMethod = QNameReflectionHelper.findMethod("createQName");
        }
        if (createMethod != null) {
            try {
                return createMethod.invoke(null, element, text);
            }
            catch (Exception e) {
                throw new BeanDefinitionStoreException("Failed to invoke method: " + createMethod + " via reflection: " + e, e);
            }
        }
        return null;
    }

    protected static Method findMethod(String name) {
        try {
            Class type = PropertyEditorHelper.loadClass("org.apache.xbean.spring.context.impl.QNameHelper");
            if (type != null) {
                Method[] methods = type.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!method.getName().equals(name)) continue;
                    return method;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

