/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Screen;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.application.Platform;

final class MonocleWindowManager {
    private static MonocleWindowManager instance = new MonocleWindowManager();
    private MonocleWindow[] windows = new MonocleWindow[0];
    private int nextID = 1;
    private MonocleWindow focusedWindow = null;

    private MonocleWindowManager() {
    }

    static MonocleWindowManager getInstance() {
        return instance;
    }

    private int getWindowIndex(MonocleWindow monocleWindow) {
        for (int i = 0; i < this.windows.length; ++i) {
            if (this.windows[i] != monocleWindow) continue;
            return i;
        }
        return -1;
    }

    void toBack(MonocleWindow monocleWindow) {
        int n = this.getWindowIndex(monocleWindow);
        if (n != 0 && n != -1) {
            System.arraycopy(this.windows, 0, this.windows, 1, n);
            this.windows[0] = monocleWindow;
        }
    }

    void toFront(MonocleWindow monocleWindow) {
        int n = this.getWindowIndex(monocleWindow);
        if (n != this.windows.length - 1 && n != -1) {
            System.arraycopy(this.windows, n + 1, this.windows, n, this.windows.length - n - 1);
            this.windows[this.windows.length - 1] = monocleWindow;
        }
    }

    int addWindow(MonocleWindow monocleWindow) {
        int n = this.getWindowIndex(monocleWindow);
        if (n == -1) {
            this.windows = Arrays.copyOf(this.windows, this.windows.length + 1);
            this.windows[this.windows.length - 1] = monocleWindow;
        }
        return this.nextID++;
    }

    boolean closeWindow(MonocleWindow monocleWindow) {
        int n = this.getWindowIndex(monocleWindow);
        if (n != -1) {
            System.arraycopy(this.windows, n + 1, this.windows, n, this.windows.length - n - 1);
            this.windows = Arrays.copyOf(this.windows, this.windows.length - 1);
        }
        ArrayList<MonocleWindow> arrayList = new ArrayList<MonocleWindow>();
        for (MonocleWindow monocleWindow2 : this.windows) {
            if (monocleWindow2.getOwner() != monocleWindow) continue;
            arrayList.add(monocleWindow2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((MonocleWindow)arrayList.get(i)).notifyClose();
        }
        monocleWindow.notifyDestroy();
        return true;
    }

    boolean minimizeWindow(MonocleWindow monocleWindow) {
        return true;
    }

    boolean maximizeWindow(MonocleWindow monocleWindow) {
        return true;
    }

    boolean requestFocus(MonocleWindow monocleWindow) {
        int n = this.getWindowIndex(monocleWindow);
        if (n != -1) {
            this.focusedWindow = monocleWindow;
            monocleWindow.notifyFocus(542);
            return true;
        }
        return false;
    }

    boolean grabFocus(MonocleWindow monocleWindow) {
        return true;
    }

    void ungrabFocus(MonocleWindow monocleWindow) {
    }

    MonocleWindow getWindowForLocation(int n, int n2) {
        for (int i = this.windows.length - 1; i >= 0; --i) {
            MonocleWindow monocleWindow = this.windows[i];
            if (n < monocleWindow.getX() || n2 < monocleWindow.getY() || n >= monocleWindow.getX() + monocleWindow.getWidth() || n2 >= monocleWindow.getY() + monocleWindow.getHeight() || !monocleWindow.isEnabled()) continue;
            return monocleWindow;
        }
        return null;
    }

    void notifyFocusDisabled(MonocleWindow monocleWindow) {
        if (monocleWindow != null) {
            monocleWindow._notifyFocusDisabled();
        }
    }

    MonocleWindow getFocusedWindow() {
        return this.focusedWindow;
    }

    void repaintAll() {
        for (int i = 0; i < this.windows.length; ++i) {
            MonocleView monocleView = (MonocleView)this.windows[i].getView();
            if (monocleView == null) continue;
            monocleView.notifyRepaint();
        }
    }

    static void repaintFromNative() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                Screen.notifySettingsChanged();
                instance.getFocusedWindow().setFullScreen(true);
                instance.repaintAll();
                Toolkit.getToolkit().requestNextPulse();
            }
        });
    }
}

