/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeCursors;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class SoftwareCursor
extends NativeCursor {
    private ByteBuffer cursorBuffer;
    private int renderX;
    private int renderY;
    private int hotspotX;
    private int hotspotY;

    SoftwareCursor() {
    }

    @Override
    Size getBestSize() {
        return new Size(16, 16);
    }

    @Override
    void setVisibility(boolean bl) {
        if (bl != this.isVisible) {
            this.isVisible = bl;
            MonocleWindowManager.getInstance().repaintAll();
        }
    }

    @Override
    void setImage(byte[] byArray) {
        this.cursorBuffer = ByteBuffer.allocate(byArray.length);
        NativeCursors.colorKeyCursor(byArray, this.cursorBuffer.asIntBuffer(), 32, 0);
        this.cursorBuffer = this.cursorBuffer.order(ByteOrder.nativeOrder());
    }

    @Override
    void setLocation(int n, int n2) {
        int n3 = n - this.hotspotX;
        int n4 = n2 - this.hotspotY;
        if (n3 != this.renderX || n4 != this.renderY) {
            this.renderX = n3;
            this.renderY = n4;
            MonocleWindowManager.getInstance().repaintAll();
        }
    }

    @Override
    void setHotSpot(int n, int n2) {
        this.hotspotX = n;
        this.hotspotY = n2;
    }

    @Override
    void shutdown() {
    }

    int getRenderX() {
        return this.renderX;
    }

    int getRenderY() {
        return this.renderY;
    }

    Buffer getCursorBuffer() {
        this.cursorBuffer.clear();
        return this.cursorBuffer;
    }
}

