/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.exception;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LegoCheckedException
extends RuntimeException {
    private static final long serialVersionUID = 9223257323548528435L;
    private long errorCode;
    private Object accessoryResult;
    private String[] parameters;

    public LegoCheckedException(String message, Throwable cause) {
        super(message, cause);
    }

    public LegoCheckedException(String message) {
        super(message);
    }

    public LegoCheckedException(long errorCode) {
        super("Code: " + errorCode);
        this.errorCode = errorCode;
    }

    public LegoCheckedException(long errorCode, String[] parameter) {
        super("Code: " + errorCode);
        this.errorCode = errorCode;
        this.parameters = (String[])ArrayDeepClone.deepClone(parameter);
    }

    public LegoCheckedException(long errorCode, Throwable e) {
        super("Code: " + errorCode, e);
        this.errorCode = errorCode;
    }

    public LegoCheckedException(long errorCode, String info) {
        super("Code: " + errorCode + "\t" + info);
        this.errorCode = errorCode;
    }

    public Object getAccessoryResult() {
        return this.accessoryResult;
    }

    public void setAccessoryResult(Object result) {
        this.accessoryResult = result;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String[] getParameters() {
        return (String[])ArrayDeepClone.deepClone(this.parameters);
    }

    private static abstract class ArrayDeepClone {
        private static final Log LOGGER = LogFactory.getInstance(Module.ATIC_CORE_BASE);

        private ArrayDeepClone() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object deepClone(Object obj) {
            Object o = null;
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            ByteArrayOutputStream baos = null;
            ByteArrayInputStream bais = null;
            try {
                if (obj != null) {
                    baos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(baos);
                    oos.writeObject(obj);
                    bais = new ByteArrayInputStream(baos.toByteArray());
                    ois = new ObjectInputStream(bais);
                    o = ois.readObject();
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), e);
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                }
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                }
                if (baos != null) {
                    try {
                        baos.flush();
                        baos.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                }
                if (bais != null) {
                    try {
                        bais.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage(), e);
                    }
                }
            }
            return o;
        }
    }
}

