/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.notify.sdk.model;

import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public final class SyslogBean
implements Serializable {
    public static final String LOG_TYPE_ALARM = "ALARM";
    public static final String LOG_TYPE_OPLOG = "OPLOG";
    private static final long serialVersionUID = -3333509701253681467L;
    private static transient Log log = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private String localHost;
    private String logType;
    private String delimiter = " ";
    private List<String> logContent;
    private byte[] bytes = null;

    public SyslogBean(String localHost, String logType, List<String> logContent) {
        this.localHost = localHost;
        this.logType = logType;
        this.logContent = logContent;
    }

    public SyslogBean(byte[] bytes) {
        this.bytes = (byte[])ArrayDeepClone.deepClone(bytes);
    }

    private String buildHeaderString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "<189>" + format.format(new Date()) + " " + this.localHost + "%%01SEC/5/" + this.logType + "(l): ";
    }

    private String buildSyslogString() {
        String syslog = this.buildHeaderString();
        StringBuffer buf = new StringBuffer();
        buf.append(syslog);
        if (this.logContent != null) {
            for (int i = 0; i < this.logContent.size(); ++i) {
                buf.append(this.logContent.get(i) + this.delimiter);
            }
        }
        syslog = buf.toString();
        return syslog;
    }

    public byte[] getBytes() {
        try {
            return this.bytes == null ? (byte[])ArrayDeepClone.deepClone(this.buildSyslogString().getBytes("UTF-8")) : (byte[])ArrayDeepClone.deepClone(this.bytes);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e);
            return (byte[])ArrayDeepClone.deepClone(this.bytes);
        }
    }
}

