/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secsyslog;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.secsyslog.IpTransformer;
import com.huawei.secsyslog.SyslogClientAbstrat;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public class UDPSysLogClientThread
extends SyslogClientAbstrat {
    private static final Log LOGGER = LogFactory.getInstance(Module.ATIC_CBB_LOG);
    private DatagramSocket udpSocket = null;

    public UDPSysLogClientThread(String ip, int port) {
        super(ip, port);
        Random ran = new Random();
        this.setName("UdpSysLogClient_" + this.getServerIp() + "_" + this.getServerPort() + "_" + ran.nextInt());
    }

    @Override
    public void run() {
        if (!IpTransformer.checkIpInvaild(this.getServerIp())) {
            LOGGER.error("input serverIP is error, creat UdpSysLogClient failed.");
            return;
        }
        LOGGER.info("Thread " + this.getName() + " start run.");
        DatagramPacket packet = null;
        int allNum = 0;
        int index = 0;
        while (this.isFlag()) {
            try {
                this.fetchSysLogList();
                if (!this.getDataList().isEmpty()) {
                    index = 0;
                    InetAddress serverAddr = InetAddress.getByName(this.getServerIp());
                    int serverPort = this.getServerPort();
                    for (byte[] data : this.getDataList()) {
                        try {
                            packet = new DatagramPacket(data, data.length, serverAddr, serverPort);
                            this.udpSocket = new DatagramSocket();
                            this.udpSocket.send(packet);
                            this.udpSocket.close();
                            LOGGER.debug("Send UDP syslog:" + this.getcleanedMessage(this.getServerIp()) + ':' + serverPort + '-' + this.getcleanedMessage(packet.toString()));
                            ++allNum;
                        }
                        catch (IOException e) {
                            LOGGER.error("SysLogClient-run error", e);
                        }
                        if (index++ % 50 != 0) continue;
                        this.sleep(2);
                    }
                    LOGGER.info("all syslog Num = " + allNum);
                    this.getDataList().clear();
                    continue;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    LOGGER.info("Thread.sleep(1000) error");
                }
            }
            catch (UnknownHostException e1) {
                LOGGER.error("UDPSysLogClient-run error", e1);
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void stopClient() {
        LOGGER.info("stopClient");
        this.setFlag(false);
        if (null != this.udpSocket) {
            this.udpSocket.close();
            this.udpSocket = null;
        }
    }
}

