
function createIPCom(containerID, ipComId ,type,doc) {
    var str = "";
    var str = new StringBuffer();
    if (doc == undefined){
       doc = document;
    }
	str.append( "<input type='hidden' id='H_" + ipComId + "' value='" + type + "'/>")
		.append("<table align='left' id='" + ipComId + "' class='x-elog-ipAddress ' cellspacing='0' cellpadding='0' >")
	    .append("    <tr>")
	    .append("        <td>")
	    .append("            <input type='text' size='3' maxlength='3' class='x-elog-ip-field' name='" + ipComId + "' style='ime-mode:disabled' id='" + ipComId + "1'>")
	    .append("        </td>")
	    .append("        <td>.</td>")

	    .append("        <td>")
     	.append("            <input type='text' size='3' maxlength='3' class='x-elog-ip-field' name='" + ipComId + "' style='ime-mode:disabled' id='" + ipComId + "2'>")
	    .append("        </td>")
	    .append("        <td>.</td>")

	    .append("        <td>")
	    .append("            <input type='text' size='3' maxlength='3' class='x-elog-ip-field' name='" + ipComId + "' style='ime-mode:disabled' id='" + ipComId + "3'>")
	    .append("        </td>")
	    .append("        <td>.</td>")

	    .append("        <td>")
	    .append("            <input type='text' size='3' maxlength='3' class='x-elog-ip-field' name='" + ipComId + "' tabIndex = 4  style='ime-mode:disabled' id='" + ipComId + "4'>")
	    .append("        </td>")
	    .append("    </tr>")
	    .append("</table>")
			if(doc.getElementById(containerID))
			{
				doc.getElementById(containerID).innerHTML = str.toString();	
			}
			else
			{
				ConditionUtils.getTopDocument().getElementById(containerID).innerHTML = str.toString();
			}			 
	addIPEvent(containerID,doc,ipComId,type);
	return ipComId;
}


function addIPEvent(containerId,doc,ipComId,type)
{  
	if(jQuery("#" + containerId +">table>tbody>tr>td>:text[name='"+ipComId+"']", doc).length != 0) {
		jQuery("#" + containerId +">table>tbody>tr>td>:text[name='"+ipComId+"']", doc).bind({
			paste : function(event){doPaste(event)},
			keydown : function(event){onIpFieldKeyDown(event)},
			keyup : function(event){onIpFieldKeyUp(event)},
			blur : function(event){doOnblur(event)}
		});
	} else {
		var ipParent = doc.getElementById(containerId);
		jQuery(ipParent).find(':text[name="'+ipComId+'"]').bind({
			paste : function(event){doPaste(event)},
			keydown : function(event){onIpFieldKeyDown(event)},
			keyup : function(event){onIpFieldKeyUp(event)},
			blur : function(event){doOnblur(event)}
		});	
	}
}


var IPCOM_Constant = {
	appType:{
	    IP:'ip',			
	    MASK:'mask',		
        IP_EXP:'ip_exp'		
	},
    eventType:{
    	BLUREV:'blurEvent',		
    	KEYUPEV:'keyUpEvent',	
    	TABEV:'tabEvent'		
    },
    returnType:{
    	NOTINPUT:null,						
    	NOTCOMPLETE:'',						
    	FORMATERROR:'formatError',			
    	FORMATERROR_EXP:'formatError_exp'	
    }
}


function doOnblur(event) {
	event = window.event?window.event:event;
    var srcObj = event.srcElement?event.srcElement:event.target;
    
	if(srcObj.pasteStrOld != null) {
		window.clipboardData.setData('text', srcObj.pasteStrOld);
		srcObj.pasteStrOld = null;
	}
	feildValue_CheckObj(srcObj,IPCOM_Constant.eventType.BLUREV);
}

function doPaste (event) {
    event = window.event || event;
    var srcObj = getEventObj(event);
    var _row = srcObj.parentNode.parentNode;

    var fieldArr = _row.getElementsByTagName('INPUT');
    var valueArr = new Array();
    for(var i = 0 ; i < fieldArr.length ; i++) {
        valueArr.push(fieldArr[i].value.toString());
        fieldArr[i].value = "";
    }

	var data = getClipboardText();
	
	if(data){
			var ipDataArr =  data.split(".");
			var reg = /\D/g;
			
			var test = !reg.test(ipDataArr[0]) && !reg.test(ipDataArr[1]) &&  !reg.test(ipDataArr[2])  && !reg.test(ipDataArr[3]);
			
            for (var i = 0; i < ipDataArr.length; i++){
                   var intV = parseInt(ipDataArr[i]);
                   
				   if(intV > 223 && i == 0) {
				        ipDataArr[i] = 223;
				        srcObj.select();
				    } else if(intV > 255) {
				        ipDataArr[i]= 255;
				        srcObj.select();
				    } 
            }
            
		    if (window.event){
		        handleIP(fieldArr,ipDataArr,valueArr,test);
		        event.returnValue = false;
		    }else{
		        handleIP(fieldArr,ipDataArr,valueArr,test);
		        event.preventDefault();
		        return false;
		    }
	}
}

function handleIP(fieldArr,ipDataArr,valueArr,flag){
	if(flag){
        for (var i = 0; i < ipDataArr.length; i++){
            if(ipDataArr[i]){
                fieldArr[i].value = ipDataArr[i];
            }
        }
	}else{
	    for (var i = 0; i < valueArr.length; i++){   
                fieldArr[i].value = valueArr[i];
        }
		LegoTag.Msg.alert('<s:text name="elog.common.info"/>','<s:text name="elog.ip.formatError"/>');
	}

}

function getClipboardText(){
    if (window.clipboardData) 
	    {
	        return (window.clipboardData.getData('text'));
	    } 
	    else 
	    {
	        if (window.netscape) 
	        {
	            try 
	            {
	                netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
	                var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
	                if (!clip) 
	                {
	                    return;
	                }
	                var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
	                if (!trans) 
	                {
	                    return;
	                }
	                trans.addDataFlavor("text/unicode");
	                clip.getData(trans, clip.kGlobalClipboard);
	                var str = new Object();
	                var len = new Object();
	                trans.getTransferData("text/unicode", str, len);
	            }
	            catch (e) 
	            {
	                return null;
	            }
	            if (str) 
	            {
	                if (Components.interfaces.nsISupportsWString) 
	                {
	                    str = str.value.QueryInterface(Components.interfaces.nsISupportsWString);
	                } 
	                else 
	                {
	                    if (Components.interfaces.nsISupportsString) 
	                    {
	                        str = str.value.QueryInterface(Components.interfaces.nsISupportsString);
	                    } 
	                    else 
	                    {
	                        str = null;
	                    }
	                }
	            }
	            if (str) 
	            {
	                return (str.data.substring(0, len.value / 2));
	            }
	        }
	    }
    	return null;
}


function fieldObj(preObj,value) {
    this.preObj = preObj;
    this.value = value;
    
    this.valueOfInt = function () {
        if(this.value.charAt(0) == '0') {
            if(this.value.charAt(1) == '0'){
                return parseInt(this.value);
            } else {
                if(this.value.length > 1)
                    return parseInt(this.value.substring(1));
                else return 0;
            }
        } else {
            return parseInt(this.value);
        }
    };
    
    this.validateMask = function () {
        var value_int = this.valueOfInt();
        var preObj = this.preObj;
        
        if(preObj != null) {
            if(preObj.valueOfInt() == 255) {
                if(this.checkV() || value_int == 0 || value_int == 255)  return true;
                    else return false;
            } else if(preObj.checkV()) {
                if(value_int == 0) return true;
                    else return false;
            } else if(preObj.valueOfInt() == 0) {
                if(value_int == 0) return true;
                    else return false;
            } else {
                return false;
            }
        } else {
            if(value_int == 255 || this.checkV()) return true;
                else return false;
        }
        return false;
    };
    this.validateIp = function () {
    };
    this.checkV = function () {
        var v = this.valueOfInt();
        if((v == 254) || (v == 252) || (v == 248) || (v == 240) || (v == 224) || (v == 192) || (v == 128)) return true;
            else return false;
        
    };
}

function getIpStrVsm(ipComId, doc) {
	
	var fieldArr = getFieldArr(ipComId,doc);
	
	if(fieldArr == null || fieldArr == undefined){
	    fieldArr = getFieldArr(ipComId, ConditionUtils.getTopDocument());
	}
	
	var field_1 = fieldArr[0].value;
	var field_2 = fieldArr[1].value;
	var field_3 = fieldArr[2].value;
	var field_4 = fieldArr[3].value;

	if (field_1 == "" && field_2 == "" && field_3 == "" && field_4 == "") {
		return IPCOM_Constant.returnType.NOTINPUT;
	}
	else if (field_1 == "" || field_2 == "" || field_3 == "" || field_4 == "") {
		var objTemp = null;
		if(field_1 == '') objTemp = fieldArr[0];
		else if(field_2 == '') objTemp = fieldArr[1];
		else if(field_3 == '') objTemp = fieldArr[2];
		else if(field_4 == '') objTemp = fieldArr[3];
		if(valueOnly != 'valueOnly') {
			objTemp.select();
		}
		return IPCOM_Constant.returnType.NOTCOMPLETE;
	}

	var fieldObj_1 = new fieldObj(null,field_1);
	var fieldObj_2 = new fieldObj(fieldObj_1,field_2);
	var fieldObj_3 = new fieldObj(fieldObj_2,field_3);
	var fieldObj_4 = new fieldObj(fieldObj_3,field_4);
	
	if (type == IPCOM_Constant.appType.MASK) {
		if(!(fieldObj_1.validateMask() && fieldObj_2.validateMask() && fieldObj_3.validateMask() && fieldObj_4.validateMask())) {
		    var objTemp = null;
		    
		    if(!fieldObj_1.validateMask()) objTemp = fieldArr[0];
		    else if(!fieldObj_2.validateMask()) objTemp = fieldArr[1];
		    else if(!fieldObj_3.validateMask()) objTemp = fieldArr[2];
		    else if(!fieldObj_4.validateMask()) objTemp = fieldArr[3];
		    
		    if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
		    return IPCOM_Constant.returnType.FORMATERROR;
		}
	} else if(type == IPCOM_Constant.appType.IP_EXP) {
		var objTemp = null;
		if(fieldObj_1.valueOfInt() == 0) {
			if(fieldObj_2.valueOfInt() != 0 || fieldObj_3.valueOfInt() != 0 || fieldObj_4.valueOfInt() != 0) {
				if(valueOnly != 'valueOnly') {
					fieldArr[0].select();
				}
				return IPCOM_Constant.returnType.FORMATERROR_EXP;
			}
		} else if(fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
		} else if(fieldObj_2.valueOfInt() > 255) {
            objTemp = fieldArr[1];
        } else if(fieldObj_3.valueOfInt() > 255) {
            objTemp = fieldArr[2];
        } else if(fieldObj_4.valueOfInt() > 255) {
            objTemp = fieldArr[3];
        } 
        if (objTemp != null) {
        	if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
        	return IPCOM_Constant.returnType.FORMATERROR_EXP;
        }
	} else{
		var objTemp = null;
		if (fieldObj_1.valueOfInt() == 0 || fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
		else if (fieldObj_2.valueOfInt() > 255)
			objTemp = fieldArr[1];
		else if (fieldObj_3.valueOfInt() > 255)
			objTemp = fieldArr[2];
		else if (fieldObj_4.valueOfInt() > 255)
			objTemp = fieldArr[3];
		if (objTemp != null) {
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
	}
	var ipString = fieldObj_1.valueOfInt() + "." + fieldObj_2.valueOfInt() + "." + fieldObj_3.valueOfInt() + "." + fieldObj_4.valueOfInt();
	return ipString;
}

function getIpStr(ipComId, type, valueOnly) {
	
	var fieldArr = getFieldArr(ipComId);	
	if(fieldArr == null || fieldArr == undefined){
	    fieldArr = getFieldArr(ipComId, ConditionUtils.getTopDocument());
	}

	var field_1 = fieldArr[0].value;
	var field_2 = fieldArr[1].value;
	var field_3 = fieldArr[2].value;
	var field_4 = fieldArr[3].value;

	if((field_1 == "" || field_2 == "" || field_3 == "" || field_4 == "") 
		&& (field_1 != "" || field_2 != "" || field_3 != "" || field_4 != ""))
	{
		return IPCOM_Constant.returnType.FORMATERROR;
	}
	
	if (field_1 == "" && field_2 == "" && field_3 == "" && field_4 == "") {
		return IPCOM_Constant.returnType.NOTINPUT;
	}
	else if (field_1 == "" || field_2 == "" || field_3 == "" || field_4 == "") {
		var objTemp = null;
		if(field_1 == '') objTemp = fieldArr[0];
		else if(field_2 == '') objTemp = fieldArr[1];
		else if(field_3 == '') objTemp = fieldArr[2];
		else if(field_4 == '') objTemp = fieldArr[3];
		if(valueOnly != 'valueOnly') {
			objTemp.select();
		}
		return IPCOM_Constant.returnType.NOTCOMPLETE;
	}

	var fieldObj_1 = new fieldObj(null,field_1);
	var fieldObj_2 = new fieldObj(fieldObj_1,field_2);
	var fieldObj_3 = new fieldObj(fieldObj_2,field_3);
	var fieldObj_4 = new fieldObj(fieldObj_3,field_4);
	
	if (type == IPCOM_Constant.appType.MASK) {
		if(!(fieldObj_1.validateMask() && fieldObj_2.validateMask() && fieldObj_3.validateMask() && fieldObj_4.validateMask())) {
		    var objTemp = null;
		    
		    if(!fieldObj_1.validateMask()) objTemp = fieldArr[0];
		    else if(!fieldObj_2.validateMask()) objTemp = fieldArr[1];
		    else if(!fieldObj_3.validateMask()) objTemp = fieldArr[2];
		    else if(!fieldObj_4.validateMask()) objTemp = fieldArr[3];
		    
		    if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
		    return IPCOM_Constant.returnType.FORMATERROR;
		}
	} else if(type == IPCOM_Constant.appType.IP_EXP) {
		var objTemp = null;
		if(fieldObj_1.valueOfInt() == 0) {
			if(fieldObj_2.valueOfInt() != 0 || fieldObj_3.valueOfInt() != 0 || fieldObj_4.valueOfInt() != 0) {
				if(valueOnly != 'valueOnly') {
					fieldArr[0].select();
				}
				return IPCOM_Constant.returnType.FORMATERROR_EXP;
			}
		} else if(fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
		} else if(fieldObj_2.valueOfInt() > 255) {
            objTemp = fieldArr[1];
        } else if(fieldObj_3.valueOfInt() > 255) {
            objTemp = fieldArr[2];
        } else if(fieldObj_4.valueOfInt() > 255) {
            objTemp = fieldArr[3];
        } 
        if (objTemp != null) {
        	if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
        	return IPCOM_Constant.returnType.FORMATERROR_EXP;
        }
	} else{
		var objTemp = null;
		if (fieldObj_1.valueOfInt() == 0 || fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
		else if (fieldObj_2.valueOfInt() > 255)
			objTemp = fieldArr[1];
		else if (fieldObj_3.valueOfInt() > 255)
			objTemp = fieldArr[2];
		else if (fieldObj_4.valueOfInt() > 255)
			objTemp = fieldArr[3];
		if (objTemp != null) {
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
	}
	var ipString = fieldObj_1.valueOfInt() + "." + fieldObj_2.valueOfInt() + "." + fieldObj_3.valueOfInt() + "." + fieldObj_4.valueOfInt();
	return ipString;
}


function setIpValue(ipStr, ipComId, doc) {
	if (!isIpStr(ipStr)) {
		return false;
	}
	var fieldArr = getFieldArr(ipComId, doc);
	var ipStrArr = ipStr.split(".");

	fieldArr[0].value = ipStrArr[0];
	fieldArr[1].value = ipStrArr[1];
	fieldArr[2].value = ipStrArr[2];
	fieldArr[3].value = ipStrArr[3];
}

function feildValue_CheckObj(srcObj,eventType) {
	if(eventType != IPCOM_Constant.eventType.TABEV && eventType != IPCOM_Constant.eventType.KEYUPEV) return false;
    var index = getFieldIndex(srcObj);
    var type = getType(srcObj.name);
    var intV = parseInt(srcObj.value);
    var isLegal = true;

    if (type == IPCOM_Constant.appType.MASK) {
        if(intV > 255) {
            srcObj.value = 255;
            srcObj.select();
            isLegal =  false;
        }
    } else if(intV > 223 && index == 1) {
        srcObj.value = 223;
        srcObj.select();
        isLegal = false;
    } else if(intV > 255) {
        srcObj.value = 255;
        srcObj.select();
        isLegal = false;
    } else if (index == 1 && parseInt(srcObj.value) == 0) {
    	if(type == IPCOM_Constant.appType.IP_EXP) {
    	}
    	else {
    		srcObj.value = 1;
            srcObj.select();
            isLegal = false;
    	}
        
    }
    
    if(type == IPCOM_Constant.appType.IP && index == 4) {
    	if(intV == 0 || intV >= 255)
    	{
    		srcObj.value = 254;
    		srcObj.focus();
            srcObj.select();	
    	}	
    } 
    
    return isLegal;
}

function onIpFieldKeyUp(event) {
	event = window.event?window.event:event;
    var srcObj = event.srcElement?event.srcElement:event.target;
	var keyCode = event.keyCode;
	
	var index = getFieldIndex(srcObj);
    var type = getType(srcObj.name);
   	var intV = parseInt(srcObj.value);

	if ((keyCode >= 48 && keyCode <= 57) || (keyCode >= 96 && keyCode <= 105)) {
		if (srcObj.value.length >= 3) {
			var goNext = feildValue_CheckObj(srcObj,IPCOM_Constant.eventType.KEYUPEV);
			if (getFieldIndex(srcObj) != 4 && goNext) {
				var nextField = getNextField(srcObj);
				nextField.select();
			}
		}
	}
	
	if(srcObj.pasteStrOld != null) {
		window.clipboardData.setData('text', srcObj.pasteStrOld);
		srcObj.pasteStrOld = null;
	}
}

function onIpFieldKeyDown(event) {
	var srcObj = getEventObj(event);
    event = window.event || event; 
	var keyCode = event.keyCode || event.which;

	if (keyCode == 190 || keyCode == 110) {

		if (srcObj.value != "" && !hasSelectArea(srcObj)) {
			var nextField = getNextField(srcObj);
			nextField.select();
		}

	   if (window.event){
	        return event.returnValue = false;
	    }else{
	        event.preventDefault();
	    }
	}

	else if (keyCode == 39 || keyCode == 40) {
		var curPos = getCaret(srcObj);
		var index = getFieldIndex(srcObj);
		
		if (curPos == srcObj.value.length && index != 4) {
			var nextField = getNextField(srcObj);
			setCaret(nextField, 'start');
			return event.returnValue = false;
		}
	}

	else if (keyCode == 37 || keyCode == 38) {
		var curPos = getCaret(srcObj);
		var index = getFieldIndex(srcObj);
		if (curPos == 0 && index != 1) {
			var preField = getPreField(srcObj);
			setCaret(preField, 'end');
			return event.returnValue = false;
		}
	}


	else if (keyCode == 8) {
		var curPos = getCaret(srcObj);
		if (curPos == 0) {
			var preField = getPreField(srcObj);
			setCaret(preField, 'end');
			return event.returnValue = false;
		}
	}

    else if(event.keyCode == 13) {
    }
    
    else if(event.keyCode == 9) {
        if(!feildValue_CheckObj(srcObj,IPCOM_Constant.eventType.TABEV)) return event.returnValue = false;
    }
    
    else if ((!event.shiftKey && keyCode >= 48 && keyCode <= 57)
			|| (keyCode >= 96 && keyCode <= 105) || keyCode == 46
			|| keyCode == 8) {
		if (window.event){
			if (document.selection
					&& (!event.shiftKey && keyCode >= 48 && keyCode <= 57)
					|| (keyCode >= 96 && keyCode <= 105)) {
				if (document.selection.type.toLowerCase() != "text"
						|| document.selection.createRange().parentElement() != srcObj) {
					if (srcObj.value.length == 3) {
						return event.returnValue = false;
					}
				}
			}
	     }
	}

	else if (event.ctrlKey && (keyCode == 67 || keyCode == 86 || keyCode == 88)) {
		return event.returnValue = true;
	}

	else {
	    if (window.event){
	        return event.returnValue = false;
	    }else{
	        event.preventDefault();
	    }
	}
}

function hasSelectArea(srcObj) {
	if (document.selection) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			return false;
		} else
			return true;
	} else
		return false;
}

function getNextField(obj) {
	var idPrefix = obj.name;
	var index = getFieldIndex(obj);
	var nextField = null;
	
	if (index == 1) {
		nextField = ConditionUtils.getTopDocument().getElementById(idPrefix + 2);
		if(nextField == null)
		{
			nextField = document.getElementById(idPrefix + 2);
		}
	} else if (index == 2) {
		nextField = ConditionUtils.getTopDocument().getElementById(idPrefix + 3);
		if(nextField == null)
		{
			nextField = document.getElementById(idPrefix + 3);
		}
	} else {
		nextField = ConditionUtils.getTopDocument().getElementById(idPrefix + 4);
		if(nextField == null)
		{
			nextField = document.getElementById(idPrefix + 4);
		}
	}
	return nextField;
}

function getPreField(obj) {
	var idPrefix = obj.name;
	var index = getFieldIndex(obj);
	var preField = null;

	if (index == 4) {
		preField = ConditionUtils.getTopDocument().getElementById(idPrefix + 3);
		if(preField ==  null)
		{
			preField = document.getElementById(idPrefix + 3);
		}
	} else if (index == 3) {
		preField = ConditionUtils.getTopDocument().getElementById(idPrefix + 2);
		if(preField ==  null)
		{
			preField = document.getElementById(idPrefix + 2);
		}
	} else {
		preField = ConditionUtils.getTopDocument().getElementById(idPrefix + 1);
		if(preField ==  null)
		{
			preField = document.getElementById(idPrefix + 1);
		}
	}
	
	return preField;
}

function getFieldIndex(obj) {
	var objId = obj.id;
	var len = objId.length;
	return objId.charAt(len - 1);
}

function isIpStr(ipStr) {
	var strArr = ipStr.split(".");

	if (strArr.length != 4) {
		return false;
	}
	for (var i = 0; i < 4; i++) {
		if (strArr[i].length == 0 || strArr[i].length > 3)
			return false;

		if (parseInt(strArr[i]) < 0 || parseInt(strArr[i]) > 255) {
			return false;
		}
	}
	return true;
}

function clearIpCom(ipComId) {
	var fieldArr = getFieldArr(ipComId);
	fieldArr[0].value = "";
	fieldArr[1].value = "";
	fieldArr[2].value = "";
	fieldArr[3].value = "";
}

function disableIpCom(ipComId, b, doc) {
	function disableField_Ext(srcObjId,b,doc) {
	    if (doc == undefined){
	       doc = document;
	    }
        var srcObj = doc.getElementById(srcObjId);
        
        if(srcObj != null)
        {
	        srcObj.disabled = b;
	        if(!b) {
	            srcObj.className = 'ip_input';
	        } else {
	            srcObj.className = 'ip_input_disabled';
	        }
        }
    }
    disableField_Ext(ipComId + '1',b,doc);
    disableField_Ext(ipComId + '2',b,doc);
    disableField_Ext(ipComId + '3',b,doc);
    disableField_Ext(ipComId + '4',b,doc);
} 


function getFieldArr(ipComId,doc) {
	doc = (doc != undefined) ? doc : document;
	var fieldArr = new Array(4);
	for (var i = 0; i < 4; i++) {
	    var ipComIdValue = doc.getElementById(ipComId + (i + 1));
	    if (ipComIdValue != null){
	        fieldArr[i] = ipComIdValue;
	    }else{
	        fieldArr[i] = ConditionUtils.getTopDocument().getElementById(ipComId + (i + 1));
	    }
	}
	return fieldArr;
}

function getType(ipComId) {
	var ipObject = ConditionUtils.getTopDocument().getElementById("H_" + ipComId);
	
	if(ipObject == null)
	{
		ipObject = document.getElementById("H_" + ipComId);
	}
	return ipObject.value;
}

function $Name(name) {
	return document.getElementsByName(name);
}
function setCaret(textbox, pos) {
    if (textbox.createTextRange) { 
		var r = textbox.createTextRange();
		if (pos == "start") {
			r.collapse(true);
		}
		else {
			r.collapse(false);
		}
		r.select();
	}
    else if(textbox.setSelectionRange)        
    {  
        textbox.focus();
        if (pos == "start") {
            textbox.setSelectionRange(0,0);
        }
        else {
            textbox.setSelectionRange(textbox.value.length,textbox.value.length);
        }
    }
    return true;
}

function getCaret(textbox) {
    if (document.selection) {               
    	textbox.focus();
    	var range = document.selection.createRange();
    	range.setEndPoint('StartToStart', textbox.createTextRange());
    	return range.text.length;
    }
    else if (textbox.selectionStart || textbox.selectionStart == '0') {   
        return textbox.selectionStart;
    }
    return 0;
}