﻿var CBB_Dialog = CBB_Dialog;
if(CBB_Dialog == undefined) {

	CBB_Dialog = function (c) {
		
		this.$RRS = c.RRS;

		this.jContainer = null;
		this._doc = null;
		this.jContentFrame = null;
		this.isRendered = false;
		
		this.isShow = false;
		this.jBody = null;
		this.jBtnBar = null;
		this.jBtnOk = null;
		this.jBtnClose = null;
		
		if(!CBB_Dialog.prototype._initialized) {
			var p =  CBB_Dialog.prototype;
			p.ID_SEED = 100;
			
			p.initProperties = function(config) {
				var cfg = jQuery.extend({
					id: "cbb-dialog-" + p.ID_SEED ++,
					title: "iReport CBB Dialog",
					width: 400,
					height: 300,
					url:"",
					contentHtml:"&nbsp;",
					iconClass: "",
					top:0,
					left: 0
				}, config?config:{});
				jQuery.extend(this, cfg);
				this.c = cfg;
				
				var w = parseInt(this.width);
				var h = parseInt(this.height);
				this.width = isNaN(w)?400:w;
				this.height = isNaN(h)?300:h;
			}
			
			p.show = function() {
				
				if(this.isRendered == true) {
					this.showMask();
					this.jContainer.show();
					this.isShow = true;
					return ;
				}
				
				var thisObj = this;

				this._doc = $CUtils.getTopDocument();
				
				this.getContainer().html(this.createDialogHtml());
				
				this.initDialogObjs();
				this.setDialogContent();
			
				DragHandler.init("cbb-dialog-title-" + this.id , "dialogContainer_" + this.id, this._doc);
				
				this.setPosition();
				
				this.showMask();
				
				this.jContainer.show();
				
				this.isRendered = true;
				
				$CUtils.showBodySrollbar(false, this._doc);
				
				this.isShow = true;
			}
			
			p.initDialogObjs = function() {
				this.jTitle = jQuery("#cbb-dialog-title-" + this.id, this._doc).css({
					width: this.width + "px"
				});
				
				this.jBody = jQuery("#dialogBody_" + this.id, this._doc);
				this.jBody.css({
					height: this.height + "px",
					width: this.width + "px"
				})
				
				this.jBottom = jQuery("#cbb-dialog-bottom-" + this.id, this._doc).css("width", this.width + "px");
				
				this.jBtnBar = jQuery("#btnBar_" + this.id, this._doc).css({
					width: "auto"
				});
				
				this.jBtnOk = jQuery("#btnOk_" + this.id, this._doc);
				this.jBtnClose = jQuery("#btnCancel_" + this.id, this._doc)
				
				this.jBtnClose.bind("click", {dialog:this,btn:"CLOSE"}, this._btnHandler);
				this.jBtnOk.bind("click", {dialog:this,btn:"OK"}, this._btnHandler);
			}
			
			p._btnHandler = function(event) {
				var dialog = event.data.dialog;
				var btn = event.data.btn;
				if(dialog.beforeClose) {
					if(dialog.beforeClose(btn, dialog)) {
						dialog.close();
						if(dialog.afterClose) dialog.afterClose(btn, dialog)	
					} 
				}
				else {
					dialog.close();
					if(dialog.afterClose) dialog.afterClose(btn, dialog)	
				}
			}
	
			p.setDialogContent = function() {
				if (this.contentHtml) {
					this.jBody.html(this.contentHtml);
				} 
				else if (this.url) {
					this.jContentFrame = jQuery("<iframe src='" + this.url + "' id='contentIframe_" + this.id + "' allowTransparency='true'  width='100%' height='100%' frameborder='0' style='background-color: #transparent; border:none;'></iframe>", this._doc);
					this.jBody.append(this.jContentFrame);
					this.jContentFrame.dialogInstance = this;
				}
			}
			
			p.createDialogHtml = function() {
					
				var arr = [];
				arr.push("<div class='cbb-dialog-wrap'>");
				arr.push("  	<div class='cbb-dialog-tl'>");
				arr.push("    		<div class='cbb-dialog-tr'>");
				arr.push("    			<div class='cbb-dialog-tc cbb-dialog-header' style='cursor:move;text-align:left;' id='cbb-dialog-title-" + this.id + "'>");
				arr.push("    				<div class='cbb-dialog-header-text'>" +  this.title + "</div>");
				arr.push("    			</div>");
				arr.push("    		</div>");
				arr.push("  	</div>");
				arr.push("  	<div class='cbb-dialog-bwrap'>");
				arr.push("  		<div class='cbb-dialog-ml'>");
				arr.push("    			<div class='cbb-dialog-mr'>");
				arr.push("    				<div class='cbb-dialog-mc'>");
				arr.push("    					<div class='cbb-dialog-body' id='dialogBody_" + this.id + "' >");
				arr.push("        				</div>");
				arr.push("        			</div>");
				arr.push("        		</div>");
				arr.push("        	</div>");
				arr.push("		</div>");
				arr.push("    <div class='cbb-dialog-bl'>");
				arr.push("			<div class='cbb-dialog-br'>");
				arr.push("        		<div class='cbb-dialog-bc' id='cbb-dialog-bottom-" + this.id + "'>");
				arr.push("            		<div id='btnBar_" + this.id + "'  class='cbb-dialog-btnbar'>");
				arr.push("           			<input style='cursor:pointer;' class='button_short' id='btnOk_" + this.id + "' type='button' value='确定'>");
				arr.push("           			<input style='cursor:pointer;' class='button_short' id='btnCancel_" + this.id + "'  type='button' value='取消'>");
				arr.push("            		</div>");
				arr.push("        		</div>");
				arr.push("    		</div>");
				arr.push("		</div>");
				arr.push("		<a href='#' onfocus='$CUtils.el(\"_forTab_" + this.id + "\").focus();'></a>");
				arr.push("	</div>");
				
				return arr.join("\n");
			}
			
			p.getContainer = function() {
				if(this.jContainer == null){
					this.jContainer = jQuery("<div />", this._doc.body).attr("id", "dialogContainer_" + this.id).addClass("cbb-dialog-container").hide().appendTo(this._doc.body);
					this.jContainer.dialogInstance = this;
					this.jContainer.css("width", (this.width + 12) + "px");
				}
				return this.jContainer;
			}
			
			p.close = function() {
	
				this.getContainer().hide();
				this.closeMask();
				
				$CUtils.showBodySrollbar(true, this._doc);
				
				this.isShow = false;
				
			}
			
			p.getOwnerDoc = function() {
				if(this._doc) return this._doc;
				this._doc = $CUtils.getTopDocument();
				return this._doc;
			}
			
			p.setPosition = function() {
				var doc = this._doc;
				var cw = doc.compatMode == "BackCompat"
						? doc.body.clientWidth
						: doc.documentElement.clientWidth;
				var ch = doc.compatMode == "BackCompat"
						? doc.body.clientHeight
						: doc.documentElement.clientHeight;
						
				var sl = Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft);
				var st = Math.max(doc.documentElement.scrollTop, doc.body.scrollTop);
				var sw = Math.max(doc.documentElement.scrollWidth, doc.body.scrollWidth);
				var sh = Math.max(doc.documentElement.scrollHeight, doc.body.scrollHeight);
				
				sw = Math.max(sw, cw);
				sh = Math.max(sh, ch);
				this.top = (ch - this.height - 30) / 2 + st - 8;
				this.left = (cw - this.width - 12) / 2 + sl;
				
				if (this.showBtuttons) {
					this.top -= 18;
				}
				
				if(this.top > 159){
					this.top = 159;
				}				
				
				this.getContainer().css({
					top:this.top + "px",
					left:this.left + "px"
				});
			}
			
			p.setSize = function(w,h) {
				if(w) {
					this.jContainer.css("width", (w+12) + "px");
					this.jTitle.css("width", (w) + "px");
					this.jBody.css("width", w + "px");
					this.jBottom.css("width", w + "px");
					this.width = w;
				}
				if(h) {
					this.jBody.css("height", h + "px");
					this.height = h;
				}
				if(w | h) 
					this.setPosition();
			}
			p.addButton = function(id, txt, func) {
			}
	
			p.destory = function() {
				if(this.jContainer) {
					this.jContainer.remove();
				}
				var el = $CUtils.el("mask_"+ this.id, this._doc);
				if(el) {
					$(el).remove();
				}
			}
	
			p.showMask = function() {
				var pdoc = this._doc;
				var el = $CUtils.el("mask_"+ this.id, this._doc);
				if(!el) {
					var maskBox = jQuery("<div class='cbb-dialog-mask' id='mask_"+ this.id +"' onselectstart='return false;'></div>", pdoc);
					maskBox.html('<div  style="position:absolute; filter:alpha(opacity=1);width:100%;height:100%;"></div><iframe src="about:blank" style="filter:alpha(opacity=1);" width="100%" height="100%" frameborder="0"></iframe>');
					jQuery(pdoc.body).append(maskBox);
					el = $CUtils.el("mask_"+ this.id, pdoc);
				}  
				var w = jQuery(pdoc).width();
				
				el.style.height = "855px";
				el.style.width = w + "px";
				$CUtils.sel(el);
			}
			
			p.closeMask = function() {
				var el = $CUtils.el("mask_"+ this.id, this._doc);
				if(el) {
					$CUtils.hel(el)
				}
			}
			
			CBB_Dialog.prototype._initialized = true;
		}
		
		this.initProperties(c);
		CBB_DialogMgr.add(this);
	}
}
var CBB_DialogMgr = CBB_DialogMgr;
if(CBB_DialogMgr == undefined) {
	var CBB_DialogMgr = {
		idSeed: 1000,
		dialogArr: [],
		dialogMap: {},
		close: function() {
			for(var i = 0 ; i < this.dialogArr.length ; i++) {
				if(this.dialogArr[i]) {
					this.dialogArr[i].close();
				}
			}
		},
		get: function(dialogId) {
			return this.dialogMap[dialogId];
		},
		add: function(dialog) {
			this.dialogArr.push(dialog);
			this.dialogMap[dialog.ID] = dialog;
		},
		alert : function(msg, title, w, h) {
			var dialog = new IReport_CBB_Dialog({
				contentHtml: msg,
				title: title?title: "系统提示",
				width: w ? w : 300,
				height: h ? h : 120
			});
			dialog.AlertFlag = true;
			dialog.show();
			dialog.okBtn.hide();
			dialog.closeBtn.value = "确 定";
			dialog.closeBtn.focus();
			dialog.btnBar.css("textAlign","center");
		},
		confirm: function(msg, title, fn, w, h){
			var dialog = new IReport_CBB_Dialog({
				contentHtml: msg,
				title: title?title: "信息确认",
				width: w ? w : 300,
				height: h ? h : 120,
				afterClose : fn
			});
			dialog.show();
			dialog.okBtn.focus();
			dialog.btnBar.css("textAlign","center");
		},
		setPosition: function(event) {
			var thisObj = event.data;
			for(var i = 0 ; i < thisObj.dialogArr.length ; i++) {
				if(thisObj.dialogArr[i] && thisObj.dialogArr[i].isShow) {
					thisObj.dialogArr[i].setPosition();
				}
			}
		},
		onKeyDown : function(event) {
			var CBB_DialogMgr = event.data;
			if (event.shiftKey && event.keyCode == 9) {
				var len = CBB_DialogMgr.dialogArr.length;
				if(len > 0) {
					CBB_DialogMgr.dialogArr[len - 1].close();
					return false;
				}
			}
			if (event.keyCode == 27) {
				jQuery.each(CBB_DialogMgr.dialogArr, function(i, d) {
					if(d.isShow == true) {
						d.close();
					}
				})
			}
		},
		destory : function(dialogId) {
			if(dialogId) {
				this.dialogArr.remove(this.dialogMap[dialogId]);
				this.dialogMap[dialogId].destory();
				delete this.dialogMap[dialogId];
			} else {
				for(var i = 0 ; i < this.dialogArr.length ; i++) {
					this.destory(this.dialogArr[i].id)
				}
			}
		}
	}
	
	jQuery($CUtils.getTopDocument()).bind("keydown",CBB_DialogMgr,CBB_DialogMgr.onKeyDown);
	jQuery($CUtils.getTopWindow()).bind("resize", CBB_DialogMgr, CBB_DialogMgr.setPosition);
}
