/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.action;

import com.hs.atic.bis.model.DnsPacketInfo;
import com.hs.atic.bis.model.HttpPacketInfo;
import com.hs.atic.bis.model.IpPacketInfo;
import com.hs.atic.bis.model.PacketAnalysis;
import com.hs.atic.bis.model.TcpPacketInfo;
import com.hs.atic.bis.model.UdpPacketInfo;
import com.hs.atic.bis.util.BisConstants;
import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.bis.util.PacketAnalysisUtil;
import com.hs.atic.bis.util.PacketAticUtil;
import com.hs.atic.bis.util.PacketBisUtil;
import com.hs.atic.bis.util.ZoneBisUtil;
import com.hs.atic.sdk.bis.form.AttackLogDetailForm;
import com.hs.atic.sdk.bis.form.AttackerCountForm;
import com.hs.atic.sdk.bis.form.PacketAnalysisForm;
import com.hs.atic.sdk.bis.form.PacketFileForm;
import com.hs.atic.sdk.bis.form.PacketFingerPrintInfoForm;
import com.hs.atic.sdk.bis.form.PacketTaskForm;
import com.hs.atic.sdk.bis.form.ProtocolItemForm;
import com.hs.atic.sdk.bis.service.IPacketFileService;
import com.hs.atic.sdk.util.PacketFileSort;
import com.hs.atic.sdk.util.PacketQueryBean;
import com.hs.atic.sdk.util.PcapLogQueryBean;
import com.hs.atic.sdk.util.ReportQueryBean;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.util.FilterUtil;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneBlacklistForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneFingerPrintForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.policy.third.service.IPacketTaskService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secservice.sdk.module.ddos.service.ICommonUtilService;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class PacketFileAction
extends BaseAction {
    static Comparator<AticDevice> comparator = new Comparator<AticDevice>(){

        @Override
        public int compare(AticDevice fw1, AticDevice fw2) {
            return fw1.getName().toLowerCase(Locale.ENGLISH).compareTo(fw2.getName().toLowerCase(Locale.ENGLISH));
        }
    };
    private static final long serialVersionUID = -8061111208361944642L;
    private static final String QUERY_PACKETFILE_IDS = "queryPacketFileName";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private String attackerNumber;
    private transient IPacketFileService packetFileService;
    private transient IPacketTaskService packetTaskService;
    private transient ICollectorService collectorService;
    private transient IAticDeviceService firewallService;
    private PacketFileForm packetFileForm;
    private List<PacketFileForm> packetFileFormList;
    private List<AttackerCountForm> attackerCountFormList;
    private ProtocolItemForm protocolItemForm;
    private List<ProtocolItemForm> pcapResolutionDataList;
    private String sortType;
    private String sortField;
    private PacketQueryBean packetQueryBean;
    private List<LangPair> strListDeviceSearchComb;
    private String zoneId;
    private String zoneIp4Report;
    private String[] zonePacketIds;
    private String[] zonePacketFileNames;
    private String[] collectorIps;
    private int num;
    private List<AttackLogDetailForm> attackLogDetailFormList;
    private PcapLogQueryBean pcapQueryBean;
    private PacketAnalysisForm packetAnalysisForm;
    private PacketFingerPrintInfoForm attackFingerInfoForm;
    private List<PacketFingerPrintInfoForm> attackFingerInfoList;
    private PacketFingerPrintInfoForm normalFingerInfoForm;
    private List<PacketFingerPrintInfoForm> normalFingerInfoList;
    private String pcapName;
    private int fingerStart;
    private List<PacketFileForm> zonePacketInfos;
    private String combPcapType;
    private String combFileState;
    private Long startTime;
    private Long endTime;
    private Long deviceId;
    private Long attackType;
    private Long deviceType;
    private String collectorIp;
    private String deviceIp;
    private Integer protocolValue;
    private Integer portValue;
    private Long zoneIdOfBlack;
    private String[] ipsOfBlack;
    private String[] protocolsOfBlack;
    private Integer[] portsOfBlack;
    private String allQueryDisplay;
    private List<LangPair> pcapTypeData;
    private List<LangPair> fileStatusData;
    private String[] contents;
    private String[] offsets;
    private String[] fingerPercent;
    private String protocol;
    private int attackerPageSize;
    private int logPageSize;
    private String taskIds;
    private String fileName;
    private String collectorAddress;
    private String collectorStatus;
    private String deviceDisplay;
    private String deviceVersion;
    private String fingerName;
    private String content;
    private String offset;
    private PacketAnalysis packetAnalysis;
    private List<IpPacketInfo> ipPacketInfoList = new ArrayList<IpPacketInfo>();
    private List<IpPacketInfo> ipPacketLengthList = new ArrayList<IpPacketInfo>();
    private List<UdpPacketInfo> udpPacketInfoList = new ArrayList<UdpPacketInfo>();
    private List<UdpPacketInfo> udpFingerInfoList = new ArrayList<UdpPacketInfo>();
    private List<TcpPacketInfo> tcpPacketInfoList = new ArrayList<TcpPacketInfo>();
    private List<TcpPacketInfo> tcpPacketFlagList = new ArrayList<TcpPacketInfo>();
    private List<DnsPacketInfo> dnsPacketInfoList = new ArrayList<DnsPacketInfo>();
    private List<DnsPacketInfo> dnsPacketFirstInfoList = new ArrayList<DnsPacketInfo>();
    private List<DnsPacketInfo> dnsPacketSecondInfoList = new ArrayList<DnsPacketInfo>();
    private List<DnsPacketInfo> dnsPacketThirdInfoList = new ArrayList<DnsPacketInfo>();
    private List<DnsPacketInfo> dnsPacketForthInfoList = new ArrayList<DnsPacketInfo>();
    private List<HttpPacketInfo> httpPacketInfoList = new ArrayList<HttpPacketInfo>();
    private List<HttpPacketInfo> httpRequestInfoList = new ArrayList<HttpPacketInfo>();
    private List<HttpPacketInfo> httpUriList = new ArrayList<HttpPacketInfo>();
    private List<HttpPacketInfo> httpHostList = new ArrayList<HttpPacketInfo>();
    private List<HttpPacketInfo> httpUserAgentList = new ArrayList<HttpPacketInfo>();
    private List<HttpPacketInfo> httpCookieList = new ArrayList<HttpPacketInfo>();
    private List<HttpPacketInfo> httpRefferList = new ArrayList<HttpPacketInfo>();
    private boolean ipLimitDisplay = true;
    private boolean udpLimitDisplay = true;
    private boolean tcpLimitDisplay = true;
    private boolean dnsLimitDisplay = true;
    private boolean httpLimitDisplay = true;
    private List<IpPacketInfo> ipPacketInfoForNum = new ArrayList<IpPacketInfo>();
    private List<UdpPacketInfo> udpPacketInfoForNum = new ArrayList<UdpPacketInfo>();
    private List<TcpPacketInfo> tcpPacketInfoForNum = new ArrayList<TcpPacketInfo>();
    private List<DnsPacketInfo> dnsPacketInfoForNum = new ArrayList<DnsPacketInfo>();
    private List<HttpPacketInfo> httpPacketInfoForNum = new ArrayList<HttpPacketInfo>();
    private boolean hasData = true;

    public void loadSearchComb() {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        IAticDeviceService service = PacketBisUtil.getIFirewallService();
        ArrayList firewalls = service.getAntiDDoSDevice(currentUser.getUserID());
        if (null == firewalls) {
            firewalls = new ArrayList();
        } else {
            this.packetTaskService = PacketBisUtil.getPacketTaskService();
            List devIds = this.packetTaskService.getAllDeployDevice();
            if (null == devIds || devIds.isEmpty()) {
                firewalls = new ArrayList();
            } else {
                for (int i = firewalls.size() - 1; i >= 0; --i) {
                    boolean hasDev = false;
                    AticDevice device = (AticDevice)firewalls.get(i);
                    for (Long devId : devIds) {
                        if (device.getMoId() != devId.longValue()) continue;
                        hasDev = true;
                        break;
                    }
                    if (hasDev) continue;
                    firewalls.remove(i);
                }
            }
        }
        Collections.sort(firewalls, comparator);
        this.strListDeviceSearchComb = new ArrayList<LangPair>();
        if (!firewalls.isEmpty()) {
            for (int i = 0; i < firewalls.size(); ++i) {
                AticDevice firewall = (AticDevice)firewalls.get(i);
                if (null == firewall) continue;
                LangPair lds = new LangPair(firewall.getIpAddress(), firewall.getName());
                this.strListDeviceSearchComb.add(lds);
            }
            if (this.packetQueryBean.getQueryDeviceIp() == null) {
                this.deviceDisplay = ((AticDevice)firewalls.get(0)).getName();
                this.packetQueryBean.setQueryDeviceIp(((AticDevice)firewalls.get(0)).getIpAddress());
            } else {
                for (AticDevice firewall : firewalls) {
                    if (!firewall.getIpAddress().equals(this.packetQueryBean.getQueryDeviceIp())) continue;
                    this.deviceDisplay = firewall.getName();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPacketFile() {
        try {
            logger.info((Object)"Begin PacketFileAction listPacketFile()");
            this.allQueryDisplay = this.getText("atic.public.query.all");
            int start = this.getStart();
            int pageSize = this.getPageSize();
            this.getSession().setAttribute("pageSize", (Object)pageSize);
            this.getSession().setAttribute("start", (Object)start);
            this.firewallService = PacketBisUtil.getIFirewallService();
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            this.collectorService = PacketBisUtil.getCollectorService();
            if (null == this.packetQueryBean) {
                this.packetQueryBean = new PacketQueryBean();
            }
            if (currentUser != null) {
                this.packetQueryBean.setCurrentUseId(currentUser.getUserID());
                this.packetQueryBean.setIsAdmin(Boolean.valueOf(currentUser.getIsAdmin()));
            }
            PacketFileSort<PacketFileForm> sort = this.getPacketFileSort();
            this.loadSearchComb();
            Long devId = this.firewallService.getMoidByIP(this.packetQueryBean.getQueryDeviceIp());
            ArrayList<Long> moIDList = new ArrayList<Long>();
            if (null != devId && 0L != devId) {
                moIDList.add(devId);
            }
            PacketBisUtil.checkUserSecurity(moIDList);
            Long collectorId = PacketBisUtil.getICollectorDeviceService().getCollectorIdByDevId(devId);
            ArrayList<String> collectorIpList = new ArrayList<String>();
            HashMap<String, String> queryMap = new HashMap<String, String>();
            String currentUserId = null;
            String isAdmin = null;
            if (null != currentUser) {
                currentUserId = currentUser.getUserID() + "";
                isAdmin = currentUser.getIsAdmin();
                queryMap.put("currentUserId", currentUserId);
                queryMap.put("currentUserIsAdmin", isAdmin);
            }
            List collectorList = this.collectorService.listCollector(queryMap);
            boolean isExist = false;
            if (null != collectorId && null != collectorList) {
                for (CollectorInfo collector : collectorList) {
                    if (collector.getId() != collectorId.longValue()) continue;
                    isExist = true;
                    if (collector.getStatus() != 1) continue;
                    collectorIpList.add(collector.getIpAddress());
                }
            }
            this.packetFileFormList = new ArrayList<PacketFileForm>();
            this.packetFileService = PacketBisUtil.getPacketFileService();
            Paging page = this.packetFileService.listPacketFile(collectorIpList, this.packetQueryBean, start, pageSize, sort);
            List tmpFormList = page.getData();
            if (!tmpFormList.isEmpty()) {
                this.processPacketFileForm(tmpFormList);
            }
            this.setTotal(page.getCount());
            if (null != devId && null != collectorId) {
                if (collectorList != null) {
                    if (collectorIpList.isEmpty() && isExist) {
                        this.setCollectorStatus("collectorOffLine");
                        logger.info((Object)"Collector is offline!");
                    } else if (collectorIpList.isEmpty() && !isExist) {
                        this.setCollectorStatus("noCollectorAuthority");
                        logger.info((Object)("The user has no authority to check the collector! CurrentUserId:" + currentUserId));
                    }
                } else {
                    this.setCollectorStatus("offLine");
                    logger.info((Object)("The user has no authority to check the collector! CurrentUserId:" + currentUserId));
                }
            } else if (null != devId && null == collectorId) {
                this.setCollectorStatus("noAssociateCollector");
                logger.info((Object)"The device don't associate any collector!");
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)("listPacketFile exception! " + e.getMessage()));
        }
        finally {
            this.pcapTypeData = PacketBisUtil.getPcapTypeCombData(true);
            this.fileStatusData = PacketBisUtil.getPacketFileStatusCombData();
            this.initAdvanceCombox();
        }
        return "list";
    }

    private PacketFileSort<PacketFileForm> getPacketFileSort() {
        PacketFileSort<PacketFileForm> sort = new PacketFileSort<PacketFileForm>();
        if (AticUtil.isNull((String)this.sortField) && AticUtil.isNull((String)this.sortType)) {
            sort.setSortField("startTime");
            sort.setSortType("desc");
        } else {
            sort.setSortField(this.sortField);
            sort.setSortType(this.sortType);
        }
        return sort;
    }

    public void processPacketFileForm(List<PacketFileForm> tmpFormList) {
        if (null != tmpFormList) {
            ArrayList<String> queryPacketFileNameList = new ArrayList<String>();
            for (PacketFileForm form : tmpFormList) {
                if (form.getAttackType() >= 10) {
                    form.setAttackTypeName(PacketAnalysisUtil.getDisplayAttackType(String.valueOf(form.getAttackType())));
                } else if ((0L == form.getZoneId() || null == form.getZoneId()) && 0 == form.getAttackType() && 0 == form.getProtocol() && 0 == form.getPort()) {
                    form.setAttackTypeName("--");
                } else {
                    form.setAttackTypeName(this.getCustomAttackTypeName());
                }
                form.setPcapTypeStr(PacketBisUtil.getPcapTypeString(form.getPcapType()));
                this.packetFileFormList.add(form);
                queryPacketFileNameList.add(form.getFileName());
            }
            logger.info((Object)("queryPacketFileNameList:" + queryPacketFileNameList));
            this.getSession().setAttribute(QUERY_PACKETFILE_IDS, queryPacketFileNameList);
        }
    }

    private String getCustomAttackTypeName() {
        return this.getText("atic.attack.type.0");
    }

    public String listPcapFileFromReport() {
        logger.info((Object)"Begin PacketFileAction listPcapFileFromReport()");
        int start = this.getStart();
        int pageSize = this.getPageSize();
        this.setPageSize(pageSize);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        Long moId = PacketBisUtil.getMoidByZoneid(Long.parseLong(this.zoneId));
        moIdList.add(moId);
        moIdList.add(this.deviceId);
        CollectorInfo collectorInfo = PacketBisUtil.getCollectorService().getCollectorInfo(this.collectorIp);
        if (null != collectorInfo) {
            moIdList.add(collectorInfo.getId());
        }
        PacketBisUtil.checkUserSecurity(moIdList);
        ReportQueryBean bean = new ReportQueryBean();
        bean.setAttackType(this.attackType);
        bean.setCollectorIp(this.collectorIp);
        bean.setDeviceId(this.deviceId);
        bean.setDeviceType(this.deviceType);
        bean.setEndTime(this.endTime);
        bean.setStartTime(this.startTime);
        bean.setZoneId(this.zoneId);
        bean.setZoneIp(this.zoneIp4Report);
        bean.setProtocol(this.protocolValue);
        bean.setPort(this.portValue);
        AticDevice ne = PacketBisUtil.getIFirewallService().getDeviceByMoid(this.deviceId.longValue());
        if (ne != null) {
            bean.setDeviceIp(ne.getIpAddress());
        }
        this.packetFileFormList = new ArrayList<PacketFileForm>();
        CollectorInfo collector = this.getCollectorByIp(this.collectorIp);
        if (collector != null && collector.getStatus() != 1) {
            this.setCollectorStatus("offLine");
        } else {
            this.packetFileService = PacketBisUtil.getPacketFileService();
            Paging page = this.packetFileService.listPcapFileFromReport(bean, start, pageSize);
            List tmpFormList = page.getData();
            if (!tmpFormList.isEmpty()) {
                for (PacketFileForm form : tmpFormList) {
                    PacketTaskForm packetTaskForm = PacketBisUtil.getPacketTaskService().findById(form.getPcapId());
                    if (null != packetTaskForm) {
                        form.setPcapName(packetTaskForm.getPcapTaskName());
                    }
                    if (form.getAttackType() >= 10) {
                        form.setAttackTypeName(PacketAnalysisUtil.getDisplayAttackType(String.valueOf(form.getAttackType())));
                    } else {
                        form.setAttackTypeName(this.getCustomAttackTypeName());
                    }
                    form.setPcapTypeStr(PacketBisUtil.getPcapTypeString(form.getPcapType()));
                    this.packetFileFormList.add(form);
                }
            }
            this.setTotal(page.getCount());
            this.queryPcapTaskWithoutFile();
        }
        return "list";
    }

    private void queryPcapTaskWithoutFile() {
        if (null != this.packetFileFormList && this.packetFileFormList.isEmpty()) {
            Paging taskPage = PacketBisUtil.getPacketTaskService().queryByPage(this.createQueryMap(), 0, Integer.MAX_VALUE);
            List packetTaskList = taskPage.getData();
            StringBuffer taskBuffer = new StringBuffer();
            if (packetTaskList != null) {
                for (int i = 0; i < packetTaskList.size(); ++i) {
                    PacketTaskForm form = (PacketTaskForm)packetTaskList.get(i);
                    if (i != 0) {
                        taskBuffer.append(',');
                    }
                    taskBuffer.append(form.getId());
                }
            }
            this.taskIds = taskBuffer.toString();
        }
    }

    private Map<String, String> createQueryMap() {
        ArrayList<Long> moIDList = new ArrayList<Long>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.deviceId) {
            if (0L != this.deviceId) {
                moIDList.add(this.deviceId);
            }
            queryMap.put("pcapDeviceId", String.valueOf(this.deviceId));
        }
        if (null != this.zoneId) {
            if (StringUtils.isNotBlank((CharSequence)this.zoneId)) {
                moIDList.add(PacketBisUtil.getMoidByZoneid(Long.parseLong(this.zoneId)));
            }
            queryMap.put("zoneId", String.valueOf(this.zoneId));
        }
        PacketBisUtil.checkUserSecurity(moIDList);
        return queryMap;
    }

    private void initAdvanceCombox() {
        if (this.packetQueryBean != null) {
            try {
                String pcapTaskId = this.packetQueryBean.getPcapType();
                String fileStat = this.packetQueryBean.getFileState();
                if (pcapTaskId != null && !"".equals(pcapTaskId)) {
                    this.combPcapType = this.getText((String)BisConstants.getMapPacketTaskType().get(Integer.parseInt(pcapTaskId)));
                }
                if (fileStat != null && !"".equals(fileStat)) {
                    this.combFileState = this.getText((String)BisConstants.getMapPacketFileStatus().get(Integer.parseInt(fileStat)));
                }
            }
            catch (Exception e) {
                logger.error((Object)("init advance comb error!" + e.getMessage()));
            }
        }
    }

    private void checkOpeSecurity(String fileNameSelcet, String collectorIpAddress) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        fileNameList.add(fileNameSelcet);
        this.checkSelectFileSecurity(fileNameList);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        CollectorInfo collectorInfo = PacketBisUtil.getCollectorService().getCollectorInfo(collectorIpAddress);
        if (null != collectorInfo) {
            moIdList.add(collectorInfo.getId());
        }
        PacketBisUtil.checkUserSecurity(moIdList);
    }

    public String findPacketAttackSource() {
        logger.info((Object)"Begin PacketFileAction findPacketAttackSource()");
        String fileNameStr = this.urlFileNameTransferred(this.packetFileForm.getFileName());
        try {
            fileNameStr = URLDecoder.decode(fileNameStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("URLDecoder.decode failed in findPacketAttackSource, fileName:" + this.getcleanedMessage(fileNameStr) + "  Exception:" + e.getMessage()));
        }
        String collectorIP = this.packetFileForm.getFtpAddress();
        Integer attackTypeInt = this.packetFileForm.getAttackType();
        this.checkOpeSecurity(fileNameStr, collectorIP);
        logger.info((Object)("FindPacketAttackSource, fileName: " + this.getcleanedMessage(fileNameStr) + ", collectorIp: " + collectorIP));
        this.packetFileService = PacketBisUtil.getPacketFileService();
        Paging page = this.packetFileService.findAttackSource(collectorIP, fileNameStr, attackTypeInt, this.getStart(), this.getPageSize());
        this.attackerCountFormList = page.getData();
        this.setTotal(page.getCount());
        this.attackerNumber = String.valueOf(page.getCount());
        this.combPcapType = String.valueOf(this.packetFileForm.getPcapType());
        return "list";
    }

    private void checkSelectFileSecurity(List<String> fileNameList) {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        if (isAdmin.booleanValue()) {
            return;
        }
        List queryFaultIds = (List)this.getSession().getAttribute(QUERY_PACKETFILE_IDS);
        if (null == queryFaultIds || queryFaultIds.isEmpty()) {
            return;
        }
        Iterator<String> iterator = fileNameList.iterator();
        while (iterator.hasNext()) {
            String fileNameTemp;
            String fileNamex = fileNameTemp = iterator.next();
            if (!FilterUtil.isChineseChar((String)fileNameTemp)) {
                try {
                    fileNamex = URLDecoder.decode(fileNameTemp, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)("URLDecoder.decode failed in checkSelectFileSecurity, fileName:" + this.getcleanedMessage(fileNameTemp) + "  Exception:" + e.getMessage()));
                }
            }
            if (queryFaultIds.contains(fileNamex)) continue;
            this.log.info((Object)("yue quan operation,ids:" + this.getcleanedMessage(fileNamex)));
            throw new LegoCheckedException(630114L);
        }
    }

    public String urlFileNameTransferred(String packetFileName) {
        if (StringUtils.isEmpty((CharSequence)packetFileName)) {
            return packetFileName;
        }
        String name = packetFileName.replaceAll("\\!", "%21").replaceAll("\\#", "%23").replaceAll("\\+", "%2B").replaceAll("\\;", "%3B").replaceAll("\\=", "%3D").replaceAll("\\@", "%40").replaceAll("\\[", "%5B").replaceAll("\\]", "%5D");
        return name;
    }

    public String packetPcapResolution() {
        logger.info((Object)"Begin PacketFileAction packetPcapResolution()");
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        String fileNameStr = this.urlFileNameTransferred(this.packetFileForm.getFileName());
        try {
            fileNameStr = URLDecoder.decode(fileNameStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("URLDecoder.decode failed in packetPcapResolution, fileName:" + this.getcleanedMessage(fileNameStr) + "  Exception:" + e.getMessage()));
        }
        String collectorIP = this.packetFileForm.getFtpAddress();
        if (AticUtil.isNull((String)collectorIP)) {
            logger.info((Object)"CollectorIp is null in packetPcapResolution() function!");
        } else {
            this.checkOpeSecurity(fileNameStr, collectorIP);
            logger.info((Object)("PcapResolution, fileName: " + this.getcleanedMessage(fileNameStr) + ", collectorIp: " + collectorIP));
            IAticDeviceService aitcDeviceService = PacketBisUtil.getIFirewallService();
            AticDevice aticDeviceIp = aitcDeviceService.getDeviceByIp(this.packetFileForm.getDeviceIp());
            if (null == aticDeviceIp) {
                throw new LegoCheckedException(201L);
            }
            this.deviceVersion = aitcDeviceService.getDeviceByIp(this.packetFileForm.getDeviceIp()).getVersion();
            this.packetFileService = PacketBisUtil.getPacketFileService();
            Paging page = this.packetFileService.findPcapResolution(fileNameStr, collectorIP, this.getStart(), this.getPageSize());
            this.pcapResolutionDataList = page.getData();
            this.setTotal(page.getCount());
        }
        return "list";
    }

    public void packetPcapResolutionData() {
        logger.info((Object)"Begin PacketFileAction packetPcapResolutionData()");
        String result = null;
        this.packetFileService = PacketBisUtil.getPacketFileService();
        result = this.packetFileService.findPcapResolutionData(this.num);
        this.responseResult(result);
    }

    public String pcap2AttackLogDetail() {
        logger.info((Object)"Begin PacketFileAction pcap2AttackLogDetail()");
        this.packetFileService = PacketBisUtil.getPacketFileService();
        if (null == this.pcapQueryBean) {
            this.pcapQueryBean = new PcapLogQueryBean();
        } else {
            CollectorInfo collectorInfo;
            ArrayList<Long> moIdList = new ArrayList<Long>();
            Long moId = PacketBisUtil.getMoidByZoneid(this.pcapQueryBean.getZoneId());
            moIdList.add(moId);
            AticDevice aticDevice = PacketBisUtil.getIFirewallService().getDeviceByIp(this.pcapQueryBean.getDeviceIp());
            if (null != aticDevice) {
                moIdList.add(aticDevice.getMoId());
            }
            if (null != (collectorInfo = PacketBisUtil.getCollectorService().getCollectorInfo(this.pcapQueryBean.getFtpAddress()))) {
                moIdList.add(collectorInfo.getId());
            }
            PacketBisUtil.checkUserSecurity(moIdList);
        }
        Paging page = this.packetFileService.pcap2AttackLogDetail(this.pcapQueryBean, this.getStart(), this.getPageSize());
        this.attackLogDetailFormList = page.getData();
        if (!this.attackLogDetailFormList.isEmpty()) {
            for (AttackLogDetailForm form : this.attackLogDetailFormList) {
                if (form.getAttackTypeValue() >= 10) {
                    form.setAttackTypes(PacketAnalysisUtil.getDisplayAttackType(String.valueOf(form.getAttackTypeValue())));
                } else {
                    form.setAttackTypes(this.getCustomAttackTypeName());
                }
                form.setAttackStatusStr(PacketBisUtil.getDsipalyAttackStatus(form.getAttackStatus()));
            }
        }
        this.setTotal(page.getCount());
        return "list";
    }

    public String getProtocolType(int attackTypeInt, int protocolStr) {
        String protocolType = "IP";
        HashMap<Integer, String> customServiceMap = new HashMap<Integer, String>();
        customServiceMap.put(1, "TCP");
        customServiceMap.put(2, "UDP");
        customServiceMap.put(3, "HTTP");
        HashMap<Integer, String> elseProtocolMap = new HashMap<Integer, String>();
        elseProtocolMap.put(10, "TCP");
        elseProtocolMap.put(11, "TCP");
        elseProtocolMap.put(12, "TCP");
        elseProtocolMap.put(13, "TCP");
        elseProtocolMap.put(14, "TCP");
        elseProtocolMap.put(15, "TCP");
        elseProtocolMap.put(16, "TCP");
        elseProtocolMap.put(17, "TCP");
        elseProtocolMap.put(18, "TCP");
        elseProtocolMap.put(19, "UDP");
        elseProtocolMap.put(20, "UDP");
        elseProtocolMap.put(21, "UDP");
        elseProtocolMap.put(22, "UDP");
        elseProtocolMap.put(23, "ICMP");
        elseProtocolMap.put(24, "IP");
        elseProtocolMap.put(25, "IP");
        elseProtocolMap.put(26, "TCP");
        elseProtocolMap.put(27, "HTTP");
        elseProtocolMap.put(29, "DNS");
        elseProtocolMap.put(30, "DNS");
        elseProtocolMap.put(31, "UDP");
        elseProtocolMap.put(32, "TCP");
        elseProtocolMap.put(33, "HTTP");
        elseProtocolMap.put(34, "TCP");
        elseProtocolMap.put(35, "TCP");
        elseProtocolMap.put(36, "UDP");
        elseProtocolMap.put(37, "UDP");
        elseProtocolMap.put(38, "ICMP");
        elseProtocolMap.put(39, "IP");
        elseProtocolMap.put(40, "TCP");
        elseProtocolMap.put(41, "HTTP");
        elseProtocolMap.put(42, "DNS");
        elseProtocolMap.put(43, "DNS");
        elseProtocolMap.put(44, "DNS");
        elseProtocolMap.put(45, "DNS");
        elseProtocolMap.put(46, "DNS");
        elseProtocolMap.put(47, "DNS");
        elseProtocolMap.put(48, "DNS");
        elseProtocolMap.put(49, "DNS");
        elseProtocolMap.put(50, "DNS");
        elseProtocolMap.put(51, "DNS");
        elseProtocolMap.put(52, "IP");
        elseProtocolMap.put(53, "TCP");
        elseProtocolMap.put(54, "TCP");
        elseProtocolMap.put(55, "UDP");
        elseProtocolMap.put(56, "DNS(No Such Name)");
        elseProtocolMap.put(57, "IP");
        elseProtocolMap.put(58, "IP");
        elseProtocolMap.put(59, "HTTP");
        elseProtocolMap.put(60, "IP");
        elseProtocolMap.put(61, "IP");
        elseProtocolMap.put(62, "HTTP");
        elseProtocolMap.put(63, "IP");
        elseProtocolMap.put(64, "UDP");
        elseProtocolMap.put(65, "IP");
        elseProtocolMap.put(66, "IP");
        elseProtocolMap.put(67, "IP");
        elseProtocolMap.put(68, "IP");
        elseProtocolMap.put(69, "TCP");
        elseProtocolMap.put(70, "UDP");
        elseProtocolMap.put(71, "ICMP");
        elseProtocolMap.put(72, "IP");
        elseProtocolMap.put(73, "IP");
        try {
            if (attackTypeInt < 10) {
                for (Map.Entry customMap : customServiceMap.entrySet()) {
                    if (protocolStr != (Integer)customMap.getKey()) continue;
                    protocolType = (String)customMap.getValue();
                }
            } else {
                for (Map.Entry protocolMap : elseProtocolMap.entrySet()) {
                    if (attackTypeInt != (Integer)protocolMap.getKey()) continue;
                    protocolType = (String)protocolMap.getValue();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getProtocolType error !" + e.getMessage()));
        }
        return protocolType;
    }

    public String packetAnalysis() {
        logger.info((Object)"Begin PacketFileAction openFingerPrint()");
        if (null == this.packetAnalysisForm) {
            return "success";
        }
        int attackTypeInt = Integer.parseInt(this.packetAnalysisForm.getAttackType());
        int protocolInt = Integer.parseInt(this.packetAnalysisForm.getProtocol());
        String protocolStr = this.getProtocolType(attackTypeInt, protocolInt);
        this.packetAnalysisForm.setProtocol(protocolStr);
        logger.info((Object)"Begin PacketFileAction getFingerPrint()");
        String fileNameStr = this.urlFileNameTransferred(this.packetAnalysisForm.getFileName());
        try {
            fileNameStr = URLDecoder.decode(fileNameStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("URLDecoder.decode failed in packetPcapResolution, fileName:" + this.getcleanedMessage(fileNameStr) + "  Exception:" + e.getMessage()));
        }
        String collectorIP = this.packetAnalysisForm.getCollectorIp();
        this.checkOpeSecurity(fileNameStr, collectorIP);
        this.packetFileService = PacketBisUtil.getPacketFileService();
        this.packetAnalysis = this.packetFileService.getPacketAnalysisResult(fileNameStr, this.transformProtocol(protocolStr), collectorIP);
        if (null != this.packetAnalysis) {
            Object info;
            Object info2;
            int i;
            List<IpPacketInfo> ipPacketInfoListTemp = this.packetAnalysis.getIpPacketInfoList();
            List<UdpPacketInfo> udpPacketInfoListTemp = this.packetAnalysis.getUdpPacketInfoList();
            List<UdpPacketInfo> udpFingerInfoListTemp = this.packetAnalysis.getUdpFingerInfoList();
            List<TcpPacketInfo> tcpPacketInfoListTemp = this.packetAnalysis.getTcpPacketInfoList();
            this.dnsPacketInfoList = this.packetAnalysis.getDnsPacketInfoList();
            this.httpPacketInfoList = this.packetAnalysis.getHttpPacketInfoList();
            List<HttpPacketInfo> httpRequestInfoListTemp = this.packetAnalysis.getHttpRequestInfoList();
            if (null != ipPacketInfoListTemp && !ipPacketInfoListTemp.isEmpty()) {
                this.ipLimitDisplay = ipPacketInfoListTemp.get(0).getIpNum() == 0;
                this.ipPacketInfoForNum.add(ipPacketInfoListTemp.get(0));
                for (i = 0; i < ipPacketInfoListTemp.size(); ++i) {
                    info2 = ipPacketInfoListTemp.get(i);
                    if (0 < ((IpPacketInfo)info2).getSrcIpNum()) {
                        this.ipPacketInfoList.add((IpPacketInfo)info2);
                    }
                    if (0 >= ((IpPacketInfo)info2).getIpLengthNum()) continue;
                    this.ipPacketLengthList.add((IpPacketInfo)info2);
                }
            }
            if (null != udpPacketInfoListTemp && !udpPacketInfoListTemp.isEmpty()) {
                this.udpLimitDisplay = udpPacketInfoListTemp.get(0).getUdpNum() == 0;
                this.udpPacketInfoForNum.add(udpPacketInfoListTemp.get(0));
                for (i = 0; i < udpPacketInfoListTemp.size(); ++i) {
                    info2 = udpPacketInfoListTemp.get(i);
                    if (0 >= ((UdpPacketInfo)info2).getUdpPortNum()) continue;
                    this.udpPacketInfoList.add((UdpPacketInfo)info2);
                }
            }
            if (null != udpFingerInfoListTemp && !udpFingerInfoListTemp.isEmpty()) {
                for (i = 0; i < udpFingerInfoListTemp.size(); ++i) {
                    info2 = udpFingerInfoListTemp.get(i);
                    if (0 >= ((UdpPacketInfo)info2).getFingerNum()) continue;
                    this.udpFingerInfoList.add((UdpPacketInfo)info2);
                }
            }
            if (!this.udpLimitDisplay && null != this.udpFingerInfoList && !this.udpFingerInfoList.isEmpty()) {
                this.udpLimitDisplay = false;
            }
            if (null != tcpPacketInfoListTemp && !tcpPacketInfoListTemp.isEmpty()) {
                this.tcpLimitDisplay = tcpPacketInfoListTemp.get(0).getTcpNum() == 0;
                this.tcpPacketInfoForNum.add(tcpPacketInfoListTemp.get(0));
                for (i = 0; i < tcpPacketInfoListTemp.size(); ++i) {
                    info2 = tcpPacketInfoListTemp.get(i);
                    if (0 < ((TcpPacketInfo)info2).getTcpPortNum()) {
                        this.tcpPacketInfoList.add((TcpPacketInfo)info2);
                    }
                    if (0 >= ((TcpPacketInfo)info2).getTcpFlagNum()) continue;
                    this.tcpPacketFlagList.add((TcpPacketInfo)info2);
                }
            }
            if (null != this.dnsPacketInfoList && !this.dnsPacketInfoList.isEmpty()) {
                this.dnsLimitDisplay = this.dnsPacketInfoList.get(0).getDnsNum() == 0;
                this.dnsPacketInfoForNum.add(this.dnsPacketInfoList.get(0));
                List<DnsPacketInfo> dnsPacketFirstInfoListTemp = this.dnsPacketInfoList.subList(0, 5);
                for (int i2 = 0; i2 < dnsPacketFirstInfoListTemp.size(); ++i2) {
                    DnsPacketInfo info3 = dnsPacketFirstInfoListTemp.get(i2);
                    if (0 >= info3.getFirstLevelDomainNameNum()) continue;
                    this.dnsPacketFirstInfoList.add(info3);
                }
                List<DnsPacketInfo> dnsPacketSecondInfoListTemp = this.dnsPacketInfoList.subList(5, 10);
                for (int i3 = 0; i3 < dnsPacketSecondInfoListTemp.size(); ++i3) {
                    DnsPacketInfo info4 = dnsPacketSecondInfoListTemp.get(i3);
                    if (0 >= info4.getSecondLevelDomainNameNum()) continue;
                    this.dnsPacketSecondInfoList.add(info4);
                }
                List<DnsPacketInfo> dnsPacketThirdInfoListTemp = this.dnsPacketInfoList.subList(10, 15);
                for (int i4 = 0; i4 < dnsPacketThirdInfoListTemp.size(); ++i4) {
                    DnsPacketInfo info5 = dnsPacketThirdInfoListTemp.get(i4);
                    if (0 >= info5.getThreeLevelDomainNameNum()) continue;
                    this.dnsPacketThirdInfoList.add(info5);
                }
                List<DnsPacketInfo> dnsPacketForthInfoListTemp = this.dnsPacketInfoList.subList(15, 20);
                for (int i5 = 0; i5 < dnsPacketForthInfoListTemp.size(); ++i5) {
                    info = dnsPacketForthInfoListTemp.get(i5);
                    if (0 >= ((DnsPacketInfo)info).getFourLevelDomainNameNum()) continue;
                    this.dnsPacketForthInfoList.add((DnsPacketInfo)info);
                }
            }
            if (null != this.httpPacketInfoList && !this.httpPacketInfoList.isEmpty()) {
                this.httpLimitDisplay = this.httpPacketInfoList.get(0).getHttpNum() == 0;
                this.httpPacketInfoForNum.add(this.httpPacketInfoList.get(0));
                List<HttpPacketInfo> httpUriListTemp = this.httpPacketInfoList.subList(0, 25);
                for (int i6 = 0; i6 < httpUriListTemp.size(); ++i6) {
                    HttpPacketInfo info6 = httpUriListTemp.get(i6);
                    if (0 >= info6.getUriNum()) continue;
                    this.httpUriList.add(info6);
                }
                List<HttpPacketInfo> httpHostListTemp = this.httpPacketInfoList.subList(25, 30);
                for (int i7 = 0; i7 < httpHostListTemp.size(); ++i7) {
                    HttpPacketInfo info7 = httpHostListTemp.get(i7);
                    if (0 >= info7.getHostNum()) continue;
                    this.httpHostList.add(info7);
                }
                List<HttpPacketInfo> httpUserAgentListTemp = this.httpPacketInfoList.subList(30, 35);
                for (int i8 = 0; i8 < httpUserAgentListTemp.size(); ++i8) {
                    HttpPacketInfo info8 = httpUserAgentListTemp.get(i8);
                    if (0 >= info8.getUserAgentNum()) continue;
                    this.httpUserAgentList.add(info8);
                }
                List<HttpPacketInfo> httpCookieListTemp = this.httpPacketInfoList.subList(35, 40);
                for (int i9 = 0; i9 < httpCookieListTemp.size(); ++i9) {
                    info = httpCookieListTemp.get(i9);
                    if (0 >= ((HttpPacketInfo)info).getCookieNum()) continue;
                    this.httpCookieList.add((HttpPacketInfo)info);
                }
                List<HttpPacketInfo> httpRefferListTemp = this.httpPacketInfoList.subList(40, 45);
                for (int i10 = 0; i10 < httpRefferListTemp.size(); ++i10) {
                    HttpPacketInfo info9 = httpRefferListTemp.get(i10);
                    if (0 >= info9.getReferNum()) continue;
                    this.httpRefferList.add(info9);
                }
            }
            if (null != httpRequestInfoListTemp && !httpRequestInfoListTemp.isEmpty()) {
                for (int i11 = 0; i11 < httpRequestInfoListTemp.size(); ++i11) {
                    info2 = httpRequestInfoListTemp.get(i11);
                    if (0 >= ((HttpPacketInfo)info2).getHttpRequestNum()) continue;
                    this.httpRequestInfoList.add((HttpPacketInfo)info2);
                }
            }
            if (!this.httpLimitDisplay && null != this.httpRequestInfoList && !this.httpRequestInfoList.isEmpty()) {
                this.httpLimitDisplay = false;
            }
        }
        this.fetchRequest().setAttribute("ipLimitDisplay", (Object)String.valueOf(this.ipLimitDisplay));
        this.fetchRequest().setAttribute("udpLimitDisplay", (Object)String.valueOf(this.udpLimitDisplay));
        this.fetchRequest().setAttribute("tcpLimitDisplay", (Object)String.valueOf(this.tcpLimitDisplay));
        this.fetchRequest().setAttribute("dnsLimitDisplay", (Object)String.valueOf(this.dnsLimitDisplay));
        this.fetchRequest().setAttribute("httpLimitDisplay", (Object)String.valueOf(this.httpLimitDisplay));
        if (this.ipLimitDisplay && this.udpLimitDisplay && this.tcpLimitDisplay && this.dnsLimitDisplay && this.httpLimitDisplay) {
            this.hasData = false;
        }
        this.fetchRequest().setAttribute("hasData", (Object)String.valueOf(this.hasData));
        this.fetchRequest().setAttribute("pcapType", (Object)this.packetAnalysisForm.getPcapType());
        return "success";
    }

    private String transformProtocol(String protocolStr) {
        String protocolType = null;
        protocolType = "DNS(No Such Name)".equalsIgnoreCase(protocolStr) ? "DNS_N" : protocolStr;
        return protocolType;
    }

    public void deployZoneFinger() {
        try {
            this.addZoneFinger(false);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("atic.bis.pcap.finger.deployFinger failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.pcap.finger.deployFinger", "lego.dic.module.AticBis", true, null, null, this.pcapName, 3, false, (Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error((Object)("atic.bis.pcap.finger.deployFinger failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.pcap.finger.deployFinger", "lego.dic.module.AticBis", true, null, null, this.pcapName, 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)("atic.bis.pcap.finger.deployFinger failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.pcap.finger.deployFinger", "lego.dic.module.AticBis", true, null, null, this.pcapName, 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public String analyzeSelFinger() {
        this.fingerName = "ManualFingerprint" + this.getCurrentTimeString();
        this.content = this.content.trim();
        this.offset = this.offset.trim();
        if (this.deviceVersion.startsWith("V100R001") && this.content.length() > 16 && !this.deviceVersion.contains("SPC900")) {
            this.content = this.content.substring(0, 16);
        } else if (this.content.length() > 64) {
            this.content = this.content.substring(0, 64);
        }
        this.checkFingerprint(this.content, this.offset);
        return "success";
    }

    private String getCurrentTimeString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        return sdf.format(new Date());
    }

    public void addManualFinger() {
        this.fingerName = this.fingerName.trim();
        PolicyUtil.checkFilterBeforeAdd((String)this.fingerName);
        this.content = this.content.trim();
        this.offset = this.offset.trim();
        this.checkFingerprint(this.content, this.offset);
        try {
            IFilterService filterService = PacketBisUtil.getFilterService();
            FilterForm filterForm = filterService.queryByName(this.fingerName);
            if (null != filterForm) {
                this.responseResult("FingerNameExist");
                this.systemOpeLog("atic.bis.pcap.finger.deployFinger", "lego.dic.module.AticBis", false, null, "atic.bis.packetFile.addFingerSummary.failed2", this.fingerName, 3, false, null);
                return;
            }
            this.contents = new String[]{this.content};
            this.offsets = new String[]{this.offset};
            this.protocol = "IP";
            this.addZoneFinger(true);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("atic.bis.pcap.finger.deployFinger failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.pcap.finger.deployFinger", "lego.dic.module.AticBis", false, null, "atic.bis.packetFile.addFingerSummary.failed2", this.fingerName, 3, false, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)("atic.bis.pcap.finger.deployFinger failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.pcap.finger.deployFinger", "lego.dic.module.AticBis", false, null, "atic.bis.packetFile.addFingerSummary.failed2", this.fingerName, 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    private void checkFingerprint(String filterContent, String filterOffset) {
        StringBuffer fingerPrint = new StringBuffer(filterOffset.trim() + " ");
        for (int i = 0; i < filterContent.trim().length(); ++i) {
            fingerPrint.append("\\x" + filterContent.trim().substring(i, i + 2));
            ++i;
        }
        fingerPrint.append("        ");
        FilterUtil.checkFingerprint((String)fingerPrint.toString());
    }

    public void addZoneFinger(boolean isManualFinger) {
        logger.info((Object)"Begin PacketFileAction deployZoneFinger()");
        String userName = "";
        ZoneInfoForm zone = null;
        if (null != this.zoneId && !"".equals(this.zoneId)) {
            zone = PacketBisUtil.getZoneService().getById(Long.valueOf(Long.parseLong(this.zoneId)));
        }
        if (null == zone) {
            logger.error((Object)("The zone (zoneId = " + this.zoneId + ") dosen't exist !"));
            this.responseResult("UserNotExist");
            this.systemOpeLog("atic.bis.pcap.finger.deployFinger", "lego.dic.module.AticBis", false, new String[]{userName}, "atic.bis.packetFile.addFingerSummary.failed2", userName, 3, false, null);
            return;
        }
        userName = zone.getZoneDesc();
        String operation = "atic.bis.pcap.finger.deployFinger";
        if (isManualFinger) {
            operation = "atic.bis.pcap.manualadd.finger.deployFinger";
        }
        this.firewallService = PacketBisUtil.getIFirewallService();
        AticDevice firewall = this.firewallService.getDeviceByIp(this.deviceIp);
        if (null == firewall) {
            logger.error((Object)("device not exist! device ip is " + this.deviceIp));
            this.responseResult("DeviceNotExist");
            this.systemOpeLog(operation, "lego.dic.module.AticBis", false, new String[]{userName}, "atic.bis.packetFile.addFingerSummary.failed1", userName, 3, false, null);
            return;
        }
        Long moId = PacketBisUtil.getMoidByZoneid(Long.valueOf(this.zoneId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        moIdList.add(firewall.getMoId());
        PacketBisUtil.checkUserSecurity(moIdList);
        String ddosVersion = this.getDeviceVersion(AticUtil.convertIpFromStr2Long((String)this.deviceIp));
        if (!"4".equalsIgnoreCase(ddosVersion) && "IP".equalsIgnoreCase(this.protocol.trim())) {
            logger.error((Object)("protocol is " + this.getcleanedMessage(this.protocol.trim()) + ", device don't support"));
            this.responseResult("DeviceNotSupport");
            this.systemOpeLog(operation, "lego.dic.module.AticBis", false, new String[]{userName}, "atic.bis.packetFile.addFingerSummary.failed1", userName, 3, false, null);
            return;
        }
        if ("DNS(No Such Name)".equalsIgnoreCase(this.protocol.trim())) {
            if (!"4".equalsIgnoreCase(ddosVersion) && !"2".equalsIgnoreCase(ddosVersion)) {
                logger.error((Object)("devType:" + firewall.getDeviceModel() + ", device don't support dns request domain !"));
            }
            this.responseResult("DeviceNotSupportDomain");
            this.systemOpeLog(operation, "lego.dic.module.AticBis", false, new String[]{userName}, "atic.bis.packetFile.addFingerSummary.failed1", userName, 3, false, null);
            return;
        }
        if ("1".equalsIgnoreCase(ddosVersion) && "ICMP".equalsIgnoreCase(this.protocol.trim())) {
            logger.error((Object)("devType:" + firewall.getDeviceModel() + ", protocol:" + this.protocol.trim() + "; device don't support"));
            this.responseResult("DeviceNotSupport");
            this.systemOpeLog(operation, "lego.dic.module.AticBis", false, new String[]{userName}, "atic.bis.packetFile.addFingerSummary.failed1", userName, 3, false, null);
            return;
        }
        if (null != this.contents && this.contents[0].contains("0x")) {
            for (int i = 0; i < this.contents.length; ++i) {
                String contentTemp = this.contents[i];
                this.contents[i] = contentTemp = contentTemp.replace("0x", "").replace(" ", "");
            }
        }
        this.addZoneFingerItems(Long.valueOf(this.zoneId), userName, firewall, operation);
    }

    private void addZoneFingerItems(Long zoneID, String userNameStr, AticDevice firewall, String operation) {
        IZoneMgrNorthSerice service = PacketBisUtil.getZoneMgrNorthSerice();
        int fail = 0;
        ArrayList<BatchOperation> batchOpList = new ArrayList<BatchOperation>();
        String detailName = this.getText("atic.bis.pcap.file.add.finger");
        if (null != this.contents) {
            for (int i = 0; i < this.contents.length; ++i) {
                BatchOperation bo = new BatchOperation();
                bo.setTargetName(this.contents[i] + "/" + this.offsets[i]);
                bo.setDetailParam(new String[]{detailName, userNameStr});
                ZoneFingerPrintForm zoneFingerForm = new ZoneFingerPrintForm();
                zoneFingerForm.setContent(this.contents[i]);
                if (null == this.protocol || "".equals(this.protocol.trim())) {
                    zoneFingerForm.setProtocol(null);
                } else {
                    zoneFingerForm.setProtocol(this.protocol.trim());
                }
                zoneFingerForm.setOffset(this.offsets[i]);
                zoneFingerForm.setZoneId(zoneID);
                zoneFingerForm.setDevId(Long.valueOf(firewall.getMoId()));
                zoneFingerForm.setMatchType(Integer.valueOf(1));
                zoneFingerForm.setContentType(Integer.valueOf(2));
                Integer errcode = service.addZoneFingerItem(zoneID, Long.valueOf(firewall.getMoId()), zoneFingerForm, this.fingerName);
                if (0 != errcode) {
                    bo.setErrorCode((long)errcode.intValue());
                    ++fail;
                    this.systemOpeLog(operation, "lego.dic.module.AticBis", false, bo.getDetailParam(), "atic.bis.packetFile.addFingerSummary.failed1", userNameStr, 3, false, null);
                }
                batchOpList.add(bo);
            }
            if (fail == 0) {
                this.responseResult("addFingerSuccess");
                this.systemOpeLog(operation, "lego.dic.module.AticBis", false, new String[]{Long.toString(zoneID)}, "atic.bis.packetFile.addFingerSummary", userNameStr, 3, true, null);
                return;
            }
            this.batchOperationResult = new BatchOperationResult();
            this.batchOperationResult.setResult(batchOpList);
            this.batchOperationResult.setFailCount(fail);
            this.batchOperationResult.setTotalCount(this.contents.length);
            this.batchOperationResult.setSucceedCount(this.contents.length - fail);
            this.bathResult(this.batchOperationResult);
        }
    }

    private String getDeviceVersion(Long deviceIP) {
        ICommonUtilService commonUtilService = PacketBisUtil.getICommonUtilService();
        return commonUtilService.getDDoSVersion(AticUtil.convertIpFromLong2Str((long)deviceIP));
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public void addBlacklist() {
        logger.info((Object)"Begin PacketFileAction addBlacklist()");
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.ipsOfBlack.length; ++i) {
            buf.append(this.ipsOfBlack[i]);
            buf.append(',');
        }
        String ipList = buf.toString();
        ipList = ipList.substring(0, ipList.length() - 1);
        String userName = "";
        ZoneInfoForm zone = null;
        if (null != this.zoneIdOfBlack && !"".equals(String.valueOf(this.zoneIdOfBlack))) {
            zone = PacketBisUtil.getZoneService().getById(this.zoneIdOfBlack);
        }
        if (null == zone) {
            this.responseResult("UserNotExist");
            return;
        }
        userName = zone.getZoneDesc();
        if (null == this.zoneIdOfBlack || "".equals(String.valueOf(this.zoneIdOfBlack))) {
            logger.error((Object)"zoneId is null in addBlacklist() function!");
            throw new LegoCheckedException(570609L);
        }
        Long moId = ZoneBisUtil.getMoidByZoneid((Long)this.zoneIdOfBlack);
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(moId);
        BisUtil.checkUserSecurity(moIdList);
        try {
            IZoneMgrNorthSerice service = PacketBisUtil.getZoneMgrNorthSerice();
            ArrayList<ZoneBlacklistForm> blacklistForms = new ArrayList<ZoneBlacklistForm>();
            for (int i = 0; i < this.ipsOfBlack.length; ++i) {
                ZoneBlacklistForm blackList = new ZoneBlacklistForm();
                blackList.setZoneId(this.zoneIdOfBlack);
                String ip = this.ipsOfBlack[i];
                logger.info((Object)("black ip is: " + ip));
                if (IPUtil.isIpv6(ip)) {
                    blackList.setIpAndMask(ip + "/" + 128);
                } else {
                    blackList.setIpAndMask(ip + "/" + 32);
                }
                logger.info((Object)("blist is: " + this.getcleanedMessage(blackList.toString())));
                if ("OTHER".equalsIgnoreCase(this.protocolsOfBlack[i])) {
                    blackList.setProtocol("ALL");
                } else {
                    blackList.setProtocol(this.protocolsOfBlack[i]);
                }
                if (this.portsOfBlack[i] > 0) {
                    blackList.setPort(this.portsOfBlack[i]);
                }
                blacklistForms.add(blackList);
            }
            service.addBlackListItems(blacklistForms);
            this.systemOpeLog("atic.bis.packet.file.add.blacklist", "lego.dic.module.AticBis", false, new String[]{userName, ipList}, "atic.bis.packetFile.addBlackSummary", userName, 3, true, null);
            this.responseResult("success");
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("atic.bis.packet.file.add.blacklist failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.packet.file.add.blacklist", "lego.dic.module.AticBis", false, new String[]{userName, ipList}, "atic.bis.packetFile.addBlackSummary", userName, 3, false, (Exception)((Object)ex));
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error((Object)("atic.bis.packet.file.add.blacklist failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.packet.file.add.blacklist", "lego.dic.module.AticBis", false, new String[]{userName, ipList}, "atic.bis.packetFile.addBlackSummary", userName, 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
        catch (Exception ex) {
            logger.error((Object)("atic.bis.packet.file.add.blacklist failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.packet.file.add.blacklist", "lego.dic.module.AticBis", false, new String[]{userName, ipList}, "atic.bis.packetFile.addBlackSummary", userName, 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public void delPacketFiles() {
        logger.info((Object)"Begin PacketFileAction delPacketFiles()");
        String result = "success";
        String fileName01 = "";
        StringBuffer buf = new StringBuffer();
        try {
            if (null != this.zonePacketFileNames) {
                ArrayList<String> fileNameList = new ArrayList<String>();
                for (int i = 0; i < this.zonePacketFileNames.length; ++i) {
                    buf.append(this.zonePacketFileNames[i]);
                    buf.append(',');
                    fileNameList.add(this.zonePacketFileNames[i]);
                }
                this.checkSelectFileSecurity(fileNameList);
                ArrayList<Long> moIdList = new ArrayList<Long>();
                this.collectorService = PacketBisUtil.getCollectorService();
                for (int i = 0; i < this.collectorIps.length; ++i) {
                    CollectorInfo collectorInfo = this.collectorService.getCollectorInfo(this.collectorIps[i]);
                    if (null == collectorInfo) continue;
                    moIdList.add(collectorInfo.getId());
                }
                PacketBisUtil.checkUserSecurity(moIdList);
                fileName01 = buf.toString();
                fileName01 = fileName01.substring(0, fileName01.length() - 1);
            }
            if (fileName01.indexOf(91) > -1 || fileName01.indexOf(93) > -1) {
                fileName01 = fileName01.replace("[", " ");
                fileName01 = fileName01.replace("]", " ");
            }
            if (null == this.zonePacketFileNames) {
                logger.error((Object)"zonePacketFileNames is null in delPacketFiles() function!");
                throw new LegoCheckedException(570505L);
            }
            this.packetFileService = PacketBisUtil.getPacketFileService();
            result = this.packetFileService.delPacketFiles(this.zonePacketFileNames, this.collectorIps);
            this.systemOpeLog("atic.bis.packet.file.del", "lego.dic.module.AticBis", false, new String[]{fileName01}, "atic.bis.packetFile.delSummary", fileName01, 3, true, null);
            this.responseResult(result);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("atic.bis.packet.file.del failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.packet.file.del", "lego.dic.module.AticBis", false, null, "atic.bis.packetFile.delSummary.failed", fileName01, 3, false, (Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)("atic.bis.packet.file.del failed, ex: " + ex.getMessage()));
            this.systemOpeLog("atic.bis.packet.file.del", "lego.dic.module.AticBis", false, null, "atic.bis.packetFile.delSummary.failed", fileName01, 3, false, ex);
            throw new LegoUncheckedException((Throwable)ex);
        }
    }

    public boolean idValidation() {
        String[] ids = this.getZonePacketIds();
        if (ids.length > 100) {
            return false;
        }
        for (int i = 0; i < ids.length; ++i) {
            long id = Long.parseLong(ids[i]);
            if (id >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean ipValidation() {
        String[] ips = this.getCollectorIps();
        for (int i = 0; i < ips.length; ++i) {
            String ip = ips[i];
            if (this.ipValidation(ip)) continue;
            return false;
        }
        return true;
    }

    public boolean validationName() {
        String[] names = this.getZonePacketFileNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (name.matches("^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$")) continue;
            return false;
        }
        return true;
    }

    public boolean ipValidation(String ip) {
        return IPUtil.isIpv4(ip) || IPUtil.isIpv6(ip);
    }

    public IPacketFileService getPacketFileService() {
        return this.packetFileService;
    }

    public void setPacketFileService(IPacketFileService packetFileService) {
        this.packetFileService = packetFileService;
    }

    public List<PacketFileForm> getPacketFileFormList() {
        return this.packetFileFormList;
    }

    public void setPacketFileFormList(List<PacketFileForm> packetFileFormList) {
        this.packetFileFormList = packetFileFormList;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public PacketQueryBean getPacketQueryBean() {
        return this.packetQueryBean;
    }

    public void setPacketQueryBean(PacketQueryBean packetQueryBean) {
        this.packetQueryBean = packetQueryBean;
    }

    public List<AttackerCountForm> getAttackerCountFormList() {
        return this.attackerCountFormList;
    }

    public void setAttackerCountFormList(List<AttackerCountForm> attackerCountFormList) {
        this.attackerCountFormList = attackerCountFormList;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public PacketFileForm getPacketFileForm() {
        return this.packetFileForm;
    }

    public void setPacketFileForm(PacketFileForm packetFileForm) {
        this.packetFileForm = packetFileForm;
    }

    public String getAttackerNumber() {
        return this.attackerNumber;
    }

    public void setAttackerNumber(String attackerNumber) {
        this.attackerNumber = attackerNumber;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String[] getZonePacketIds() {
        if (null != this.zonePacketIds) {
            return (String[])this.zonePacketIds.clone();
        }
        return new String[0];
    }

    public void setZonePacketIds(String[] zonePacketIds) {
        this.zonePacketIds = null != zonePacketIds ? (String[])zonePacketIds.clone() : null;
    }

    public String[] getZonePacketFileNames() {
        if (null != this.zonePacketFileNames) {
            return (String[])this.zonePacketFileNames.clone();
        }
        return new String[0];
    }

    public void setZonePacketFileNames(String[] zonePacketFileNames) {
        this.zonePacketFileNames = null != zonePacketFileNames ? (String[])zonePacketFileNames.clone() : null;
    }

    public String[] getCollectorIps() {
        if (null != this.collectorIps) {
            return (String[])this.collectorIps.clone();
        }
        return new String[0];
    }

    public void setCollectorIps(String[] collectorIps) {
        this.collectorIps = null != collectorIps ? (String[])collectorIps.clone() : null;
    }

    public List<ProtocolItemForm> getPcapResolutionDataList() {
        return this.pcapResolutionDataList;
    }

    public void setPcapResolutionDataList(List<ProtocolItemForm> pcapResolutionDataList) {
        this.pcapResolutionDataList = pcapResolutionDataList;
    }

    public ProtocolItemForm getProtocolItemForm() {
        return this.protocolItemForm;
    }

    public void setProtocolItemForm(ProtocolItemForm protocolItemForm) {
        this.protocolItemForm = protocolItemForm;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public List<AttackLogDetailForm> getAttackLogDetailFormList() {
        return this.attackLogDetailFormList;
    }

    public void setAttackLogDetailFormList(List<AttackLogDetailForm> attackLogDetailFormList) {
        this.attackLogDetailFormList = attackLogDetailFormList;
    }

    public PcapLogQueryBean getPcapQueryBean() {
        return this.pcapQueryBean;
    }

    public void setPcapQueryBean(PcapLogQueryBean pcapQueryBean) {
        this.pcapQueryBean = pcapQueryBean;
    }

    public PacketFingerPrintInfoForm getAttackFingerInfoForm() {
        return this.attackFingerInfoForm;
    }

    public void setAttackFingerInfoForm(PacketFingerPrintInfoForm attackFingerInfoForm) {
        this.attackFingerInfoForm = attackFingerInfoForm;
    }

    public List<PacketFingerPrintInfoForm> getAttackFingerInfoList() {
        return this.attackFingerInfoList;
    }

    public void setAttackFingerInfoList(List<PacketFingerPrintInfoForm> attackFingerInfoList) {
        this.attackFingerInfoList = attackFingerInfoList;
    }

    public PacketFingerPrintInfoForm getNormalFingerInfoForm() {
        return this.normalFingerInfoForm;
    }

    public void setNormalFingerInfoForm(PacketFingerPrintInfoForm normalFingerInfoForm) {
        this.normalFingerInfoForm = normalFingerInfoForm;
    }

    public List<PacketFingerPrintInfoForm> getNormalFingerInfoList() {
        return this.normalFingerInfoList;
    }

    public void setNormalFingerInfoList(List<PacketFingerPrintInfoForm> normalFingerInfoList) {
        this.normalFingerInfoList = normalFingerInfoList;
    }

    public static long getSerialVersionUID() {
        return -8061111208361944642L;
    }

    public String getPcapName() {
        return this.pcapName;
    }

    public void setPcapName(String pcapName) {
        this.pcapName = pcapName;
    }

    public List<PacketFileForm> getZonePacketInfos() {
        return this.zonePacketInfos;
    }

    public void setZonePacketInfos(List<PacketFileForm> zonePacketInfos) {
        this.zonePacketInfos = zonePacketInfos;
    }

    public int getFingerPageSize() {
        return null == this.fetchRequest().getParameter("fingerPageSize") && null == this.packetQueryBean ? this.pageSize : (Integer)this.getSession().getAttribute("fingerPageSize");
    }

    public int getFingerStart() {
        return this.fingerStart;
    }

    public void setFingerStart(int fingerStart) {
        this.fingerStart = fingerStart;
    }

    public String getCombPcapType() {
        if (null == this.combPcapType) {
            return null;
        }
        return this.combPcapType.trim();
    }

    public void setCombPcapType(String combPcapType) {
        this.combPcapType = combPcapType;
    }

    public String getCombFileState() {
        if (null == this.combFileState) {
            return null;
        }
        return this.combFileState.trim();
    }

    public void setCombFileState(String combFileState) {
        this.combFileState = combFileState;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public Long getAttackType() {
        return this.attackType;
    }

    public void setAttackType(Long attackType) {
        this.attackType = attackType;
    }

    public Long getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(Long deviceType) {
        this.deviceType = deviceType;
    }

    public String getCollectorIp() {
        return this.collectorIp;
    }

    public void setCollectorIp(String collectorIp) {
        this.collectorIp = collectorIp;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public Long getZoneIdOfBlack() {
        return this.zoneIdOfBlack;
    }

    public void setZoneIdOfBlack(Long zoneIdOfBlack) {
        this.zoneIdOfBlack = zoneIdOfBlack;
    }

    public String[] getIpsOfBlack() {
        if (null != this.ipsOfBlack) {
            return (String[])this.ipsOfBlack.clone();
        }
        return new String[0];
    }

    public void setIpsOfBlack(String[] ipsOfBlack) {
        this.ipsOfBlack = null != ipsOfBlack ? (String[])ipsOfBlack.clone() : null;
    }

    public String[] getProtocolsOfBlack() {
        if (null != this.protocolsOfBlack) {
            return (String[])this.protocolsOfBlack.clone();
        }
        return new String[0];
    }

    public void setProtocolsOfBlack(String[] protocolsOfBlack) {
        this.protocolsOfBlack = null != protocolsOfBlack ? (String[])protocolsOfBlack.clone() : null;
    }

    public Integer[] getPortsOfBlack() {
        if (null != this.portsOfBlack) {
            return (Integer[])this.portsOfBlack.clone();
        }
        return new Integer[0];
    }

    public void setPortsOfBlack(Integer[] portsOfBlack) {
        this.portsOfBlack = null != portsOfBlack ? (Integer[])portsOfBlack.clone() : null;
    }

    public String getAllQueryDisplay() {
        if (null == this.allQueryDisplay) {
            return null;
        }
        return this.allQueryDisplay.trim();
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public List<LangPair> getPcapTypeData() {
        return this.pcapTypeData;
    }

    public List<LangPair> getFileStatusData() {
        return this.fileStatusData;
    }

    public String[] getContents() {
        if (null != this.contents) {
            return (String[])this.contents.clone();
        }
        return new String[0];
    }

    public void setContents(String[] contents) {
        this.contents = null != contents ? (String[])contents.clone() : null;
    }

    public String[] getOffsets() {
        if (null != this.offsets) {
            return (String[])this.offsets.clone();
        }
        return new String[0];
    }

    public void setOffsets(String[] offsets) {
        this.offsets = null != offsets ? (String[])offsets.clone() : null;
    }

    public String[] getFingerPercent() {
        if (null != this.fingerPercent) {
            return (String[])this.fingerPercent.clone();
        }
        return new String[0];
    }

    public void setFingerPercent(String[] fingerPercent) {
        this.fingerPercent = null != fingerPercent ? (String[])fingerPercent.clone() : null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public int getAttackerPageSize() {
        return this.attackerPageSize;
    }

    public void setAttackerPageSize(int attackerPageSize) {
        this.attackerPageSize = attackerPageSize;
    }

    public int getLogPageSize() {
        return this.logPageSize;
    }

    public void setLogPageSize(int logPageSize) {
        this.logPageSize = logPageSize;
    }

    public String getTaskIds() {
        return this.taskIds;
    }

    public void setTaskIds(String taskIds) {
        this.taskIds = taskIds;
    }

    public int getPageSize() {
        return null == this.fetchRequest().getParameter("pageSize") && null == this.packetQueryBean ? this.pageSize : (Integer)this.getSession().getAttribute("pageSize");
    }

    public List<LangPair> getStrListDeviceSearchComb() {
        return this.strListDeviceSearchComb;
    }

    public void setStrListDeviceSearchComb(List<LangPair> strListDeviceSearchComb) {
        this.strListDeviceSearchComb = strListDeviceSearchComb;
    }

    public void setPageSize(int pageSize) {
        this.getSession().setAttribute("pageSize", (Object)pageSize);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getCollectorAddress() {
        return this.collectorAddress;
    }

    public void setCollectorAddress(String collectorAddress) {
        this.collectorAddress = collectorAddress;
    }

    public String getCollectorStatus() {
        return this.collectorStatus;
    }

    public void setCollectorStatus(String collectorStatus) {
        this.collectorStatus = collectorStatus;
    }

    public Integer getProtocolValue() {
        return this.protocolValue;
    }

    public void setProtocolValue(Integer protocolValue) {
        this.protocolValue = protocolValue;
    }

    public Integer getPortValue() {
        return this.portValue;
    }

    public void setPortValue(Integer portValue) {
        this.portValue = portValue;
    }

    public void queryPcapFileExist() {
        CollectorInfo collector = this.getCollectorByIp(this.collectorAddress);
        if (collector == null || collector.getStatus() != 1) {
            this.responseResult("offLine");
            return;
        }
        this.checkOpeSecurity(this.fileName, this.collectorAddress);
        String pcapFileName = this.getPcapFileName(this.fileName);
        this.packetFileService = PacketBisUtil.getPacketFileService();
        Boolean existBool = this.packetFileService.findPcapFileByName(this.collectorAddress, pcapFileName);
        if (existBool != null && existBool.booleanValue()) {
            this.responseResult("exist");
        } else {
            this.responseResult("noexist");
        }
    }

    private CollectorInfo getCollectorByIp(String collectorIP) {
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        this.collectorService = PacketBisUtil.getCollectorService();
        List collectorList = this.collectorService.listCollector(queryMap);
        if (collectorList != null) {
            for (CollectorInfo collector : collectorList) {
                if (!collector.getIpAddress().equals(collectorIP)) continue;
                return collector;
            }
        }
        return null;
    }

    private String getPcapFileName(String fileName01) {
        StringBuffer tempFileName = new StringBuffer();
        if (fileName01 != null) {
            tempFileName.append(fileName01);
            tempFileName.append(".pcap");
        }
        return tempFileName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pcapFileDownload() {
        this.fileName = this.fileName.replaceAll("\\+", "%2B").replaceAll("\\#", "%23");
        String pcapFileName = this.getPcapFileName(this.fileName);
        User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        if (!PacketAticUtil.checkPacpFileName(pcapFileName, "pcap")) {
            SysOptLog logout = new SysOptLog();
            logout.setLevel(SysoplogLevel.info.getValue());
            logout.setResult(1);
            logout.setModule("lego.dic.module.user");
            logout.setOperation("lego.lab.com.loginout");
            logout.setOperator(user.getUserName());
            logout.setTerminalIp(user.getIpAdr());
            logout.setTarget(user.getUserName());
            logout.setDetail("atic.system.check.filepath.error");
            ISysOptLog sysLogService = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            sysLogService.writeOptLog(logout);
            this.fetchRequest().getSession().invalidate();
            return;
        }
        this.checkOpeSecurity(this.fileName, this.collectorAddress);
        String attachFileName = null;
        String logFileName = null;
        try {
            pcapFileName = URLDecoder.decode(pcapFileName, "UTF-8");
            logFileName = URLDecoder.decode(this.fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("URLDecoder.decode failed in pcapFileDownload, fileName:" + this.getcleanedMessage(this.fileName) + "  Exception:" + e.getMessage()));
        }
        attachFileName = pcapFileName.replace(' ', '_');
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.DOWNLOAD_PCAP_FILE)) {
            logger.error((Object)"pcap file export operate is executing!");
            throw new LegoCheckedException(570516L);
        }
        this.getResponse().setContentType("application/x-download");
        this.getResponse().setCharacterEncoding("windows-1251");
        String isoFileName = this.parse2ISOEncoding(attachFileName, this.fetchRequest().getHeader("user-agent"));
        this.getResponse().addHeader("Content-Disposition", "attachment;filename=" + isoFileName);
        FilterOutputStream bos = null;
        try {
            this.packetFileService = PacketBisUtil.getPacketFileService();
            byte[] b = this.packetFileService.downloadPcapFile(this.collectorAddress, attachFileName);
            bos = new BufferedOutputStream((OutputStream)this.getResponse().getOutputStream());
            bos.write(b);
            this.systemOpeLog("atic.bis.pcap.file.download", "lego.dic.module.AticBis", false, new String[]{logFileName}, "atic.bis.pcap.file.download.success", logFileName, 3, true, null);
        }
        catch (Exception e) {
            logger.error((Object)(this.getcleanedMessage(attachFileName) + " pcapFileDownload error." + e.getMessage()));
            this.systemOpeLog("atic.bis.pcap.file.download", "lego.dic.module.AticBis", false, new String[]{logFileName}, "atic.bis.pcap.file.download.failed", logFileName, 3, false, e);
        }
        finally {
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.DOWNLOAD_PCAP_FILE);
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("outputStream IOException!" + e.getMessage()));
            }
        }
    }

    private String parse2ISOEncoding(String sourceString, String userAgent) {
        if (sourceString == null || sourceString.equals("")) {
            return sourceString;
        }
        try {
            sourceString = userAgent != null && (userAgent.toLowerCase(Locale.ENGLISH).indexOf("firefox") >= 0 || userAgent.toLowerCase(Locale.ENGLISH).indexOf("chrome") >= 0 || userAgent.toLowerCase(Locale.ENGLISH).indexOf("safari") >= 0) ? new String(sourceString.getBytes("UTF-8"), "ISO8859-1") : URLEncoder.encode(sourceString, "UTF8");
            return sourceString;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("packet download unsupported encoding! " + e.getMessage()));
            return sourceString;
        }
    }

    public String getZoneIp4Report() {
        return this.zoneIp4Report;
    }

    public void setZoneIp4Report(String zoneIp4Report) {
        this.zoneIp4Report = zoneIp4Report;
    }

    public boolean validateIp(String parameterName) {
        HttpServletRequest request = ServletActionContext.getRequest();
        String ip = request.getParameter(parameterName);
        return IPUtil.isIpv4(ip.trim()) || IPUtil.isIpv6(ip.trim());
    }

    public boolean validateEndTimeNotNull() {
        String date = this.pcapQueryBean.getEndTime();
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateStartTimeNotNull() {
        String date = this.pcapQueryBean.getStartTime();
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateStartTimeNotNull2() {
        String date = this.packetAnalysisForm.getStartTime();
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateBeginTime() {
        if (null == this.packetQueryBean) {
            return true;
        }
        String date = this.packetQueryBean.getBeginTime();
        if ("".equals(date) || null == date) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateEndTime() {
        if (null == this.packetQueryBean) {
            return true;
        }
        String date = this.packetQueryBean.getEndTime();
        if ("".equals(date) || null == date) {
            return true;
        }
        return AticUtil.checkDateFormat((String)"yyyy-MM-dd HH:mm:ss", (String)date);
    }

    public boolean validateAnalysisId(String parameterName) {
        HttpServletRequest request = ServletActionContext.getRequest();
        String id = request.getParameter(parameterName);
        if (null == id || "".equals(id) || "0".equals(id)) {
            return true;
        }
        return this.validateId(parameterName);
    }

    public boolean validateId(String parameterName) {
        HttpServletRequest request = ServletActionContext.getRequest();
        String id = request.getParameter(parameterName);
        long idTemp = 0L;
        try {
            idTemp = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Integer format is error");
            return false;
        }
        return idTemp >= 0L;
    }

    public boolean validatePcapNum() {
        String numberTemp = this.packetAnalysisForm.getPcapNum();
        long numTemp = 0L;
        try {
            numTemp = Long.parseLong(numberTemp);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Integer format is error");
            return false;
        }
        return numTemp >= 1L && numTemp <= 100000L;
    }

    public boolean validateFileName() {
        if (null == this.packetQueryBean) {
            return true;
        }
        String name = this.packetQueryBean.getFileName();
        if ("".equals(name) || null == name) {
            return true;
        }
        if (name.length() > 64) {
            return false;
        }
        if (name.trim().equalsIgnoreCase("null")) {
            return false;
        }
        String regex = "^(?!null$)[\u4e00-\u9fa5|a-zA-Z0-9|\\!|\\@|\\#|\\$|\\*|\\^|\\+|\\-|\\_|\\=|\\|\\}|\\{|\\]|\\[|\\;|\\?|\\/|\\.]*$";
        return name.matches(regex);
    }

    public boolean validateContents() {
        if (this.contents.length == 0) {
            return false;
        }
        String regex = "^[\\w|\u4e00-\u9fa5|\\=|\\-|\\!|\\@|\\%|\\#|\\$|\\*|\\^|\\:|\\,|\\;|\\.|\\+|\\}|\\{ ]*$";
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i].matches(regex)) continue;
            return false;
        }
        return true;
    }

    public boolean validateOffsets() {
        if (this.offsets.length == 0) {
            return false;
        }
        String regex = "^[\\w|\u4e00-\u9fa5|\\=|\\-|\\!|\\@|\\%|\\#|\\$|\\*|\\^|\\:|\\,|\\;|\\.|\\+|\\}|\\{]*$";
        for (int i = 0; i < this.offsets.length; ++i) {
            if (this.offsets[i].matches(regex)) continue;
            return false;
        }
        return true;
    }

    public boolean validatePercents() {
        if (this.fingerPercent.length == 0) {
            return false;
        }
        float temp = 0.0f;
        for (int i = 0; i < this.fingerPercent.length; ++i) {
            try {
                temp = Float.parseFloat(this.fingerPercent[i]);
            }
            catch (NumberFormatException e) {
                logger.error((Object)"Integer format is error");
                return false;
            }
            if (temp >= 1.0f && temp <= 100.0f) continue;
            return false;
        }
        return true;
    }

    public boolean validateString(String name) {
        return AticUtil.isNull((String)name) || name.matches("^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$");
    }

    public boolean validateFileName(String name) {
        if (AticUtil.isNull((String)name)) {
            return false;
        }
        try {
            name = URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)"validate file name error");
            return false;
        }
        if ((long)name.length() > 256L) {
            return false;
        }
        String pcapFileNameRegex = "^.*(\\\\|/|:|\\?|\\*|\\||\"|<|>).*$";
        return !name.matches(pcapFileNameRegex);
    }

    public boolean validateIpsOfBlack() {
        if (null == this.ipsOfBlack) {
            return false;
        }
        if (this.ipsOfBlack.length > 100) {
            return false;
        }
        for (int i = 0; i < this.ipsOfBlack.length; ++i) {
            boolean bool;
            boolean bl = bool = IPUtil.isIpv4(this.ipsOfBlack[i].trim()) || IPUtil.isIpv6(this.ipsOfBlack[i].trim());
            if (bool) continue;
            return false;
        }
        return true;
    }

    public boolean validateProtocolsOfBlack() {
        if (null == this.protocolsOfBlack) {
            return false;
        }
        if (this.protocolsOfBlack.length > 100) {
            return false;
        }
        String regex = "^[\\w|\u4e00-\u9fa5|=|\\-|!|@|#|$|*|^|:|,|.|+|%|}|{]*$";
        for (int i = 0; i < this.protocolsOfBlack.length; ++i) {
            if (this.protocolsOfBlack[i].matches(regex)) continue;
            return false;
        }
        return true;
    }

    public boolean validatePcapType() {
        return this.packetQueryBean == null || null == this.packetQueryBean.getPcapType() || "".equals(this.packetQueryBean.getPcapType()) || Integer.parseInt(this.packetQueryBean.getPcapType()) >= 0 && Integer.parseInt(this.packetQueryBean.getPcapType()) <= 3;
    }

    public boolean validateFileState() {
        return this.packetQueryBean == null || null == this.packetQueryBean.getFileState() || "".equals(this.packetQueryBean.getFileState()) || Integer.parseInt(this.packetQueryBean.getFileState()) >= 0 && Integer.parseInt(this.packetQueryBean.getFileState()) <= 1;
    }

    public boolean validateQueryDeviceIp() {
        if (this.packetQueryBean == null) {
            return true;
        }
        return AticUtil.isNullForVpn((String)this.packetQueryBean.getQueryDeviceIp()) || IPUtil.isIpv4(this.packetQueryBean.getQueryDeviceIp()) || IPUtil.isIpv6(this.packetQueryBean.getQueryDeviceIp());
    }

    public boolean validateQueryPacketIp() {
        if (this.packetQueryBean == null) {
            return true;
        }
        return null == this.packetQueryBean.getQueryPacketIp() || "".equals(this.packetQueryBean.getQueryPacketIp()) || IPUtil.isIpv4(this.packetQueryBean.getQueryPacketIp()) || IPUtil.isIpv6(this.packetQueryBean.getQueryPacketIp());
    }

    public boolean validateTaskName() {
        if (null == this.packetQueryBean) {
            return true;
        }
        String name = this.packetQueryBean.getTaskName();
        if ("".equals(name) || null == name) {
            return true;
        }
        if (name.length() > 64) {
            return false;
        }
        if (name.trim().equalsIgnoreCase("null")) {
            return false;
        }
        String regex = "^(?!null$)[\u4e00-\u9fa5|a-zA-Z0-9|\\!|\\@|\\#|\\$|\\*|\\^|\\+|\\-|\\_|\\=|\\|\\}|\\{|\\]|\\[|\\;|\\?|\\/|\\.]*$";
        return name.matches(regex);
    }

    public boolean validateFingerName() {
        if (AticUtil.isNull((String)this.fingerName)) {
            return false;
        }
        String locationNameRegex = "^(?!\\s*(?i)null$)[\\w*]{1,63}$";
        return this.fingerName.length() <= 63 && this.fingerName.matches(locationNameRegex);
    }

    public boolean validatePortsOfBlack() {
        if (null == this.portsOfBlack) {
            return false;
        }
        for (Integer portTemp : this.portsOfBlack) {
            if (portTemp >= -1) continue;
            return false;
        }
        return true;
    }

    public String getDeviceDisplay() {
        return this.deviceDisplay;
    }

    public void setDeviceDisplay(String deviceDisplay) {
        this.deviceDisplay = deviceDisplay;
    }

    public String getDeviceVersion() {
        return this.deviceVersion;
    }

    public String getFingerName() {
        return this.fingerName;
    }

    public void setFingerName(String fingerName) {
        this.fingerName = fingerName;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public void setDeviceVersion(String deviceVersion) {
        this.deviceVersion = deviceVersion;
    }

    public List<IpPacketInfo> getIpPacketInfoList() {
        return this.ipPacketInfoList;
    }

    public void setIpPacketInfoList(List<IpPacketInfo> ipPacketInfoList) {
        this.ipPacketInfoList = ipPacketInfoList;
    }

    public PacketAnalysisForm getPacketAnalysisForm() {
        return this.packetAnalysisForm;
    }

    public void setPacketAnalysisForm(PacketAnalysisForm packetAnalysisForm) {
        this.packetAnalysisForm = packetAnalysisForm;
    }

    public List<UdpPacketInfo> getUdpPacketInfoList() {
        return this.udpPacketInfoList;
    }

    public void setUdpPacketInfoList(List<UdpPacketInfo> udpPacketInfoList) {
        this.udpPacketInfoList = udpPacketInfoList;
    }

    public List<TcpPacketInfo> getTcpPacketInfoList() {
        return this.tcpPacketInfoList;
    }

    public void setTcpPacketInfoList(List<TcpPacketInfo> tcpPacketInfoList) {
        this.tcpPacketInfoList = tcpPacketInfoList;
    }

    public List<DnsPacketInfo> getDnsPacketInfoList() {
        return this.dnsPacketInfoList;
    }

    public void setDnsPacketInfoList(List<DnsPacketInfo> dnsPacketInfoList) {
        this.dnsPacketInfoList = dnsPacketInfoList;
    }

    public List<HttpPacketInfo> getHttpPacketInfoList() {
        return this.httpPacketInfoList;
    }

    public void setHttpPacketInfoList(List<HttpPacketInfo> httpPacketInfoList) {
        this.httpPacketInfoList = httpPacketInfoList;
    }

    public boolean isIpLimitDisplay() {
        return this.ipLimitDisplay;
    }

    public void setIpLimitDisplay(boolean ipLimitDisplay) {
        this.ipLimitDisplay = ipLimitDisplay;
    }

    public boolean isUdpLimitDisplay() {
        return this.udpLimitDisplay;
    }

    public void setUdpLimitDisplay(boolean udpLimitDisplay) {
        this.udpLimitDisplay = udpLimitDisplay;
    }

    public boolean isTcpLimitDisplay() {
        return this.tcpLimitDisplay;
    }

    public void setTcpLimitDisplay(boolean tcpLimitDisplay) {
        this.tcpLimitDisplay = tcpLimitDisplay;
    }

    public boolean isDnsLimitDisplay() {
        return this.dnsLimitDisplay;
    }

    public void setDnsLimitDisplay(boolean dnsLimitDisplay) {
        this.dnsLimitDisplay = dnsLimitDisplay;
    }

    public boolean isHttpLimitDisplay() {
        return this.httpLimitDisplay;
    }

    public void setHttpLimitDisplay(boolean httpLimitDisplay) {
        this.httpLimitDisplay = httpLimitDisplay;
    }

    public List<IpPacketInfo> getIpPacketInfoForNum() {
        return this.ipPacketInfoForNum;
    }

    public void setIpPacketInfoForNum(List<IpPacketInfo> ipPacketInfoForNum) {
        this.ipPacketInfoForNum = ipPacketInfoForNum;
    }

    public List<UdpPacketInfo> getUdpPacketInfoForNum() {
        return this.udpPacketInfoForNum;
    }

    public void setUdpPacketInfoForNum(List<UdpPacketInfo> udpPacketInfoForNum) {
        this.udpPacketInfoForNum = udpPacketInfoForNum;
    }

    public List<TcpPacketInfo> getTcpPacketInfoForNum() {
        return this.tcpPacketInfoForNum;
    }

    public void setTcpPacketInfoForNum(List<TcpPacketInfo> tcpPacketInfoForNum) {
        this.tcpPacketInfoForNum = tcpPacketInfoForNum;
    }

    public List<DnsPacketInfo> getDnsPacketInfoForNum() {
        return this.dnsPacketInfoForNum;
    }

    public void setDnsPacketInfoForNum(List<DnsPacketInfo> dnsPacketInfoForNum) {
        this.dnsPacketInfoForNum = dnsPacketInfoForNum;
    }

    public List<HttpPacketInfo> getHttpPacketInfoForNum() {
        return this.httpPacketInfoForNum;
    }

    public void setHttpPacketInfoForNum(List<HttpPacketInfo> httpPacketInfoForNum) {
        this.httpPacketInfoForNum = httpPacketInfoForNum;
    }

    public boolean isHasData() {
        return this.hasData;
    }

    public void setHasData(boolean hasData) {
        this.hasData = hasData;
    }

    public List<UdpPacketInfo> getUdpFingerInfoList() {
        return this.udpFingerInfoList;
    }

    public void setUdpFingerInfoList(List<UdpPacketInfo> udpFingerInfoList) {
        this.udpFingerInfoList = udpFingerInfoList;
    }

    public List<HttpPacketInfo> getHttpRequestInfoList() {
        return this.httpRequestInfoList;
    }

    public void setHttpRequestInfoList(List<HttpPacketInfo> httpRequestInfoList) {
        this.httpRequestInfoList = httpRequestInfoList;
    }

    public List<HttpPacketInfo> getHttpUriList() {
        return this.httpUriList;
    }

    public void setHttpUriList(List<HttpPacketInfo> httpUriList) {
        this.httpUriList = httpUriList;
    }

    public List<HttpPacketInfo> getHttpHostList() {
        return this.httpHostList;
    }

    public void setHttpHostList(List<HttpPacketInfo> httpHostList) {
        this.httpHostList = httpHostList;
    }

    public List<HttpPacketInfo> getHttpUserAgentList() {
        return this.httpUserAgentList;
    }

    public void setHttpUserAgentList(List<HttpPacketInfo> httpUserAgentList) {
        this.httpUserAgentList = httpUserAgentList;
    }

    public List<HttpPacketInfo> getHttpCookieList() {
        return this.httpCookieList;
    }

    public void setHttpCookieList(List<HttpPacketInfo> httpCookieList) {
        this.httpCookieList = httpCookieList;
    }

    public List<HttpPacketInfo> getHttpRefferList() {
        return this.httpRefferList;
    }

    public void setHttpRefferList(List<HttpPacketInfo> httpRefferList) {
        this.httpRefferList = httpRefferList;
    }

    public List<DnsPacketInfo> getDnsPacketFirstInfoList() {
        return this.dnsPacketFirstInfoList;
    }

    public void setDnsPacketFirstInfoList(List<DnsPacketInfo> dnsPacketFirstInfoList) {
        this.dnsPacketFirstInfoList = dnsPacketFirstInfoList;
    }

    public List<DnsPacketInfo> getDnsPacketSecondInfoList() {
        return this.dnsPacketSecondInfoList;
    }

    public void setDnsPacketSecondInfoList(List<DnsPacketInfo> dnsPacketSecondInfoList) {
        this.dnsPacketSecondInfoList = dnsPacketSecondInfoList;
    }

    public List<DnsPacketInfo> getDnsPacketThirdInfoList() {
        return this.dnsPacketThirdInfoList;
    }

    public void setDnsPacketThirdInfoList(List<DnsPacketInfo> dnsPacketThirdInfoList) {
        this.dnsPacketThirdInfoList = dnsPacketThirdInfoList;
    }

    public List<DnsPacketInfo> getDnsPacketForthInfoList() {
        return this.dnsPacketForthInfoList;
    }

    public void setDnsPacketForthInfoList(List<DnsPacketInfo> dnsPacketForthInfoList) {
        this.dnsPacketForthInfoList = dnsPacketForthInfoList;
    }

    public List<IpPacketInfo> getIpPacketLengthList() {
        return this.ipPacketLengthList;
    }

    public void setIpPacketLengthList(List<IpPacketInfo> ipPacketLengthList) {
        this.ipPacketLengthList = ipPacketLengthList;
    }

    public List<TcpPacketInfo> getTcpPacketFlagList() {
        return this.tcpPacketFlagList;
    }

    public void setTcpPacketFlagList(List<TcpPacketInfo> tcpPacketFlagList) {
        this.tcpPacketFlagList = tcpPacketFlagList;
    }
}

