/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.bis.service;

import com.hs.atic.collector.entity.alarm.CleanPcapAlarmEntity;
import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.Collector;
import java.util.ArrayList;
import java.util.List;

public class PacketAlarmHandler {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_PACKETCAPTURE);
    private IAlarmService alarmService = null;
    private CollectorDao collectorDao = null;

    private String[] assemblePcapAlarmInfo(CleanPcapAlarmEntity entity) {
        try {
            if (entity != null) {
                String[] param = new String[]{entity.getCollectorIp(), entity.getDiskName(), entity.getUseRatio(), String.valueOf(entity.getDelNumbers())};
                return param;
            }
        }
        catch (Exception e) {
            logger.error((Object)("assemble alarm info error. " + e.getMessage()));
        }
        return new String[3];
    }

    public void cleanPcapFileAlarm(List<CleanPcapAlarmEntity> entitys) {
        if (!entitys.isEmpty()) {
            ArrayList<AticAlarmObject> alarmObjectList = new ArrayList<AticAlarmObject>();
            for (CleanPcapAlarmEntity entry : entitys) {
                String[] alarmPara = this.assemblePcapAlarmInfo(entry);
                AticAlarmObject alarmObject = new AticAlarmObject();
                alarmObject.setAlarmId("0x0000000803240805");
                alarmObject.setAlarmParam(alarmPara);
                alarmObject.setIsAlarm(Boolean.valueOf(true));
                Collector collector = this.collectorDao.getCollectorEntryByIp(entry.getCollectorIp());
                if (null == collector) continue;
                alarmObject.setMoId(collector.getMoId());
                alarmObject.setExtendMoId(Long.valueOf(0L));
                alarmObject.setMoName(collector.getCollectorName());
                alarmObject.setMoIp(entry.getCollectorIp());
                alarmObject.setAlertTime(entry.getAlertTime());
                alarmObjectList.add(alarmObject);
            }
            try {
                this.alarmService.callAlarmQueue(alarmObjectList);
            }
            catch (Exception e) {
                logger.error((Object)("cleanPcapFileAlarm error:" + e.getMessage()));
            }
        }
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }
}

