/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.NetProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class IpProtocol
implements Serializable,
NetProtocol {
    private static final long serialVersionUID = 8472151545679444644L;
    private byte[] headData = new byte[0];
    private byte[] loadData = new byte[0];
    private boolean isOption;
    private int version;
    private int differentiatedServiceFiled;
    private int totalLength;
    private int identification;
    private int flag;
    private int fragmentOffset;
    private int ttl;
    private int checkSum;
    private String source;
    private String destination;
    private Protocol subProtocol;
    private SubProtocolType subTypeFlag;
    private Map<String, String> optionContent = new HashMap<String, String>();
    private int optionSize;

    public Map<String, String> getOptionContent() {
        return this.optionContent;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    @Override
    public String getDescription() {
        return "Src Addr:" + this.source + ", Dst Addr:" + this.destination;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    public int getDifferentiatedServiceFiled() {
        return this.differentiatedServiceFiled;
    }

    public int getFlag() {
        return this.flag;
    }

    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Version", this.version + "");
        content.put("Head Length", this.headData.length + "");
        content.put("Differentiated Service Field", "0x" + Integer.toHexString(this.differentiatedServiceFiled));
        content.put("Total Length", this.totalLength + "");
        content.put("Identification", "0x" + Integer.toHexString(this.identification));
        content.put("Flag", this.flag + "");
        content.put("Fragment Offset", this.fragmentOffset + "");
        content.put("Ttl", this.ttl + "");
        content.put("CheckSum", "0x" + Integer.toHexString(this.checkSum));
        content.put("Source", this.source);
        content.put("Destination", this.destination);
        if (this.isOption) {
            content.put("Options", this.optionSize + "");
            content.putAll(this.optionContent);
        }
        return content;
    }

    public void setOption(boolean option) {
        this.isOption = option;
    }

    public void setOptionContent(Map<String, String> options) {
        this.optionContent = options;
    }

    public int getOptionSize() {
        return this.optionSize;
    }

    public void setOptionSize(int optionSize) {
        this.optionSize = optionSize;
    }

    @Override
    public byte[] getHeadData() {
        byte[] copy = new byte[this.headData.length];
        System.arraycopy(this.headData, 0, copy, 0, this.headData.length);
        return copy;
    }

    public int getHeadLength() {
        return this.headData.length;
    }

    public int getIdentification() {
        return this.identification;
    }

    @Override
    public byte[] getLoadData() {
        byte[] copy = new byte[this.loadData.length];
        System.arraycopy(this.loadData, 0, copy, 0, this.loadData.length);
        return copy;
    }

    @Override
    public String getProtocolName() {
        return "Internet Protocol";
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return this.subTypeFlag;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getVersion() {
        return this.version;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setDifferentiatedServiceFiled(int differentiatedServiceFiled) {
        this.differentiatedServiceFiled = differentiatedServiceFiled;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public void setFragmentOffset(int fragmentOffset) {
        this.fragmentOffset = fragmentOffset;
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(null != headData ? (byte[])headData.clone() : null);
    }

    public void setIdentification(int identification) {
        this.identification = identification;
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = (byte[])(null != loadData ? (byte[])loadData.clone() : null);
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }

    public void setSubTypeFlag(SubProtocolType subTypeFlag) {
        this.subTypeFlag = subTypeFlag;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String toString() {
        String str = "IpProtocol [isOption=" + this.isOption + ", version=" + this.version + ", differentiatedServiceFiled=" + this.differentiatedServiceFiled + ", totalLength=" + this.totalLength + ", identification=" + this.identification + ", flag=" + this.flag + ", fragmentOffset=" + this.fragmentOffset + ", ttl=" + this.ttl + ", checkSum=" + this.checkSum + ", source=" + this.source + ", destination=" + this.destination + ", subTypeFlag=" + this.subTypeFlag + ", optionContent=" + this.optionContent + ", optionSize=" + this.optionSize;
        if (this.subProtocol != null) {
            str = str + ", subProtocol=" + this.subProtocol.toString();
        }
        str = str + "]";
        return str;
    }
}

