/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.ApplicationProtocol;
import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class SnmpProtocol
implements ApplicationProtocol,
Serializable {
    private static final long serialVersionUID = 6559522918605234104L;
    private Protocol subProtocol;
    private Map<String, String> pduContent;
    private byte[] loadData = new byte[0];
    private String community;
    private String pduTypeDescription;
    private byte[] headData = new byte[0];
    private int version;

    public void setLoadData(byte[] loadData) {
        this.loadData = (byte[])(null != loadData ? (byte[])loadData.clone() : null);
    }

    @Override
    public byte[] getLoadData() {
        if (null != this.loadData) {
            return (byte[])this.loadData.clone();
        }
        return new byte[0];
    }

    public void setPduContent(Map<String, String> pduContent) {
        this.pduContent = pduContent;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    @Override
    public String getDescription() {
        String result = this.pduTypeDescription;
        result = result + "  SNMPV" + (this.version + 1) + "-SMI  ";
        return result;
    }

    public void setPduTypeDescription(String pduTypeDescription) {
        this.pduTypeDescription = pduTypeDescription;
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Version", this.version + 1 + "");
        content.put("Community", this.community);
        content.putAll(this.pduContent);
        return content;
    }

    @Override
    public byte[] getHeadData() {
        if (null != this.headData) {
            return (byte[])this.headData.clone();
        }
        return new byte[0];
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(null != headData ? (byte[])headData.clone() : null);
    }

    @Override
    public String getProtocolName() {
        return "SNMP";
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return null;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }
}

