/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.TransforProtocol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TcpProtocol
implements TransforProtocol,
Serializable {
    private static final long serialVersionUID = 1187236829730908973L;
    private Protocol subProtocol;
    private byte[] loadData = new byte[0];
    private int sourcePort;
    private SubProtocolType subProtocolType;
    private int destinationPort;
    private long sequenceNumber;
    private long acknowledgementNumber;
    private int length;
    private int flag;
    private int windowSize;
    private int checkSum;
    private byte[] headData;
    private int mss;

    public void setSubProtocolType(SubProtocolType subProtocolType) {
        this.subProtocolType = subProtocolType;
    }

    public long getAcknowledgementNumber() {
        return this.acknowledgementNumber;
    }

    @Override
    public int getCheckSum() {
        return this.checkSum;
    }

    @Override
    public String getDescription() {
        String result = this.getSourcePort() + " > " + this.getDestinationPort() + this.getFlagDescrition() + " Seq:" + this.getSequenceNumber() + " Win:" + this.getWindowSize() + " Len:" + this.getLength();
        if (this.mss != 0) {
            result = result + " MSS:" + this.getMss();
        }
        return result;
    }

    @Override
    public int getDestinationPort() {
        return this.destinationPort;
    }

    public int getFlag() {
        return this.flag;
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Source port", this.sourcePort + "");
        content.put("Destination Port", this.destinationPort + "");
        content.put("Sequence Number", this.sequenceNumber + "");
        content.put("Acknowledgement Number", this.acknowledgementNumber + "");
        if (null != this.headData) {
            content.put("Head Length", this.headData.length + "");
        }
        content.put("Flag", this.getFlagDescrition());
        content.put("WindowSize", this.windowSize + "");
        content.put("CheckSum", "0x" + Integer.toHexString(this.checkSum));
        return content;
    }

    @Override
    public byte[] getHeadData() {
        if (null == this.headData) {
            return new byte[0];
        }
        byte[] copy = new byte[this.headData.length];
        System.arraycopy(this.headData, 0, copy, 0, this.headData.length);
        return copy;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getLoadData() {
        byte[] copy = new byte[this.loadData.length];
        System.arraycopy(this.loadData, 0, copy, 0, this.loadData.length);
        return copy;
    }

    public int getMss() {
        return this.mss;
    }

    @Override
    public String getProtocolName() {
        return "TCP";
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public int getSourcePort() {
        return this.sourcePort;
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return this.subProtocolType;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setAcknowledgementNumber(long acknowledgementNumber) {
        this.acknowledgementNumber = acknowledgementNumber;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public void setDestinationPort(int destinationPort) {
        this.destinationPort = destinationPort;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(null != headData ? (byte[])headData.clone() : null);
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = (byte[])(null != loadData ? (byte[])loadData.clone() : null);
    }

    public void setMss(int mss) {
        this.mss = mss;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    private String getFlagDescrition() {
        int value;
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        ArrayList<String> flagStr = new ArrayList<String>();
        int flags = this.getFlag();
        while ((value = this.getSingleFlag(flags, flagStr)) != 0) {
            flags -= value;
        }
        Collections.reverse(flagStr);
        for (int i = 0; i < flagStr.size(); ++i) {
            buffer.append((String)flagStr.get(i));
            if (i + 1 >= flagStr.size()) continue;
            buffer.append(',');
        }
        buffer.append(']');
        return buffer.toString();
    }

    private int getSingleFlag(int value, List<String> flagStr) {
        if (value >= 32) {
            flagStr.add("URGENT");
            return 32;
        }
        if (value >= 16) {
            flagStr.add("ACK");
            return 16;
        }
        if (value >= 8) {
            flagStr.add("PUSH");
            return 8;
        }
        if (value >= 4) {
            flagStr.add("RST");
            return 4;
        }
        if (value >= 2) {
            flagStr.add("SYN");
            return 2;
        }
        if (value >= 1) {
            flagStr.add("FIN");
            return 1;
        }
        return 0;
    }
}

