/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.collector.entity.pcap;

import com.hs.atic.collector.entity.pcap.Protocol;
import com.hs.atic.collector.entity.pcap.SubProtocolType;
import com.hs.atic.collector.entity.pcap.TransforProtocol;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class UdpProtocol
implements Serializable,
TransforProtocol {
    private static final int HEAD_LENGTH = 8;
    private static final long serialVersionUID = 1503339360424716138L;
    private int sourcePort;
    private int destinationPort;
    private int length;
    private int checkSum;
    private byte[] headData = new byte[8];
    private byte[] loadData = new byte[0];
    private Protocol subProtocol;
    private SubProtocolType subProtocolTypes;

    public void setProtocolTypeFlag(SubProtocolType subProtocolType) {
        this.subProtocolTypes = subProtocolType;
    }

    @Override
    public int getCheckSum() {
        return this.checkSum;
    }

    @Override
    public String getDescription() {
        return "Source port:" + this.getSourcePort() + " Destination port:" + this.getDestinationPort();
    }

    @Override
    public int getDestinationPort() {
        return this.destinationPort;
    }

    @Override
    public Map<String, String> getHeadContent() {
        LinkedHashMap<String, String> content = new LinkedHashMap<String, String>();
        content.put("Source port", this.sourcePort + "");
        content.put("Destination Port", this.destinationPort + "");
        content.put("Length", this.length + "");
        content.put("CheckSum", "0x" + Integer.toHexString(this.checkSum));
        return content;
    }

    @Override
    public byte[] getHeadData() {
        byte[] copy = new byte[this.headData.length];
        System.arraycopy(this.headData, 0, copy, 0, this.headData.length);
        return copy;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public byte[] getLoadData() {
        byte[] copy = new byte[this.loadData.length];
        System.arraycopy(this.loadData, 0, copy, 0, this.loadData.length);
        return copy;
    }

    @Override
    public String getProtocolName() {
        return "UDP";
    }

    @Override
    public int getSourcePort() {
        return this.sourcePort;
    }

    @Override
    public Protocol getSubProtocol() {
        return this.subProtocol;
    }

    @Override
    public SubProtocolType getSubProtocolType() {
        return this.subProtocolTypes;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public void setDestinationPort(int destinationPort) {
        this.destinationPort = destinationPort;
    }

    public void setHeadData(byte[] headData) {
        this.headData = (byte[])(null != headData ? (byte[])headData.clone() : null);
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLoadData(byte[] loadData) {
        this.loadData = new byte[loadData.length];
        System.arraycopy(loadData, 0, this.loadData, 0, this.loadData.length);
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    @Override
    public void setSubProtocol(Protocol subProtocol) {
        this.subProtocol = subProtocol;
    }
}

