/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.cloudclean.constant.AticSdkConstants;
import com.hs.atic.cloudclean.form.CloudCleanConfigDevFlowForm;
import com.hs.atic.cloudclean.form.CloudCleanConfigForm;
import com.hs.atic.cloudclean.form.CloudCleanProtectIpDeviceForm;
import com.hs.atic.cloudclean.form.CloudCleanProtectIpForm;
import com.hs.atic.cloudclean.form.DeviceIpTopN;
import com.hs.atic.sdk.bis.form.CloudCleanForm;
import com.hs.atic.sdk.bis.service.IDateTableFileService;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.ddos.policy.ref.ZoneReferUtil;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.opensymphony.xwork2.ActionContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class CloudCleanAction
extends BaseAction {
    public static final String ADD_CLOUDCLEAN = "atic.bis.cloud.clean.operation.create";
    public static final String DELETE_CLOUDCLEAN = "atic.bis.cloud.clean.operation.delete";
    public static final String ENABLE_CLOUDCLEAN = "atic.bis.cloud.clean.operation.enable";
    public static final String DISABLED_CLOUDCLEAN = "atic.bis.cloud.clean.operation.disable";
    public static final String DEPLOY_DIVERT = "atic.bis.cloud.clean.operation.deploy";
    public static final String UNDO_DEPLOY_DIVERT = "atic.bis.cloud.clean.operation.undoDeploy";
    public static final String ADD_PROTECTIP = "atic.bis.cloudclean.ip.list.add";
    public static final String DELETE_PROTECTIP = "atic.bis.cloudclean.ip.list.delete";
    private static final long serialVersionUID = -1L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private List<LangPair> defendActionList;
    private List<LangPair> defendScopeList;
    private CloudCleanForm cloudCleanForm;
    private CloudCleanProtectIpForm cloudCleanProtectIpForm;
    private String cloudCleanDefendScopeDef;
    private String cloudSp;
    private ICloudCleanService cloudCleanService;
    private IAticDeviceService aticDeviceService;
    private ISysOptLog sysLogService;
    private String ipMask;
    private String defendAction;
    private String unblockTime;
    private Integer defendScope;
    private List<CloudCleanForm> cloudCleanFormList;
    private List<CloudCleanProtectIpForm> ipReInjectDeviceList;
    private Long[] batchCloudCleanId;
    private Long cloudCleanId;
    private String pageType = "";
    private Long deviceId;
    private String deviceName;
    private String deviceIp;
    private String inflow;
    private String threshold;
    private List<DeviceIpTopN> deviceIpTopNList;
    private String sortType = null;
    private String sortField = null;
    private int staticToal = 0;
    private int ipToal = 0;
    private IAticDeviceService firewallService;
    private String defDeviceName;
    private String defDeviceId;
    private String reInjectDeviceId;
    private String reInjectDeviceName;

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public String viewCloudCleanTab() {
        return "success";
    }

    public String viewCloudClean() {
        if (null != this.cloudCleanService) {
            Integer policy = this.cloudCleanService.getByStaticPolicy();
            if (null != policy) {
                this.staticToal = policy;
            } else {
                logger.error((Object)"getByStaticPolicy(), is null");
            }
        } else {
            logger.error((Object)"getCloudCleanService() is null");
        }
        this.queryByPage();
        return "success";
    }

    private void queryByPage() {
        HashMap<String, String> map = new HashMap<String, String>();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        map.put("userId", String.valueOf(currentUser.getUserID()));
        map.put("isAdmin", currentUser.getIsAdmin());
        if (null == this.sortType) {
            this.sortType = "desc";
            this.sortField = "deviceId";
            map.put("sortName", this.sortField);
            map.put("sortType", this.sortType);
            logger.info((Object)("queryByPage start is " + this.start + ", pagesize is " + this.pageSize));
            if (null != this.cloudCleanService) {
                Paging paging = this.cloudCleanService.queryByPage(map, this.start, this.pageSize);
                this.cloudCleanFormList = paging.getData();
                this.total = paging.getCount();
            }
        }
    }

    private void queryIpByPage(Map<String, String> map) {
        if (null == this.sortType) {
            this.sortType = "acs";
            this.sortField = "pkid";
            map.put("sortName", this.sortField);
            map.put("sortType", this.sortType);
            logger.info((Object)("queryIpByPage start is " + this.start + ", pagesize is " + this.pageSize));
            if (null != this.cloudCleanService) {
                Paging paging = this.cloudCleanService.queryIpByPage(map, this.start, this.pageSize);
                this.ipReInjectDeviceList = paging.getData();
                this.total = paging.getCount();
            }
        }
    }

    public String addCloudClean() {
        this.pageType = "create";
        if (null == this.cloudCleanForm && null != this.cloudCleanService) {
            CloudCleanConfigForm configForm = this.cloudCleanService.getCloudCleanConf();
            this.cloudCleanForm = new CloudCleanForm();
            if (null != configForm && null != configForm.getServiceProvider()) {
                if ("CTCC".equalsIgnoreCase(configForm.getServiceProvider())) {
                    this.cloudCleanForm.setServiceProvider("CTCC");
                }
                if ("HW".equalsIgnoreCase(configForm.getServiceProvider())) {
                    this.cloudCleanForm.setServiceProvider("HW");
                }
            }
        }
        if (null != this.cloudCleanForm) {
            this.initAddCloudClean();
        }
        return "success";
    }

    public String addProtectIp() {
        return "success";
    }

    public void checkCloudCleanSp() {
        if (null != this.cloudCleanService) {
            CloudCleanConfigForm configForm = this.cloudCleanService.getCloudCleanConf();
            this.cloudCleanForm = new CloudCleanForm();
            if (null != configForm) {
                if (null != configForm.getServiceProvider()) {
                    if ("CTCC".equalsIgnoreCase(configForm.getServiceProvider()) || "HW".equalsIgnoreCase(configForm.getServiceProvider())) {
                        this.responseResult("success");
                    } else {
                        this.responseResult("error");
                    }
                } else {
                    this.responseResult("error");
                }
            }
        }
    }

    private void initAddCloudClean() {
        this.cloudSp = null != this.cloudCleanForm && "CTCC".equals(this.cloudCleanForm.getServiceProvider()) ? this.getText("atic.bis.cloud.clean.sp.ctcc") : this.getText("atic.bis.cloud.clean.sp.hw");
        this.defendActionList = new ArrayList<LangPair>();
        LangPair pair1 = new LangPair("clean", this.getText("atic.bis.cloud.clean.defend.clean"));
        LangPair pair2 = new LangPair("block", this.getText("atic.bis.cloud.clean.defend.block"));
        this.defendActionList.add(pair1);
        this.defendActionList.add(pair2);
        this.defendScopeList = new ArrayList<LangPair>();
        LangPair pairDefScop1 = new LangPair(String.valueOf(AticSdkConstants.CLOUDCLEAN_DEFENDSCOPE_ONE), this.getText("atic.bis.cloud.clean.defend.scope.one"));
        LangPair pairDefScop2 = new LangPair(String.valueOf(AticSdkConstants.CLOUDCLEAN_DEFENDSCOPE_TWO), this.getText("atic.bis.cloud.clean.defend.scope.two"));
        LangPair pairDefScop3 = new LangPair(String.valueOf(AticSdkConstants.CLOUDCLEAN_DEFENDSCOPE_THREE), this.getText("atic.bis.cloud.clean.defend.scope.three"));
        LangPair pairDefScop4 = new LangPair(String.valueOf(AticSdkConstants.CLOUDCLEAN_DEFENDSCOPE_FOUR), this.getText("atic.bis.cloud.clean.defend.scope.four"));
        this.defendScopeList.add(pairDefScop1);
        this.defendScopeList.add(pairDefScop2);
        this.defendScopeList.add(pairDefScop3);
        this.defendScopeList.add(pairDefScop4);
        if (null != this.cloudCleanForm && null != this.cloudCleanForm.getDefendScope()) {
            if (this.cloudCleanForm.getDefendScope() == 1) {
                this.cloudCleanDefendScopeDef = this.getText("atic.bis.cloud.clean.defend.scope.one");
            }
            if (this.cloudCleanForm.getDefendScope() == 2) {
                this.cloudCleanDefendScopeDef = this.getText("atic.bis.cloud.clean.defend.scope.two");
            }
            if (this.cloudCleanForm.getDefendScope() == 3) {
                this.cloudCleanDefendScopeDef = this.getText("atic.bis.cloud.clean.defend.scope.three");
            }
            if (this.cloudCleanForm.getDefendScope() == 4) {
                this.cloudCleanDefendScopeDef = this.getText("atic.bis.cloud.clean.defend.scope.four");
            }
        }
    }

    public void saveCloudClean() {
        if (!this.validateBeforeAdd()) {
            this.responseResult("error");
            return;
        }
        if (null != this.cloudCleanService) {
            try {
                CloudCleanProtectIpForm protectIpForm;
                logger.info((Object)("saveCloudClean service :" + CloudCleanAction.getcleanedMessage(this.cloudCleanService.toString())));
                if (null == this.cloudCleanService.getByIpMaskAndPolicyType(this.ipMask, this.cloudSp, "static")) {
                    if (null == this.cloudCleanForm) {
                        this.cloudCleanForm = new CloudCleanForm();
                        this.cloudCleanForm.setServiceProvider(this.cloudSp);
                        this.cloudCleanForm.setIpMask(this.ipMask);
                        this.cloudCleanForm.setDeviceName("--");
                        this.cloudCleanForm.setPolicyType("static");
                        this.cloudCleanForm.setStatus("disable");
                        User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
                        this.cloudCleanForm.setOperator(currentUser.getUserName());
                        if ("CTCC".equals(this.cloudSp)) {
                            this.cloudCleanForm.setDefendAction("block");
                            this.cloudCleanForm.setDefendScope(this.defendScope);
                        } else {
                            this.cloudCleanForm.setDefendAction(this.defendAction);
                            this.cloudCleanForm.setDefendScope(null);
                        }
                    }
                    if (!this.checkMaxCloudClean()) {
                        this.failedProcessOpeLog(ADD_CLOUDCLEAN, true, null, "com.hs.vsm.secservice.ddos.policy.cloudClean.max.num", "atic.bis.cloud.clean.operation");
                        this.responseResult("574001");
                        return;
                    }
                    protectIpForm = this.cloudCleanService.getProtectIpByIp(this.cloudCleanForm.getIpMask());
                    if (null == protectIpForm) {
                        String[] detailPara = new String[]{this.ipMask};
                        this.failedProcessOpeLog(ADD_CLOUDCLEAN, true, detailPara, "atic.bis.cloud.clean.addpolicy.system.notProtected", "atic.bis.cloud.clean.operation");
                        this.responseResult("notProtected");
                        return;
                    }
                    User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
                    List ddosDevices = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
                    ArrayList<Long> securityIds = new ArrayList<Long>();
                    for (Object dev : ddosDevices) {
                        securityIds.add(dev.getMoId());
                    }
                    List<CloudCleanProtectIpDeviceForm> ipDevs = protectIpForm.getIpDevs();
                    for (CloudCleanProtectIpDeviceForm cloudCleanProtectIpDeviceForm : ipDevs) {
                        if (securityIds.contains(cloudCleanProtectIpDeviceForm.getDevId())) continue;
                        String[] detailPara = new String[]{protectIpForm.getProtectIp() + "/" + protectIpForm.getMask()};
                        this.failedProcessOpeLog(ADD_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.add.policy.oplog", "atic.bis.cloud.clean.operation");
                        this.responseResult("checkIpFailed," + protectIpForm.getProtectIp() + "/" + protectIpForm.getMask());
                        return;
                    }
                } else {
                    String[] detailPara = new String[]{this.ipMask};
                    this.failedProcessOpeLog(ADD_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.add.policy.already.oplog", "atic.bis.cloud.clean.operation");
                    this.responseResult("exist");
                    return;
                }
                this.cloudCleanForm.setProtectIpId(protectIpForm.getId());
                this.cloudCleanForm.setReInjectDeviceName(protectIpForm.getReInjectDeviceName());
                this.cloudCleanService.saveCloudClean(this.cloudCleanForm);
                String[] detailPara = new String[]{this.cloudCleanForm.getIpMask()};
                this.successProcessOpeLog("atic.bis.cloud.clean.operation", true, ADD_CLOUDCLEAN, detailPara, "atic.bis.cloudclean.add.policy.oplog");
                this.responseResult("success");
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("LegoCheckedException saveCloudClean failed. " + e.getMessage()));
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                Object[] para = e.getParameters();
                String[] detailPara = new String[]{};
                if (null != para && para.length > 0) {
                    detailPara = para;
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                this.failedProcessOpeLog(ADD_PROTECTIP, true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloudclean.ip");
                this.responseResult(errorInfo);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.info((Object)("RuntimeException saveCloudClean failed. " + e.getMessage()));
                String[] detailPara = new String[]{this.ipMask};
                this.failedProcessOpeLog(ADD_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.add.policy.oplog", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
            catch (Exception e) {
                logger.info((Object)("Exception saveCloudClean failed. " + e.getMessage()));
                String[] detailPara = new String[]{this.ipMask};
                this.failedProcessOpeLog(ADD_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.add.policy.oplog", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
        }
    }

    public void saveProtectIp() {
        if (!this.validateProtectIp()) {
            this.responseResult("error");
            return;
        }
        if (null != this.cloudCleanService) {
            try {
                if (null != this.reInjectDeviceId) {
                    String[] protectIpDeviceIds = this.reInjectDeviceId.split(",");
                    ArrayList<Long> moIdList = new ArrayList<Long>();
                    for (int i = 0; i < protectIpDeviceIds.length; ++i) {
                        moIdList.add(Long.parseLong(protectIpDeviceIds[i]));
                    }
                    BisUtil.checkUserSecurity(moIdList);
                }
                if (null == this.cloudCleanService.getByProtectIpMask(this.ipMask)) {
                    if (null == this.cloudCleanProtectIpForm) {
                        this.cloudCleanProtectIpForm = new CloudCleanProtectIpForm();
                        this.cloudCleanProtectIpForm.setProtectIp(this.ipMask.split("/")[0]);
                        this.cloudCleanProtectIpForm.setMask(Integer.parseInt(this.ipMask.split("/")[1]));
                    }
                    if (!this.checkMaxProtectIp()) {
                        this.failedProcessOpeLog(ADD_PROTECTIP, true, new String[0], "com.hs.vsm.secservice.ddos.policy.protectip.max.num", "atic.bis.cloudclean.ip");
                        this.responseResult("574001");
                        return;
                    }
                    Long protectIpId = this.cloudCleanService.saveProtectIp(this.cloudCleanProtectIpForm);
                    if (null == protectIpId || protectIpId == 0L) {
                        this.failedProcessOpeLog(ADD_PROTECTIP, true, new String[0], "atic.bis.cloudclean.error.parameter", "atic.bis.cloudclean.ip");
                        this.responseResult("error");
                        return;
                    }
                    ArrayList<CloudCleanProtectIpDeviceForm> protectIpDeviceForms = new ArrayList<CloudCleanProtectIpDeviceForm>();
                    if (null != this.reInjectDeviceId) {
                        String[] protectIpDeviceIds;
                        for (String id : protectIpDeviceIds = this.reInjectDeviceId.split(",")) {
                            CloudCleanProtectIpDeviceForm protectIpDeviceForm = new CloudCleanProtectIpDeviceForm();
                            protectIpDeviceForm.setProtectIpId(protectIpId);
                            protectIpDeviceForm.setDevId(Long.valueOf(id));
                            protectIpDeviceForms.add(protectIpDeviceForm);
                        }
                    }
                    this.cloudCleanService.saveProtectIpDevice(protectIpDeviceForms);
                    String[] detailPara = new String[]{this.cloudCleanProtectIpForm.getProtectIp() + "/" + this.cloudCleanProtectIpForm.getMask()};
                    this.successProcessOpeLog("atic.bis.cloudclean.ip", true, ADD_PROTECTIP, detailPara, "atic.bis.cloudclean.add.ip.success.oplog");
                    this.responseResult("success");
                } else {
                    this.failedProcessOpeLog(ADD_PROTECTIP, true, new String[0], "atic.bis.cloudclean.protectip.exist", "atic.bis.cloudclean.ip");
                    this.responseResult("exist");
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("LegoCheckedException saveProtectIp failed for IP/MASK " + this.ipMask + ". " + e.getMessage()));
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                String[] detailPara = new String[]{};
                Object[] para = e.getParameters();
                if (null != para && para.length > 0) {
                    detailPara = para;
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                this.failedProcessOpeLog(ADD_PROTECTIP, true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloudclean.ip");
                this.responseResult(errorInfo);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.error((Object)("RuntimeException saveProtectIp failed for IP/MASK " + this.ipMask + ". " + e.getMessage()));
                String[] detailPara = new String[]{this.ipMask};
                this.failedProcessOpeLog(ADD_PROTECTIP, true, detailPara, "atic.bis.cloudclean.add.ip.failed.oplog", "atic.bis.cloudclean.ip");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
            catch (Exception e) {
                logger.error((Object)("Exception saveProtectIp failed for IP/MASK " + this.ipMask + ". " + e.getMessage()));
                String[] detailPara = new String[]{this.ipMask};
                this.failedProcessOpeLog(ADD_PROTECTIP, true, detailPara, "atic.bis.cloudclean.add.ip.failed.oplog", "atic.bis.cloudclean.ip");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
        }
    }

    public boolean checkMaxCloudClean() {
        if (null != this.cloudCleanService) {
            HashMap<String, String> map = new HashMap<String, String>();
            User currentUser = (User)this.getSession().getAttribute("currentUser");
            map.put("userId", String.valueOf(currentUser.getUserID()));
            map.put("isAdmin", currentUser.getIsAdmin());
            Paging paging = this.cloudCleanService.queryByPage(map, this.start, this.pageSize);
            this.total = paging.getCount();
            if (this.total >= 10000) {
                logger.error((Object)("cloudClean_list_num exceed 10000, cloudClean_list_num=" + (this.total + 1)));
                return false;
            }
        }
        return true;
    }

    public boolean checkMaxProtectIp() {
        if (null != this.cloudCleanService) {
            HashMap<String, String> map = new HashMap<String, String>();
            Paging paging = this.cloudCleanService.queryIpByPage(map, this.start, this.pageSize);
            this.total = paging.getCount();
            if (this.total >= 4096) {
                logger.error((Object)("cloudClean_protectip_list_num exceed 4096, cloudClean_protectip_list_num=" + (this.total + 1)));
                return false;
            }
        }
        return true;
    }

    public boolean validateBeforeAdd() {
        String regex = "^[\\d]*$";
        Pattern pattern = Pattern.compile(regex);
        if (!AticUtil.isNull((String)this.ipMask)) {
            String[] ipMasks = this.ipMask.split("/");
            if (ipMasks.length != 2) {
                return false;
            }
            Matcher matcher = pattern.matcher(ipMasks[1]);
            if (!matcher.find()) {
                return false;
            }
            if (!IPUtil.isIpv4((String)ipMasks[0])) {
                return false;
            }
            if (!AticUtil.isNull((String)this.cloudSp)) {
                if (this.cloudSp.equals("CTCC")) {
                    if (this.defendScope < 1 || this.defendScope > 4) {
                        return false;
                    }
                    if (!this.defendAction.equals("block") && !this.defendAction.equals("clean")) {
                        return false;
                    }
                    return Integer.parseInt(ipMasks[1]) == 32;
                }
                if (!AticUtil.isNull((String)this.defendAction)) {
                    if (this.defendAction.equals("block")) {
                        return Integer.parseInt(ipMasks[1]) == 32;
                    }
                    if (this.defendAction.equals("clean")) {
                        return Integer.parseInt(ipMasks[1]) >= 16 && Integer.parseInt(ipMasks[1]) <= 24;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean validateProtectIp() {
        if (AticUtil.isNull((String)this.ipMask)) {
            return false;
        }
        String[] ipMasks = this.ipMask.split("/");
        if (ipMasks.length != 2) {
            return false;
        }
        String regex = "^[\\d]*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ipMasks[1]);
        if (!matcher.find()) {
            return false;
        }
        if (!IPUtil.isIpv4((String)ipMasks[0])) {
            return false;
        }
        return Integer.parseInt(ipMasks[1]) >= 16 && Integer.parseInt(ipMasks[1]) <= 24;
    }

    public boolean validateInjectDeviceId() {
        if (AticUtil.isNull((String)this.reInjectDeviceId)) {
            return false;
        }
        String[] injectDeviceIds = this.reInjectDeviceId.split(",");
        if (injectDeviceIds.length > 500) {
            return false;
        }
        String regex = "^[0-9,]+$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(this.reInjectDeviceId);
        return matcher.find();
    }

    public void deleteCloudClean() {
        block19: {
            try {
                ArrayList<CloudCleanForm> listCloundClean = new ArrayList<CloudCleanForm>();
                CloudCleanForm ccf = null;
                if (null == this.cloudCleanService || null == this.batchCloudCleanId) break block19;
                for (Long id : this.batchCloudCleanId) {
                    ccf = this.cloudCleanService.getById(id);
                    if (null != ccf) {
                        listCloundClean.add(ccf);
                        this.checkUserSecurity(id);
                        continue;
                    }
                    this.failedProcessOpeLog(DELETE_CLOUDCLEAN, true, new String[0], "atic.bis.cloudclean.delete.policy.not.exist", "atic.bis.cloud.clean.operation");
                    this.responseResult("NOTEXIST");
                }
                Boolean batchResult = true;
                HashMap<String, LegoCheckedException> ip2Exception = new HashMap<String, LegoCheckedException>();
                try {
                    for (CloudCleanForm ccform : listCloundClean) {
                        String target = "atic.bis.cloud.clean.operation";
                        ArrayList<CloudCleanForm> tempList = new ArrayList<CloudCleanForm>();
                        tempList.add(ccform);
                        String ccformStatus = ccform.getStatus();
                        try {
                            String[] params = this.getOptLogParas();
                            this.cloudCleanService.deteleByForm(tempList, params);
                        }
                        catch (LegoCheckedException e) {
                            String[] detailPara = new String[]{ccform.getIpMask()};
                            this.failedProcessOpeLog(DELETE_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.delete.policy.failed.oplog", target);
                            batchResult = false;
                            ip2Exception.put(ccform.getIpMask(), e);
                            continue;
                        }
                        if (!"enable".equals(ccformStatus) || !"HW".equals(ccform.getServiceProvider())) continue;
                        Long protectIpId = ccf.getProtectIpId();
                        CloudCleanProtectIpForm protectIpForm = this.cloudCleanService.getIpById(protectIpId);
                        List<CloudCleanProtectIpDeviceForm> ipDeviceForms = protectIpForm.getIpDevs();
                        Boolean result = false;
                        for (CloudCleanProtectIpDeviceForm ipDeviceForm : ipDeviceForms) {
                            AticDevice reInjectDevice = null;
                            if (null == ipDeviceForm || null == this.aticDeviceService) continue;
                            reInjectDevice = this.aticDeviceService.getDeviceByMoid(ipDeviceForm.getDevId().longValue());
                            Boolean res = this.cloudCleanService.undoDeployDivert(ccform, reInjectDevice, "LoopBack100");
                            String[] detailParas = new String[]{ccform.getIpMask(), "LoopBack100", reInjectDevice.getName()};
                            if (!res.booleanValue()) {
                                this.failedProcessOpeLog(UNDO_DEPLOY_DIVERT, true, detailParas, "atic.bis.cloudclean.disable.policy.failed.oplog.undoDeployDivert", target);
                                continue;
                            }
                            result = true;
                            this.successProcessOpeLog(target, true, UNDO_DEPLOY_DIVERT, detailParas, "atic.bis.cloudclean.disable.policy.success.oplog.undoDeployDivert");
                        }
                        this.undoDeployDivert300(ccf);
                        if (!result.booleanValue()) {
                            logger.error((Object)("undo deployDivert error for " + ccform.getIpMask()));
                            String[] detailPara = new String[]{ccform.getIpMask()};
                            this.failedProcessOpeLog(DELETE_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.delete.policy.failed.oplog", target);
                            continue;
                        }
                        logger.info((Object)("undo deployDivert success for " + ccform.getIpMask()));
                        logger.info((Object)("disable cloud clean success for ip " + ccform.getIpMask()));
                    }
                    if (batchResult.booleanValue()) {
                        this.responseResult("success");
                    } else if (!batchResult.booleanValue() && ip2Exception.size() > 0) {
                        throw (LegoCheckedException)((Object)ip2Exception.entrySet().iterator().next().getValue());
                    }
                }
                catch (LegoCheckedException e) {
                    logger.error((Object)("LegoCheckedException deleteCloudClean " + e.getMessage()));
                    String errorInfo = this.getText("lego.err." + e.getErrorCode());
                    String[] detailPara = new String[]{};
                    Object[] para = e.getParameters();
                    if (null != para && para.length > 0) {
                        detailPara = para;
                        errorInfo = MessageFormat.format(errorInfo, para);
                    }
                    this.failedProcessOpeLog(DELETE_CLOUDCLEAN, true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloudclean.ip");
                    this.responseResult(errorInfo);
                    return;
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("LegoCheckedException deleteCloudClean " + e.getMessage()));
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                String[] detailPara = new String[]{};
                Object[] para = e.getParameters();
                if (null != para && para.length > 0) {
                    detailPara = para;
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                this.failedProcessOpeLog(DELETE_CLOUDCLEAN, true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloud.clean.operation");
                this.responseResult(errorInfo);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.error((Object)("RuntimeException deleteCloudClean " + e.getMessage()));
                this.failedProcessOpeLog(DELETE_CLOUDCLEAN, true, new String[0], "lego.err.102", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
            catch (Exception e) {
                logger.error((Object)("Exception deleteCloudClean " + e.getMessage()));
                this.failedProcessOpeLog(DELETE_CLOUDCLEAN, true, new String[0], "lego.err.102", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
        }
    }

    private void checkUserSecurity(Long id) {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        CloudCleanForm ccf = this.cloudCleanService.getById(id);
        if (null == ccf) {
            logger.error((Object)"checkUserSecurity can not get CloudCleanForm by id");
            throw new LegoCheckedException(630178L);
        }
        Long deviceId = ccf.getDeviceId();
        if (null != deviceId) {
            moIdList.add(deviceId);
        }
        Long protectIpId = ccf.getProtectIpId();
        CloudCleanProtectIpForm protectIpForm = this.cloudCleanService.getIpById(protectIpId);
        List<CloudCleanProtectIpDeviceForm> ipDeviceForms = protectIpForm.getIpDevs();
        for (CloudCleanProtectIpDeviceForm ipDeviceForm : ipDeviceForms) {
            Long devId = ipDeviceForm.getDevId();
            if (null == devId) continue;
            moIdList.add(devId);
        }
        try {
            if (!moIdList.isEmpty()) {
                BisUtil.checkUserSecurity(moIdList);
            }
        }
        catch (LegoCheckedException e) {
            if (630114L == e.getErrorCode()) {
                ArrayList<String> nameList = new ArrayList<String>();
                nameList.add(ccf.getIpMask());
                String[] parameter = new String[]{((Object)nameList).toString()};
                throw new LegoCheckedException(630176L, parameter);
            }
            throw e;
        }
    }

    public void deleteProtectIp() {
        block17: {
            try {
                ArrayList<CloudCleanProtectIpForm> listIpForm = new ArrayList<CloudCleanProtectIpForm>();
                ArrayList<CloudCleanProtectIpForm> isEnableListIpForm = new ArrayList<CloudCleanProtectIpForm>();
                String target = "atic.bis.cloudclean.ip";
                Boolean isEnable = false;
                if (null == this.cloudCleanService || null == this.batchCloudCleanId) break block17;
                for (Long id : this.batchCloudCleanId) {
                    CloudCleanProtectIpForm ipForm = this.cloudCleanService.getIpById(id);
                    if (null == ipForm) {
                        this.failedProcessOpeLog(DELETE_PROTECTIP, true, new String[0], "atic.bis.cloudclean.protectip.not.exist", target);
                        this.responseResult("error");
                        continue;
                    }
                    if (!this.cloudCleanService.canBeDeleted(id).booleanValue()) {
                        isEnableListIpForm.add(ipForm);
                        isEnable = true;
                        continue;
                    }
                    listIpForm.add(ipForm);
                }
                try {
                    String[] detailPara;
                    User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
                    List ddosDevices = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
                    ArrayList<Long> securityIds = new ArrayList<Long>();
                    for (AticDevice dev : ddosDevices) {
                        securityIds.add(dev.getMoId());
                    }
                    for (CloudCleanProtectIpForm cleanIpForm : listIpForm) {
                        List<CloudCleanProtectIpDeviceForm> ipDevs = cleanIpForm.getIpDevs();
                        for (CloudCleanProtectIpDeviceForm cloudCleanProtectIpDeviceForm : ipDevs) {
                            if (securityIds.contains(cloudCleanProtectIpDeviceForm.getDevId())) continue;
                            String[] detailPara2 = new String[]{cleanIpForm.getProtectIp() + "/" + cleanIpForm.getMask()};
                            this.failedProcessOpeLog(DELETE_PROTECTIP, true, detailPara2, "atic.bis.cloudclean.delete.ip.failed.oplog", target);
                            this.responseResult("checkIpFailed," + cleanIpForm.getProtectIp() + "/" + cleanIpForm.getMask());
                            return;
                        }
                    }
                    this.cloudCleanService.batchDeteleProtectIpForm(listIpForm);
                    for (CloudCleanProtectIpForm form : listIpForm) {
                        detailPara = new String[]{form.getProtectIp() + "/" + form.getMask()};
                        this.successProcessOpeLog(target, true, DELETE_PROTECTIP, detailPara, "atic.bis.cloudclean.delete.ip.success.oplog");
                    }
                    if (isEnable.booleanValue()) {
                        for (CloudCleanProtectIpForm form : isEnableListIpForm) {
                            detailPara = new String[]{form.getProtectIp() + "/" + form.getMask()};
                            this.failedProcessOpeLog(DELETE_PROTECTIP, true, detailPara, "atic.bis.cloudclean.protectip.enable.ip", target);
                        }
                        this.responseResult("574001");
                        return;
                    }
                    this.responseResult("success");
                }
                catch (LegoCheckedException e) {
                    for (CloudCleanProtectIpForm form : listIpForm) {
                        String[] detailPara = new String[]{form.getProtectIp() + "/" + form.getMask()};
                        this.failedProcessOpeLog(DELETE_PROTECTIP, true, detailPara, "atic.bis.cloudclean.delete.ip.failed.oplog", target);
                    }
                    this.responseResult(e.getErrorCode());
                    return;
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("LegoCheckedException deleteProtectIp failed. " + e.getMessage()));
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                Object[] para = e.getParameters();
                String[] detailPara = new String[]{};
                if (null != para && para.length > 0) {
                    detailPara = para;
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                this.failedProcessOpeLog(DELETE_PROTECTIP, true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloudclean.ip");
                this.responseResult(errorInfo);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.error((Object)("RuntimeException deleteProtectIp failed. " + e.getMessage()));
                this.failedProcessOpeLog(DELETE_PROTECTIP, true, new String[0], "lego.err.102", "atic.bis.cloudclean.ip");
                this.responseResult(this.getText("lego.err.102"));
                throw new LegoCheckedException(102L);
            }
            catch (Exception e) {
                logger.error((Object)("RuntimeException deleteProtectIp failed. " + e.getMessage()));
                this.failedProcessOpeLog(DELETE_PROTECTIP, true, new String[0], "lego.err.102", "atic.bis.cloudclean.ip");
                this.responseResult(this.getText("lego.err.102"));
                throw new LegoCheckedException(102L);
            }
        }
    }

    public void saveEditCloudClean() {
        if (null != this.cloudCleanService) {
            try {
                logger.info((Object)("editCloudClean service :" + CloudCleanAction.getcleanedMessage(this.cloudCleanService.toString())));
                if (null != this.cloudCleanId) {
                    this.cloudCleanForm = this.cloudCleanService.getById(this.cloudCleanId);
                }
                if (null == this.cloudCleanForm) {
                    this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, new String[0], "atic.bis.cloudclean.delete.policy.not.exist", "atic.bis.cloud.clean.operation");
                    logger.error((Object)"saveEditCloudClean failed!");
                    return;
                }
                String target = "atic.bis.cloud.clean.operation";
                if (null != this.cloudCleanForm.getDeviceId()) {
                    this.deviceId = this.cloudCleanForm.getDeviceId();
                }
                if (this.cloudCleanForm.getIpMask().equals(this.ipMask)) {
                    this.cloudCleanForm.setIpMask(this.ipMask);
                    if ("CTCC".equals(this.cloudSp)) {
                        this.cloudCleanForm.setDefendScope(this.defendScope);
                    } else {
                        this.cloudCleanForm.setDefendAction(this.defendAction);
                    }
                } else {
                    CloudCleanForm ccf = this.cloudCleanService.getByIpMaskAndPolicyType(this.ipMask, this.cloudSp, "static");
                    if (null != ccf) {
                        String[] detailPara = new String[]{this.ipMask};
                        this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, detailPara, "atic.bis.cloudclean.add.policy.already.oplog", target);
                        this.responseResult("exist");
                        return;
                    }
                    this.cloudCleanForm.setIpMask(this.ipMask);
                    CloudCleanProtectIpForm protectIpForm = this.cloudCleanService.getProtectIpByIp(this.cloudCleanForm.getIpMask());
                    if (null == protectIpForm) {
                        String[] detailPara = new String[]{this.ipMask};
                        this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, detailPara, "atic.bis.cloud.clean.addpolicy.system.notProtected", target);
                        this.responseResult("notProtected");
                        return;
                    }
                    this.cloudCleanForm.setProtectIpId(protectIpForm.getId());
                    this.cloudCleanForm.setReInjectDeviceName(protectIpForm.getReInjectDeviceName());
                    if ("CTCC".equals(this.cloudSp)) {
                        this.cloudCleanForm.setDefendScope(this.defendScope);
                    } else {
                        this.cloudCleanForm.setDefendAction(this.defendAction);
                    }
                }
                User currentUser = (User)ServletActionContext.getRequest().getSession().getAttribute("currentUser");
                List ddosDevices = this.aticDeviceService.getAntiDDoSDevice(currentUser.getUserID());
                ArrayList<Long> securityIds = new ArrayList<Long>();
                for (AticDevice dev : ddosDevices) {
                    securityIds.add(dev.getMoId());
                }
                CloudCleanProtectIpForm protectIpForm = this.cloudCleanService.getProtectIpByIp(this.cloudCleanForm.getIpMask());
                if (null == protectIpForm) {
                    String[] detailPara = new String[]{this.ipMask};
                    this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, detailPara, "atic.bis.cloud.clean.addpolicy.system.notProtected", target);
                    this.responseResult("notProtected");
                    return;
                }
                List<CloudCleanProtectIpDeviceForm> ipDevs = protectIpForm.getIpDevs();
                for (CloudCleanProtectIpDeviceForm cloudCleanProtectIpDeviceForm : ipDevs) {
                    if (securityIds.contains(cloudCleanProtectIpDeviceForm.getDevId())) continue;
                    String[] detailPara = new String[]{protectIpForm.getProtectIp() + "/" + protectIpForm.getMask()};
                    this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, detailPara, "atic.bis.cloudclean.edit.policy.oplog", target);
                    this.responseResult("checkIpFailed," + protectIpForm.getProtectIp() + "/" + protectIpForm.getMask());
                    return;
                }
                this.cloudCleanService.updateCloudClean(this.cloudCleanForm);
                String[] detailPara = new String[]{this.cloudCleanForm.getIpMask()};
                this.successProcessOpeLog("atic.bis.cloud.clean.operation", true, "atic.bis.cloud.clean.operation.edit", detailPara, "atic.bis.cloudclean.add.policy.oplog");
                this.responseResult("success");
            }
            catch (LegoCheckedException e) {
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                Object[] para = e.getParameters();
                String[] detailPara = new String[]{};
                if (null != para && para.length > 0) {
                    detailPara = para;
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloud.clean.operation");
                logger.info((Object)("LegoCheckedException editCloudClean failed. " + e.getMessage()));
                this.responseResult(errorInfo);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (RuntimeException e) {
                String[] detailPara = new String[]{this.ipMask};
                String target = "atic.bis.cloud.clean.operation";
                if (null != this.cloudCleanForm.getDeviceId()) {
                    this.deviceId = this.cloudCleanForm.getDeviceId();
                }
                this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, detailPara, "atic.bis.cloudclean.edit.policy.oplog", target);
                logger.info((Object)("RuntimeException editCloudClean failed. " + e.getMessage()));
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
            catch (Exception e) {
                String[] detailPara = new String[]{this.ipMask};
                String target = "atic.bis.cloud.clean.operation";
                if (null != this.cloudCleanForm.getDeviceId()) {
                    this.deviceId = this.cloudCleanForm.getDeviceId();
                }
                this.failedProcessOpeLog("atic.bis.cloud.clean.operation.edit", true, detailPara, "atic.bis.cloudclean.edit.policy.oplog", target);
                logger.info((Object)("Exception editCloudClean failed. " + e.getMessage()));
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
        }
    }

    public String editCloudClean() {
        this.pageType = "edit";
        logger.info((Object)("editCloudClean CloudcleanForm.id" + this.cloudCleanId));
        if (null != this.cloudCleanId && null != this.cloudCleanService) {
            this.cloudCleanForm = this.cloudCleanService.getById(this.cloudCleanId);
            if (null != this.cloudCleanForm) {
                this.initAddCloudClean();
            } else {
                throw new LegoCheckedException(201L);
            }
        }
        return "success";
    }

    public String viewDetail() {
        logger.info((Object)("viewDetail" + this.cloudCleanId));
        ArrayList<Long> moIdList = new ArrayList<Long>();
        moIdList.add(this.deviceId);
        BisUtil.checkUserSecurity(moIdList);
        if (null != this.cloudCleanService) {
            AticDevice aticDevice = this.getDeviceById();
            CloudCleanConfigForm configForm = this.cloudCleanService.getCloudCleanConf();
            HashMap<String, String> mapDetail = null;
            if (null != aticDevice && null != configForm) {
                mapDetail = new HashMap<String, String>();
                mapDetail.put("deviceIp", aticDevice.getIpAddress());
                mapDetail.put("ipStatus", configForm.getIpStatus());
                mapDetail.put("ipFlowValue", configForm.getIpFlowValue());
                mapDetail.put("topn", configForm.getIpFlowTopn());
                mapDetail.put("ipVersion", "ipv4");
                String ipWhiteList = configForm.getIpWhiteList();
                ipWhiteList = ipWhiteList.replace("\r", "");
                ipWhiteList = ipWhiteList.replace("\n", ",");
                mapDetail.put("ipWhiteList", ipWhiteList);
                this.deviceIpTopNList = this.cloudCleanService.getTopNIPFlow(aticDevice.getMoId(), mapDetail);
                this.deviceId = aticDevice.getMoId();
                this.deviceName = aticDevice.getName();
                this.deviceIp = (String)mapDetail.get("deviceIp");
                CloudCleanConfigDevFlowForm ccfForm = this.cloudCleanService.getCloudCleanConfDevByDeviceId(aticDevice.getMoId());
                if (null != ccfForm) {
                    this.inflow = ccfForm.getCurFlowValue();
                    this.threshold = ccfForm.getDevFlowValue();
                }
            }
        }
        return "success";
    }

    public String configReInjectDev4Ip() {
        if (null != this.cloudCleanService) {
            Integer count = this.cloudCleanService.getProtectIpNum();
            if (null != count) {
                this.ipToal = count;
            } else {
                logger.error((Object)"getProtectIpNum(), is null");
            }
        } else {
            logger.error((Object)"getCloudCleanService() is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        this.queryIpByPage(map);
        return "success";
    }

    public AticDevice getDeviceById() {
        AticDevice deviceForm = null;
        if (null != this.deviceId && null != this.aticDeviceService) {
            deviceForm = this.aticDeviceService.getDeviceByMoid(this.deviceId.longValue());
        }
        return deviceForm;
    }

    public void enableCloudClean() {
        block24: {
            try {
                logger.info((Object)"Enable Cloud Clean in the action");
                CloudCleanForm cloudForm = null;
                ArrayList<CloudCleanForm> cloudcleanHWFormList = new ArrayList<CloudCleanForm>();
                if (null == this.cloudCleanService || null == this.batchCloudCleanId) break block24;
                Boolean batchResult = true;
                for (Long cloudCleanID : this.batchCloudCleanId) {
                    cloudForm = this.cloudCleanService.getById(cloudCleanID);
                    if (null == cloudForm || !"HW".equals(cloudForm.getServiceProvider()) || "enable".equals(cloudForm.getStatus())) continue;
                    this.checkUserSecurity(cloudCleanID);
                    cloudcleanHWFormList.add(cloudForm);
                }
                if (cloudcleanHWFormList.isEmpty()) {
                    this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, new String[0], "atic.bis.cloudclean.delete.policy.not.exist", "atic.bis.cloud.clean.operation");
                    logger.error((Object)"Failed to enableCloudClean: cloudclean_policy does not exist or service provider is not HW or its status is disable.");
                    this.responseResult("failed");
                    return;
                }
                for (CloudCleanForm cform : cloudcleanHWFormList) {
                    String[] detailPara;
                    String[] detailPara2;
                    CloudCleanProtectIpForm protectIpForm;
                    Long protectIpId;
                    String target = "atic.bis.cloud.clean.operation";
                    if (null != cform.getDeviceId()) {
                        this.deviceId = cform.getDeviceId();
                    }
                    if (null == (protectIpId = cform.getProtectIpId())) {
                        protectIpForm = this.cloudCleanService.getProtectIpByIp(cform.getIpMask());
                        if (null == protectIpForm) {
                            detailPara2 = new String[]{cform.getIpMask(), "atic.bis.cloudClean.disable"};
                            this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, detailPara2, "atic.bis.cloudclean.enable.failed.policy.oplog.not.protect", target);
                            batchResult = false;
                            continue;
                        }
                    } else {
                        protectIpForm = this.cloudCleanService.getIpById(protectIpId);
                        if (null == protectIpForm && null == (protectIpForm = this.cloudCleanService.getProtectIpByIp(cform.getIpMask()))) {
                            detailPara2 = new String[]{cform.getIpMask(), "atic.bis.cloudClean.disable"};
                            this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, detailPara2, "atic.bis.cloudclean.enable.failed.policy.oplog.not.protect", target);
                            batchResult = false;
                            continue;
                        }
                    }
                    cform.setReInjectDeviceName(protectIpForm.getReInjectDeviceName());
                    cform.setProtectIpId(protectIpForm.getId());
                    List<CloudCleanProtectIpDeviceForm> ipDeviceForms = protectIpForm.getIpDevs();
                    Boolean result = true;
                    if (ipDeviceForms.isEmpty()) {
                        result = false;
                    }
                    for (CloudCleanProtectIpDeviceForm ipDeviceForm : ipDeviceForms) {
                        String[] detailPara3;
                        AticDevice reInjectDevice = null;
                        if (null == ipDeviceForm || null == this.aticDeviceService) continue;
                        reInjectDevice = this.aticDeviceService.getDeviceByMoid(ipDeviceForm.getDevId().longValue());
                        Boolean res = this.cloudCleanService.deployDivert(cform, reInjectDevice, "LoopBack100");
                        if (!res.booleanValue()) {
                            logger.error((Object)("deployDivert failed for " + cform.getIpMask() + " on reInjectDevice" + reInjectDevice.getName()));
                            result = false;
                            detailPara3 = new String[]{cform.getIpMask(), "LoopBack100", reInjectDevice.getName()};
                            this.failedProcessOpeLog(DEPLOY_DIVERT, true, detailPara3, "atic.bis.cloudclean.disable.policy.failed.oplog.deployDivert", target);
                            break;
                        }
                        logger.info((Object)("deployDivert success for " + cform.getIpMask() + " on reInjectDevice" + reInjectDevice.getName()));
                        detailPara3 = new String[]{cform.getIpMask(), "LoopBack100", reInjectDevice.getName()};
                        this.successProcessOpeLog(target, true, DEPLOY_DIVERT, detailPara3, "atic.bis.cloudclean.disable.policy.success.oplog.deployDivert");
                    }
                    if (!result.booleanValue()) {
                        logger.error((Object)("deployDivert failed for " + cform.getIpMask()));
                        cform.setStatus("disable");
                        String[] detailPara4 = new String[]{cform.getIpMask(), "atic.bis.cloudClean.disable"};
                        this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, detailPara4, "atic.bis.cloudclean.enable.failed.policy.oplog.deploy.failed", target);
                        batchResult = false;
                        continue;
                    }
                    logger.info((Object)("deployDivert success for " + cform.getIpMask() + " on all reInjectDevices."));
                    ArrayList<CloudCleanForm> list = new ArrayList<CloudCleanForm>();
                    list.add(cform);
                    try {
                        this.cloudCleanService.enableCloudClean4HW(list);
                    }
                    catch (LegoCheckedException e) {
                        detailPara = new String[]{cloudForm.getIpMask(), "atic.bis.cloudClean.disable"};
                        this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.enable.failed.policy.oplog.restful.failed", target);
                        batchResult = false;
                        continue;
                    }
                    logger.info((Object)("enable cloud clean success for " + cform.getIpMask()));
                    if ("enable".equals(cform.getStatus())) {
                        try {
                            this.cloudCleanService.deleteGroupDeviceDivert(cform);
                        }
                        catch (LegoCheckedException e) {
                            logger.error((Object)("deleteGroupDeviceDivert error. " + e.getMessage()));
                            detailPara = new String[]{cloudForm.getIpMask(), "atic.bis.cloudClean.disable"};
                            this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.enable.failed.policy.oplog.delete.divert.failed", target);
                            batchResult = false;
                            continue;
                        }
                    }
                    String[] detailPara5 = new String[]{cform.getIpMask(), "atic.bis.cloudClean.enable"};
                    this.successProcessOpeLog(target, true, ENABLE_CLOUDCLEAN, detailPara5, "atic.bis.cloudclean.enable.success.policy.oplog");
                }
                if (batchResult.booleanValue()) {
                    this.responseResult("success");
                } else {
                    this.responseResult("failed");
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("LegoCheckedException enableCloudClean failed " + e.getMessage()));
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                Object[] para = e.getParameters();
                String[] detailPara = new String[]{};
                if (null != para && para.length > 0) {
                    detailPara = para;
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloud.clean.operation");
                this.responseResult(errorInfo);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.error((Object)("RuntimeException enableCloudClean failed " + e.getMessage()));
                this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, new String[0], "lego.err.102", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
            catch (Exception e) {
                logger.error((Object)("Exception enableCloudClean failed " + e.getMessage()));
                this.failedProcessOpeLog(ENABLE_CLOUDCLEAN, true, new String[0], "lego.err.102", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
        }
    }

    public void disableCloudClean() {
        block17: {
            try {
                logger.info((Object)"Disable Cloud Clean in the action");
                CloudCleanForm cloudForm = null;
                if (null == this.cloudCleanService || null == this.batchCloudCleanId) break block17;
                ArrayList<CloudCleanForm> disableCloudClean4HWFormList = new ArrayList<CloudCleanForm>();
                for (Long cloudCleanID : this.batchCloudCleanId) {
                    cloudForm = this.cloudCleanService.getById(cloudCleanID);
                    if (null == cloudForm || !"HW".equals(cloudForm.getServiceProvider()) || "disable".equals(cloudForm.getStatus())) continue;
                    this.checkUserSecurity(cloudCleanID);
                    disableCloudClean4HWFormList.add(cloudForm);
                }
                if (disableCloudClean4HWFormList.isEmpty()) {
                    this.failedProcessOpeLog(DISABLED_CLOUDCLEAN, true, new String[0], "atic.bis.cloudclean.delete.policy.not.exist", "atic.bis.cloud.clean.operation");
                    logger.error((Object)"Failed to disableCloudClean: cloudclean_policy does not exist or service provider is not HW or its status is disable.");
                    this.responseResult("failed");
                    return;
                }
                Boolean batchResult = true;
                for (CloudCleanForm ccf : disableCloudClean4HWFormList) {
                    String[] detailPara;
                    String target = "atic.bis.cloud.clean.operation";
                    if (null != ccf.getDeviceId()) {
                        this.deviceId = ccf.getDeviceId();
                    }
                    ArrayList<CloudCleanForm> tempList = new ArrayList<CloudCleanForm>();
                    tempList.add(ccf);
                    try {
                        this.cloudCleanService.disableCloudClean4HW(tempList);
                    }
                    catch (LegoCheckedException e) {
                        String[] detailPara2 = new String[]{ccf.getIpMask(), "atic.bis.cloudClean.enable"};
                        this.failedProcessOpeLog(DISABLED_CLOUDCLEAN, true, detailPara2, "atic.bis.cloudclean.disable.policy.failed.oplog.restful.failed", target);
                        batchResult = false;
                        continue;
                    }
                    Long protectIpId = ccf.getProtectIpId();
                    CloudCleanProtectIpForm protectIpForm = this.cloudCleanService.getIpById(protectIpId);
                    List<CloudCleanProtectIpDeviceForm> ipDeviceForms = protectIpForm.getIpDevs();
                    Boolean result = false;
                    for (CloudCleanProtectIpDeviceForm ipDeviceForm : ipDeviceForms) {
                        AticDevice reInjectDevice = null;
                        if (null == ipDeviceForm || null == this.aticDeviceService) continue;
                        reInjectDevice = this.aticDeviceService.getDeviceByMoid(ipDeviceForm.getDevId().longValue());
                        Boolean res = this.cloudCleanService.undoDeployDivert(ccf, reInjectDevice, "LoopBack100");
                        String[] detailParas = new String[]{ccf.getIpMask(), "LoopBack100", reInjectDevice.getName()};
                        if (!res.booleanValue()) {
                            this.failedProcessOpeLog(UNDO_DEPLOY_DIVERT, true, detailParas, "atic.bis.cloudclean.disable.policy.failed.oplog.undoDeployDivert", target);
                            continue;
                        }
                        result = true;
                        this.successProcessOpeLog(target, true, UNDO_DEPLOY_DIVERT, detailParas, "atic.bis.cloudclean.disable.policy.success.oplog.undoDeployDivert");
                    }
                    this.undoDeployDivert300(ccf);
                    if (result.booleanValue()) {
                        logger.info((Object)("undo deployDivert success for " + ccf.getIpMask()));
                        detailPara = new String[]{ccf.getIpMask(), "atic.bis.cloudClean.disable"};
                        this.successProcessOpeLog(target, true, DISABLED_CLOUDCLEAN, detailPara, "atic.bis.cloudclean.disable.policy.success.oplog");
                    } else {
                        logger.error((Object)("undo deployDivert error for " + ccf.getIpMask()));
                        detailPara = new String[]{cloudForm.getIpMask(), "atic.bis.cloudClean.disable"};
                        this.failedProcessOpeLog(DISABLED_CLOUDCLEAN, true, detailPara, "atic.bis.cloudclean.disable.policy.failed.oplog.deploy.failed", target);
                        batchResult = false;
                    }
                    logger.info((Object)("disable cloud clean success for ip " + ccf.getIpMask()));
                }
                if (batchResult.booleanValue()) {
                    this.responseResult("success");
                } else {
                    this.responseResult("failed");
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("LegoCheckedException disableCloudClean failed " + e.getMessage()));
                String errorInfo = this.getText("lego.err." + e.getErrorCode());
                Object[] para = e.getParameters();
                String[] detailPara = new String[]{};
                if (null != para && para.length > 0) {
                    detailPara = para;
                    errorInfo = MessageFormat.format(errorInfo, para);
                }
                this.failedProcessOpeLog(DISABLED_CLOUDCLEAN, true, detailPara, "lego.err." + e.getErrorCode(), "atic.bis.cloud.clean.operation");
                this.responseResult(errorInfo);
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
            catch (RuntimeException e) {
                logger.error((Object)("RuntimeException disableCloudClean failed " + e.getMessage()));
                this.failedProcessOpeLog(DISABLED_CLOUDCLEAN, true, new String[0], "lego.err.102", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
            catch (Exception e) {
                logger.error((Object)("RuntimeException Exception failed " + e.getMessage()));
                this.failedProcessOpeLog(DISABLED_CLOUDCLEAN, true, new String[0], "lego.err.102", "atic.bis.cloud.clean.operation");
                this.responseResult("failed");
                throw new LegoCheckedException(102L);
            }
        }
    }

    private void successProcessOpeLog(String target, boolean targetLocal, String operation, String[] detailPara, String detail) {
        SysOptLog sysOptLogLego = new SysOptLog();
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String operator = "";
        String terminalIp = "127.0.0.1";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("atic.bis.cloudClean");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget(target);
        sysOptLogLego.setResult(1);
        sysOptLogLego.setDetail(detail);
        sysOptLogLego.setDetailPara(detailPara);
        sysOptLogLego.setTerminalIp(terminalIp);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(targetLocal));
        this.sysLogService.writeOptLog(sysOptLogLego);
    }

    private void failedProcessOpeLog(String operation, boolean targetLocal, String[] detailPara, String detail, String target) {
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String operator = "";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.normal.getValue());
        sysOptLogLego.setModule("atic.bis.cloudClean");
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget(target);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(targetLocal));
        sysOptLogLego.setResult(0);
        sysOptLogLego.setDetailPara(detailPara);
        sysOptLogLego.setDetail(detail);
        sysOptLogLego.setTerminalIp(terminalIp);
        this.sysLogService.writeOptLog(sysOptLogLego);
    }

    public boolean validateBatchCloudCleanId() {
        if (null == this.batchCloudCleanId) {
            return false;
        }
        if (this.batchCloudCleanId.length > 100) {
            return false;
        }
        for (int i = 0; i < this.batchCloudCleanId.length; ++i) {
            if (this.batchCloudCleanId[i] >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean validateIpAndMask() {
        if (AticUtil.isNull((String)this.ipMask)) {
            return false;
        }
        String regex1 = "^((22[0-3]|2[0-1]\\d|1\\d{2}|[1-9]\\d|[1-9])\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[0-9]\\d|[0-9]))?\\/(([0-9])|([1-2][0-9])|(3[0-2]))$";
        if (this.ipMask.matches(regex1)) {
            String ipHeadStr = this.ipMask.split("\\.")[0];
            return !StringUtils.equals((CharSequence)ipHeadStr, (CharSequence)"127");
        }
        return false;
    }

    public boolean processPara() {
        String nameTemp = this.reInjectDeviceName.trim();
        if (CommonUtil.isNull((String)nameTemp) || nameTemp.length() > 16500) {
            return false;
        }
        String[] injectDeviceNames = this.reInjectDeviceName.split(",");
        if (injectDeviceNames.length > 500) {
            return false;
        }
        String nameRegex = "^(?!(?i)null$)[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5\\.,]*$";
        return nameTemp.matches(nameRegex);
    }

    private void undoDeployDivert300(CloudCleanForm cloudCleanForm) {
        if (null != cloudCleanForm.getPolicyType() && "auto".equals(cloudCleanForm.getPolicyType()) && this.isNeedUndoLoopBack300()) {
            logger.info((Object)"need to undo LoopBack300.");
            String[] paras = this.getOptLogParas();
            this.cloudCleanService.undoDeployDivert300(cloudCleanForm, paras);
        }
    }

    private boolean isNeedUndoLoopBack300() {
        IDateTableFileService dateTableFileService = ZoneReferUtil.getDateTableFileService();
        boolean isOpenLoopBack300 = dateTableFileService.isOpenLoopBack300();
        int loopBack300DelayTime = dateTableFileService.getLoopBack300DelayTime();
        return isOpenLoopBack300 && loopBack300DelayTime == 0;
    }

    private String[] getOptLogParas() {
        String[] paras = new String[2];
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String operator = "system";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        paras[0] = operator;
        paras[1] = terminalIp;
        return paras;
    }

    public List<LangPair> getDefendActionList() {
        return this.defendActionList;
    }

    public void setDefendActionList(List<LangPair> defendActionList) {
        this.defendActionList = defendActionList;
    }

    public CloudCleanForm getCloudCleanForm() {
        return this.cloudCleanForm;
    }

    public void setCloudCleanForm(CloudCleanForm cloudCleanForm) {
        this.cloudCleanForm = cloudCleanForm;
    }

    public List<LangPair> getDefendScopeList() {
        return this.defendScopeList;
    }

    public void setDefendScopeList(List<LangPair> defendScopeList) {
        this.defendScopeList = defendScopeList;
    }

    public String getCloudCleanDefendScopeDef() {
        return this.cloudCleanDefendScopeDef;
    }

    public void setCloudCleanDefendScopeDef(String cloudCleanDefendScopeDef) {
        this.cloudCleanDefendScopeDef = cloudCleanDefendScopeDef;
    }

    public String getCloudSp() {
        return this.cloudSp;
    }

    public void setCloudSp(String cloudSp) {
        this.cloudSp = cloudSp;
    }

    public ICloudCleanService getCloudCleanService() {
        return this.cloudCleanService;
    }

    public void setCloudCleanService(ICloudCleanService cloudCleanService) {
        this.cloudCleanService = cloudCleanService;
    }

    public String getIpMask() {
        return this.ipMask;
    }

    public void setIpMask(String ipMask) {
        this.ipMask = ipMask;
    }

    public String getDefendAction() {
        return this.defendAction;
    }

    public void setDefendAction(String defendAction) {
        this.defendAction = defendAction;
    }

    public String getUnblockTime() {
        return this.unblockTime;
    }

    public void setUnblockTime(String unblockTime) {
        this.unblockTime = unblockTime;
    }

    public Integer getDefendScope() {
        return this.defendScope;
    }

    public void setDefendScope(Integer defendScope) {
        this.defendScope = defendScope;
    }

    public List<CloudCleanForm> getCloudCleanFormList() {
        return this.cloudCleanFormList;
    }

    public void setCloudCleanFormList(List<CloudCleanForm> cloudCleanFormList) {
        this.cloudCleanFormList = cloudCleanFormList;
    }

    public List<CloudCleanProtectIpForm> getIpReInjectDeviceList() {
        return this.ipReInjectDeviceList;
    }

    public void setIpReInjectDeviceList(List<CloudCleanProtectIpForm> ipReInjectDeviceList) {
        this.ipReInjectDeviceList = ipReInjectDeviceList;
    }

    public Long[] getBatchCloudCleanId() {
        if (null != this.batchCloudCleanId) {
            return (Long[])this.batchCloudCleanId.clone();
        }
        return new Long[0];
    }

    public void setBatchCloudCleanId(Long[] batchCloudCleanId) {
        this.batchCloudCleanId = null != batchCloudCleanId ? (Long[])batchCloudCleanId.clone() : null;
    }

    public Long getCloudCleanId() {
        return this.cloudCleanId;
    }

    public void setCloudCleanId(Long cloudCleanId) {
        this.cloudCleanId = cloudCleanId;
    }

    public String getPageType() {
        return this.pageType;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public Long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public String getInflow() {
        return this.inflow;
    }

    public void setInflow(String inflow) {
        this.inflow = inflow;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public void setThreshold(String threshold) {
        this.threshold = threshold;
    }

    public List<DeviceIpTopN> getDeviceIpTopNList() {
        return this.deviceIpTopNList;
    }

    public void setDeviceIpTopNList(List<DeviceIpTopN> deviceIpTopNList) {
        this.deviceIpTopNList = deviceIpTopNList;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public int getStaticToal() {
        return this.staticToal;
    }

    public void setStaticToal(int staticToal) {
        this.staticToal = staticToal;
    }

    public int getIpToal() {
        return this.ipToal;
    }

    public void setIpToal(int ipToal) {
        this.ipToal = ipToal;
    }

    public IAticDeviceService getFirewallService() {
        return this.firewallService;
    }

    public void setFirewallService(IAticDeviceService firewallService) {
        this.firewallService = firewallService;
    }

    public String getDefDeviceName() {
        return this.defDeviceName;
    }

    public void setDefDeviceName(String defDeviceName) {
        this.defDeviceName = defDeviceName;
    }

    public String getDefDeviceId() {
        return this.defDeviceId;
    }

    public void setDefDeviceId(String defDeviceId) {
        this.defDeviceId = defDeviceId;
    }

    public String getReInjectDeviceId() {
        return this.reInjectDeviceId;
    }

    public void setReInjectDeviceId(String reInjectDeviceId) {
        this.reInjectDeviceId = reInjectDeviceId;
    }

    public String getReInjectDeviceName() {
        return this.reInjectDeviceName;
    }

    public void setReInjectDeviceName(String reInjectDeviceName) {
        this.reInjectDeviceName = reInjectDeviceName;
    }

    public CloudCleanProtectIpForm getCloudCleanProtectIpForm() {
        return this.cloudCleanProtectIpForm;
    }

    public void setCloudCleanProtectIpForm(CloudCleanProtectIpForm cloudCleanProtectIpForm) {
        this.cloudCleanProtectIpForm = cloudCleanProtectIpForm;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public ISysOptLog getSysLogService() {
        return this.sysLogService;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }
}

