/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.dao;

import com.hs.atic.cloudclean.model.CloudCleanProtectIp;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CloudCleanProtectIpDao
extends CommonDaoImpl {
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);

    public void deleteById(Long id) {
        String hql = "delete from CloudCleanProtectIp where id=?0";
        this.logger.info((Object)("deleteById,id is " + id));
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{id});
    }

    public void batchDeteleProtectIp(List<CloudCleanProtectIp> ipList) {
        this.getHibernateTemplate().deleteAll(ipList);
        StringBuffer sb = new StringBuffer();
        for (CloudCleanProtectIp ip : ipList) {
            sb.append(ip.getId()).append(':').append(ip.getProtectIp()).append('/').append(ip.getMask()).append(';');
        }
        this.logger.info((Object)("batchDeteleProtectIpForm success! The delete ip is " + sb.toString()));
    }

    public void updateCloudCleanProtectIp(CloudCleanProtectIp ip) {
        this.logger.info((Object)("update CloudCleanProtectIp, the ip is " + ip.getProtectIp() + "/" + ip.getMask()));
        this.getHibernateTemplate().saveOrUpdate((Object)ip);
    }

    public Paging queryIpByPage(Map<String, String> conditionMap, int start, int pageSize) {
        String regular;
        Paging page = new Paging();
        HashMap queryMap = new HashMap();
        String hql = "from CloudCleanProtectIp where (1=1) ";
        String hql4Count = "select count(*) as rowCount ";
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        String sortType = conditionMap.get("sortType");
        String sortName = conditionMap.get("sortName");
        if (!AticUtil.isNull((String)sortType) && !AticUtil.isNull((String)sortName) && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql = hql + " order by " + sortName + " " + sortType;
        }
        List result = this.findPage(hql, start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<CloudCleanProtectIp> getAllProtectIpMask() {
        String hql = "from CloudCleanProtectIp";
        List ipList = this.findByHql(hql);
        if (ipList != null) {
            return ipList;
        }
        return new ArrayList<CloudCleanProtectIp>();
    }

    public List<CloudCleanProtectIp> getIpById(Long id) {
        String hql = "from CloudCleanProtectIp where id=?0";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        param.put(0, String.valueOf(id));
        this.logger.info((Object)("getIpById the id is " + id));
        return this.findByHql(hql, param);
    }

    public Integer getProtectIpNum() {
        Iterator iterator;
        String hql = "SELECT COUNT(*) FROM CloudCleanProtectIp";
        this.logger.info((Object)"getProtectIpNum");
        List countList = this.findByHql(hql);
        if (null != countList && !countList.isEmpty() && (iterator = countList.iterator()).hasNext()) {
            Long count = (Long)iterator.next();
            this.logger.info((Object)("getProtectIpNum: the count is " + count));
            return Integer.valueOf(String.valueOf(count));
        }
        this.logger.info((Object)"getProtectIpNum: the count is 0");
        return null;
    }
}

