/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.service.impl;

import com.hs.atic.cloudclean.dao.CloudCleanConfigDao;
import com.hs.atic.cloudclean.dao.CloudCleanConfigDevFlowDao;
import com.hs.atic.cloudclean.dao.CloudCleanDao;
import com.hs.atic.cloudclean.form.CloudCleanConfigDevFlowForm;
import com.hs.atic.cloudclean.form.CloudCleanConfigForm;
import com.hs.atic.cloudclean.model.CloudClean;
import com.hs.atic.cloudclean.model.CloudCleanConfig;
import com.hs.atic.cloudclean.model.CloudCleanConfigDevFlow;
import com.hs.atic.cloudclean.util.CloudCleanAlarmHandler;
import com.hs.atic.cloudclean.util.CloudCleanThreadDeal;
import com.hs.atic.cloudclean.util.CloudCleanUtil;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanConfigService;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanService;
import com.hs.lego.cbb.fault.sdk.service.FaultService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CloudCleanConfigService
implements ICloudCleanConfigService {
    private static final int DELAYTIME_MIN = 0;
    private static final int DELAYTIME_MAX = 1200;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private CloudCleanConfigDao cloudCleanConfigDao;
    private CloudCleanConfigDevFlowDao cloudCleanConfigDevFlowDao;
    private CloudCleanDao cloudCleanDao;
    private ICloudCleanService cloudCleanService;
    private CloudCleanAlarmHandler cloudCleanAlarmHandler;
    private CloudCleanThreadDeal cloudCleanThreadDeal;
    private FaultService iFaultService;
    private IDataProtectService dataProtectService;

    @Override
    public void saveCloudCleanConfig(CloudCleanConfigForm form, boolean isChangeFlowValue) {
        if (null != form) {
            String serviceProviderStr = form.getServiceProvider();
            if (StringUtils.equals((CharSequence)"HW", (CharSequence)serviceProviderStr)) {
                String unblockTime = form.getUnblockTime();
                try {
                    int num = Integer.parseInt(unblockTime);
                    if (num < 0 || num > 1200) {
                        throw new LegoCheckedException(570505L);
                    }
                }
                catch (NumberFormatException e) {
                    throw new LegoCheckedException(570505L, (Throwable)e);
                }
            }
            this.logger.info((Object)("save configFormToConfigInfo to database; info.id=" + form.getId() + ";info.serviceProvider" + form.getServiceProvider()));
            this.cloudCleanConfigDao.save(this.configFormToConfigInfo(form));
        }
        this.logger.info((Object)("isChangeFlowValue is " + isChangeFlowValue + " in the saveCloudCleanConfig"));
        this.cloudCleanThreadDeal.setChangeFlowValue(isChangeFlowValue);
    }

    public CloudCleanConfig configFormToConfigInfo(CloudCleanConfigForm form) {
        List infoList = this.cloudCleanConfigDao.getAll();
        CloudCleanConfig info = null;
        info = null != infoList && !infoList.isEmpty() ? (CloudCleanConfig)infoList.get(0) : new CloudCleanConfig();
        if (null != form) {
            info.setId(form.getId());
            info.setServiceProvider(form.getServiceProvider());
            info.setMode(form.getMode());
            info.setIpStatus(form.getIpStatus());
            info.setIpFlowTopn(form.getIpFlowTopn());
            info.setIpFlowValue(form.getIpFlowValue());
            info.setDefaultPolicy(form.getDefaultPolicy());
            info.setUnblockTime(form.getUnblockTime());
            info.setUrl(form.getUrl());
            if (null != form.getPrivateKey()) {
                info.setPrivateKey(form.getPrivateKey());
            }
            if (null != form.getPublicKey()) {
                info.setPublicKey(form.getPublicKey());
            }
            info.setDefendAction(form.getDefendAction());
            info.setIpWhiteList(form.getIpWhiteList());
            ArrayList<CloudCleanConfigDevFlow> cloudCleanConfigDevFlows = new ArrayList<CloudCleanConfigDevFlow>();
            if (null != form.getCloudCleanConfigDevFlows() && !form.getCloudCleanConfigDevFlows().isEmpty()) {
                for (CloudCleanConfigDevFlowForm devForm : form.getCloudCleanConfigDevFlows()) {
                    cloudCleanConfigDevFlows.add(this.devFormToDevInfo(devForm));
                }
            }
            info.setCloudCleanConfigDevFlows(cloudCleanConfigDevFlows);
            info.setCertAlias(form.getCertAlias());
        }
        return info;
    }

    public CloudCleanConfigDevFlow devFormToDevInfo(CloudCleanConfigDevFlowForm form) {
        CloudCleanConfigDevFlow info = new CloudCleanConfigDevFlow();
        if (null != form) {
            info.setId(form.getId());
            info.setConfigId(form.getConfigId());
            info.setDevFlowValue(form.getDevFlowValue());
            info.setDeviceId(form.getDeviceId());
            info.setDeviceIp(form.getDeviceIp());
            info.setDeviceName(form.getDeviceName());
            info.setCurFlowValue(form.getCurFlowValue());
        }
        return info;
    }

    @Override
    public CloudCleanConfigForm findCloudCleanConfig() {
        CloudCleanConfig info;
        this.logger.info((Object)"get configFormToConfigInfo from database ");
        List list = this.cloudCleanConfigDao.getAll();
        if (null != list && !list.isEmpty() && null != (info = (CloudCleanConfig)list.get(0))) {
            this.logger.info((Object)("get configFormToConfigInfo from database SUCCESS; info.id=" + info.getId()));
            return this.configInfoToConfigForm(info);
        }
        this.logger.info((Object)"get configFormToConfigInfo from database FAIL: return null ");
        return null;
    }

    public CloudCleanConfigForm configInfoToConfigForm(CloudCleanConfig info) {
        CloudCleanConfigForm form = new CloudCleanConfigForm();
        if (null != info) {
            form.setId(info.getId());
            form.setServiceProvider(info.getServiceProvider());
            form.setMode(info.getMode());
            form.setIpStatus(info.getIpStatus());
            form.setIpFlowTopn(info.getIpFlowTopn());
            form.setIpFlowValue(info.getIpFlowValue());
            form.setDefaultPolicy(info.getDefaultPolicy());
            form.setUnblockTime(info.getUnblockTime());
            form.setUrl(info.getUrl());
            form.setPrivateKey(info.getPrivateKey());
            form.setPublicKey(info.getPublicKey());
            form.setDefendAction(info.getDefendAction());
            form.setIpWhiteList(info.getIpWhiteList());
            ArrayList<CloudCleanConfigDevFlowForm> cloudCleanConfigDevFlowForms = new ArrayList<CloudCleanConfigDevFlowForm>();
            if (null != info.getCloudCleanConfigDevFlows() && !info.getCloudCleanConfigDevFlows().isEmpty()) {
                for (CloudCleanConfigDevFlow devInfo : info.getCloudCleanConfigDevFlows()) {
                    cloudCleanConfigDevFlowForms.add(this.devInfoToDevForm(devInfo));
                }
            }
            form.setCloudCleanConfigDevFlows(cloudCleanConfigDevFlowForms);
            form.setCertAlias(info.getCertAlias());
        }
        return form;
    }

    public CloudCleanConfigDevFlowForm devInfoToDevForm(CloudCleanConfigDevFlow info) {
        CloudCleanConfigDevFlowForm form = new CloudCleanConfigDevFlowForm();
        if (null != info) {
            form.setId(info.getId());
            form.setConfigId(info.getConfigId());
            form.setDevFlowValue(info.getDevFlowValue());
            form.setDeviceId(info.getDeviceId());
            form.setDeviceIp(info.getDeviceIp());
            form.setDeviceName(info.getDeviceName());
            form.setCurFlowValue(info.getCurFlowValue());
        }
        return form;
    }

    @Override
    public void updateCloudCleanConfig(CloudCleanConfigForm form) {
        this.logger.info((Object)("update configFormToConfigInfo :form.id" + form.getId() + "form.ServiceProvider" + form.getServiceProvider()));
        this.cloudCleanConfigDao.update(this.configFormToConfigInfo(form));
    }

    public List<CloudCleanConfigDevFlowForm> queryDevFlowList() {
        this.logger.info((Object)"get CloudCleanConfigDevFlowForm from database");
        List list = this.cloudCleanConfigDevFlowDao.getAll();
        ArrayList<CloudCleanConfigDevFlowForm> formList = new ArrayList<CloudCleanConfigDevFlowForm>();
        if (null != list && !list.isEmpty()) {
            for (CloudCleanConfigDevFlow info : list) {
                formList.add(this.devInfoToDevForm(info));
                this.logger.info((Object)("get CloudCleanConfigDevFlowForm from database;info.deviceid :" + info.getDeviceId()));
            }
        }
        return formList;
    }

    public void notifyDevFlowList(CloudCleanConfigDevFlow cloudCleanConfigDevFlow) {
        this.logger.info((Object)"save CurFlowValue to database");
        Long deviceId = cloudCleanConfigDevFlow.getDeviceId();
        List<CloudClean> list = null;
        CloudCleanConfigDevFlow deviceInfo = this.cloudCleanConfigDevFlowDao.findByDeviceId(deviceId.toString());
        if (deviceInfo != null) {
            deviceInfo.setCurFlowValue(cloudCleanConfigDevFlow.getCurFlowValue());
            CloudCleanConfigForm form = this.findCloudCleanConfig();
            this.logger.info((Object)("policy is null:create policy;deviceId=" + deviceId));
            this.cloudCleanConfigDevFlowDao.save(deviceInfo);
            list = this.cloudCleanService.autoCreateCloudClean(deviceId);
            if (null != list && !list.isEmpty() && null != form) {
                this.saveDeviceAndStartPolicy(list, form, deviceInfo);
            }
        }
    }

    public void saveDeviceAndStartPolicy(List<CloudClean> list, CloudCleanConfigForm form, CloudCleanConfigDevFlow deviceInfo) {
        this.logger.info((Object)("clean manual save deviceInfo.deviceId=" + deviceInfo.getDeviceId() + " to database;"));
        this.cloudCleanConfigDevFlowDao.save(deviceInfo);
        for (CloudClean info : list) {
            String policyType = info.getPolicyType();
            String status = info.getStatus();
            if (!"auto".equals(policyType)) continue;
            this.logger.info((Object)"cloud clean policy auto start, alarm start");
            if ("enable".equals(status)) {
                this.cloudCleanAlarmHandler.cloudCleanAlarmStart(deviceInfo, form, info);
            } else {
                this.cloudCleanAlarmHandler.cloudCleanAlarmStartFailed(deviceInfo, form, info);
            }
            this.logger.info((Object)"cloud clean policy auto start, alarm end");
        }
    }

    @Override
    public Map<String, String> getStartCloudCleanParams(CloudCleanConfigForm form, CloudClean info, CloudCleanConfigDevFlow deviceInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ipMask", info.getIpMask());
        if (null == deviceInfo) {
            return map;
        }
        String flowValue = deviceInfo.getCurFlowValue();
        if (null == flowValue) {
            map.put("curFlow", null);
        } else {
            map.put("curFlow", flowValue + "G");
        }
        map.put("defendAction", form.getDefendAction());
        return map;
    }

    @Override
    public CloudCleanConfigDevFlow queryDevFlowById(String id) {
        this.logger.info((Object)("get CloudCleanConfigDevFlow by device id;id=" + id));
        return this.cloudCleanConfigDevFlowDao.findByDeviceId(id);
    }

    @Override
    public void deletePolicyByDeviceId(List<Long> deviceIds) {
        this.logger.info((Object)"when delete device delete policy");
        if (null == deviceIds || deviceIds.isEmpty()) {
            this.logger.info((Object)"when delete device delete policy: deviceids is null ");
            return;
        }
        CloudCleanConfigForm cloudCleanConfigForm = this.findCloudCleanConfig();
        for (Long id : deviceIds) {
            CloudCleanConfigDevFlow cloudCleanConfigDevFlow = this.queryDevFlowById(id + "");
            List<CloudClean> list = this.cloudCleanDao.queryByDeviceId(id);
            if (null == list || list.isEmpty()) {
                this.cloudCleanConfigDevFlowDao.deleteByDeviceId(id);
                continue;
            }
            ArrayList<CloudClean> deletelist = new ArrayList<CloudClean>();
            if (null != cloudCleanConfigDevFlow && null != cloudCleanConfigForm) {
                for (CloudClean info : list) {
                    this.logger.info((Object)("when delete device delete policy:close cloud clean;policy.id=" + info.getId() + "configForm.id" + cloudCleanConfigForm.getId() + "deviceFlow.deviceId=" + cloudCleanConfigDevFlow.getDeviceId()));
                    this.closeCloudClean(info, cloudCleanConfigForm);
                    if (null == info.getPolicyType() || "static".equals(info.getPolicyType())) continue;
                    deletelist.add(info);
                }
            }
            this.cloudCleanService.deteleByInfo(list);
            this.cloudCleanThreadDeal.removeDeleteList(deletelist);
            this.cloudCleanConfigDevFlowDao.deleteByDeviceId(id);
            this.logger.info((Object)"when delete device delete policy:end");
        }
    }

    private void closeCloudClean(CloudClean info, CloudCleanConfigForm configForm) {
        String serviceProvider = configForm.getServiceProvider();
        if ("HW".equals(serviceProvider)) {
            this.logger.info((Object)"when delete device delete policy:close cloud clean  cttc;");
            CloudCleanUtil.getInstance().disableCloudClean4HW(configForm.getUrl(), new StringBuffer(configForm.getPublicKey()), new StringBuffer(configForm.getPrivateKey()), info.getEventId(), configForm.getCertAlias());
        }
    }

    @Override
    public Map<String, String> getStartCTTCCloudCleanParams(CloudClean info, CloudCleanConfigDevFlow deviceInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("ip", deviceInfo.getDeviceIp());
        map.put("zone", info.getDefendScope() + "");
        map.put("unblockTime", info.getUnblockTime());
        return map;
    }

    @Override
    public Map<String, String> testCloudCleanConfig(String serviceProvider, String url, StringBuffer publicKey, StringBuffer privateKey, String alias) {
        Map<String, String> map = null;
        StringBuffer pubPWD = DataProtectServiceConst.sdpDecryptLocalBuffer((String)publicKey.toString());
        StringBuffer prvPWD = DataProtectServiceConst.sdpDecryptLocalBuffer((String)privateKey.toString());
        if ("HW".equals(serviceProvider)) {
            map = CloudCleanUtil.getInstance().getAccountInfo4HW(url, pubPWD, prvPWD, alias);
        }
        return map;
    }

    public void deleteByAlarm(long deviceId) {
        List<CloudClean> delCloudCleanList = this.cloudCleanDao.deleteByAlarm(deviceId);
        if (null != delCloudCleanList && !delCloudCleanList.isEmpty()) {
            ISysOptLog sysOptLogMgr = CloudCleanUtil.getSysOptLog();
            for (CloudClean ccdel : delCloudCleanList) {
                SysOptLog sysOptLog = new SysOptLog();
                sysOptLog.setOperation("atic.bis.cloud.clean.operation.delete");
                sysOptLog.setModule("lego.dic.module.AticBis");
                sysOptLog.setTerminalIp("127.0.0.1");
                sysOptLog.setOperator("system");
                sysOptLog.setLevel(SysoplogLevel.normal.getValue());
                sysOptLog.setResult(1);
                sysOptLog.setTarget(ccdel.getIpMask());
                sysOptLog.setDetail("atic.bis.cloudclean.delete.policy.success.oplog.autocreate");
                String[] detailPara = new String[]{ccdel.getIpMask()};
                sysOptLog.setDetailPara(detailPara);
                if (null == sysOptLogMgr) continue;
                sysOptLogMgr.writeOptLog(sysOptLog);
            }
        }
    }

    @Override
    public boolean isChangeFlowValue() {
        return this.cloudCleanThreadDeal.isIsChangeFlowValue();
    }

    @Override
    public void changeFalseFlowValue() {
        this.cloudCleanThreadDeal.setChangeFlowValue(false);
    }

    public IDataProtectService getDataProtectService() {
        return this.dataProtectService;
    }

    public void setDataProtectService(IDataProtectService dataProtectService) {
        this.dataProtectService = dataProtectService;
    }

    public CloudCleanConfigDao getCloudCleanConfigDao() {
        return this.cloudCleanConfigDao;
    }

    public void setCloudCleanConfigDao(CloudCleanConfigDao cloudCleanConfigDao) {
        this.cloudCleanConfigDao = cloudCleanConfigDao;
    }

    public CloudCleanConfigDevFlowDao getCloudCleanConfigDevFlowDao() {
        return this.cloudCleanConfigDevFlowDao;
    }

    public void setCloudCleanConfigDevFlowDao(CloudCleanConfigDevFlowDao cloudCleanConfigDevFlowDao) {
        this.cloudCleanConfigDevFlowDao = cloudCleanConfigDevFlowDao;
    }

    public CloudCleanDao getCloudCleanDao() {
        return this.cloudCleanDao;
    }

    public void setCloudCleanDao(CloudCleanDao cloudCleanDao) {
        this.cloudCleanDao = cloudCleanDao;
    }

    public ICloudCleanService getCloudCleanService() {
        return this.cloudCleanService;
    }

    public void setCloudCleanService(ICloudCleanService cloudCleanService) {
        this.cloudCleanService = cloudCleanService;
    }

    public CloudCleanAlarmHandler getAlarmHandler() {
        return this.cloudCleanAlarmHandler;
    }

    public void setAlarmHandler(CloudCleanAlarmHandler alarmHandler) {
        this.cloudCleanAlarmHandler = alarmHandler;
    }

    public CloudCleanThreadDeal getCloudCleanThreadDeal() {
        return this.cloudCleanThreadDeal;
    }

    public void setCloudCleanThreadDeal(CloudCleanThreadDeal cloudCleanThreadDeal) {
        this.cloudCleanThreadDeal = cloudCleanThreadDeal;
    }

    public FaultService getiFaultService() {
        return this.iFaultService;
    }

    public void setiFaultService(FaultService iFaultServices) {
        this.iFaultService = iFaultServices;
    }

    public CloudCleanAlarmHandler getCloudCleanAlarmHandler() {
        return this.cloudCleanAlarmHandler;
    }

    public void setCloudCleanAlarmHandler(CloudCleanAlarmHandler cloudCleanAlarmHandler) {
        this.cloudCleanAlarmHandler = cloudCleanAlarmHandler;
    }
}

