/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.service.impl;

import com.hs.atic.sdk.cloudclean.service.ICloudCleanConfigService;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanService;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDeviceForm;
import java.util.ArrayList;
import org.springframework.beans.factory.InitializingBean;

public class CloudCleanReceiveMessageForDelDevice
extends MessageTaskManager
implements InitializingBean {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_POLICY);
    private ICloudCleanConfigService cloudCleanConfigService;
    private ICloudCleanService cloudCleanService;
    private IMessageCenter messageCenter = null;

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(116L);
        return mrs;
    }

    public void onMessage(MessageUnit message) {
        if (null == message) {
            return;
        }
        int messageCode = (int)message.getCmdcode();
        if (116L == (long)messageCode) {
            ArrayList deviceList = (ArrayList)message.getObj();
            ArrayList<Long> moidList = new ArrayList<Long>();
            for (AticDeviceForm aticDeviceForm : deviceList) {
                moidList.add(aticDeviceForm.getMoId());
            }
            try {
                this.cloudCleanConfigService.deletePolicyByDeviceId(moidList);
                for (Long moid : moidList) {
                    this.cloudCleanService.deleteCloudCleanProtectIpDevice(moid);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("delete device relation mo is error." + ex.getMessage()));
            }
        }
    }

    public ICloudCleanConfigService getCloudCleanConfigService() {
        return this.cloudCleanConfigService;
    }

    public void setCloudCleanConfigService(ICloudCleanConfigService cloudCleanConfigService) {
        this.cloudCleanConfigService = cloudCleanConfigService;
    }

    public ICloudCleanService getCloudCleanService() {
        return this.cloudCleanService;
    }

    public void setCloudCleanService(ICloudCleanService cloudCleanService) {
        this.cloudCleanService = cloudCleanService;
    }

    public void afterPropertiesSet() throws Exception {
        this.messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }
}

