/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cloudclean.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hs.atic.sdk.cloudclean.service.ICloudCleanService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.restful.util.HttpsConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CloudCleanUtil {
    public static final String CLOUD_CLEAN_SP_HW = "HW";
    public static final String CLOUD_CLEAN_METHOD_HW_EVENT = "/api/events/";
    public static final String CLOUD_CLEAN_METHOD_HW_ACCOUNT = "/api/profiling/";
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_CLOUDCLEAN);
    private static final CloudCleanUtil INSTANCE = new CloudCleanUtil();

    public static CloudCleanUtil getInstance() {
        return INSTANCE;
    }

    public static ISysOptLog getSysOptLog() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ISysOptLog sysOptLog = (ISysOptLog)context.getService("sysLogService", ISysOptLog.class);
            if (sysOptLog != null) {
                return sysOptLog;
            }
            logger.error((Object)"get system/sysLogService service error");
        }
        logger.error((Object)"get system/sysLogService service error");
        return null;
    }

    public static ICloudCleanService getCloudCleanService() {
        ServiceContext context = ServiceContext.getInstance();
        if (context != null) {
            ICloudCleanService cloudCleanService = (ICloudCleanService)context.getService("cloudCleanService", ICloudCleanService.class);
            if (cloudCleanService != null) {
                return cloudCleanService;
            }
            logger.error((Object)"get AticBis/cloudCleanService service error");
        }
        logger.error((Object)"get AticBis/cloudCleanService service error");
        return null;
    }

    public String enableCloudClean4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey, Map<String, String> params) {
        String curFlow = params.get("curFlow");
        if (null == curFlow) {
            curFlow = "";
        }
        String json = "{\"curr_bandwidth\": \"" + curFlow + "\", \"attack_type\": \"\", \"cidr\": \"" + params.get("ipMask") + "\", \"clean_country\": \"\", \"action\": \"" + params.get("defendAction") + "\"}";
        String result = "";
        try {
            result = this.connectRestByPost(targetURL, CLOUD_CLEAN_METHOD_HW_EVENT, json, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, json, null), params.get("alias"));
        }
        catch (LegoCheckedException e) {
            try {
                result = this.connectRestByPost(targetURL, CLOUD_CLEAN_METHOD_HW_EVENT, json, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, json, null), params.get("alias"));
            }
            catch (LegoCheckedException exception) {
                throw new LegoCheckedException(exception.getErrorCode(), (Throwable)exception);
            }
        }
        String eventId = null;
        if (CloudCleanUtil.validateResult(result)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.disableDefaultTyping();
            try {
                eventId = ((Map)mapper.readValue(result, Map.class)).get("id").toString();
            }
            catch (IOException io) {
                logger.error((Object)("json format error:" + io.getMessage()));
            }
            logger.info((Object)("enableCloudClean4HW, eventId=" + eventId));
        }
        return eventId;
    }

    public void disableCloudClean4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String eventId, String alias) {
        logger.info((Object)("disableCloudClean4HW start for eventId " + eventId));
        String action = CLOUD_CLEAN_METHOD_HW_EVENT;
        if (StringUtils.isEmpty((CharSequence)eventId)) {
            logger.error((Object)"cannot disableCloudClean4HW because eventId is null");
            return;
        }
        action = action + eventId + "/";
        String result = "";
        try {
            result = this.connectRestByDel(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId), alias);
        }
        catch (LegoCheckedException e) {
            try {
                result = this.connectRestByDel(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId), alias);
            }
            catch (LegoCheckedException exception) {
                try {
                    result = this.connectRestByDel(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId), alias);
                }
                catch (LegoCheckedException exception1) {
                    logger.error((Object)("disableCloudClean4HW failed, eventId=" + eventId));
                    throw new LegoCheckedException(exception1.getErrorCode(), (Throwable)exception1);
                }
            }
        }
        if (CloudCleanUtil.validateResult(result)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.disableDefaultTyping();
            try {
                Map jsonObject = (Map)mapper.readValue(result, Map.class);
                String id = jsonObject.get("id").toString();
                String startTime = jsonObject.get("start_time").toString();
                String endTime = jsonObject.get("end_time").toString();
                logger.info((Object)("disableCloudClean4HW success, eventId=" + id + ", startTime=" + startTime + ", endTime=" + endTime));
            }
            catch (IOException io) {
                logger.error((Object)("json format error:" + io.getMessage()));
            }
            catch (Exception e) {
                logger.error((Object)("disableCloudClean4HW happens error:" + e.getMessage()));
            }
        }
    }

    public String getCloudCleanStatus4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String eventId, String alias) {
        String action = CLOUD_CLEAN_METHOD_HW_EVENT;
        String status = null;
        if (StringUtils.isEmpty((CharSequence)eventId)) {
            logger.error((Object)"getCloudCleanStatus4HW failed, eventId is null");
            return status;
        }
        action = action + eventId + "/";
        String result = "";
        try {
            result = this.connectRestByGet(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId), alias);
        }
        catch (LegoCheckedException e) {
            try {
                result = this.connectRestByGet(targetURL, action, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_EVENT, null, eventId), alias);
            }
            catch (LegoCheckedException exception) {
                throw new LegoCheckedException(exception.getErrorCode(), (Throwable)exception);
            }
        }
        if (CloudCleanUtil.validateResult(result)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.disableDefaultTyping();
            try {
                Map jsonObject = (Map)mapper.readValue(result, Map.class);
                String id = jsonObject.get("id").toString();
                String startTime = jsonObject.get("start_time").toString();
                String endTime = jsonObject.get("end_time").toString();
                status = jsonObject.get("status").toString();
                logger.info((Object)("getCloudCleanStatus4HW, eventId=" + id + ", status=" + status + ", startTime=" + startTime + ", endTime=" + endTime));
            }
            catch (IOException io) {
                logger.error((Object)("json format error:" + io.getMessage()));
            }
        }
        return status;
    }

    public Map<String, String> getAccountInfo4HW(String targetURL, StringBuffer accessKey, StringBuffer secretKey, String alias) {
        HashMap<String, String> accountInfo = null;
        String json = null;
        try {
            json = this.connectRestByGet(targetURL, CLOUD_CLEAN_METHOD_HW_ACCOUNT, CloudCleanUtil.buildAuthInfo4HW(accessKey, secretKey, CLOUD_CLEAN_METHOD_HW_ACCOUNT, null, null), alias);
        }
        catch (LegoCheckedException e) {
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        if (CloudCleanUtil.validateResult(json)) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            mapper.disableDefaultTyping();
            try {
                Map obj1 = (Map)mapper.readValue(json, Map.class);
                if (obj1.containsKey("clean_tokens")) {
                    Map obj2 = (Map)obj1.get("clean_tokens");
                    String name = obj1.containsKey("customer_name") ? obj1.get("customer_name").toString() : "";
                    String total = obj2.containsKey("total") ? obj2.get("total").toString() : "";
                    String remaining = obj2.containsKey("remaining") ? obj2.get("remaining").toString() : "";
                    accountInfo = new HashMap<String, String>();
                    accountInfo.put("name", name);
                    accountInfo.put("total", total);
                    accountInfo.put("remaining", remaining);
                    logger.info((Object)("getAccountInfo4HW, name=" + CloudCleanUtil.getcleanedMessage(name) + ", total=" + total + ", remaining=" + CloudCleanUtil.getcleanedMessage(remaining)));
                }
            }
            catch (IOException io) {
                logger.error((Object)("json format error:" + io.getMessage()));
            }
        }
        return accountInfo;
    }

    private static Map<String, String> buildAuthInfo4HW(StringBuffer accessKey, StringBuffer secretKey, String method, String json, String eventId) {
        HashMap<String, String> authInfo = new HashMap<String, String>();
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        StringBuffer signature = new StringBuffer();
        if (StringUtils.isEmpty((CharSequence)json)) {
            json = "{}";
        }
        if (StringUtils.isEmpty((CharSequence)eventId)) {
            signature.append(method).append(json);
        } else {
            signature.append(method).append(eventId).append("/").append(json);
        }
        String hmacStr = CloudCleanUtil.hmac256(signature, secretKey);
        String auth = CloudCleanUtil.getBASE64(accessKey + ":" + hmacStr);
        authInfo.put("tonce", timestamp);
        authInfo.put("auth", auth);
        return authInfo;
    }

    private String connectRestByPost(String url, String action, String json, Map<String, String> authInfo, String alias) {
        String result = null;
        InputStream in = null;
        int statusCode = -1;
        CloseableHttpClient httpClient = null;
        if (!url.startsWith("https")) {
            return null;
        }
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        try {
            HttpPost method = new HttpPost(url + action);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            method.setConfig(globalConfig);
            method.setHeader("Content-type", "application/json");
            method.setHeader("Date", authInfo.get("tonce"));
            method.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
            sslcontext.init(null, new TrustManager[]{new HttpsConnection.HttpsConnectionX509TrustManager(alias)}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(url));
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            StringEntity myEntity = new StringEntity(json, ContentType.create((String)"text/plain", (String)"UTF-8"));
            method.setEntity((HttpEntity)myEntity);
            response = httpClient.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestByPost, StatusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB, "UTF-8");
            }
            logger.info((Object)("connectRestByPost, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (SSLException e) {
            logger.error((Object)("CloudCleanUtil cloud connectRestByPost SSLException e" + e.getMessage()));
            long errorId = 0L;
            errorId = e.getMessage().contains("9600100") ? 9600100L : (e.getMessage().contains("9600200") ? 9600200L : (e.getMessage().contains("9600300") ? 9600300L : 9600400L));
            throw new LegoCheckedException(errorId);
        }
        catch (KeyManagementException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (ClientProtocolException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("LegoCheckedException error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"connectRestByPost error");
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestByPost error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"connectRestByPost close in error");
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)"response close in error");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)"httpClient close in error");
                }
            }
        }
        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_HW, statusCode, null);
        return result;
    }

    private String connectRestByGet(String url, String action, Map<String, String> authInfo, String alias) {
        String result = null;
        int statusCode = -1;
        InputStream in = null;
        CloseableHttpClient httpClient = null;
        if (!url.startsWith("https")) {
            return null;
        }
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        try {
            HttpGet method = new HttpGet(url + action);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            method.setConfig(globalConfig);
            method.setHeader("Content-type", "application/json");
            method.setHeader("Date", authInfo.get("tonce"));
            method.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
            sslcontext.init(null, new TrustManager[]{new HttpsConnection.HttpsConnectionX509TrustManager(alias)}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(url));
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            response = httpClient.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestByGet, StatusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB, "UTF-8");
            }
            logger.info((Object)("connectRestByGet, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (SSLException e) {
            logger.error((Object)("CloudCleanUtil cloud connectRestByGet SSLException e" + e.getMessage()));
            long errorId = 0L;
            errorId = e.getMessage().contains("9600100") ? 9600100L : (e.getMessage().contains("9600200") ? 9600200L : (e.getMessage().contains("9600300") ? 9600300L : 9600400L));
            throw new LegoCheckedException(errorId);
        }
        catch (ClientProtocolException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("LegoCheckedException error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"connectRestByGet error");
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (KeyManagementException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestByGet error" + CloudCleanUtil.getcleanedMessage(e.getMessage())));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"connectRestByGet close in error");
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)"response close in error");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)"httpClient close in error");
                }
            }
        }
        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_HW, statusCode, null);
        return result;
    }

    private String connectRestByDel(String url, String action, Map<String, String> authInfo, String alias) {
        String result = null;
        int statusCode = -1;
        InputStream in = null;
        CloseableHttpClient httpClient = null;
        if (!url.startsWith("https")) {
            return null;
        }
        CloseableHttpResponse response = null;
        byte[] responseContentB = null;
        try {
            HttpDelete method = new HttpDelete(url + action);
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setSocketTimeout(10000).setConnectTimeout(10000).build();
            method.setConfig(globalConfig);
            method.setHeader("Content-type", "application/json");
            method.setHeader("Date", authInfo.get("tonce"));
            method.setHeader("Authorization", "Basic " + authInfo.get("auth"));
            SSLContext sslcontext = SSLContext.getInstance("TLSv1.2");
            sslcontext.init(null, new TrustManager[]{new HttpsConnection.HttpsConnectionX509TrustManager(alias)}, new SecureRandom());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1.2"}, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"}, (HostnameVerifier)new HttpsConnection.HttpsConnectionHostnameVerifier(url));
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            response = httpClient.execute((HttpUriRequest)method);
            statusCode = response.getStatusLine().getStatusCode();
            logger.info((Object)("connectRestByDel, StatusCode = " + statusCode));
            int responseContentLen = (int)response.getEntity().getContentLength();
            if (responseContentLen > 0) {
                responseContentB = new byte[responseContentLen];
                in = response.getEntity().getContent();
                byte[] buffer = new byte[1024];
                int readLength = 0;
                int destPos = 0;
                while ((readLength = in.read(buffer)) != -1) {
                    System.arraycopy(buffer, 0, responseContentB, destPos, readLength);
                    destPos += readLength;
                }
                result = new String(responseContentB, "UTF-8");
            }
            logger.info((Object)("connectRestByDel, result = " + CloudCleanUtil.getcleanedMessage(result)));
        }
        catch (SSLException e) {
            logger.error((Object)("CloudCleanUtil cloud connectRestByDel SSLException e" + e.getMessage()));
            long errorId = 0L;
            errorId = e.getMessage().contains("9600100") ? 9600100L : (e.getMessage().contains("9600200") ? 9600200L : (e.getMessage().contains("9600300") ? 9600300L : 9600400L));
            throw new LegoCheckedException(errorId);
        }
        catch (KeyManagementException e) {
            logger.error((Object)("connectRestByDel error: " + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("connectRestByDel error: " + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("LegoCheckedException error: " + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("connectRestByDel error: " + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("connectRestByDel error" + e.getMessage()));
            throw new LegoCheckedException(571971L, (Throwable)e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"connectRestByDel close in error");
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)"response close in error");
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)"httpClient close in error");
                }
            }
        }
        CloudCleanUtil.dealStatusCode(CLOUD_CLEAN_SP_HW, statusCode, result);
        return result;
    }

    private static String hmac256(StringBuffer macData, StringBuffer macKey) {
        String result = null;
        Mac hmac = null;
        try {
            hmac = Mac.getInstance("HmacSHA256");
            byte[] secretByte = macKey.toString().getBytes("UTF-8");
            byte[] dataBytes = macData.toString().getBytes("UTF-8");
            SecretKeySpec secret = new SecretKeySpec(secretByte, "HMACSHA256");
            hmac.init(secret);
            byte[] doFinal = hmac.doFinal(dataBytes);
            byte[] hexB = new Hex().encode(doFinal);
            result = new String(hexB, "utf-8");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)("hmac256 method is error: " + e.getMessage()));
        }
        return result;
    }

    private static void dealStatusCode(String sp, int code, String result) {
        if (-1 == code) {
            throw new LegoCheckedException(571971L);
        }
        if (200 == code) {
            return;
        }
        if (CLOUD_CLEAN_SP_HW.equals(sp)) {
            if (400 == code) {
                if (null != result && CloudCleanUtil.getcleanedMessage(result).contains("has ended")) {
                    return;
                }
                throw new LegoCheckedException(571968L);
            }
            if (401 == code) {
                throw new LegoCheckedException(571951L);
            }
            if (404 == code) {
                throw new LegoCheckedException(571954L);
            }
            if (402 == code) {
                throw new LegoCheckedException(571952L);
            }
            if (403 == code) {
                throw new LegoCheckedException(571953L);
            }
            throw new LegoCheckedException(571968L);
        }
    }

    private static String getBASE64(String str) {
        if (str == null) {
            return null;
        }
        try {
            return new String(Base64.encodeBase64((byte[])str.getBytes("utf-8")), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    private static boolean validateResult(String json) {
        boolean result = false;
        if (null != json) {
            if ((json = json.trim()).contains("has ended")) {
                result = false;
            } else if (json.startsWith("{") && json.endsWith("}") && json.contains(":")) {
                result = true;
            } else {
                logger.error((Object)("validateResult, json content is illegal, json=" + CloudCleanUtil.getcleanedMessage(json)));
                throw new LegoCheckedException(571971L);
            }
        }
        return result;
    }

    private static String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }
}

