/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.action;

import com.hs.atic.util.AnonymousContentUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.FileUtils;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AESUtil;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.service.SysOptLogImpl;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import com.hs.lego.ui.plat.common.util.OperateLocker;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IRTextField;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.engine.output.ExportReport;
import com.security.ireport.model.vo.BackTask;
import com.security.ireport.model.vo.ImageObj;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.model.vo.SysOptLog;
import com.security.ireport.model.vo.TableObj;
import com.security.ireport.util.CRCCheckUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportLogManager;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import com.security.ireport.validator.ReportValidatorFactory;
import com.security.logserver.module.condition.common.BaseAction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class QueryReport
extends BaseAction {
    public static final int MAXIMUM_POOL_SIZE = 5;
    public static final int ALL_DEVICE_CORE_POOL_SIZE = 1;
    public static final int KEEP_ALIVE_TIME = 10;
    public static final String COMMA = ",";
    public static final String USERS = "users";
    public static final String DEPARTMENT = "department";
    public static final String OPERA_OBJECT = "operaObject";
    public static final String OEPRA_USER_ALL = "0";
    public static final String OEPRA_USER = "1";
    public static final String OEPRA_IP = "2";
    public static final String OEPRA_DEPARTMENT = "3";
    public static final String NETWORK = "network";
    public static final String NE_ALL = "0";
    public static final String SELECT_NE_GROUP = "1";
    public static final String SELECT_NE = "2";
    public static final String STATISTICCONTENT = "statistictcontent";
    public static final String URLTYPESWITCHOPTION = "urlTypeSwitchOption";
    public static final String SELECT_URLTYPES = "1";
    public static final String SELECT_URLSUBTYPES = "2";
    public static final String URLTYPES = "urlTypes";
    public static final String URLSUBTYPES = "urlSubTypes";
    public static final String NE_GROUP = "group";
    public static final String DEVICE_ID = "DEVICE_ID";
    public static final String SWITCH_OPTION = "switchOption";
    public static final String SWITCH_APP_TYPE = "1";
    public static final String SWITCH_APP_SUBTYPE = "2";
    public static final String SWITCH_APP = "3";
    public static final String APP = "app";
    public static final String APP_TYPE = "appType";
    public static final String APP_SUBTYPE = "appSubType";
    public static final String STARTIP = "ipMark1";
    public static final String ENDIP = "ipMark2";
    public static final String EMAIL_REGEX = "^\\w+([-\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.\\w+([-\\.]\\w+)*$";
    public static final int EMAIL_MAX_LENGTH = 64;
    private static final long serialVersionUID = 3956659634267591563L;
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 5, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(10), Executors.defaultThreadFactory(), new SpecialReportDiscardPolicy());
    private static Map<String, String> reportExportStatus = new ConcurrentHashMap<String, String>();
    private String reportId;
    private TableObj tableObj = new TableObj();
    private Long sessionId;
    private String sessionIds;
    private List<ComponentElement> elementList = new ArrayList<ComponentElement>();
    private int columnNumber = 1;
    private List<String> exportList = new ArrayList<String>();
    private String conditionStr;
    private String checkCode;
    private String exportCountAlert;
    private int maxExportCount;
    private String templateName;
    private String templateId = null;
    private boolean saveCond = false;
    private SecureRandom gORandom = new SecureRandom();
    private String theme;
    private String mainAddressees;
    private String ccAddressee;
    private String content;
    private String exportTypes;
    private String type;
    private String pageSize;
    private String pageNum;
    private String firstQuery;
    private String checkBackTaskReport;
    private String dataDrillTitle;
    private String reportSessionId;
    private String orderField;
    private String orderType;
    private String downloadFileName;
    private String fileTime;
    private InputStream inputStream;
    private String formType;
    private String requestSessionId;

    public String dataDrillWithNoSession() {
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        try {
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter pw = response.getWriter();
            HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
            Enumeration stringParams = request.getParameterNames();
            String valueStr = null;
            while (stringParams.hasMoreElements()) {
                valueStr = (String)stringParams.nextElement();
                paramMap.put(valueStr, request.getParameterValues(valueStr));
            }
            Map<String, JsonValueObj> newParaMap = JSONUtil.createParaMap(paramMap);
            ReportSession newReportSession = ReportSessionManager.getInstance().createNewSessionForDataDrill(this.reportId, request.getSession().getId(), newParaMap, LocaleUtil.getCurrentUserLocale());
            return this.commDirillReport(newReportSession, pw, request);
        }
        catch (Exception e) {
            LOGGER.error((Object)("dataDrill with no Session failed!" + e.getMessage()));
            return "error";
        }
    }

    public String dataDrillReport() {
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        if (StringUtils.isNotEmpty((CharSequence)this.dataDrillTitle) && (this.dataDrillTitle.contains("<") || this.dataDrillTitle.contains(">") || this.dataDrillTitle.contains("\"") || this.dataDrillTitle.contains("&"))) {
            throw new LegoSecurityException(206L);
        }
        try {
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter pw = response.getWriter();
            this.sessionId = Long.valueOf(this.reportSessionId);
            Map<String, JsonValueObj> newParaMap = JSONUtil.createParaMap(request.getParameterMap());
            ReportSession newReportSession = ReportSessionManager.getInstance().createSessionForDataDrill(this.reportId, this.sessionId, request.getSession().getId(), newParaMap);
            return this.commDirillReport(newReportSession, pw, request);
        }
        catch (IOException e) {
            LOGGER.error((Object)("dataDrill failed!" + e.getMessage()));
            return "error";
        }
        catch (Exception e) {
            LOGGER.error((Object)("dataDrill failed!" + e.getMessage()));
            return "error";
        }
    }

    private String commDirillReport(ReportSession newReportSession, PrintWriter pw, HttpServletRequest request) throws ProviderException {
        IReportConfigUtil.getInstance().setContextPath(request.getContextPath());
        if (null == newReportSession) {
            LOGGER.error((Object)"create reportSession failure");
            return "error";
        }
        this.sessionId = newReportSession.getSessionId();
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        Enumeration stringParams = request.getParameterNames();
        String valueStr = null;
        while (stringParams.hasMoreElements()) {
            valueStr = (String)stringParams.nextElement();
            paramMap.put(valueStr, request.getParameterValues(valueStr));
        }
        this.conditionStr = JSONUtil.mapToJson(JSONUtil.createParaMap(paramMap));
        String checkCycl = this.checkCyclomatic();
        if (!checkCycl.equals("checkOk")) {
            return checkCycl;
        }
        this.provideReportData(newReportSession, pw);
        request.setAttribute("dataDrillTitle", (Object)this.dataDrillTitle);
        if (this.exportList.isEmpty()) {
            IReport report = newReportSession.getIReport();
            this.exportList.addAll(report.getExportList());
            request.setAttribute("refresh", (Object)report.getRefresh());
        }
        if (1 == newReportSession.getIReport().getIRTableList(newReportSession.getSwitchOption()).size()) {
            this.queryTable(newReportSession, request);
            return "reportViewSp";
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importTurnBackTaskPage() throws ParaException {
        this.validateImportTurnBackTaskPage();
        Map<String, JsonValueObj> reportCond = null;
        boolean createReportSessionSuccess = true;
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        Locale locale = LocaleUtil.getCurrentUserLocale();
        ReportSession reportSession = ReportSessionManager.getInstance().createReportSession(this.reportId, request.getSession().getId(), locale);
        if (null == reportSession) {
            createReportSessionSuccess = false;
            LOGGER.error((Object)"create reportSession failure");
        } else {
            this.sessionId = reportSession.getSessionId();
        }
        PrintWriter writer = null;
        HttpServletResponse response = ServletActionContext.getResponse();
        try {
            reportCond = JSONUtil.transformKeyValueObjMap(this.conditionStr);
            writer = response.getWriter();
            if (null != reportSession) {
                boolean result = reportSession.splitTask(reportCond);
                if (createReportSessionSuccess && result) {
                    writer.write(this.sessionId.toString() + COMMA + this.getShowQueryReportType());
                } else {
                    writer.write("error");
                }
            } else {
                writer.write("error");
            }
            writer.flush();
        }
        catch (ParaException e) {
            LOGGER.error((Object)("conditionStr value is invalid , and redirect to attack process. conditionStr: " + this.conditionStr + ". " + e.getMessage()));
            this.secoOptWithAttack();
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public synchronized void changeToBackTask() {
        block6: {
            String operationObj = "";
            try {
                ActionContext ctx = ActionContext.getContext();
                HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                ReportSession reportSession = ReportSessionManager.getInstance().getSessionBySessionId(this.sessionId, request.getSession().getId());
                IReport mReport = PluginManager.getInstance().getReportPlugin(reportSession.getIReport().getId());
                String reportName = "";
                if (null != mReport) {
                    reportName = mReport.getName();
                }
                BackTask backTask = new BackTask();
                backTask.setCreateDate(new Date().getTime());
                backTask.setSessionId(this.sessionId);
                backTask.setReportId(reportSession.getIReport().getId());
                backTask.setReportName(reportName);
                backTask.setReportCondition(this.conditionStr);
                if (reportSession.isPrepare()) {
                    backTask.setState(1);
                    backTask.setEndDate(new Date().getTime());
                } else {
                    backTask.setState(0);
                }
                long backTaskId = 0L;
                Date startDate = new Date(backTask.getCreateDate());
                SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String startDateStr = smpDateFormat.format(startDate);
                operationObj = "reportName:" + backTask.getReportName() + " createTime:" + startDateStr;
                backTaskId = ProductFaceUtil.getInstance().addBackTask(backTask, this.sessionId);
                reportSession.setBackTaskId(backTaskId);
                String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
                if (!productName.equalsIgnoreCase("SIG V2")) {
                    IReportLogManager.getInstance().printSysLog(new SysOptLog(LocaleUtil.getProperty("backTask.manager"), LocaleUtil.getProperty("backTask.log.add"), operationObj + " ", LocaleUtil.getProperty("backTask.log.add") + " " + LocaleUtil.getProperty("backTask.log.success") + " " + operationObj));
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("failed to BackTask! " + e.getMessage()));
                String productName = IReportConfigUtil.getInstance().getConfig("report.productName");
                if (productName.equalsIgnoreCase("SIG V2")) break block6;
                IReportLogManager.getInstance().printSysLog(new SysOptLog(LocaleUtil.getProperty("backTask.manager"), LocaleUtil.getProperty("backTask.log.add"), operationObj + "", 1, LocaleUtil.getProperty("backTask.log.add") + " " + LocaleUtil.getProperty("backTask.log.failed") + e.getMessage()));
            }
        }
    }

    public String queryReport() throws ProviderException {
        LOGGER.info((Object)"start queryReport");
        String checkCycl = this.checkCyclomatic();
        if (!checkCycl.equals("checkOk")) {
            LOGGER.error((Object)("checkCycl=" + checkCycl));
            return checkCycl;
        }
        HttpServletRequest request = this.fetchRequest();
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/html; charset=UTF-8");
        try {
            boolean checkReport;
            IReportConfigUtil.getInstance().setContextPath(request.getContextPath());
            ReportSession reportSession = null;
            String result = "success";
            boolean isFirstQuery = false;
            if ("true".equals(this.firstQuery)) {
                isFirstQuery = true;
            }
            LOGGER.info((Object)"get reportSession");
            reportSession = this.getReportSession(request.getSession().getId(), this.sessionId, this.checkBackTaskReport);
            if (null == reportSession) {
                LOGGER.error((Object)"create reportSession failure");
                return "error";
            }
            LOGGER.info((Object)"get reportSession sucess");
            reportSession.setJsonValueStr(this.conditionStr);
            boolean bl = checkReport = "true".equals(this.checkBackTaskReport) && "true".equals(this.firstQuery);
            if (checkReport) {
                reportSession.setBackTaskId(0L);
            }
            this.sessionId = reportSession.getSessionId();
            LOGGER.info((Object)"queryReport() get reportSession success");
            this.handleFirstQuery(isFirstQuery, reportSession, request, this.checkBackTaskReport);
            LOGGER.info((Object)"after handleFirstQuery");
            if (reportSession.getBackTaskId() > 0L) {
                ProductFaceUtil.getInstance().setBaskTaskIsPrepare(reportSession.getBackTaskId());
                LOGGER.error((Object)"reportSession.getBackTaskId() > 0 return null");
                return null;
            }
            result = this.drowReport(reportSession, response, request);
            LOGGER.info((Object)("return result=" + result));
            return result;
        }
        catch (ParaException e) {
            LOGGER.error((Object)("conditionStr value is invalid , and redirect to attack process. conditionStr: " + this.conditionStr + ". " + e.getMessage()));
            this.secoOptWithAttack();
            return "error";
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to queryReport. " + e.getMessage()));
            if (ProductFaceUtil.getInstance().isBusinessException(e)) {
                ProductFaceUtil.getInstance().throwProductException(e.getMessage(), "INFO", e);
            }
            return "error";
        }
    }

    private String checkCyclomatic() {
        boolean isValidateQueryReport = this.validateQueryReport();
        if (!isValidateQueryReport) {
            LOGGER.error((Object)"old validate query report param error");
            return "validateError";
        }
        if (null == this.reportId) {
            boolean checkPage;
            boolean bl = checkPage = null == this.pageSize || null == this.pageNum;
            if (checkPage) {
                return "validateError";
            }
            this.pageSize = Normalizer.normalize(this.pageSize, Normalizer.Form.NFKC);
            this.pageNum = Normalizer.normalize(this.pageNum, Normalizer.Form.NFKC);
            boolean bl2 = checkPage = !this.pageSize.matches("\\d+") || !this.pageNum.matches("\\d+");
            if (checkPage) {
                return "validateError";
            }
        } else {
            boolean isValidate = ReportValidatorFactory.getInstance().validate(this.reportId, this.conditionStr);
            if (!isValidate) {
                LOGGER.error((Object)"new validate query report param error");
                return "validateError";
            }
        }
        return "checkOk";
    }

    private Map<String, JsonValueObj> handleFirstQuery(boolean isFirstQuery, ReportSession reportSession, HttpServletRequest request, String checkBackTaskReportM) throws ParaException {
        Map<String, JsonValueObj> reportCond = null;
        if (isFirstQuery) {
            if (!reportSession.getParameterMap().isEmpty()) {
                reportCond = reportSession.getParameterMap();
            } else if (!IReportConfCheckUtil.isStringEmpty(this.conditionStr)) {
                reportCond = JSONUtil.transformKeyValueObjMap(this.conditionStr);
            } else {
                reportCond = this.getProductCond(request);
                reportSession.splitTask(reportCond);
            }
            if (TimeZone.getDefault().useDaylightTime() && reportCond != null && reportCond.get("dateRange") != null) {
                JsonValueObj valueObj = reportCond.get("dateRange");
                List<JsonValueItem> valueList = valueObj.getValueList();
                for (JsonValueItem jsonValueItem : valueList) {
                    String valueH = jsonValueItem.getValue();
                    if (!valueH.matches("\\d+")) continue;
                    Date baseTime = new Date(Long.parseLong(valueH) * 1000L);
                    Calendar base = Calendar.getInstance();
                    base.setTime(baseTime);
                    Calendar pre = Calendar.getInstance();
                    Calendar after = Calendar.getInstance();
                    pre.setTime(baseTime);
                    after.setTime(baseTime);
                    pre.add(11, -1);
                    after.add(11, 1);
                    if (pre.get(11) == base.get(11)) {
                        LOGGER.info((Object)("transform1 DST:" + baseTime + " to " + pre.getTime()));
                        jsonValueItem.setValue(String.valueOf(pre.getTime().getTime() / 1000L));
                    }
                    if (after.get(11) != base.get(11)) continue;
                    LOGGER.info((Object)("transform2 DST:" + baseTime + " to " + after.getTime()));
                    jsonValueItem.setValue(String.valueOf(baseTime.getTime() / 1000L));
                }
            }
            if (this.templateId != null) {
                reportSession.splitTask(reportCond);
            }
            if (!"SIG V2".equalsIgnoreCase(IReportConfigUtil.getInstance().getProductName()) && "true".equals(checkBackTaskReportM)) {
                reportSession.splitTask(reportCond);
            }
            try {
                reportSession.prepare(reportCond, false);
            }
            catch (NumberFormatException e) {
                User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
                if (user == null) {
                    throw new LegoSecurityException(206L);
                }
                LOGGER.error((Object)"conditionStr value is invalid, make NumberFormatException!");
                this.getSysOptLog().setOperation("lego.err.error");
                this.getSysOptLog().setModule("lego.dic.module.user");
                this.getSysOptLog().setLevel(SysoplogLevel.warning.getValue());
                this.getSysOptLog().setOperator(user.getUserName().trim());
                this.getSysOptLog().setTargetLocal(Boolean.valueOf(true));
                this.getSysOptLog().setTarget("lego.dic.module.user");
                this.getSysOptLog().setTerminalIp(((User)this.fetchRequest().getSession().getAttribute("currentUser")).getIpAdr());
                this.getSysOptLog().setResult(0);
                this.getSysOptLog().setDetail("lego.err.dataerror");
                ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
                sysOptLog.writeOptLog(this.getSysOptLog());
                this.fetchRequest().getSession().invalidate();
                this.getSysOptLog().setLevel(SysoplogLevel.info.getValue());
                this.getSysOptLog().setResult(1);
                this.getSysOptLog().setModule("lego.dic.module.user");
                this.getSysOptLog().setOperation("lego.lab.com.loginout");
                this.getSysOptLog().setOperator(user.getUserName());
                this.getSysOptLog().setTerminalIp(user.getIpAdr());
                this.getSysOptLog().setTargetLocal(Boolean.valueOf(true));
                this.getSysOptLog().setTarget(user.getUserName());
                this.getSysOptLog().setDetail("lego.err.dataerror");
                sysOptLog.writeOptLog(this.getSysOptLog());
                throw new LegoSecurityException(206L, "conditionStr");
            }
        }
        return reportCond;
    }

    private String drowReport(ReportSession reportSession, HttpServletResponse response, HttpServletRequest request) {
        String result = null;
        result = this.drawReport(reportSession, response, request);
        return result;
    }

    private String drawReport(ReportSession reportSession, HttpServletResponse response, HttpServletRequest request) {
        String result = "success";
        try {
            if (reportSession.isPrepare() && reportSession.getBackTaskId() <= 0L) {
                this.provideReportData(reportSession, response.getWriter());
                if (this.exportList.isEmpty()) {
                    IReport report = reportSession.getIReport();
                    if (null != this.reportId && "appFlow".equalsIgnoreCase(this.reportId)) {
                        Map<String, JsonValueObj> reportCond = null;
                        if (!reportSession.getParameterMap().isEmpty()) {
                            reportCond = reportSession.getParameterMap();
                        } else if (!IReportConfCheckUtil.isStringEmpty(this.conditionStr)) {
                            reportCond = JSONUtil.transformKeyValueObjMap(this.conditionStr);
                        } else {
                            reportCond = this.getProductCond(request);
                            reportSession.splitTask(reportCond);
                        }
                        JsonValueObj valueObj = reportCond.get("reportType");
                        String reportType = valueObj.getValueList().get(0).getValue();
                        if ("appFlow".equalsIgnoreCase(this.reportId) && "1".equals(reportType)) {
                            report.getExportList().remove(report.getExportList().indexOf("csv"));
                        } else {
                            report.getExportList().add("csv");
                        }
                    }
                    this.exportList.addAll(report.getExportList());
                    request.setAttribute("refresh", (Object)report.getRefresh());
                }
                if (1 == reportSession.getIReport().getIRTableList(reportSession.getSwitchOption()).size()) {
                    this.queryTable(reportSession, request);
                    result = "reportViewSp";
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("failed to drawReport! " + e.getMessage()));
            if (ProductFaceUtil.getInstance().isBusinessException(e)) {
                ProductFaceUtil.getInstance().throwProductException(e.getMessage(), "INFO", e);
            }
            return "error";
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to drawReport! " + e.getMessage()));
            if (ProductFaceUtil.getInstance().isBusinessException(e)) {
                ProductFaceUtil.getInstance().throwProductException(e.getMessage(), "INFO", e);
            }
            return "error";
        }
        return result;
    }

    public void isPrepare() {
        ReportSession reportSession = null;
        try {
            ActionContext ctx = ActionContext.getContext();
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            reportSession = this.getReportSession(request.getSession().getId(), this.sessionId, "true");
            if (null == reportSession) {
                LOGGER.error((Object)"create reportSession failure");
            } else if (reportSession.isPrepare()) {
                response.getWriter().write("success");
            } else {
                response.getWriter().write("fail");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to prePare! " + e.getMessage()));
        }
    }

    private Map<String, JsonValueObj> getProductCond(HttpServletRequest request) {
        HashMap<String, JsonValueObj> reportCond = null;
        Object obj = request.getAttribute("CUSTOM_CONDITION");
        reportCond = obj != null ? (HashMap<String, JsonValueObj>)obj : new HashMap<String, JsonValueObj>();
        return reportCond;
    }

    private ReportSession getReportSession(String httpSessionId, Long reportSessionIdI, String checkBackTaskReportM) {
        ReportSession reportSession = null;
        Locale locale = LocaleUtil.getCurrentUserLocale();
        if ("true".equals(checkBackTaskReportM)) {
            reportSession = !ReportSessionManager.getInstance().hasReportSession(reportSessionIdI, httpSessionId) ? ReportSessionManager.getInstance().createSessionForBackTask(this.reportId, reportSessionIdI, httpSessionId, locale) : ReportSessionManager.getInstance().getSessionBySessionId(reportSessionIdI, httpSessionId);
        } else if (null != reportSessionIdI) {
            reportSession = ReportSessionManager.getInstance().getSessionBySessionId(reportSessionIdI, httpSessionId);
            if (null == reportSession) {
                LOGGER.error((Object)"getReportSession === reportSession is null.Failed to get reportSession by id.");
                this.secoOptWithAttack();
            } else {
                this.reportId = reportSession.getIReport().getId();
                LOGGER.info((Object)("--------------reportId: " + this.reportId));
            }
        } else {
            reportSession = ReportSessionManager.getInstance().createReportSession(this.reportId, httpSessionId, locale);
        }
        return reportSession;
    }

    public void exportReport() {
        String reportFileName = null;
        try {
            ActionContext ctx = ActionContext.getContext();
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            byte[] bytes = new byte[16];
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(bytes);
            String requestSessionId = AESUtil.parseByte2HexStr((byte[])bytes);
            QueryReport.setReportExportStatus(requestSessionId, "");
            ReportSession reportSession = this.getReportSession(request.getSession().getId(), this.sessionId, "false");
            if (null == reportSession) {
                throw new LegoCheckedException(570507L);
            }
            reportSession.prepareJasper();
            ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
            reportSessionList.add(reportSession);
            String tmpTime = new SimpleDateFormat("yyyyMMdd_HH_mm_ss").format(new Date());
            String downloadFilePath = ServletActionContext.getServletContext().getRealPath("/") + "temp" + File.separator + tmpTime;
            IReport report = ((ReportSession)reportSessionList.get(0)).getIReport();
            reportFileName = IReportUtil.getProperty(report.getIRDefine().getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale());
            HttpSession session = request.getSession();
            String contextPath = request.getContextPath();
            String remoteAddr = request.getRemoteAddr();
            if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.EXPORT_REPORT)) {
                throw new LegoCheckedException(570516L);
            }
            SubRunnable runnable = new SubRunnable(this, ctx, reportSessionList, request, session, this.type, reportFileName, requestSessionId, downloadFilePath, contextPath, remoteAddr);
            executor.allowCoreThreadTimeOut(true);
            executor.execute(runnable);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("formType", this.type);
            resultMap.put("reportFileName", reportFileName);
            resultMap.put("fileTime", tmpTime);
            resultMap.put("requestSessionId", requestSessionId);
            LOGGER.info((Object)"end QueryReport exportReport function");
            this.responseResultObj(resultMap);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("LegoCheckedException exportReport " + e.getMessage()));
            QueryReport.recordSysOptLog((User)this.fetchRequest().getSession().getAttribute("currentUser"), reportFileName, "atic.analysis", this.formType, true, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
            throw new LegoCheckedException(e.getErrorCode());
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("RuntimeException exportReport " + e.getMessage()));
            QueryReport.recordSysOptLog((User)this.fetchRequest().getSession().getAttribute("currentUser"), reportFileName, "atic.analysis", this.formType, true, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
            throw new LegoCheckedException(102L);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception exportReport " + e.getMessage()));
            QueryReport.recordSysOptLog((User)this.fetchRequest().getSession().getAttribute("currentUser"), reportFileName, "atic.analysis", this.formType, true, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
            throw new LegoCheckedException(102L);
        }
    }

    public void ajaxReportExportStatus() {
        if (!AticUtil.isNull((String)QueryReport.getReportExportStatus(this.requestSessionId))) {
            this.responseResult(QueryReport.getReportExportStatus(this.requestSessionId));
            QueryReport.removeReportExportStatus(this.requestSessionId);
        }
    }

    public static String getReportExportStatus(String httpSessionId) {
        return reportExportStatus.get(httpSessionId);
    }

    public static String removeReportExportStatus(String httpSessionId) {
        return reportExportStatus.remove(httpSessionId);
    }

    public static void setReportExportStatus(String httpSessionId, String reportExportStatusStr) {
        reportExportStatus.put(httpSessionId, reportExportStatusStr);
    }

    public String downloadFile() {
        String suffix = this.getExportSuffix(this.formType);
        if ("csv".equalsIgnoreCase(this.formType) && suffix.equalsIgnoreCase(".zip")) {
            suffix = "_csv" + suffix;
        }
        String downloadFileDirPath = ServletActionContext.getServletContext().getRealPath("/") + "temp" + File.separator + this.fileTime;
        String downloadFilePath = downloadFileDirPath + File.separator + this.downloadFileName + "(" + this.fileTime + ")" + suffix;
        String optTarget = this.downloadFileName;
        File f = new File(downloadFilePath);
        if (!f.exists()) {
            LOGGER.error((Object)"file is not exist.");
            QueryReport.recordSysOptLog((User)this.fetchRequest().getSession().getAttribute("currentUser"), optTarget, "atic.analysis", this.formType, false, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
            return "error";
        }
        try {
            byte[] filebytes = FileUtils.copyFileDeleteSrc((String)downloadFilePath);
            this.downloadFileName = new String((optTarget + "(" + this.fileTime + ")" + suffix).getBytes("gbk"), "ISO8859-1");
            this.inputStream = new ByteArrayInputStream(filebytes);
            return "success";
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"file is not found error.");
            QueryReport.recordSysOptLog((User)this.fetchRequest().getSession().getAttribute("currentUser"), optTarget, "atic.analysis", this.formType, false, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
            return "error";
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"UnsupportedEncodingException error.");
            QueryReport.recordSysOptLog((User)this.fetchRequest().getSession().getAttribute("currentUser"), optTarget, "atic.analysis", this.formType, false, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
            return "error";
        }
        catch (IOException e) {
            LOGGER.error((Object)("downloadFile copyFileDeleteSrc error" + e.getMessage()));
            QueryReport.recordSysOptLog((User)this.fetchRequest().getSession().getAttribute("currentUser"), optTarget, "atic.analysis", this.formType, false, false, SysoplogLevel.normal, "export.report.fail", new String[0]);
            return "error";
        }
    }

    private static void recordSysOptLog(User currentUser, String operation, String module, String target, boolean targetLocal, boolean isSuccess, SysoplogLevel sysoplogLevel, String detail, String[] detailPara) {
        com.hs.lego.core.system.syslog.sdk.model.SysOptLog sLog = new com.hs.lego.core.system.syslog.sdk.model.SysOptLog();
        ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", SysOptLogImpl.class);
        sLog.setDate(new Date());
        sLog.setTarget(target);
        sLog.setModule(module);
        sLog.setOperation(operation);
        sLog.setDetail(detail);
        sLog.setOperator(currentUser.getUserName());
        sLog.setTerminalIp(currentUser.getIpAdr());
        sLog.setTargetLocal(Boolean.valueOf(targetLocal));
        sLog.setLevel(sysoplogLevel.getValue());
        if (isSuccess) {
            sLog.setResult(1);
        } else {
            sLog.setResult(0);
        }
        sysOpLog.writeOptLog(sLog);
    }

    private String getExportSuffix(String fileType) {
        if ("pdf".equals(fileType) || "print".equals(fileType)) {
            return ".pdf";
        }
        if ("3".equals(fileType)) {
            return ".rtf";
        }
        if ("rtf".equals(fileType)) {
            return ".rtf";
        }
        if ("word".equals(fileType)) {
            return ".doc";
        }
        if ("excel".equals(fileType)) {
            return ".xls";
        }
        if ("html".equals(fileType)) {
            return ".zip";
        }
        if ("csv".equals(fileType)) {
            return ".zip";
        }
        if ("4".equals(fileType)) {
            return ".zip";
        }
        return fileType;
    }

    public String sendMailPage() {
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        request.setAttribute("sessionId", (Object)this.sessionId);
        request.setAttribute("type", (Object)this.type);
        ReportSession reportSession = this.getReportSession(request.getSession().getId(), this.sessionId, "false");
        if (null == reportSession) {
            return "";
        }
        List<String> exeportList = reportSession.getIReport().getExportList();
        request.setAttribute("exeportList", exeportList);
        String themeLocal = this.getChangeFileName(reportSession);
        request.setAttribute("mailTheme", (Object)themeLocal);
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAndSendEmail() {
        SysOptLog sog;
        String userName;
        if (!OperateLocker.getInstance().addOneExecutingOperate(OperateLockEnum.exportAndSendEmail)) {
            throw new LegoCheckedException(570516L);
        }
        try {
            ActionContext ctx = ActionContext.getContext();
            HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            HttpServletResponse response = (HttpServletResponse)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            response.setCharacterEncoding("UTF-8");
            ReportSession reportSession = this.getReportSession(request.getSession().getId(), this.sessionId, "false");
            if (null == reportSession) {
                return;
            }
            reportSession.prepareJasper();
            ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
            reportSessionList.add(reportSession);
            String[] totalAddressees = null;
            totalAddressees = null != this.ccAddressee && this.ccAddressee.length() > 0 ? new String[]{this.mainAddressees, this.ccAddressee} : new String[]{this.mainAddressees};
            ExportReport exportReport = new ExportReport(reportSessionList, request, response);
            if (null != this.exportTypes && this.exportTypes.length() > 0) {
                boolean mkdirs;
                String[] exportTypeArray = this.exportTypes.split(COMMA);
                String fileName = this.getChangeFileName(reportSession);
                String randomPath = IReportUtil.getIReportTempImagePath() + File.separator + this.gORandom.nextDouble() + File.separator;
                String realPath = randomPath + File.separator + fileName + File.separator;
                File realPathFile = new File(realPath);
                if (!realPathFile.exists() && !(mkdirs = realPathFile.mkdirs())) {
                    LOGGER.error((Object)("mkdirs:" + mkdirs));
                }
                String result = "";
                int num = exportTypeArray.length;
                for (int index = 0; index < num; ++index) {
                    result = exportReport.timeExport(exportTypeArray[index], realPath, fileName + this.getSuffixName(exportTypeArray[index]));
                    if (null == result) continue;
                    response.getWriter().write(result);
                    LOGGER.error((Object)("export failed , the failed message is:" + result));
                    this.processSendEmailLog(result, totalAddressees);
                    return;
                }
                IReportMgrUtil.exportToZipFile(randomPath, fileName, null);
                String sendReturnMessage = ProductFaceUtil.getInstance().notifySendEmail(totalAddressees, this.theme, this.content, randomPath + File.separator + fileName + ".zip");
                if (null == sendReturnMessage || "".equals(sendReturnMessage) || "success".equals(sendReturnMessage)) {
                    this.processSendEmailLog("success", totalAddressees);
                    response.getWriter().write("success");
                } else {
                    this.processSendEmailLog(result, totalAddressees);
                    response.getWriter().write(sendReturnMessage);
                }
            }
        }
        catch (IOException e) {
            userName = ProductFaceUtil.getInstance().getUserName();
            sog = new SysOptLog("report.manager", "report.commom.sysLog", this.mainAddressees, 1, "lego.err.570507", userName, SysoplogLevel.normal.getValue());
            IReportLogManager.getInstance().printSysLog(sog);
            LOGGER.error((Object)"export and send Email failed!");
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"export and send Email failed! LegoCheckedException");
            userName = ProductFaceUtil.getInstance().getUserName();
            sog = new SysOptLog("report.manager", "report.commom.sysLog", this.mainAddressees, 1, "lego.err." + e.getErrorCode(), userName, SysoplogLevel.normal.getValue());
            IReportLogManager.getInstance().printSysLog(sog);
        }
        catch (RuntimeException e) {
            userName = ProductFaceUtil.getInstance().getUserName();
            sog = new SysOptLog("report.manager", "report.commom.sysLog", this.mainAddressees, 1, "lego.err.570507", userName, SysoplogLevel.normal.getValue());
            IReportLogManager.getInstance().printSysLog(sog);
            LOGGER.error((Object)"export and send Email failed!");
        }
        catch (Exception e) {
            LOGGER.error((Object)"export and send Email failed! Exception");
            userName = ProductFaceUtil.getInstance().getUserName();
            sog = new SysOptLog("report.manager", "report.commom.sysLog", this.mainAddressees, 1, "lego.err.570507", userName, SysoplogLevel.normal.getValue());
            IReportLogManager.getInstance().printSysLog(sog);
        }
        finally {
            OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.exportAndSendEmail);
        }
    }

    private void processSendEmailLog(String returnStr, String[] emailAddress) {
        for (int i = 0; i < emailAddress.length; ++i) {
            StringBuffer mainEmailsAddress = new StringBuffer();
            String emailAddresses = emailAddress[i];
            if (AticUtil.isNull((String)emailAddresses)) continue;
            String[] emails = emailAddresses.split(";");
            for (int j = 0; j < emails.length; ++j) {
                String address = emails[j];
                mainEmailsAddress.append(AnonymousContentUtil.getAnonymousMailContent((String)address)).append(';');
            }
            emailAddress[i] = mainEmailsAddress.substring(0, mainEmailsAddress.lastIndexOf(";"));
        }
        String userName = ProductFaceUtil.getInstance().getUserName();
        SysOptLog sysOptLog = new SysOptLog("report.manager", "report.commom.sysLog", emailAddress[0], 1, "report.commom.sysLog.failure", userName, SysoplogLevel.normal.getValue());
        sysOptLog.setDetailPara(emailAddress);
        if ("success".equals(returnStr)) {
            sysOptLog.setDetail("report.commom.sysLog.success");
            sysOptLog.setResult(0);
        } else {
            sysOptLog.setDetail("report.commom.sysLog.failure");
            sysOptLog.setResult(1);
        }
        sysOptLog.setTarget(emailAddress[0]);
        IReportLogManager.getInstance().printSysLog(sysOptLog);
    }

    private String getChangeFileName(ReportSession reportSession) {
        IReport report = reportSession.getIReport();
        String fileName = IReportUtil.getProperty(report.getIRDefine().getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale());
        String tmpTime = new SimpleDateFormat("yyyyMMdd_HH_mm_ss").format(new Date());
        fileName = fileName + "(" + tmpTime + ")";
        fileName = fileName.replaceAll("[/\\:\\-~`*?\"<>|]", "_");
        fileName = IReportMgrUtil.replaceAllBlank(fileName);
        return fileName;
    }

    private String getSuffixName(String fileType) {
        String suffixName = "";
        suffixName = "pdf".equalsIgnoreCase(fileType) ? ".pdf" : ("excel".equalsIgnoreCase(fileType) ? ".xls" : ("html".equalsIgnoreCase(fileType) ? ".zip" : ("csv".equalsIgnoreCase(fileType) ? ".csv" : ("rtf".equalsIgnoreCase(fileType) ? ".rtf" : ""))));
        return suffixName;
    }

    private void provideReportData(ReportSession reportSession, PrintWriter pw) throws ProviderException {
        IReport report = reportSession.getIReport();
        this.columnNumber = report.getIRDefine().getColumnNumber();
        int row = 0;
        int column = 0;
        Map<String, String[]> imagePaths = reportSession.getAllChartsImgPath(pw);
        for (ComponentElement componentElement : report.getElementList()) {
            if (componentElement.getColspan() > this.columnNumber) {
                componentElement.setColspan(this.columnNumber);
            }
            if (this.columnNumber < column + componentElement.getColspan()) {
                if (this.columnNumber > column) {
                    ComponentElement empty = new ComponentElement();
                    empty.setRow(row);
                    empty.setColumn(column);
                    empty.setColspan(this.columnNumber - column);
                    this.elementList.add(empty);
                }
                ++row;
                column = 0;
            }
            if (componentElement instanceof IRChart) {
                IRChart iChart = (IRChart)componentElement;
                ImageObj imageObj = new ImageObj();
                imageObj.setShowLegend(iChart.isLegend());
                imageObj.setImagePath(imagePaths.get(iChart.getId()));
                imageObj.setLegendList(reportSession.getImgLegendMap(iChart.getId()));
                imageObj.setRow(row);
                imageObj.setColumn(column);
                imageObj.setNum(iChart.getNum());
                imageObj.setColspan(iChart.getColspan());
                this.elementList.add(imageObj);
            }
            if (componentElement instanceof IRTable) {
                IRTable iTable = (IRTable)componentElement;
                iTable.setRow(row);
                iTable.setColumn(column);
                iTable.setTitle(IReportUtil.getProperty(iTable.getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale()));
                this.elementList.add(iTable);
            }
            if (componentElement instanceof IRTextField) {
                IRTextField temp = (IRTextField)componentElement;
                temp.setRow(row);
                temp.setColumn(column);
                this.elementList.add(temp);
            }
            column += componentElement.getColspan().intValue();
        }
        if (this.elementList.isEmpty() && column < this.columnNumber) {
            ComponentElement empty = new ComponentElement();
            empty.setRow(row);
            empty.setColumn(column);
            empty.setColspan(this.columnNumber - column);
            this.elementList.add(empty);
        }
    }

    public void queryTable(ReportSession reportSession, HttpServletRequest request) {
        IRTable iRTable = reportSession.getIReport().getIRTableList(reportSession.getSwitchOption()).get(0);
        int pageNumM = 1;
        if (this.pageNum != null) {
            pageNumM = Integer.parseInt(this.pageNum);
        }
        int pageSizeM = 0;
        if (this.pageSize != null) {
            pageSizeM = Integer.parseInt(this.pageSize);
        }
        OrderInfo orderInfo = null;
        if (this.orderField != null && !this.orderField.isEmpty() && !this.orderField.equals("null")) {
            orderInfo = new OrderInfo();
            orderInfo.setOrderField(this.orderField);
            orderInfo.setOrderType(this.orderType);
        }
        reportSession.getOrderInfoMap().put(iRTable.getId(), orderInfo);
        this.tableObj = reportSession.getTableData(iRTable, pageNumM, pageSizeM, orderInfo, false);
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public List<String> getExportList() {
        return this.exportList;
    }

    public void setExportList(List<String> exportList) {
        this.exportList = exportList;
    }

    public int getMaxExportCount() {
        IReportConfigUtil reportCfg = IReportConfigUtil.getInstance();
        String maxExportStr = reportCfg.getConfig("maxExportCount");
        this.maxExportCount = null != maxExportStr && !maxExportStr.isEmpty() ? Integer.parseInt(maxExportStr) : 2000;
        return this.maxExportCount;
    }

    public void setMaxExportCount(int maxExportCount) {
        this.maxExportCount = maxExportCount;
    }

    public String getExportCountAlert() {
        if (null == this.exportCountAlert || this.exportCountAlert.isEmpty()) {
            String maxReportAlert = LocaleUtil.getLocaleText("export.confirm.datacountExceed");
            this.exportCountAlert = MessageFormat.format(maxReportAlert, this.getMaxExportCount());
        }
        return this.exportCountAlert;
    }

    public void setExportCountAlert(String exportCountAlert) {
        this.exportCountAlert = exportCountAlert;
    }

    public String getConditionStr() {
        return this.conditionStr;
    }

    public void setConditionStr(String conditionStr) {
        this.conditionStr = conditionStr;
    }

    public List<ComponentElement> getElementList() {
        return this.elementList;
    }

    public void setElementList(List<ComponentElement> elementList) {
        this.elementList = elementList;
    }

    public TableObj getTableObj() {
        return this.tableObj;
    }

    public void setTableObj(TableObj tableObj) {
        this.tableObj = tableObj;
    }

    public String getSessionIds() {
        return this.sessionIds;
    }

    public void setSessionIds(String sessionIds) {
        this.sessionIds = sessionIds;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public String getShowQueryReportType() {
        String showQueryReport = IReportConfigUtil.getInstance().getConfig("showQueryReportType");
        return IReportUtil.parseShowQueryReportType(showQueryReport);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public boolean isSaveCond() {
        return this.saveCond;
    }

    public void setSaveCond(boolean saveCond) {
        this.saveCond = saveCond;
    }

    public boolean validateExportType() {
        String suffixName = this.getSuffixName(this.type);
        return !"".equals(suffixName);
    }

    public boolean validateType() {
        String regex = "^(print|email)$";
        return this.type.matches(regex);
    }

    private boolean validateImportTurnBackTaskPage() {
        boolean jsonValidFlag;
        IReport report = PluginManager.getInstance().getReportPlugin(this.reportId);
        if (null == report) {
            LOGGER.error((Object)"validateImportTurnBackTaskPage.Report is null.Failed to get report by id.");
            this.secoOptWithAttack();
        }
        if (!(jsonValidFlag = JSONUtil.isValidJsonStr(this.conditionStr))) {
            LOGGER.error((Object)("conditionStr is invalid jsonstr, and redirect to attack process. conditionStr: " + this.conditionStr));
            this.secoOptWithAttack();
        }
        return true;
    }

    private boolean validateQueryReport() {
        boolean jsonValidFlag;
        ReportSession reportSession = ReportSessionManager.getInstance().getSessionBySessionId(this.sessionId, this.fetchRequest().getSession().getId());
        if (null == reportSession) {
            LOGGER.error((Object)"validateQueryReport.ReportSession is null.Failed to get reportSession.");
            this.secoOptWithAttack();
        } else if (this.reportId == null) {
            if (this.pageSize == null) {
                return false;
            }
            if (this.pageNum == null) {
                return false;
            }
            this.pageSize = Normalizer.normalize(this.pageSize, Normalizer.Form.NFKC);
            this.pageNum = Normalizer.normalize(this.pageNum, Normalizer.Form.NFKC);
            return this.pageSize.matches("\\d+") && this.pageNum.matches("\\d+");
        }
        IReport report = PluginManager.getInstance().getReportPlugin(this.reportId);
        if (null == report) {
            LOGGER.error((Object)"validateQueryReport.Report is null.Failed to get report by id......");
            this.secoOptWithAttack();
        }
        if (!(jsonValidFlag = JSONUtil.isValidJsonStr(this.conditionStr))) {
            LOGGER.error((Object)("conditionStr is invalid jsonstr, and redirect to attack process. conditionStr: " + this.conditionStr));
            this.secoOptWithAttack();
        }
        return true;
    }

    public boolean validateEmailThem() {
        String regex = "(?im-)^(?!null$)[\\u4e00-\\u9fa5|\\\u3002|\\\uff0c|\\\uff1a|\\\uff1b|\\\uff01|\\\uff1f|\\\u3001|\\\u300a|\\\u300b|\\\u201c|\\\u201d|\\\u2018|\\\u2019|\\\uffe5|\\\uff08|\\\uff09|\\\u3010|\\\u3011|\\\u2026|\\ |\\w|\\!|\\:|\\;|\\?|\\.|\\,|\\(|\\)]*$";
        if (null == this.theme || "".equals(this.theme.trim())) {
            return true;
        }
        return this.theme.matches(regex);
    }

    public static String getConditionsById(String id, Map<String, JsonValueObj> reportCond) {
        List<JsonValueItem> valueItems = reportCond.get(id).getValueList();
        if (null == valueItems || valueItems.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (JsonValueItem jsonValueItem : valueItems) {
            sb.append(jsonValueItem.getValue());
            sb.append(COMMA);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public boolean validateCrc() {
        if (null != this.reportId && !this.reportId.isEmpty() && !this.reportId.matches("^[a-zA-Z0-9]{1,30}$")) {
            return false;
        }
        if (null == this.conditionStr || this.conditionStr.isEmpty()) {
            return true;
        }
        if (!this.conditionStr.startsWith("[") || !this.conditionStr.endsWith("]")) {
            return false;
        }
        if (this.conditionStr.length() > 30720) {
            return false;
        }
        if (!JSONUtil.isValidJsonStr(this.conditionStr)) {
            return false;
        }
        try {
            JSONUtil.transformKeyValueObjMap(this.conditionStr);
        }
        catch (ParaException e) {
            return false;
        }
        return this.validateCheckCode(this.conditionStr, this.checkCode);
    }

    private boolean validateCheckCode(String conditionStrCh, String checkCodeCh) {
        long code = CRCCheckUtil.getCrc32Code(conditionStrCh);
        if (!String.valueOf(code).equals(checkCodeCh)) {
            LOGGER.error((Object)"conditionStr has been modified");
            return false;
        }
        return true;
    }

    public boolean validateMainAddressees() {
        String[] each;
        for (String tempeach : each = this.mainAddressees.split(";")) {
            if (tempeach.length() <= 64 && tempeach.matches(EMAIL_REGEX)) continue;
            return false;
        }
        return true;
    }

    public boolean validateccAddressee() {
        String[] each;
        if (this.ccAddressee == null || "".equals(this.ccAddressee.trim())) {
            return true;
        }
        for (String tempeach : each = this.ccAddressee.split(";")) {
            if (tempeach.length() <= 64 && tempeach.matches(EMAIL_REGEX)) continue;
            return false;
        }
        return true;
    }

    public String getCheckCode() {
        return this.checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getMainAddressees() {
        return this.mainAddressees;
    }

    public void setMainAddressees(String mainAddressees) {
        this.mainAddressees = mainAddressees;
    }

    public String getCcAddressee() {
        return this.ccAddressee;
    }

    public void setCcAddressee(String ccAddressee) {
        this.ccAddressee = ccAddressee;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getExportTypes() {
        return this.exportTypes;
    }

    public void setExportTypes(String exportTypes) {
        this.exportTypes = exportTypes;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(String pageNum) {
        this.pageNum = pageNum;
    }

    public String getCheckBackTaskReport() {
        return this.checkBackTaskReport;
    }

    public void setCheckBackTaskReport(String checkBackTaskReport) {
        this.checkBackTaskReport = checkBackTaskReport;
    }

    public String getFirstQuery() {
        return this.firstQuery;
    }

    public void setFirstQuery(String firstQuery) {
        this.firstQuery = firstQuery;
    }

    public String getDataDrillTitle() {
        return this.dataDrillTitle;
    }

    public void setDataDrillTitle(String dataDrillTitle) {
        this.dataDrillTitle = dataDrillTitle;
    }

    public String getReportSessionId() {
        return this.reportSessionId;
    }

    public void setReportSessionId(String reportSessionId) {
        this.reportSessionId = reportSessionId;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getDownloadFileName() {
        return this.downloadFileName;
    }

    public void setDownloadFileName(String downloadFileName) {
        this.downloadFileName = downloadFileName;
    }

    public String getFileTime() {
        return this.fileTime;
    }

    public void setFileTime(String fileTime) {
        this.fileTime = fileTime;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getFormType() {
        return this.formType;
    }

    public void setFormType(String formType) {
        this.formType = formType;
    }

    public String getRequestSessionId() {
        return this.requestSessionId;
    }

    public void setRequestSessionId(String requestSessionId) {
        this.requestSessionId = requestSessionId;
    }

    private static class SpecialReportDiscardPolicy
    implements RejectedExecutionHandler {
        private SpecialReportDiscardPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor exec) {
            LOGGER.info((Object)("the current number of threads in the pool: " + exec.getPoolSize()));
            if (r instanceof SubRunnable) {
                SubRunnable runnable = (SubRunnable)r;
                LOGGER.info((Object)("runnable.getRequestSessionId() : " + runnable.getRequestSessionId()));
                QueryReport.setReportExportStatus(runnable.getRequestSessionId(), "serverBusy");
            }
        }
    }

    private static class SubRunnable
    implements Runnable {
        private ActionSupport action;
        private ActionContext ctx = null;
        private List<ReportSession> reportSessionList = null;
        private HttpServletRequest request = null;
        private HttpSession session;
        private String contextPath = "";
        private String remoteAddr;
        private String formType;
        private String tempReportFileName = "";
        private String requestSessionId = "";
        private String downloadFilePath = "";

        protected SubRunnable(ActionSupport action, ActionContext ctx, List<ReportSession> reportSessionList, HttpServletRequest request, HttpSession session, String formType, String tempReportFileName, String requestSessionId, String downloadFilePath, String contextPath, String remoteAddr) {
            ctx.put("com.opensymphony.xwork2.dispatcher.HttpServletRequest", (Object)request);
            ActionContext.setContext((ActionContext)ctx);
            this.action = action;
            this.ctx = ctx;
            this.reportSessionList = reportSessionList;
            this.request = request;
            this.session = session;
            this.formType = formType;
            this.tempReportFileName = tempReportFileName;
            this.requestSessionId = requestSessionId;
            this.downloadFilePath = downloadFilePath;
            this.contextPath = contextPath;
            this.remoteAddr = remoteAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                User currentUser = (User)this.session.getAttribute("currentUser");
                this.ctx.put("com.opensymphony.xwork2.dispatcher.HttpServletRequest", (Object)this.request);
                this.ctx.put("currentUser", (Object)currentUser);
                this.ctx.put("contextPath", (Object)this.contextPath);
                this.ctx.put("remoteAddr", (Object)this.remoteAddr);
                ActionContext.setContext((ActionContext)this.ctx);
                HttpServletResponse response = (HttpServletResponse)this.ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
                ExportReport exportReport = new ExportReport(this.reportSessionList, this.request, response);
                Boolean exportStatus = null;
                exportStatus = exportReport.export(this.formType, this.tempReportFileName, this.downloadFilePath);
                if (null != exportStatus) {
                    QueryReport.setReportExportStatus(this.requestSessionId, "finished");
                    if (!exportStatus.booleanValue()) {
                        QueryReport.setReportExportStatus(this.requestSessionId, "exportError");
                        LOGGER.error((Object)"exportReport error!");
                        QueryReport.recordSysOptLog((User)this.session.getAttribute("currentUser"), "export.report", "atic.analysis", this.formType, false, false, SysoplogLevel.info, "export.report.fail", new String[0]);
                    }
                }
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                String errorMsg = this.action.getText("lego.err." + errorCode);
                QueryReport.setReportExportStatus(this.requestSessionId, errorMsg);
                LOGGER.error((Object)String.format("ExportReport errorCode : [%s].", errorCode));
                QueryReport.recordSysOptLog((User)this.session.getAttribute("currentUser"), "export.report", "atic.analysis", this.formType, false, false, SysoplogLevel.info, "lego.err." + errorCode, new String[0]);
            }
            finally {
                OperateLocker.getInstance().removeOneExecutingOperate(OperateLockEnum.EXPORT_REPORT);
            }
        }

        public String getRequestSessionId() {
            return this.requestSessionId;
        }
    }
}

