/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.action;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.model.vo.TableObj;
import com.security.logserver.module.condition.common.BaseAction;
import javax.servlet.http.HttpServletRequest;

public class QueryTable
extends BaseAction {
    private static final long serialVersionUID = 3956659634267591563L;
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private TableObj tableObj = new TableObj();
    private Long sessionId = null;
    private long tableId = 0L;
    private int index;
    private String pageNum;
    private String pageSize;
    private String orderField;
    private String orderType;

    public String queryTable() {
        ActionContext ctx = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        try {
            ReportSession reportSession = ReportSessionManager.getInstance().getSessionBySessionId(this.sessionId, request.getSession().getId());
            IRTable iRTable = (IRTable)reportSession.getIReport().getElementList().get(this.index);
            int pageNumI = 1;
            if (this.pageNum != null) {
                pageNumI = Integer.parseInt(this.pageNum);
            }
            int pageSizeI = 0;
            if (this.pageSize != null) {
                pageSizeI = Integer.parseInt(this.pageSize);
            }
            OrderInfo orderInfo = null;
            if (this.orderField != null && !this.orderField.isEmpty() && !this.orderField.equals("null")) {
                orderInfo = new OrderInfo();
                orderInfo.setOrderField(this.orderField);
                orderInfo.setOrderType(this.orderType);
            }
            reportSession.getOrderInfoMap().put(iRTable.getId(), orderInfo);
            this.tableObj = reportSession.getTableData(iRTable, pageNumI, pageSizeI, orderInfo, false);
        }
        catch (Exception e) {
            LOG.error((Object)("ask table failed! " + e.getMessage()));
        }
        return "success";
    }

    public boolean validatePageSize() {
        if (null == this.pageSize) {
            return true;
        }
        if ("".equals(this.pageSize)) {
            return false;
        }
        String regex = "^(10|20|30|50|100)$";
        return this.pageSize.matches(regex);
    }

    public TableObj getTableObj() {
        return this.tableObj;
    }

    public void setTableObj(TableObj tableObj) {
        this.tableObj = tableObj;
    }

    public Long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Long sessionId) {
        this.sessionId = sessionId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(String pageNum) {
        this.pageNum = pageNum;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }
}

