/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.connpool;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DBPool {
    protected static final ThreadLocal<Connection> CONNECTION = new ThreadLocal();
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private DataSource dsPooled;

    protected DBPool() {
    }

    public DataSource getDsPooled() {
        return this.dsPooled;
    }

    public void setDsPooled(DataSource dsPooled) {
        this.dsPooled = dsPooled;
    }

    public Connection getConnection() throws SQLException {
        Connection con = CONNECTION.get();
        if (null == con) {
            con = this.dsPooled.getConnection();
            CONNECTION.set(con);
        }
        return con;
    }

    public void closeConnection() {
        try {
            Connection conn = CONNECTION.get();
            if (conn != null) {
                CONNECTION.set(null);
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"closeConnection failed.");
        }
    }
}

