/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.connpool;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.mchange.v2.c3p0.DataSources;
import com.security.ireport.connpool.DBPool;
import com.security.ireport.engine.dataset.JdbcConnectorCfg;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.util.IReportConfigUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class DBPoolFactory {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static DBPoolFactory mODbpoolFactory = new DBPoolFactory();
    private static Map<String, DataSource> poollist = new HashMap<String, DataSource>();

    private DBPoolFactory() {
    }

    public static DBPoolFactory getInstance() {
        return mODbpoolFactory;
    }

    public void add(String key, String driver, String url, String username, String password) throws ParaException, ClassNotFoundException, SQLException {
        if (null == key) {
            throw new ParaException("DBPool 'key' can't be null");
        }
        Class.forName(driver);
        DataSource dsUnpooled = DataSources.unpooledDataSource((String)url, (String)username, (String)password);
        HashMap<String, Integer> overrides = new HashMap<String, Integer>();
        overrides.put("acquireIncrement", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("acquireIncrement.defaut")));
        overrides.put("minPoolSize", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("acquireIncrement.minPoolSize")));
        overrides.put("maxPoolSize", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("acquireIncrement.maxPoolSize")));
        overrides.put("maxIdleTime", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("c3p0.maxIdleTime")));
        DataSource dsPooled = DataSources.pooledDataSource((DataSource)dsUnpooled, overrides);
        if (poollist.containsKey(key)) {
            poollist.remove(key);
        }
        poollist.put(key, dsPooled);
    }

    public void add(JdbcConnectorCfg connCfg) throws ParaException, ClassNotFoundException, SQLException {
        if (null == connCfg) {
            throw new ParaException("JdbcConnectorCfg can't be null");
        }
        Class.forName(connCfg.getDriverClass());
        DataSource dsUnpooled = DataSources.unpooledDataSource((String)connCfg.getUrl(), (String)connCfg.getUserName(), (String)connCfg.getPassword());
        HashMap<String, Integer> overrides = new HashMap<String, Integer>();
        overrides.put("acquireIncrement", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("acquireIncrement.defaut")));
        overrides.put("minPoolSize", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("acquireIncrement.minPoolSize")));
        overrides.put("maxPoolSize", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("acquireIncrement.maxPoolSize")));
        overrides.put("maxIdleTime", Integer.valueOf(IReportConfigUtil.getInstance().getConfig("c3p0.maxIdleTime")));
        DataSource dsPooled = DataSources.pooledDataSource((DataSource)dsUnpooled, overrides);
        if (poollist.containsKey(connCfg.getConnId())) {
            poollist.remove(connCfg.getConnId());
        }
        poollist.put(connCfg.getConnId(), dsPooled);
    }

    public DBPool getDBPool(String key) {
        DBPool dbpool = null;
        if (key != null && poollist.containsKey(key)) {
            DataSource ds = poollist.get(key);
            LOG.debug((Object)("getDBPool DataSource key:" + key));
            dbpool = new DBPool();
            dbpool.setDsPooled(ds);
        } else {
            LOG.error((Object)("dbConnectId=" + key + " not exist."));
        }
        return dbpool;
    }

    public Connection getDBConnect(String key) {
        try {
            if (key != null && poollist.containsKey(key)) {
                DataSource ds = poollist.get(key);
                LOG.debug((Object)("getDBPool DataSource key:" + key));
                return ds.getConnection();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("getDBConnect key=" + key + " failed. " + e.getMessage()));
        }
        return null;
    }
}

