/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine;

import com.security.ireport.engine.definition.IRChart;
import org.jfree.chart.plot.PlotOrientation;

public abstract class ReportConstants {
    public static final long TIME_LEVEL_DEFAULT = 0L;
    public static final long TIME_LEVEL_MI = 1L;
    public static final long TIME_LEVEL_H = 2L;
    public static final long TIME_LEVEL_D = 3L;
    public static final long TIME_LEVEL_M = 4L;
    public static final long TIME_LEVEL_W = 5L;
    public static final long TIME_LEVEL_Q = 6L;
    public static final int BAR_CHART = 0;
    public static final int BAR_CHART_3D = 20;
    public static final int PIE_CHART = 1;
    public static final int PIE_CHART_3D = 21;
    public static final int XY_CHART = 2;
    public static final int TIME_CHART = 3;
    public static final int RING_CHART = 4;
    public static final int AREA_CHART = 5;
    public static final int XY_AREA_CHART = 6;
    public static final int TIME_AREA_CHART = 7;
    public static final int STACKED_BAR_CHART = 8;
    public static final int DIAL_CHART = 9;
    public static final int THERMOMETER_CHART = 10;
    public static final int BUBBLE_CHART = 11;
    public static final int XY_BAR_CHART = 13;
    public static final int STACKED_XY_BAR_CHART = 14;
    public static final int TIME_BAR_CHART = 15;
    public static final int STACKED_TIME_AREA_CHART = 16;
    public static final int PERCENT_BAR_CHART = 17;
    public static final int PERCENT_BAR_CHART_3D = 22;
    public static final int COMP_LINE_CHART = 23;
    public static final int COMP_BAR_CHART = 24;
    public static final int PERCENT_TIME_CHART = 18;
    public static final int HORI_BAR_CHART = 30;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final String DRILLDOWN_PARAMETER = "DrillDown";
    public static final String STR_HORIZONTAL = "HORIZONTAL";
    public static final String STR_VERTICAL = "VERTICAL";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String PERCENT_FORMAT = "percentFormat";
    public static final String DEFAULT_GROUP_NAME = "";
    public static final String DEFAULT_TIME_LEVEL = "timeLevel";

    public static PlotOrientation transPlotOrientation(String str) {
        if (STR_HORIZONTAL.equalsIgnoreCase(str)) {
            return PlotOrientation.HORIZONTAL;
        }
        return PlotOrientation.VERTICAL;
    }

    public static int getChartType(IRChart reportChart) {
        if (reportChart.getChartType().equalsIgnoreCase("PieChart3D")) {
            return 1;
        }
        if (reportChart.getChartType().equalsIgnoreCase("PieChart")) {
            return 1;
        }
        if (reportChart.getChartType().equalsIgnoreCase("BarChart")) {
            return 0;
        }
        if (reportChart.getChartType().equalsIgnoreCase("BarChart3D")) {
            return 0;
        }
        if (reportChart.getChartType().equalsIgnoreCase("XYSeriesChart")) {
            return 2;
        }
        if (reportChart.getChartType().equalsIgnoreCase("XYAreaChart")) {
            return 6;
        }
        if (reportChart.getChartType().equalsIgnoreCase("TimeSeriesChart")) {
            return 3;
        }
        if (reportChart.getChartType().equalsIgnoreCase("TimeAreaChart")) {
            return 7;
        }
        if (reportChart.getChartType().equalsIgnoreCase("StackedTimeAreaChart")) {
            return 16;
        }
        if (reportChart.getChartType().equalsIgnoreCase("PercentBarChart")) {
            return 17;
        }
        if (reportChart.getChartType().equalsIgnoreCase("PercentTimeSeriesChart")) {
            return 18;
        }
        if (reportChart.getChartType().equalsIgnoreCase("CompLineChart")) {
            return 23;
        }
        if (reportChart.getChartType().equalsIgnoreCase("CompBarChart")) {
            return 24;
        }
        if (reportChart.getChartType().equalsIgnoreCase("HoriBarChart")) {
            return 30;
        }
        return 0;
    }

    public static enum Status {
        SUCCESS,
        FAILURE,
        INVALID;

    }

    public static enum ScheduleAmPm {
        AM(0),
        PM(1);

        private final int code;

        private ScheduleAmPm(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ScheduleAmPm findByCode(int code) {
            for (ScheduleAmPm scheduleAmPm : ScheduleAmPm.values()) {
                if (scheduleAmPm.getCode() != code) continue;
                return scheduleAmPm;
            }
            return null;
        }
    }

    public static enum ScheduleType {
        ONCE(0),
        DAILY(1),
        WEEKLY(2),
        MONTHLY(3),
        WEEKDAYS(4),
        HOURLY(5),
        CRON(6);

        private final int code;

        private ScheduleType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ScheduleType findByCode(int code) {
            for (ScheduleType scheduleType : ScheduleType.values()) {
                if (scheduleType.getCode() != code) continue;
                return scheduleType;
            }
            return null;
        }
    }

    public static enum ExportType {
        PDF(0),
        XLS(1),
        HTML(2),
        CSV(3),
        IMAGE(4),
        RTF(5),
        TEXT(6),
        EXCEL(7),
        HTML_EMBEDDED(8);

        private final int code;

        private ExportType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ExportType findByCode(int code) {
            for (ExportType exportType : ExportType.values()) {
                if (exportType.getCode() != code) continue;
                return exportType;
            }
            return null;
        }
    }

    public static enum DeliveryMethod {
        EMAIL("email"),
        FILE("fileSystem"),
        FAX("fax"),
        FTP("ftp"),
        PRINTER("printer"),
        DOCUMENT_REPOSITORY("documentRepository");

        private final String name;

        private DeliveryMethod(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static DeliveryMethod findByName(String name) {
            for (DeliveryMethod value : DeliveryMethod.values()) {
                if (!value.getName().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }
}

