/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.dataset;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.util.HotSwapClassLoader;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JavaDataSourceCollector
extends IDataSourceCollector {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<Object> cachedData = new ArrayList<Object>();
    private List<Object> curPageData = new ArrayList<Object>();
    private String dataSourceId;
    private boolean hasCacheData = false;
    private boolean isCacheData;
    private String javaClass;
    private String classPath;
    private String pojo;
    private IJavaDataSource javaDataSource;
    private long sessionId;

    public JavaDataSourceCollector() {
        this(false);
    }

    public JavaDataSourceCollector(boolean catchData) {
        this.isCacheData = catchData;
    }

    public JavaDataSourceCollector(IRDataSource dsCfg, long sessionId) {
        this.isCacheData = dsCfg.isCache();
        this.dataSourceId = dsCfg.getId();
        this.javaClass = dsCfg.getClassName();
        this.classPath = dsCfg.getPath();
        this.pojo = dsCfg.getPojo();
        this.sessionId = sessionId;
        this.createJavaDataInstance();
    }

    private void createJavaDataInstance() {
        String simpleClsName = IReportUtil.getSimpleClassName(this.javaClass);
        String packageName = IReportUtil.getClassPackage(this.javaClass);
        String classFilePath = this.classPath + File.separator + simpleClsName + ".class";
        try {
            File directory = new File(this.classPath);
            File[] files = directory.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (!file.isFile() || file.getName().equals(simpleClsName + ".class") || !file.getName().endsWith(".class")) continue;
                    String filePathName = file.getPath();
                    String className = packageName + "." + IReportUtil.getFileNameNotSuffix(file.getName());
                    HotSwapClassLoader.getInstance().load(className, filePathName);
                }
            } else {
                LOG.error((Object)"files is null.");
            }
            LOG.debug((Object)("load class" + directory.getName()));
            Class<?> cls = HotSwapClassLoader.getInstance().load(this.javaClass, classFilePath);
            this.javaDataSource = (IJavaDataSource)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"createJavaDataInstance load class failed ClassNotFoundException.");
        }
        catch (InstantiationException e) {
            LOG.error((Object)"createJavaDataInstance load class failed InstantiationException.");
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"createJavaDataInstance load class failed IllegalAccessException.");
        }
        catch (Error e) {
            LOG.error((Object)"createJavaDataInstance load class error.");
        }
    }

    @Override
    public List<FieldInfo> getAllFieldInfo() {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        try {
            Field[] fields;
            String simpleClsName = IReportUtil.getSimpleClassName(this.pojo);
            String packageName = IReportUtil.getClassPackage(this.pojo);
            String path = this.classPath + "/" + simpleClsName + ".class";
            String className = packageName + "." + simpleClsName;
            Class<?> pojoClass = HotSwapClassLoader.getInstance().load(className, path);
            for (Field field : fields = pojoClass.getDeclaredFields()) {
                FieldInfo info = new FieldInfo();
                info.setFieldName(field.getName());
                info.setFieldType(field.getType().getSimpleName());
                fieldInfos.add(info);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"getAllFieldInfo load class failed.");
        }
        catch (RuntimeException e) {
            LOG.error((Object)"getAllFieldInfo load class failed.");
        }
        return fieldInfos;
    }

    @Override
    public long getCurPageCount() {
        return this.curPageData.size();
    }

    @Override
    public void setCacheData(boolean cacheData) {
        this.isCacheData = cacheData;
    }

    @Override
    public long getAllCount() {
        try {
            return this.javaDataSource.getAllCount(this.dataSourceId, this.sessionId);
        }
        catch (Exception e) {
            LOG.error((Object)("reportPlugin configure javaDataSource class getAllCount method exception! " + e.getMessage()));
            return 0L;
        }
        catch (Error e) {
            LOG.error((Object)("reportPlugin configure javaDataSource class getAllCount method Error! " + e.getMessage()));
            return 0L;
        }
    }

    @Override
    public void loadData(long pgIndex, long pgSize, OrderInfo sortList) {
        if (this.hasCacheData) {
            LOG.debug((Object)("load data fro cache. pageIndex=" + pgIndex + "; pgSize=" + pgSize));
            this.curPageData.clear();
            if (0L == pgIndex && 0L == pgSize) {
                this.curPageData.addAll(this.cachedData);
            } else {
                long endIndex;
                long startIndex = (pgIndex - 1L) * pgSize;
                if (startIndex < 0L) {
                    startIndex = 0L;
                }
                if (startIndex >= (long)this.cachedData.size()) {
                    startIndex = this.cachedData.size();
                }
                if ((endIndex = pgIndex * pgSize) >= (long)this.cachedData.size()) {
                    endIndex = this.cachedData.size();
                }
                for (long i = startIndex; i < endIndex; ++i) {
                    this.curPageData.add(this.cachedData.get((int)i));
                }
            }
        } else {
            LOG.debug((Object)("load data fro java interface. pageIndex=" + pgIndex + "; pgSize=" + pgSize));
            try {
                this.curPageData = this.javaDataSource.fetchData(pgIndex, pgSize, sortList, this.dataSourceId, this.sessionId);
            }
            catch (Exception e) {
                LOG.error((Object)("reportPlugin configure javaDataSource class fetchData method exception! " + e.getMessage()));
                if (ProductFaceUtil.getInstance().isBusinessException(e)) {
                    ProductFaceUtil.getInstance().throwProductException(e.getMessage(), "INFO", e);
                }
            }
            catch (Error e) {
                LOG.error((Object)("reportPlugin configure javaDataSource class fetchData method Error! " + e.getMessage()));
            }
            if (this.isCacheData && 0L == pgIndex && 0L == pgSize) {
                this.hasCacheData = true;
                this.cachedData.addAll(this.curPageData);
            }
        }
    }

    @Override
    public Object getValue(long row, String colName) {
        Object obj = this.curPageData.get((int)row);
        Object value = null;
        String methodName = "get" + colName.substring(0, 1).toUpperCase(Locale.US) + colName.substring(1);
        try {
            Method getMethod = obj.getClass().getMethod(methodName, new Class[0]);
            value = getMethod.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)("get value failed. " + e.getMessage()));
        }
        return value;
    }

    public Object getValue(long row) {
        Object obj = this.curPageData.get((int)row);
        return obj;
    }

    public List<IFlexTableData> getFlexTableHeader() {
        return this.javaDataSource.getFlexTableHeader();
    }

    @Override
    public int prepareData(String reportId, String dataSourceIdNew, Map<?, ?> queryCond, long sessId) {
        this.sessionId = sessId;
        if (null == this.javaDataSource) {
            this.createJavaDataInstance();
        }
        try {
            boolean isShowReport;
            int isPrepare = this.javaDataSource.prepareData(reportId, dataSourceIdNew, queryCond, this.sessionId);
            if (0 == isPrepare && (isShowReport = this.javaDataSource.isShowReport(this.sessionId, queryCond))) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            if (ProductFaceUtil.getInstance().isBusinessException(e)) {
                ProductFaceUtil.getInstance().throwProductException(e.getMessage(), "INFO", e);
            }
            LOG.error((Object)("reportPlugin configure javaDataSource class prepareData method exception! " + e.getMessage()));
            return 1;
        }
        catch (Error e) {
            LOG.error((Object)("reportPlugin configure javaDataSource class prepareData method Error! " + e.getMessage()));
            return 1;
        }
    }

    @Override
    public boolean splitTask(String reportId, String dataSourceIdNew, Map<?, ?> queryCond, long sessId) {
        boolean result = false;
        this.sessionId = sessId;
        if (null == this.javaDataSource) {
            this.createJavaDataInstance();
        }
        try {
            boolean isSplite;
            result = isSplite = this.javaDataSource.splitTask(reportId, dataSourceIdNew, queryCond, this.sessionId);
        }
        catch (Exception e) {
            LOG.error((Object)("reportPlugin configure javaDataSource class spliteTask method exception! " + e.getMessage()));
            return result;
        }
        return result;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }

    public String getPojo() {
        return this.pojo;
    }

    public void setPojo(String pojo) {
        this.pojo = pojo;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    @Override
    public boolean isShowReport(long sessionIdNew, Map<?, ?> cond) {
        this.sessionId = sessionIdNew;
        if (null == this.javaDataSource) {
            this.createJavaDataInstance();
        }
        return this.javaDataSource.isShowReport(sessionIdNew, cond);
    }

    @Override
    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceIdNew, Map<?, ?> queryCondNew, long sessionIdNew) {
        return this.javaDataSource.getPrepareParasMap(reportId, dataSourceIdNew, queryCondNew, sessionIdNew);
    }

    @Override
    public void clean() {
        this.cachedData.clear();
        this.curPageData.clear();
        this.javaDataSource = null;
    }
}

