/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.dataset;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.util.HotSwapClassLoader;
import com.security.ireport.util.IReportUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PojoFieldAnalyse {
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static Map<String, FieldInfo> getFieldInfoMap(String reportId, String pojo, IRTable table) {
        HashMap<String, FieldInfo> fieldInfoMap = new HashMap<String, FieldInfo>();
        String filePath = IReportUtil.getPluginPath() + reportId;
        String simpleClsName = IReportUtil.getSimpleClassName(pojo);
        String path = filePath + "/" + simpleClsName + ".class";
        try {
            Field[] fields;
            Class<?> pojoClass = HotSwapClassLoader.getInstance().load(pojo, path);
            for (Field field : fields = pojoClass.getDeclaredFields()) {
                FieldInfo info = new FieldInfo();
                info.setFieldName(field.getName());
                info.setFieldType(PojoFieldAnalyse.getFieldType(field.getType().getName()));
                info.setFieldType("java.lang.String");
                String findFormatType = PojoFieldAnalyse.findFormatType(table, field.getName());
                if (null == findFormatType || findFormatType.isEmpty()) {
                    info.setFieldType(PojoFieldAnalyse.getFieldType(field.getType().getName()));
                } else {
                    info.setFieldType(String.class.getName());
                }
                fieldInfoMap.put(info.getFieldName(), info);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"getFieldInfoMap load class failed.");
        }
        catch (RuntimeException e) {
            LOG.error((Object)"getFieldInfoMap load class failed.");
        }
        return fieldInfoMap;
    }

    private static String findFormatType(IRTable table, String filedName) {
        Iterator<IRColumn> itColumn = table.getIRColumnList().iterator();
        IRColumn next = null;
        while (itColumn.hasNext()) {
            next = itColumn.next();
            if (!next.getField().equals(filedName)) continue;
            return next.getFormatType();
        }
        return null;
    }

    public static Map<String, FieldInfo> getDataSourceFieldInfoMap(IReport report, IRTable table) {
        String iRTableDataSource = table.getDataSource();
        HashMap<String, FieldInfo> fieldInfoMap = new HashMap();
        IRDataSource dsConfig = report.getIRDataSourceMap().get(iRTableDataSource);
        if (dsConfig.getType().trim().equalsIgnoreCase("java")) {
            fieldInfoMap = PojoFieldAnalyse.getFieldInfoMap(report.getId(), dsConfig.getPojo(), table);
        } else {
            List<FieldInfo> fieldList = dsConfig.getFieldList().getFieldList();
            for (FieldInfo fieldInfo : fieldList) {
                FieldInfo newItem = new FieldInfo();
                newItem.setFieldName(fieldInfo.getFieldName());
                newItem.setSection(fieldInfo.getSection());
                newItem.setFieldType("java.lang.String");
                fieldInfoMap.put(fieldInfo.getFieldName(), newItem);
            }
        }
        return fieldInfoMap;
    }

    public static String getFieldType(String type) {
        String javaType = type;
        if ("int".equals(type)) {
            javaType = "java.lang.Integer";
        } else if ("long".equals(type)) {
            javaType = "java.lang.Long";
        } else if ("boolean".equals(type)) {
            javaType = "java.lang.Boolean";
        } else if ("short".equals(type)) {
            javaType = "java.lang.Short";
        } else if ("char".equals(type)) {
            javaType = "java.lang.Character";
        } else if ("float".equals(type)) {
            javaType = "java.lang.Float";
        } else if ("double".equals(type)) {
            javaType = "java.lang.Double";
        }
        return javaType;
    }
}

