/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.dataset;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.connpool.DBPool;
import com.security.ireport.connpool.DBPoolFactory;
import com.security.ireport.engine.dataset.DBConnectionManager;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.IDataSourceCollector;
import com.security.ireport.engine.dataset.ISqlDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.IRDataSource;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.util.HotSwapClassLoader;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.SqlUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SqlDataSourceCollector
extends IDataSourceCollector {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<Object[]> curPageData = new ArrayList<Object[]>();
    private IRDataSource dataSourceCfg = null;
    private String dataBaseType = null;
    private List<String> sqlSectionList = null;
    private long fixCount = 0L;
    private ISqlDataSource sqlInterface;

    public SqlDataSourceCollector(IRDataSource dsCfg) {
        this.dataSourceCfg = dsCfg;
        String classPath = dsCfg.getPath();
        this.dataBaseType = DBConnectionManager.getInstance().getConnectionType(this.dataSourceCfg.getDatabase());
        String javaClass = dsCfg.getClassName();
        if (dsCfg.isUseSqlInterface() && !IReportConfCheckUtil.isStringEmpty(javaClass)) {
            Object obj = this.createJavaDataInstance(classPath, javaClass);
            if (obj != null && obj instanceof ISqlDataSource) {
                this.sqlInterface = (ISqlDataSource)obj;
            } else {
                LOG.error((Object)"Error to get ISqlDataSource.");
            }
        }
    }

    private Object createJavaDataInstance(String classPath, String javaClass) {
        String simpleClsName = IReportUtil.getSimpleClassName(javaClass);
        String packageName = IReportUtil.getClassPackage(javaClass);
        String classFilePath = classPath + File.separator + simpleClsName + ".class";
        try {
            File directory = new File(classPath);
            File[] files = directory.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (!file.isFile() || file.getName().equals(simpleClsName + ".class") || !file.getName().endsWith(".class")) continue;
                    String filePathName = file.getPath();
                    String className = packageName + "." + IReportUtil.getFileNameNotSuffix(file.getName());
                    HotSwapClassLoader.getInstance().load(className, filePathName);
                }
            } else {
                LOG.error((Object)"files is null.");
            }
            Class<?> cls = HotSwapClassLoader.getInstance().load(javaClass, classFilePath);
            return cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)"createJavaDataInstance load class failed ClassNotFoundException.");
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"createJavaDataInstance load class failed IllegalAccessException.");
        }
        catch (InstantiationException e) {
            LOG.error((Object)"createJavaDataInstance load class failed InstantiationException .");
        }
        catch (Error e) {
            LOG.error((Object)"createJavaDataInstance load class error.");
        }
        return null;
    }

    @Override
    public void setCacheData(boolean cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAllCount() {
        long recordCount = 0L;
        DBPool dbPool = DBPoolFactory.getInstance().getDBPool(this.dataSourceCfg.getDatabase());
        if (null == dbPool) {
            return 0L;
        }
        try {
            Connection conn = dbPool.getConnection();
            String sqlCount = SqlUtil.getCountSql(this.sqlSectionList);
            List<Object[]> result = SqlUtil.execusePrepareQuery(sqlCount, conn, this.dataSourceCfg.getParaList().getParaList(), this.getAllFieldInfo());
            if (result != null && !result.isEmpty()) {
                recordCount = IReportConfCheckUtil.getLong(result.get(0)[0]);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)(" get getDBPool failed. dbConnId=" + this.dataSourceCfg.getDatabase()));
        }
        finally {
            dbPool.closeConnection();
        }
        if (this.fixCount > 0L && this.fixCount < recordCount) {
            return this.fixCount;
        }
        return recordCount;
    }

    @Override
    public long getCurPageCount() {
        return this.curPageData.size();
    }

    @Override
    public Object getValue(long row, String colName) {
        return SqlUtil.getValue(row, colName, this.curPageData, this.getAllFieldInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(long pgIndex, long pgSize, OrderInfo sortList) {
        DBPool dbPool;
        this.curPageData.clear();
        String sql = SqlUtil.getFullSql(this.sqlSectionList);
        String sqlFilter = SqlUtil.getSqlFilterByDataType(sql, pgIndex, pgSize, sortList, this.dataBaseType);
        if (null != sortList) {
            LOG.info((Object)("sqlFilter->pgIndex=" + pgIndex + ",pgSize=" + pgSize + ",orderField=" + sortList.getOrderField() + ",orderType=" + sortList.getOrderType()));
        }
        if (null == (dbPool = DBPoolFactory.getInstance().getDBPool(this.dataSourceCfg.getDatabase()))) {
            return;
        }
        try {
            Connection conn = dbPool.getConnection();
            List<Object[]> result = SqlUtil.execusePrepareQuery(sqlFilter, conn, this.dataSourceCfg.getParaList().getParaList(), this.getAllFieldInfo());
            if (result != null && !result.isEmpty()) {
                long allCount = this.getAllCount();
                allCount -= (pgIndex - 1L) * pgSize;
                allCount = pgSize > 0L ? (pgSize > allCount ? allCount : pgSize) : ((long)result.size() > allCount ? allCount : (long)result.size());
                int i = 0;
                while ((long)i < allCount) {
                    this.curPageData.add(result.get(i));
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            LOG.error((Object)(" get getDBPool failed. dbConnId=" + this.dataSourceCfg.getDatabase()));
        }
        finally {
            dbPool.closeConnection();
        }
    }

    @Override
    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryConds, long sessionId) {
        Map<String, JsonValueObj> queryCond = queryConds;
        Map<String, List<String>> paramKeyValueMap = JSONUtil.transformKeyValueMap(queryCond);
        if (this.dataSourceCfg.isUseSqlInterface()) {
            String filterSql = this.sqlInterface.prepareSql(reportId, dataSourceId, queryCond);
            this.sqlSectionList = SqlUtil.decomposeSql(filterSql);
        } else {
            this.sqlSectionList = this.createSqlSectionList(paramKeyValueMap);
        }
        if (paramKeyValueMap.containsKey("FIX_RECORD_COUNT")) {
            List<String> value = paramKeyValueMap.get("FIX_RECORD_COUNT");
            this.fixCount = Long.parseLong(value.get(0));
        }
        return 0;
    }

    private List<String> createSqlSectionList(Map<String, List<String>> paramKeyValueMap) {
        ArrayList<String> otherSqlList = new ArrayList<String>();
        if (this.dataSourceCfg.getSqlSectionList() != null) {
            List<String> tempSqlList = this.dataSourceCfg.getSqlSectionList().getSqlSectionList();
            String otherSql = null;
            for (String tempSql : tempSqlList) {
                otherSql = SqlUtil.formatSQLSection(tempSql, paramKeyValueMap);
                if (null == otherSql) continue;
                otherSqlList.add(otherSql);
            }
        }
        String tempSql = SqlUtil.formatSQL(this.dataSourceCfg.getSql(), paramKeyValueMap);
        StringBuffer filterSql = null;
        filterSql = null != tempSql ? new StringBuffer(tempSql) : new StringBuffer();
        if (!otherSqlList.isEmpty()) {
            for (String item : otherSqlList) {
                filterSql.append(' ').append(item);
            }
        }
        List<String> sqlSectionListNew = SqlUtil.decomposeSql(filterSql.toString());
        List<Integer> nullKeyIndex = SqlUtil.getNullKeyIndex(paramKeyValueMap, this.dataSourceCfg.getParaList().getParaList());
        String whereSql = SqlUtil.removeWhereNullKey(sqlSectionListNew.get(1), nullKeyIndex);
        whereSql = SqlUtil.replaceKeyMulValueSql(whereSql, this.dataSourceCfg.getParaList().getParaList());
        sqlSectionListNew.remove(1);
        sqlSectionListNew.add(1, whereSql);
        return sqlSectionListNew;
    }

    @Override
    public List<FieldInfo> getAllFieldInfo() {
        return this.dataSourceCfg.getFieldList().getFieldList();
    }
}

