/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportConfCheckUtil;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;

public class IRLabelGenerator {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String labelFormat = null;
    private String valueFormat = null;
    private String numberFormat;
    private String percentFormat;
    private String rangeFormatType;
    private String rangeFormatValue;
    private String domainFormatValue;

    public String getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(String valueFormat) {
        this.valueFormat = valueFormat;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getPercentFormat() {
        return this.percentFormat;
    }

    public void setPercentFormat(String percentFormat) {
        this.percentFormat = percentFormat;
    }

    private StandardCategoryToolTipGenerator createCategoryToolTipGenerator() {
        StandardCategoryToolTipGenerator result = null;
        if (IReportConfCheckUtil.isStringEmpty(this.rangeFormatType) || IReportConfCheckUtil.isStringEmpty(this.labelFormat)) {
            return new StandardCategoryToolTipGenerator();
        }
        if (this.rangeFormatType.equals("numberFormat")) {
            result = this.createNumCategoryToolTipGenerator(this.rangeFormatValue, this.labelFormat);
        } else {
            if (this.rangeFormatType.equals("dateFormat")) {
                return this.createDateCategoryToolTipGenerator(this.rangeFormatValue, this.labelFormat);
            }
            LOGGER.error((Object)("yFormatType=" + this.rangeFormatType + " is invalid."));
        }
        return result;
    }

    private StandardCategoryToolTipGenerator createNumCategoryToolTipGenerator(String rangeFormatValueNew, String labelFormatNew) {
        StandardCategoryToolTipGenerator result = null;
        result = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new StandardCategoryToolTipGenerator(labelFormatNew, (NumberFormat)new DecimalFormat()) : new StandardCategoryToolTipGenerator(labelFormatNew, (NumberFormat)new DecimalFormat(rangeFormatValueNew));
        return result;
    }

    private StandardCategoryToolTipGenerator createDateCategoryToolTipGenerator(String rangeFormatValueNew, String labelFormatNew) {
        StandardCategoryToolTipGenerator result = null;
        result = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new StandardCategoryToolTipGenerator(labelFormatNew, (DateFormat)new SimpleDateFormat()) : new StandardCategoryToolTipGenerator(labelFormatNew, (DateFormat)new SimpleDateFormat(rangeFormatValueNew));
        return result;
    }

    private StandardCategoryItemLabelGenerator createCategoryItemLabelGenerator() {
        StandardCategoryItemLabelGenerator result = null;
        if (IReportConfCheckUtil.isStringEmpty(this.rangeFormatType) || IReportConfCheckUtil.isStringEmpty(this.valueFormat)) {
            return new StandardCategoryItemLabelGenerator();
        }
        if (this.rangeFormatType.equals("numberFormat")) {
            result = this.createNumCategoryItemLabelGenerator(this.rangeFormatValue, this.percentFormat, this.valueFormat);
        } else if (this.rangeFormatType.equals("dateFormat")) {
            result = this.createDateCategoryItemLabelGenerator(this.rangeFormatValue, this.valueFormat);
        } else {
            LOGGER.error((Object)("yFormatType=" + this.rangeFormatType + " is invalid."));
        }
        return result;
    }

    private StandardCategoryItemLabelGenerator createNumCategoryItemLabelGenerator(String rangeFormatValueNew, String percentFormatNew, String valueFormatNew) {
        StandardCategoryItemLabelGenerator result = null;
        try {
            DecimalFormat numberFormatNew = null;
            numberFormatNew = !IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new DecimalFormat(rangeFormatValueNew) : new DecimalFormat();
            result = !IReportConfCheckUtil.isStringEmpty(percentFormatNew) ? new StandardCategoryItemLabelGenerator(valueFormatNew, (NumberFormat)numberFormatNew, (NumberFormat)new DecimalFormat(percentFormatNew)) : new StandardCategoryItemLabelGenerator(valueFormatNew, (NumberFormat)numberFormatNew);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardCategoryItemLabelGenerator();
        }
        return result;
    }

    private StandardCategoryItemLabelGenerator createDateCategoryItemLabelGenerator(String rangeFormatValueNew, String labelFormatNew) {
        StandardCategoryItemLabelGenerator result = null;
        result = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new StandardCategoryItemLabelGenerator(labelFormatNew, (DateFormat)new SimpleDateFormat()) : new StandardCategoryItemLabelGenerator(labelFormatNew, (DateFormat)new SimpleDateFormat(rangeFormatValueNew));
        return result;
    }

    public StandardXYToolTipGenerator createStandardXYToolTipGenerator() {
        StandardXYToolTipGenerator result = null;
        if (IReportConfCheckUtil.isStringEmpty(this.rangeFormatType) || IReportConfCheckUtil.isStringEmpty(this.labelFormat)) {
            return new StandardXYToolTipGenerator();
        }
        if (this.rangeFormatType.equals("numberFormat")) {
            result = this.createNumStandardXYToolTipGenerator(this.labelFormat, this.domainFormatValue, this.rangeFormatValue);
        } else if (this.rangeFormatType.equals("dateFormat")) {
            result = this.createDateStandardXYToolTipGenerator(this.labelFormat, this.domainFormatValue, this.rangeFormatValue);
        } else {
            LOGGER.error((Object)("yFormatType=" + this.rangeFormatType + " is invalid."));
        }
        return result;
    }

    private StandardXYToolTipGenerator createNumStandardXYToolTipGenerator(String labelFormatNew, String domainFormatValueNew, String rangeFormatValueNew) {
        StandardXYToolTipGenerator result = null;
        try {
            DecimalFormat domainFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(domainFormatValueNew) ? new DecimalFormat() : new DecimalFormat(domainFormatValueNew);
            DecimalFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new DecimalFormat() : new DecimalFormat(rangeFormatValueNew);
            result = new StandardXYToolTipGenerator(labelFormatNew, (NumberFormat)domainFormat, (NumberFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardXYToolTipGenerator();
        }
        return result;
    }

    private StandardXYToolTipGenerator createDateStandardXYToolTipGenerator(String labelFormatNew, String domainFormatValueNew, String rangeFormatValueNew) {
        StandardXYToolTipGenerator result = null;
        try {
            DecimalFormat domainFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(domainFormatValueNew) ? new DecimalFormat() : new DecimalFormat(domainFormatValueNew);
            SimpleDateFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(rangeFormatValueNew);
            result = new StandardXYToolTipGenerator(labelFormatNew, (NumberFormat)domainFormat, (DateFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardXYToolTipGenerator();
        }
        return result;
    }

    public StandardXYToolTipGenerator createTimeSeriesToolTipGenerator() {
        StandardXYToolTipGenerator result = null;
        if (IReportConfCheckUtil.isStringEmpty(this.rangeFormatType) || IReportConfCheckUtil.isStringEmpty(this.labelFormat)) {
            return new StandardXYToolTipGenerator();
        }
        if (this.rangeFormatType.equals("numberFormat")) {
            result = this.createNumTimeSeriesToolTipGenerator(this.labelFormat, this.domainFormatValue, this.rangeFormatValue);
        } else if (this.rangeFormatType.equals("dateFormat")) {
            result = this.createDateTimeSeriesToolTipGenerator(this.labelFormat, this.domainFormatValue, this.rangeFormatValue);
        } else {
            LOGGER.error((Object)("yFormatType=" + this.rangeFormatType + " is invalid."));
        }
        return result;
    }

    private StandardXYToolTipGenerator createNumTimeSeriesToolTipGenerator(String labelFormatNew, String domainFormatValueNew, String rangeFormatValueNew) {
        StandardXYToolTipGenerator result = null;
        try {
            SimpleDateFormat domainFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(domainFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(domainFormatValueNew);
            DecimalFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new DecimalFormat() : new DecimalFormat(rangeFormatValueNew);
            result = new StandardXYToolTipGenerator(labelFormatNew, (DateFormat)domainFormat, (NumberFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardXYToolTipGenerator();
        }
        return result;
    }

    private StandardXYToolTipGenerator createDateTimeSeriesToolTipGenerator(String labelFormatNew, String domainFormatValueNew, String rangeFormatValueNew) {
        StandardXYToolTipGenerator result = null;
        try {
            SimpleDateFormat domainFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(domainFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(domainFormatValueNew);
            SimpleDateFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(rangeFormatValueNew);
            result = new StandardXYToolTipGenerator(labelFormatNew, (DateFormat)domainFormat, (DateFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardXYToolTipGenerator();
        }
        return result;
    }

    public StandardXYItemLabelGenerator createTimeSeriesItemLabelGenerator() {
        StandardXYItemLabelGenerator result = null;
        if (IReportConfCheckUtil.isStringEmpty(this.rangeFormatType) || IReportConfCheckUtil.isStringEmpty(this.valueFormat)) {
            return new StandardXYItemLabelGenerator();
        }
        if (this.rangeFormatType.equals("numberFormat")) {
            result = this.createNumTimeSeriesItemLabelGenerator(this.valueFormat, this.domainFormatValue, this.rangeFormatValue);
        } else if (this.rangeFormatType.equals("dateFormat")) {
            result = this.createDateTimeSeriesItemLabelGenerator(this.valueFormat, this.domainFormatValue, this.rangeFormatValue);
        } else {
            LOGGER.error((Object)("yFormatType=" + this.rangeFormatType + " is invalid."));
        }
        return result;
    }

    private StandardXYItemLabelGenerator createNumTimeSeriesItemLabelGenerator(String valueFormatNew, String domainFormatValueNew, String rangeFormatValueNew) {
        StandardXYItemLabelGenerator result = null;
        try {
            SimpleDateFormat domainFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(domainFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(domainFormatValueNew);
            DecimalFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new DecimalFormat() : new DecimalFormat(rangeFormatValueNew);
            result = new StandardXYItemLabelGenerator(valueFormatNew, (DateFormat)domainFormat, (NumberFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardXYItemLabelGenerator();
        }
        return result;
    }

    private StandardXYItemLabelGenerator createDateTimeSeriesItemLabelGenerator(String valueFormatNew, String domainFormatValueNew, String rangeFormatValueNew) {
        StandardXYItemLabelGenerator result = null;
        try {
            SimpleDateFormat domainFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(domainFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(domainFormatValueNew);
            SimpleDateFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(rangeFormatValueNew);
            result = new StandardXYItemLabelGenerator(valueFormatNew, (DateFormat)domainFormat, (DateFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardXYItemLabelGenerator();
        }
        return result;
    }

    public StandardCategoryToolTipGenerator createCompLineToolTipGenerator() {
        StandardCategoryToolTipGenerator result = null;
        if (IReportConfCheckUtil.isStringEmpty(this.rangeFormatType) || IReportConfCheckUtil.isStringEmpty(this.labelFormat)) {
            return new StandardCategoryToolTipGenerator();
        }
        if (this.rangeFormatType.equals("numberFormat")) {
            result = this.createNumCompLineToolTipGenerator(this.labelFormat, this.rangeFormatValue);
        } else if (this.rangeFormatType.equals("dateFormat")) {
            result = this.createDateCompLineToolTipGenerator(this.labelFormat, this.domainFormatValue, this.rangeFormatValue);
        } else {
            LOGGER.error((Object)("yFormatType=" + this.rangeFormatType + " is invalid."));
        }
        return result;
    }

    private StandardCategoryToolTipGenerator createNumCompLineToolTipGenerator(String labelFormatNew, String rangeFormatValueNew) {
        StandardCategoryToolTipGenerator result = null;
        try {
            if (IReportConfCheckUtil.isStringEmpty(this.domainFormatValue)) {
                new SimpleDateFormat();
            } else {
                new SimpleDateFormat(this.domainFormatValue);
            }
            DecimalFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new DecimalFormat() : new DecimalFormat(rangeFormatValueNew);
            result = new StandardCategoryToolTipGenerator(labelFormatNew, (NumberFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardCategoryToolTipGenerator();
        }
        return result;
    }

    private StandardCategoryToolTipGenerator createDateCompLineToolTipGenerator(String labelFormatNew, String domainFormatValueNew, String rangeFormatValueNew) {
        StandardCategoryToolTipGenerator result = null;
        try {
            if (IReportConfCheckUtil.isStringEmpty(domainFormatValueNew)) {
                new SimpleDateFormat();
            } else {
                new SimpleDateFormat(domainFormatValueNew);
            }
            SimpleDateFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(rangeFormatValueNew);
            result = new StandardCategoryToolTipGenerator(labelFormatNew, (DateFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardCategoryToolTipGenerator();
        }
        return result;
    }

    public StandardCategoryItemLabelGenerator createCompLineItemLabelGenerator() {
        StandardCategoryItemLabelGenerator result = null;
        if (IReportConfCheckUtil.isStringEmpty(this.rangeFormatType) || IReportConfCheckUtil.isStringEmpty(this.valueFormat)) {
            return new StandardCategoryItemLabelGenerator();
        }
        if (this.rangeFormatType.equals("numberFormat")) {
            result = this.createNumCompLineItemLabelGenerator(this.valueFormat, this.rangeFormatValue);
        } else if (this.rangeFormatType.equals("dateFormat")) {
            result = this.createDateCompLineItemLabelpGenerator(this.valueFormat, this.rangeFormatValue);
        } else {
            LOGGER.error((Object)("yFormatType=" + this.rangeFormatType + " is invalid."));
        }
        return result;
    }

    private StandardCategoryItemLabelGenerator createNumCompLineItemLabelGenerator(String valueFormatNew, String rangeFormatValueNew) {
        StandardCategoryItemLabelGenerator result = null;
        try {
            DecimalFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new DecimalFormat() : new DecimalFormat(rangeFormatValueNew);
            result = new StandardCategoryItemLabelGenerator(valueFormatNew, (NumberFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardCategoryItemLabelGenerator();
        }
        return result;
    }

    private StandardCategoryItemLabelGenerator createDateCompLineItemLabelpGenerator(String valueFormatNew, String rangeFormatValueNew) {
        StandardCategoryItemLabelGenerator result = null;
        try {
            SimpleDateFormat rangeFormat = null;
            rangeFormat = IReportConfCheckUtil.isStringEmpty(rangeFormatValueNew) ? new SimpleDateFormat() : new SimpleDateFormat(rangeFormatValueNew);
            result = new StandardCategoryItemLabelGenerator(valueFormatNew, (DateFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            result = new StandardCategoryItemLabelGenerator();
        }
        return result;
    }

    public String getRangeFormatType() {
        return this.rangeFormatType;
    }

    public void setRangeFormatType(String rangeFormatType) {
        this.rangeFormatType = rangeFormatType;
    }

    public String getRangeFormatValue() {
        return this.rangeFormatValue;
    }

    public void setRangeFormatValue(String rangeFormatValue) {
        this.rangeFormatValue = rangeFormatValue;
    }

    public String getDomainFormatValue() {
        return this.domainFormatValue;
    }

    public void setDomainFormatValue(String domainFormatValue) {
        this.domainFormatValue = domainFormatValue;
    }

    public void setToolTipAndLabelGenerator(BarRenderer3D renderer) {
        if (renderer != null) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)this.createCategoryToolTipGenerator());
            renderer.setItemLabelGenerator((CategoryItemLabelGenerator)this.createCategoryItemLabelGenerator());
        }
    }

    public void setToolTipAndLabelGenerator(BarRenderer renderer) {
        if (renderer != null) {
            renderer.setToolTipGenerator((CategoryToolTipGenerator)this.createCategoryToolTipGenerator());
            renderer.setItemLabelGenerator((CategoryItemLabelGenerator)this.createCategoryItemLabelGenerator());
        }
    }

    public void setToolTipAndLabelGenerator(PiePlot3D plot, boolean isLabelShow) {
        if (null == plot) {
            return;
        }
        if (IReportConfCheckUtil.isStringEmpty(this.labelFormat)) {
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            if (!isLabelShow) {
                plot.setLabelGenerator(null);
            } else {
                plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
            }
        } else {
            plot.setToolTipGenerator((PieToolTipGenerator)this.createPieTooltipGenerator(this.labelFormat, this.numberFormat, this.percentFormat));
            if (!isLabelShow) {
                plot.setLabelGenerator(null);
            } else {
                plot.setLabelGenerator((PieSectionLabelGenerator)this.createPieLabelGenerator(this.labelFormat, this.numberFormat, this.percentFormat));
            }
        }
    }

    public void setToolTipAndLabelGenerator(PiePlot plot, boolean isLabelShow) {
        if (null == plot) {
            return;
        }
        if (IReportConfCheckUtil.isStringEmpty(this.labelFormat)) {
            plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            if (!isLabelShow) {
                plot.setLabelGenerator(null);
            } else {
                plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
            }
        } else {
            plot.setToolTipGenerator((PieToolTipGenerator)this.createPieTooltipGenerator(this.labelFormat, this.numberFormat, this.percentFormat));
            if (!isLabelShow) {
                plot.setLabelGenerator(null);
            } else {
                plot.setLabelGenerator((PieSectionLabelGenerator)this.createPieLabelGenerator(this.labelFormat, this.numberFormat, this.percentFormat));
            }
        }
    }

    private StandardPieToolTipGenerator createPieTooltipGenerator(String labelFormatNew, String numberFormatNew, String percentFormatNew) {
        try {
            DecimalFormat domainFormat = null;
            DecimalFormat rangeFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(numberFormatNew) ? new DecimalFormat() : new DecimalFormat(numberFormatNew);
            rangeFormat = IReportConfCheckUtil.isStringEmpty(percentFormatNew) ? new DecimalFormat() : new DecimalFormat(percentFormatNew);
            return new StandardPieToolTipGenerator(labelFormatNew, (NumberFormat)domainFormat, (NumberFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            return new StandardPieToolTipGenerator();
        }
    }

    private StandardPieSectionLabelGenerator createPieLabelGenerator(String labelFormatNew, String numberFormatNew, String percentFormatNew) {
        StandardPieSectionLabelGenerator generator = null;
        try {
            DecimalFormat domainFormat = null;
            DecimalFormat rangeFormat = null;
            domainFormat = IReportConfCheckUtil.isStringEmpty(numberFormatNew) ? new DecimalFormat() : new DecimalFormat(numberFormatNew);
            rangeFormat = IReportConfCheckUtil.isStringEmpty(percentFormatNew) ? new DecimalFormat() : new DecimalFormat(percentFormatNew);
            generator = new StandardPieSectionLabelGenerator(labelFormatNew, (NumberFormat)domainFormat, (NumberFormat)rangeFormat);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            generator = new StandardPieSectionLabelGenerator();
        }
        return generator;
    }
}

