/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.definition.IRColorMap;
import com.security.ireport.engine.definition.IRLabelGenerator;
import com.security.ireport.engine.definition.IRSeriesColor;
import com.security.ireport.model.vo.LegendColor;
import java.util.ArrayList;
import java.util.List;

public class IRPlot
implements Cloneable {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IRSeriesColor> sectionPaintList = new ArrayList<IRSeriesColor>();
    private List<IRColorMap> colorMapList = new ArrayList<IRColorMap>();
    private String orientation = "VERTICAL";
    private IRLabelGenerator labelGenerator = new IRLabelGenerator();
    private float foregroundAlpha = 1.0f;
    private List<LegendColor> legendColorList = new ArrayList<LegendColor>();
    private int showWhenLessNum = -1;
    private int sectionLabelMaxLen = 8;

    public void addLabelGenerator(IRLabelGenerator lblGenerator) {
        this.labelGenerator = lblGenerator;
    }

    public void addIRSeriesColor(IRSeriesColor seriesColor) {
        try {
            this.sectionPaintList.add(seriesColor.getSection(), seriesColor);
        }
        catch (Exception e) {
            LOGGER.error((Object)("seriesColor is add not continue! " + e.getMessage()));
        }
    }

    public void addIRColorMap(IRColorMap colorMap) {
        this.colorMapList.add(colorMap);
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float foregroundAlpha) {
        if (Float.compare(foregroundAlpha, 0.0f) >= 0 && Float.compare(foregroundAlpha, 1.0f) <= 0) {
            this.foregroundAlpha = foregroundAlpha;
        } else {
            LOGGER.error((Object)("foregroundAlpha=" + foregroundAlpha + " not in value range (0-1)"));
        }
    }

    public List<IRSeriesColor> getSectionPaintList() {
        return this.sectionPaintList;
    }

    public void setSectionPaintList(List<IRSeriesColor> sectionPaintList) {
        this.sectionPaintList = sectionPaintList;
    }

    public List<IRColorMap> getColorMapList() {
        return this.colorMapList;
    }

    public void setColorMapList(List<IRColorMap> colorMapList) {
        this.colorMapList = colorMapList;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public IRLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(IRLabelGenerator labelGenerator) {
        this.labelGenerator = labelGenerator;
    }

    public List<LegendColor> getLegendColorList() {
        return this.legendColorList;
    }

    public void setLegendColorList(List<LegendColor> legendColorList) {
        this.legendColorList = legendColorList;
    }

    public List<String> getAllColorList() {
        ArrayList<String> colorList = new ArrayList<String>();
        if (this.sectionPaintList != null && !this.sectionPaintList.isEmpty()) {
            for (IRSeriesColor iRSeriesColor : this.sectionPaintList) {
                if (colorList.contains(iRSeriesColor.getColor())) continue;
                colorList.add(iRSeriesColor.getColor());
            }
        }
        if (this.colorMapList != null && !this.colorMapList.isEmpty()) {
            for (IRColorMap iRColorMap : this.colorMapList) {
                if (colorList.contains(iRColorMap.getColor())) continue;
                colorList.add(iRColorMap.getColor());
            }
        }
        return colorList;
    }

    protected IRPlot clone() throws CloneNotSupportedException {
        IRPlot newObj = (IRPlot)super.clone();
        newObj.sectionPaintList = new ArrayList<IRSeriesColor>();
        for (IRSeriesColor item : this.sectionPaintList) {
            newObj.sectionPaintList.add(item.clone());
        }
        newObj.colorMapList = new ArrayList<IRColorMap>();
        for (IRColorMap color : this.colorMapList) {
            newObj.colorMapList.add(color.clone());
        }
        newObj.legendColorList = new ArrayList<LegendColor>();
        for (LegendColor lcolor : this.legendColorList) {
            newObj.legendColorList.add(lcolor.clone());
        }
        return newObj;
    }

    public int getShowWhenLessNum() {
        return this.showWhenLessNum;
    }

    public void setShowWhenLessNum(int showWhenLessNum) {
        this.showWhenLessNum = showWhenLessNum;
    }

    public int getSectionLabelMaxLen() {
        return this.sectionLabelMaxLen;
    }

    public void setSectionLabelMaxLen(int sectionLabelMaxLen) {
        this.sectionLabelMaxLen = sectionLabelMaxLen;
    }
}

