/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.definition;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.dataset.PojoFieldAnalyse;
import com.security.ireport.engine.definition.ComponentElement;
import com.security.ireport.engine.definition.HeaderColumn;
import com.security.ireport.engine.definition.HeaderRow;
import com.security.ireport.engine.definition.IJasperReportBuilder;
import com.security.ireport.engine.definition.IRChart;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRDefine;
import com.security.ireport.engine.definition.IRSwitchOption;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IRTextField;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.definition.ProductExportType;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JasperReportConfigFactory;
import com.security.ireport.util.ProductFaceUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class JasperDefinitionParser {
    public static final int CONDITION_HEIGHT = 15;
    public static final int ROW_MARGIN = ProductExportType.getProductExportType(ProductFaceUtil.getInstance().getProductName()).getRowMargin();
    public static final String PAGEFOOTER_HEITHT = "50";
    public static final int PAGEFOOTER_WIDTH = 60;
    public static final int CURPAGENUM_TOTALPAGENUM_WIDTH = 12;
    public static final int CURPAGENUM_TOTALPAGENUM_TOP_HEIGHT = 22;
    public static final int CURPAGENUM_TOTALPAGENUM_HEIGHT = 25;
    public static final int LINE_LENGTH = 48;
    public static final int RIGHT_MARGIN = 5;
    public static final int COMPONENTELEMENT_HEIGHT = 70;
    public static final int PERCENT_20 = 20;
    public static final int PERCENT_10 = 10;
    public static final int PERCENT_72 = 72;
    public static final int PERCENT_100 = 100;
    public static final String FONT_SIZE = "12";
    public static final int REPORT_TITLE_HEIGHT = 20;
    public static final int CHART_HEIGHT = 50;
    public static final int CHART_LEGEND_HEIGHT = 10;
    public static final int CHART_REPORT_ELEMENT_HEIGHT = 60;
    public static final int LEGEND_HEIGHT = 10;
    public static final int TABLE_TITLE_HEIGHT = 20;
    public static final int TABLE_HEIGHT = 30;
    public static final int TABLE_CELL_HEIGHT = 15;
    public static final int TABLE_HEADER_HEIGHT = 15;
    public static final int TABLE_NUM_WIDTH = 30;
    public static final int PAGE_HEIGHT_MARGIN = 200;
    public static final int DEFAULT_PAGE_HEIGHT = 120;
    public static final int PAGE_HEIGHT_DEFAULT = 842;
    private static final int DEFAULT_ZERO = 0;
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private int elementWidth;
    private int summaryBandHeight = 0;
    private IReport report;
    private IJasperReportBuilder jasperReportBuilder = new JasperReportBuilderImpl();
    private List<Element> subDatasetList = new ArrayList<Element>();
    private List<Element> parameterList = new ArrayList<Element>();
    private List<Element> componentElementList = new ArrayList<Element>();
    private List<Integer> rowStartHeightList = new ArrayList<Integer>();
    private boolean isTextField = false;
    private String componentKey;

    public JasperDefinitionParser(IReport report) {
        this.report = report;
    }

    public void buildJasperReport() {
        if (this.report.isUseProductDefine()) {
            return;
        }
        if (this.notNeedStart() && !this.needRebuildJasper()) {
            return;
        }
        this.cleanJasperFile(IReportUtil.getPluginPath() + this.report.getId());
        IRSwitchOption switchOption = this.report.getIRSwitchOption();
        if (null == switchOption) {
            this.justBuildJasperReport("");
        } else {
            for (String caseValue : switchOption.getCaseValueList()) {
                this.justBuildJasperReport(caseValue);
            }
        }
    }

    public void buildJasperReport(String caseValue) {
        if (!this.needRebuildJasper(caseValue)) {
            return;
        }
        this.justBuildJasperReport(caseValue);
    }

    public static String createJasperFilePath(String caseValue, IReport report, String suffix) {
        String jasperFileName = JasperDefinitionParser.createJasperFileName(caseValue, report);
        return IReportUtil.getPluginPath() + report.getId() + '/' + jasperFileName + '.' + suffix;
    }

    private static String createJasperFileName(String caseValue, IReport report) {
        StringBuffer result = new StringBuffer();
        result.append("rpt");
        if (!IReportConfCheckUtil.isStringEmpty(caseValue)) {
            result.append(caseValue);
        }
        if (report.isFlexTable()) {
            List<ComponentElement> elementList = report.getElementList(caseValue);
            for (ComponentElement item : elementList) {
                if (!(item instanceof IRTable) || !((IRTable)item).isFlexTable()) continue;
                IRTable temp = (IRTable)item;
                result.append('_').append(temp.getId()).append('@').append(temp.getIRColumnList().size());
            }
        }
        return result.toString();
    }

    private String getXmlFileName(String caseValue) {
        String fileName = IReportUtil.getJasperTemplatePath() + this.report.getIRDefine(caseValue).getTemplate() + ".jrxml";
        return fileName;
    }

    private Element createParameter(String name, String classType) {
        Document document = DocumentHelper.createDocument();
        Element parameter = document.addElement("parameter");
        parameter.addAttribute("name", name);
        parameter.addAttribute("class", classType);
        return parameter;
    }

    private Element createField(String name, String classType) {
        Document document = DocumentHelper.createDocument();
        Element field = document.addElement("field");
        field.addAttribute("name", name);
        field.addAttribute("class", classType);
        Element fieldDescription = field.addElement("fieldDescription");
        fieldDescription.addCDATA(name);
        return field;
    }

    private Element createSubDataset(String name) {
        Document document = DocumentHelper.createDocument();
        Element subDataset = document.addElement("subDataset");
        subDataset.addAttribute("name", name);
        return subDataset;
    }

    private Element createTextElement(String size, String isBold, String textAlignment) {
        Document document = DocumentHelper.createDocument();
        Element textElement = document.addElement("textElement");
        textElement.addAttribute("verticalAlignment", "Middle");
        textElement.addAttribute("textAlignment", textAlignment);
        Element font = textElement.addElement("font");
        if (size != null) {
            font.addAttribute("size", size);
        }
        if (isBold != null) {
            font.addAttribute("isBold", isBold);
        }
        font.addAttribute("pdfFontName", IReportConfigUtil.getInstance().getJasperPdfFontName());
        font.addAttribute("pdfEncoding", "Identity-H");
        font.addAttribute("isPdfEmbedded", "true");
        return textElement;
    }

    private Element createTextElement(String size, String isBold) {
        Document document = DocumentHelper.createDocument();
        Element textElement = document.addElement("textElement");
        Element font = textElement.addElement("font");
        if (size != null) {
            font.addAttribute("size", size);
        }
        if (isBold != null) {
            font.addAttribute("isBold", isBold);
        }
        font.addAttribute("pdfFontName", IReportConfigUtil.getInstance().getJasperPdfFontName());
        font.addAttribute("pdfEncoding", "Identity-H");
        font.addAttribute("isPdfEmbedded", "true");
        return textElement;
    }

    private Element createTextField(String style, String printWhenExpression, int width, int height, String classType, String value, String textAlignment) {
        String stretchType = "RelativeToBandHeight";
        int left = 0;
        int top = 0;
        String size = FONT_SIZE;
        if (null != value && value.contains("_COLUMN_FIRST_CODE_")) {
            size = "13";
        }
        if (null != value && "$P{IREPORT_SECURITY_DEFAULT_VALUE}".equals(value)) {
            size = "16";
        }
        return this.createTextField(style, stretchType, printWhenExpression, left, top, width, height, classType, value, size, null, textAlignment, Boolean.FALSE);
    }

    private Element createTextField(String style, String stretchType, String printWhenExpression, int left, int top, int width, int height, String classType, String value, String size, String isBold, String textAlignment, boolean isRemoveLineWhenBlank) {
        Document document = DocumentHelper.createDocument();
        Element textField = document.addElement("textField");
        textField.addAttribute("isStretchWithOverflow", "true");
        textField.addAttribute("isBlankWhenNull", "true");
        Element reportElement = this.createReportElement(style, stretchType, printWhenExpression, left, top, width, height);
        if (isRemoveLineWhenBlank) {
            reportElement.addAttribute("isRemoveLineWhenBlank", "true");
        }
        textField.add(reportElement);
        textField.add(this.createTextElement(size, isBold, textAlignment));
        Element textFieldExpression = textField.addElement("textFieldExpression");
        textFieldExpression.addAttribute("class", classType);
        textFieldExpression.addCDATA(value);
        return textField;
    }

    private Element createTextField(String style, String stretchType, String printWhenExpression, int left, int top, int width, int height, String classType, String value, String size, String isBold) {
        Document document = DocumentHelper.createDocument();
        Element textField = document.addElement("textField");
        textField.addAttribute("isStretchWithOverflow", "true");
        textField.addAttribute("isBlankWhenNull", "true");
        textField.add(this.createReportElement(style, stretchType, printWhenExpression, left, top, width, height));
        textField.add(this.createTextElement(size, isBold));
        Element textFieldExpression = textField.addElement("textFieldExpression");
        textFieldExpression.addAttribute("class", classType);
        textFieldExpression.addCDATA(value);
        return textField;
    }

    private void addReportTitle(IRDefine reportDefine) {
        this.parameterList.add(this.createParameter("reportTitle", "java.lang.String"));
        this.parameterList.add(this.createParameter("reportMainTitle", "java.lang.String"));
        int width = this.report.getPageWidth() - 5;
        boolean isMainTitleShow = !IReportConfCheckUtil.isStringEmpty(reportDefine.getMainTitle());
        int totalHeight = 60;
        int reportTitleStartIndex = 42;
        if (!isMainTitleShow) {
            totalHeight = 20;
            reportTitleStartIndex = 0;
        }
        Document document = DocumentHelper.createDocument();
        Element componentElement = document.addElement("frame");
        componentElement.add(this.createReportElement(null, null, null, 0, 0, width, totalHeight));
        if (isMainTitleShow) {
            Element mainTitle = this.createTextField(null, null, isMainTitleShow + "", 0, 0, width, 25, "java.lang.String", "$P{reportMainTitle}", reportDefine.getMainTitleFontSize() + "", reportDefine.isMainTitleBold() + "", "Center", Boolean.FALSE);
            componentElement.add(mainTitle);
            Element mainTitleLine = componentElement.addElement("line");
            Element mainTitleLineReportElement = this.createReportElement(null, null, isMainTitleShow + "", 0, 30, width, 1);
            mainTitleLineReportElement.addAttribute("forecolor", "#660000");
            mainTitleLine.add(mainTitleLineReportElement);
        }
        Element reportTitle = componentElement.addElement("textField");
        reportTitle.addAttribute("isStretchWithOverflow", "true");
        reportTitle.addAttribute("hyperlinkType", "None");
        reportTitle.addAttribute("hyperlinkTarget", "self");
        String isShowPage = IReportConfigUtil.getInstance().getConfig("ireport.show.headPage").trim();
        if (isShowPage.equals("true")) {
            reportTitle.addAttribute("bookmarkLevel", "2");
        } else {
            reportTitle.addAttribute("bookmarkLevel", "1");
        }
        reportTitle.addAttribute("isBlankWhenNull", "false");
        reportTitle.addAttribute("evaluationTime", "Now");
        reportTitle.add(this.createReportElement(null, "RelativeToBandHeight", String.valueOf(reportDefine.isShowReportTitle()), 0, reportTitleStartIndex, width, 14));
        Element textElement = this.createTextElement(reportDefine.getTitleFontSize() + "", reportDefine.isTitleBold() + "");
        textElement.addAttribute("textAlignment", "Center");
        textElement.addAttribute("verticalAlignment", "Middle");
        reportTitle.add(textElement);
        Element textFieldExpression = reportTitle.addElement("textFieldExpression");
        textFieldExpression.addAttribute("class", "java.lang.String");
        textFieldExpression.addCDATA("$P{reportTitle}");
        Element nameExpression = reportTitle.addElement("anchorNameExpression");
        nameExpression.addCDATA("$P{reportTitle}");
        this.componentElementList.add(componentElement);
        this.summaryBandHeight = !isMainTitleShow ? 30 : 70;
    }

    private Element createImage(int left, int top, int width, int height, String value) {
        Document document = DocumentHelper.createDocument();
        Element image = document.addElement("image");
        image.addAttribute("scaleImage", "RealSize");
        image.add(this.createReportElement(null, null, null, left, top, width, height));
        Element imageExpression = image.addElement("imageExpression");
        imageExpression.addCDATA("$F{" + value + "}");
        return image;
    }

    private Element createReportElement(String style, String stretchType, String printWhenExpression, int left, int top, int width, int height) {
        Document document = DocumentHelper.createDocument();
        Element reportElement = document.addElement("reportElement");
        if (style != null) {
            reportElement.addAttribute("style", style);
        }
        reportElement.addAttribute("positionType", "Float");
        if (stretchType != null) {
            reportElement.addAttribute("stretchType", stretchType);
        }
        if (printWhenExpression != null) {
            Element printWhenExpressionE = reportElement.addElement("printWhenExpression");
            printWhenExpressionE.addCDATA(printWhenExpression);
        }
        reportElement.addAttribute("x", String.valueOf(left));
        reportElement.addAttribute("y", String.valueOf(top));
        reportElement.addAttribute("width", String.valueOf(width));
        reportElement.addAttribute("height", String.valueOf(height));
        return reportElement;
    }

    private void addChart(IRChart iRChart, int row, int column, int colspan) {
        this.parameterList.add(this.createParameter(iRChart.getId() + "DS", "net.sf.jasperreports.engine.data.JRBeanCollectionDataSource"));
        this.parameterList.add(this.createParameter(iRChart.getId() + "_show", "java.lang.Boolean"));
        Element subDataset = this.createSubDataset(iRChart.getId() + "DS");
        subDataset.add(this.createField("path", "java.lang.String"));
        subDataset.add(this.createField("legendDs", "net.sf.jasperreports.engine.data.JRTableModelDataSource"));
        subDataset.add(this.createField("showLegend", "java.lang.Boolean"));
        this.subDatasetList.add(subDataset);
        Document document = DocumentHelper.createDocument();
        Element componentElement = document.addElement("componentElement");
        String printWhenExpression = "$P{" + iRChart.getId() + "_show" + "}";
        int left = column * this.elementWidth;
        if (this.rowStartHeightList.size() > row) {
            this.summaryBandHeight = this.rowStartHeightList.get(row);
        } else {
            this.rowStartHeightList.add(this.summaryBandHeight);
        }
        int width = this.elementWidth * colspan - 5;
        componentElement.add(this.createReportElement(null, null, printWhenExpression, left, this.summaryBandHeight, width, 2));
        this.summaryBandHeight += 2;
        Element jrTable = componentElement.addElement("table");
        jrTable.addNamespace("jr", "http://jasperreports.sourceforge.net/jasperreports/components");
        jrTable.setName("jr:table");
        jrTable.addAttribute("xsi:schemaLocation", "http://jasperreports.sourceforge.net/jasperreports/components http://jasperreports.sourceforge.net/xsd/components.xsd");
        Element datasetRun = jrTable.addElement("datasetRun");
        datasetRun.addAttribute("subDataset", iRChart.getId() + "DS");
        Element dataSourceExpression = datasetRun.addElement("dataSourceExpression");
        dataSourceExpression.addCDATA("$P{" + iRChart.getId() + "DS}");
        Element jrColumn = jrTable.addElement("jr:column");
        jrColumn.addAttribute("width", String.valueOf(this.elementWidth * colspan - 5));
        Element jrDetailCell = jrColumn.addElement("jr:detailCell");
        jrDetailCell.addAttribute("height", "2");
        jrDetailCell.addAttribute("rowSpan", "1");
        jrDetailCell.add(this.createImage(0, 0, this.elementWidth * colspan - 5, 2, "path"));
        this.componentElementList.add(componentElement);
    }

    private void addChartLegend(IRChart iRChart, int column, int colspan, boolean isFourCol) {
        String subreportDs = iRChart.getId() + "_legendDs";
        this.parameterList.add(this.createParameter(subreportDs, "net.sf.jasperreports.engine.data.JRTableModelDataSource"));
        Document document = DocumentHelper.createDocument();
        Element componentElement = document.addElement("frame");
        int left = column * this.elementWidth;
        int width = this.elementWidth * colspan - 5;
        componentElement.add(this.createReportElement(null, null, null, left, this.summaryBandHeight, width, 0));
        componentElement.add(this.createImageLegendSub(0, 0, this.elementWidth * colspan - 5, 0, subreportDs, isFourCol));
        this.componentElementList.add(componentElement);
    }

    private Element createImageLegendSub(int left, int top, int width, int height, String value, boolean isFourCol) {
        Document document = DocumentHelper.createDocument();
        Element subreport = document.addElement("subreport");
        subreport.add(this.createReportElement(null, null, null, left, top, width, height));
        Element dataSourceExpression = subreport.addElement("dataSourceExpression");
        dataSourceExpression.addCDATA("$P{" + value + "}");
        Element subreportExpression = subreport.addElement("subreportExpression");
        subreportExpression.addAttribute("class", "java.lang.String");
        String jasperName = IReportUtil.getJasperTemplatePath() + "/" + "fourColLegendSubreport" + ".jasper";
        if (!isFourCol) {
            jasperName = IReportUtil.getJasperTemplatePath() + "/" + "twoColLegendSubreport" + ".jasper";
        }
        subreportExpression.addCDATA("\"" + jasperName + "\"");
        return subreport;
    }

    private void addComponentInterval() {
        Document document = DocumentHelper.createDocument();
        Element componentElement = document.addElement("frame");
        int left = 0;
        int width = this.report.getPageWidth() - 5;
        int tempHeight = 0;
        String parameterName = "$P{IREPORT_SECURITY_DEFAULT_VALUE}";
        if (this.isTextField) {
            parameterName = this.componentKey + "_Text_Space";
            this.parameterList.add(this.createParameter(parameterName, "java.lang.String"));
            parameterName = "$P{" + parameterName + "}";
        }
        Element reportElement = this.createReportElement(null, null, null, left, this.summaryBandHeight, width, tempHeight);
        componentElement.add(reportElement);
        componentElement.add(this.createTextField(null, null, width, tempHeight, "java.lang.String", parameterName, "Center"));
        this.componentElementList.add(componentElement);
        this.isTextField = false;
    }

    private void addIRTextField(IRTextField textField, int row, int column, int colspan) {
        if (this.rowStartHeightList.size() > row) {
            int tempSummaryBandHeight = this.rowStartHeightList.get(row);
            if (this.summaryBandHeight > tempSummaryBandHeight) {
                tempSummaryBandHeight = this.summaryBandHeight;
            }
            this.rowStartHeightList.set(row, tempSummaryBandHeight);
        } else {
            this.rowStartHeightList.add(this.summaryBandHeight);
        }
        this.isTextField = true;
        this.componentKey = textField.getId();
        this.parameterList.add(this.createParameter(this.componentKey + "_Text", "java.lang.String"));
        int titleLeft = column * this.elementWidth;
        int width = this.elementWidth * colspan - 5;
        int tempHeight = 0;
        boolean tempBoolean = Boolean.TRUE;
        Element textFieldElement = this.createTextField(null, null, null, titleLeft, this.summaryBandHeight, width, tempHeight, "java.lang.String", "$P{" + this.componentKey + "_Text}", textField.getFontSize() + "", textField.isBold() + "", "Left", tempBoolean);
        if (null != textField.getBookmarkLevel()) {
            textFieldElement.addAttribute("bookmarkLevel", textField.getBookmarkLevel());
            textFieldElement.addElement("anchorNameExpression").addCDATA("$P{" + textField.getId() + "_Text}");
        }
        this.componentElementList.add(textFieldElement);
    }

    private void addTable(IRTable iRTable, int row, int column, int colspan, String caseValue) {
        this.parameterList.add(this.createParameter(iRTable.getId() + "Title", "java.lang.String"));
        this.parameterList.add(this.createParameter(iRTable.getId() + "_show", "java.lang.Boolean"));
        this.parameterList.add(this.createParameter(iRTable.getId() + "_isGroup", "java.lang.Boolean"));
        this.parameterList.add(this.createParameter(iRTable.getId() + "DS", "net.sf.jasperreports.engine.data.JRTableModelDataSource"));
        Element subDataset = this.createSubDataset(iRTable.getId() + "DS");
        this.subDatasetList.add(subDataset);
        subDataset.add(this.createParameter(iRTable.getId() + "_COLUMN_FIRST_CODE_", "java.lang.String"));
        String printWhenExpression = "$P{" + iRTable.getId() + "_show" + "}";
        if (this.rowStartHeightList.size() > row) {
            this.summaryBandHeight = this.rowStartHeightList.get(row);
        } else {
            this.rowStartHeightList.add(this.summaryBandHeight);
        }
        int titleLeft = column * this.elementWidth;
        int titleWidth = this.elementWidth * colspan - 5;
        this.componentElementList.add(this.createTextField(null, null, printWhenExpression, titleLeft, this.summaryBandHeight, titleWidth, 0, "java.lang.String", "$P{" + iRTable.getId() + "Title}", FONT_SIZE, "true"));
        if (!IReportConfCheckUtil.isStringEmpty(iRTable.getUseJasper())) {
            this.createTableSubreport(iRTable, column, colspan);
            this.createTableDataset(iRTable, subDataset);
            return;
        }
        if (iRTable.getIRColumnList() == null || iRTable.getIRColumnList().isEmpty()) {
            return;
        }
        int columnWidthSum = iRTable.getExportColumnWidthSun();
        int left = column * this.elementWidth;
        this.handleTableExtendHeader(iRTable, colspan, columnWidthSum, printWhenExpression, left);
        Document document = DocumentHelper.createDocument();
        Element componentElement = document.addElement("componentElement");
        int width = this.elementWidth * colspan - 5;
        componentElement.add(this.createReportElement("table", null, printWhenExpression, left, this.summaryBandHeight, width, 2));
        Element jrTable = componentElement.addElement("table");
        jrTable.addNamespace("jr", "http://jasperreports.sourceforge.net/jasperreports/components");
        jrTable.setName("jr:table");
        jrTable.addAttribute("xsi:schemaLocation", "http://jasperreports.sourceforge.net/jasperreports/components http://jasperreports.sourceforge.net/xsd/components.xsd");
        Element datasetRun = jrTable.addElement("datasetRun");
        datasetRun.addAttribute("subDataset", iRTable.getId() + "DS");
        this.parameterList.add(this.createParameter(iRTable.getId() + "_COLUMN_FIRST_CODE_", "java.lang.String"));
        if (columnWidthSum != 0 && !iRTable.isFlexTable() && iRTable.isSerialNumShow()) {
            Element jrColumnNum = jrTable.addElement("jr:column");
            jrColumnNum.addAttribute("width", String.valueOf(30));
            Element jrColumnHeader = jrColumnNum.addElement("jr:columnHeader");
            jrColumnHeader.addAttribute("height", "1");
            jrColumnHeader.addAttribute("rowSpan", "1");
            jrColumnHeader.add(this.createTextField("table_CH", null, 30, 1, "java.lang.String", "$P{" + iRTable.getId() + "_COLUMN_FIRST_CODE_" + "}", "Center"));
            Element jrDetailCellNum = jrColumnNum.addElement("jr:detailCell");
            jrDetailCellNum.addAttribute("height", "1");
            jrDetailCellNum.addAttribute("rowSpan", "1");
            Element jrDetailCellTextField1 = this.createTextField("table_TD_1", "RelativeToBandHeight", "new Boolean($V{REPORT_COUNT}.intValue()%2==1)", 0, 0, 30, 1, "java.lang.Integer", "$V{REPORT_COUNT}", FONT_SIZE, null);
            this.setHeaderDetailCell(jrDetailCellTextField1);
            jrDetailCellNum.add(jrDetailCellTextField1);
            Element jrDetailCellTextField2 = this.createTextField("table_TD_2", "RelativeToBandHeight", "new Boolean($V{REPORT_COUNT}.intValue()%2==0)", 0, 0, 30, 1, "java.lang.Integer", "$V{REPORT_COUNT}", FONT_SIZE, null);
            this.setHeaderDetailCell(jrDetailCellTextField2);
            jrDetailCellNum.add(jrDetailCellTextField2);
        }
        this.handleTabelCell(iRTable, datasetRun, colspan, columnWidthSum, jrTable, subDataset, caseValue);
        Element dataSourceExpression = datasetRun.addElement("dataSourceExpression");
        dataSourceExpression.addCDATA("$P{" + iRTable.getId() + "DS}");
        this.componentElementList.add(componentElement);
        this.summaryBandHeight += 2;
    }

    private void createTableSubreport(IRTable iRTable, int column, int colspan) {
        Document document = DocumentHelper.createDocument();
        Element componentElement = document.addElement("frame");
        int left = column * this.elementWidth;
        int width = this.elementWidth * colspan - 5;
        componentElement.add(this.createReportElement(null, null, null, left, this.summaryBandHeight, width, 30));
        Element subreport = componentElement.addElement("subreport");
        subreport.add(this.createReportElement(null, null, null, left, 0, width, 30));
        Element subPara = null;
        Element subParaExp = null;
        String paraName = "";
        for (int i = 0; i < iRTable.getIRColumnList().size(); ++i) {
            paraName = iRTable.getId() + "Column" + i;
            subPara = subreport.addElement("subreportParameter");
            subPara.addAttribute("name", paraName);
            subParaExp = subPara.addElement("subreportParameterExpression");
            subParaExp.addCDATA("$P{" + paraName + "}");
        }
        Element dataSourceExpression = subreport.addElement("dataSourceExpression");
        dataSourceExpression.addCDATA("$P{" + iRTable.getId() + "DS}");
        Element subreportExpression = subreport.addElement("subreportExpression");
        subreportExpression.addAttribute("class", "java.lang.String");
        String jasperName = IReportUtil.getJasperTemplatePath() + "/" + iRTable.getUseJasper();
        subreportExpression.addCDATA("\"" + jasperName + "\"");
        this.componentElementList.add(componentElement);
        this.summaryBandHeight += 30 + ROW_MARGIN;
    }

    private void createTableDataset(IRTable iRTable, Element subDataset) {
        Map<String, FieldInfo> fieldInfoMap = PojoFieldAnalyse.getDataSourceFieldInfoMap(this.report, iRTable);
        ArrayList<Element> parameterListSub = new ArrayList<Element>();
        ArrayList<Element> fieldListSub = new ArrayList<Element>();
        String columnFieldType = null;
        for (int i = 0; i < iRTable.getIRColumnList().size(); ++i) {
            IRColumn iRColumn = iRTable.getIRColumnList().get(i);
            if (!iRColumn.isColumnExport()) continue;
            this.parameterList.add(this.createParameter(iRTable.getId() + "Column" + i, "java.lang.String"));
            parameterListSub.add(this.createParameter(iRTable.getId() + "Column" + i, "java.lang.String"));
            if (iRTable.isFlexTable()) {
                columnFieldType = "java.lang.String";
                fieldListSub.add(this.createField("FlexColumn" + i, columnFieldType));
                continue;
            }
            columnFieldType = IReportConfCheckUtil.isSpecialField(iRColumn.getField()) ? "java.lang.String" : fieldInfoMap.get(iRColumn.getField()).getFieldType();
            fieldListSub.add(this.createField(iRColumn.getField(), columnFieldType));
        }
        for (Element parameterSub : parameterListSub) {
            subDataset.add(parameterSub);
        }
        for (Element fieldSub : fieldListSub) {
            subDataset.add(fieldSub);
        }
    }

    private void handleTabelCell(IRTable iRTable, Element datasetRun, int colspan, int columnWidthSum, Element jrTable, Element subDataset, String caseValue) {
        Map<String, FieldInfo> fieldInfoMap = PojoFieldAnalyse.getDataSourceFieldInfoMap(this.report, iRTable);
        ArrayList<Element> parameterListSub = new ArrayList<Element>();
        parameterListSub.add(this.createParameter(iRTable.getId() + "_isGroup", "java.lang.Boolean"));
        Element datasetParameter = datasetRun.addElement("datasetParameter");
        datasetParameter.addAttribute("name", iRTable.getId() + "_isGroup");
        Element datasetParameterExpression = datasetParameter.addElement("datasetParameterExpression");
        datasetParameterExpression.addCDATA("$P{" + iRTable.getId() + "_isGroup" + "}");
        datasetParameter = datasetRun.addElement("datasetParameter");
        datasetParameter.addAttribute("name", iRTable.getId() + "_COLUMN_FIRST_CODE_");
        datasetParameterExpression = datasetParameter.addElement("datasetParameterExpression");
        datasetParameterExpression.addCDATA("$P{" + iRTable.getId() + "_COLUMN_FIRST_CODE_" + "}");
        ArrayList<Element> fieldListSub = new ArrayList<Element>();
        for (int i = 0; i < iRTable.getIRColumnList().size(); ++i) {
            String printWhenExpression;
            String tableIsGroupParam;
            IRColumn iRColumn = iRTable.getIRColumnList().get(i);
            if (!iRColumn.isColumnExport()) continue;
            this.parameterList.add(this.createParameter(iRTable.getId() + "Column" + i, "java.lang.String"));
            parameterListSub.add(this.createParameter(iRTable.getId() + "Column" + i, "java.lang.String"));
            datasetParameter = datasetRun.addElement("datasetParameter");
            datasetParameter.addAttribute("name", iRTable.getId() + "Column" + i);
            datasetParameterExpression = datasetParameter.addElement("datasetParameterExpression");
            datasetParameterExpression.addCDATA("$P{" + iRTable.getId() + "Column" + i + "}");
            String columnFieldType = null;
            if (iRTable.isFlexTable()) {
                columnFieldType = "java.lang.String";
                fieldListSub.add(this.createField("FlexColumn" + i, columnFieldType));
            } else {
                columnFieldType = IReportConfCheckUtil.isSpecialField(iRColumn.getField()) ? "java.lang.String" : fieldInfoMap.get(iRColumn.getField()).getFieldType();
                fieldListSub.add(this.createField(iRColumn.getField(), columnFieldType));
            }
            int columnWidth = iRTable.isSerialNumShow() ? Integer.parseInt(iRColumn.getWidth()) * (this.elementWidth * colspan - 5 - 30) / columnWidthSum : Integer.parseInt(iRColumn.getWidth()) * (this.elementWidth * colspan - 5) / columnWidthSum;
            iRColumn.setJasperWidth(caseValue, columnWidth);
            Element jrColumn = jrTable.addElement("jr:column");
            jrColumn.addAttribute("width", String.valueOf(columnWidth));
            Element jrColumnHeader = jrColumn.addElement("jr:columnHeader");
            jrColumnHeader.addAttribute("height", "1");
            jrColumnHeader.addAttribute("rowSpan", "1");
            jrColumnHeader.add(this.createTextField("table_CH", null, columnWidth, 1, "java.lang.String", "$P{" + iRTable.getId() + "Column" + i + "}", "Center"));
            Element jrDetailCell = jrColumn.addElement("jr:detailCell");
            jrDetailCell.addAttribute("height", "1");
            jrDetailCell.addAttribute("rowSpan", "1");
            if (null != iRColumn.getChartRef() && iRColumn.getChartRef().length() > 0) {
                jrDetailCell.add(this.addTableCellImage(iRColumn.getField(), "table_TD_1", "new Boolean($V{REPORT_COUNT}.intValue()%2==1)", 0, 0, columnWidth, 1));
                jrDetailCell.add(this.addTableCellImage(iRColumn.getField(), "table_TD_2", "new Boolean($V{REPORT_COUNT}.intValue()%2==0)", 0, 0, columnWidth, 1));
                continue;
            }
            String textAlignment = "Center";
            String productName = IReportConfigUtil.getInstance().getProductName();
            boolean isVSM = "VSM V2".equalsIgnoreCase(productName);
            if (!isVSM) {
                textAlignment = iRTable.isFlexTable() && i != 0 ? "Right" : iRColumn.getTextAlign();
            } else if (!iRTable.isFlexTable()) {
                textAlignment = iRColumn.getTextAlign();
            }
            if (iRTable.getGroupNum() > 1 && i < iRTable.getGroupNum()) {
                tableIsGroupParam = "$P{" + iRTable.getId() + "_isGroup" + "}";
                printWhenExpression = "new Boolean($V{REPORT_COUNT}.intValue()%2==1 && !" + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_TD_1", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                printWhenExpression = "new Boolean($V{REPORT_COUNT}.intValue()%2==0 && !" + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_TD_2", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                printWhenExpression = "new Boolean(!$F{" + iRColumn.getField() + "}.equals(\"\") && " + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_group_TD_first", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                printWhenExpression = "new Boolean($F{" + iRColumn.getField() + "}.equals(\"\") && " + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_group_TD_other", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                continue;
            }
            if (0 == i && iRTable.isGroupTable()) {
                tableIsGroupParam = "$P{" + iRTable.getId() + "_isGroup" + "}";
                printWhenExpression = "new Boolean($V{REPORT_COUNT}.intValue()%2==1 && !" + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_TD_1", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                printWhenExpression = "new Boolean($V{REPORT_COUNT}.intValue()%2==0 && !" + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_TD_2", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                printWhenExpression = "new Boolean(!$F{" + iRColumn.getField() + "}.equals(\"\") && " + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_group_TD_first", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                printWhenExpression = "new Boolean($F{" + iRColumn.getField() + "}.equals(\"\") && " + tableIsGroupParam + ")";
                jrDetailCell.add(this.createTextField("table_group_TD_other", printWhenExpression, columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
                continue;
            }
            jrDetailCell.add(this.createTextField("table_TD_1", "new Boolean($V{REPORT_COUNT}.intValue()%2==1)", columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
            jrDetailCell.add(this.createTextField("table_TD_2", "new Boolean($V{REPORT_COUNT}.intValue()%2==0)", columnWidth, 1, columnFieldType, "$F{" + iRColumn.getField() + "}", textAlignment));
        }
        for (Element parameterSub : parameterListSub) {
            subDataset.add(parameterSub);
        }
        for (Element fieldSub : fieldListSub) {
            subDataset.add(fieldSub);
        }
    }

    private void handleTableExtendHeader(IRTable iRTable, int colspan, int columnWidthSum, String printWhenExpression, int left) {
        List<Integer> columnWidthList = this.getTableAllColumnWidth(iRTable, colspan, columnWidthSum);
        for (int i = 0; i < iRTable.getHeaderRowList().size(); ++i) {
            this.handleTableExtendHeaderRow(iRTable.getId(), i, iRTable.getHeaderRowList().get(i), columnWidthList, printWhenExpression, left);
        }
    }

    private void handleTableExtendHeaderRow(String tableId, int rowNo, HeaderRow headerRow, List<Integer> columnWidthList, String printWhenExpression, int totalLeft) {
        Document document = DocumentHelper.createDocument();
        Element frameElement = document.addElement("frame");
        int totalWidth = 0;
        for (int colWidth : columnWidthList) {
            totalWidth += colWidth;
        }
        frameElement.add(this.createReportElement(null, null, null, totalLeft, this.summaryBandHeight, totalWidth, 0));
        int left = 0;
        int width = 0;
        HeaderColumn item = null;
        int startIndex = 0;
        int endIndex = -1;
        for (int j = 0; j < headerRow.getHeaderColumnList().size(); ++j) {
            item = headerRow.getHeaderColumnList().get(j);
            startIndex = endIndex + 1;
            width = this.getCountValue(columnWidthList, startIndex, endIndex += item.getExportColspan());
            String parameterName = tableId + "_HeaderStretch_row" + rowNo + "col" + j;
            this.parameterList.add(this.createParameter(parameterName, "java.lang.String"));
            frameElement.add(this.createTextField("table_CH_Stretch", "RelativeToBandHeight", printWhenExpression, left, 0, width, 0, "java.lang.String", "$P{" + parameterName + "}", FONT_SIZE, "true", "Center", Boolean.FALSE));
            left += width;
        }
        this.componentElementList.add(frameElement);
    }

    private int getCountValue(List<Integer> columnWidthList, int startIndex, int endIndex) {
        int iBegin;
        int count = 0;
        int iEnd = endIndex;
        int iCount = columnWidthList.size();
        if (iBegin >= 0 && iBegin <= iEnd && iEnd < iCount) {
            for (iBegin = startIndex; iBegin <= iEnd; ++iBegin) {
                count += columnWidthList.get(iBegin).intValue();
            }
        }
        return count;
    }

    private List<Integer> getTableAllColumnWidth(IRTable iRTable, int colspan, int columnWidthSum) {
        ArrayList<Integer> columnWidthList = new ArrayList<Integer>();
        for (int i = 0; i < iRTable.getIRColumnList().size(); ++i) {
            IRColumn item = iRTable.getIRColumnList().get(i);
            if (!item.isColumnExport()) continue;
            int temp = this.getExportColumnWidth(iRTable.isSerialNumShow(), colspan, columnWidthSum, item);
            columnWidthList.add(temp);
        }
        if (iRTable.isSerialNumShow()) {
            columnWidthList.add(0, 30);
        }
        return columnWidthList;
    }

    private int getExportColumnWidth(boolean isSerialNumShow, int colspan, int columnWidthSum, IRColumn iRColumn) {
        int columnWidth = isSerialNumShow ? Integer.parseInt(iRColumn.getWidth()) * (this.elementWidth * colspan - 5 - 30) / columnWidthSum : Integer.parseInt(iRColumn.getWidth()) * (this.elementWidth * colspan - 5) / columnWidthSum;
        return columnWidth;
    }

    private void addConditionElement() {
        this.parameterList.add(this.createParameter("condDataset", "net.sf.jasperreports.engine.data.JRBeanCollectionDataSource"));
        this.parameterList.add(this.createParameter("IREPORT_SECURITY_DEFAULT_VALUE", "java.lang.String"));
        this.parameterList.add(this.createParameter("exportShowCondition", "java.lang.Boolean"));
        Element subDataset = this.createSubDataset("condDataset");
        subDataset.add(this.createField("key", "java.lang.String"));
        subDataset.add(this.createField("value", "java.lang.String"));
        this.subDatasetList.add(subDataset);
        Document document = DocumentHelper.createDocument();
        Element conditionElement = document.addElement("componentElement");
        conditionElement.add(this.createReportElement(null, null, "$P{exportShowCondition}", 0, this.summaryBandHeight, this.report.getPageWidth() - 5, 15));
        Element jrTable = conditionElement.addElement("table");
        jrTable.addNamespace("jr", "http://jasperreports.sourceforge.net/jasperreports/components");
        jrTable.setName("jr:table");
        jrTable.addAttribute("xsi:schemaLocation", "http://jasperreports.sourceforge.net/jasperreports/components http://jasperreports.sourceforge.net/xsd/components.xsd");
        Element datasetRun = jrTable.addElement("datasetRun");
        datasetRun.addAttribute("subDataset", "condDataset");
        Element dataSourceExpression = datasetRun.addElement("dataSourceExpression");
        dataSourceExpression.addCDATA("$P{condDataset}");
        Element jrKeyColumn = jrTable.addElement("jr:column");
        jrKeyColumn.addAttribute("width", String.valueOf((this.report.getPageWidth() - 5) * 20 / 100));
        Element jrKeyDetailCell = jrKeyColumn.addElement("jr:detailCell");
        jrKeyDetailCell.addAttribute("height", String.valueOf(15));
        jrKeyDetailCell.addAttribute("rowSpan", "1");
        jrKeyDetailCell.add(this.createTextField(null, "RelativeToBandHeight", null, 0, 0, (this.report.getPageWidth() - 5) * 20 / 100, 15, "java.lang.String", "$F{key}", FONT_SIZE, null));
        Element jrNullColumn = jrTable.addElement("jr:column");
        jrNullColumn.addAttribute("width", String.valueOf((this.report.getPageWidth() - 5) * 10 / 100));
        Element jrNullDetailCell = jrNullColumn.addElement("jr:detailCell");
        jrNullDetailCell.addAttribute("height", String.valueOf(15));
        jrNullDetailCell.addAttribute("rowSpan", "1");
        jrNullDetailCell.add(this.createTextField(null, "RelativeToBandHeight", null, 0, 0, (this.report.getPageWidth() - 5) * 10 / 100, 15, "java.lang.String", " ", FONT_SIZE, null));
        Element jrValueColumn = jrTable.addElement("jr:column");
        jrValueColumn.addAttribute("width", String.valueOf((this.report.getPageWidth() - 5) * 72 / 100));
        Element jrValueDetailCell = jrValueColumn.addElement("jr:detailCell");
        jrValueDetailCell.addAttribute("height", String.valueOf(15));
        jrValueDetailCell.addAttribute("rowSpan", "1");
        jrValueDetailCell.add(this.createTextField(null, "RelativeToBandHeight", null, 0, 0, (this.report.getPageWidth() - 5) * 72 / 100, 15, "java.lang.String", "$F{value}", FONT_SIZE, null));
        this.componentElementList.add(conditionElement);
        this.summaryBandHeight += 15 + ROW_MARGIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void justBuildJasperReport(String caseValue) {
        Class<JasperDefinitionParser> clazz = JasperDefinitionParser.class;
        synchronized (JasperDefinitionParser.class) {
            try {
                this.jasperReportBuilder.builderJasperReport(caseValue);
            }
            catch (Exception e) {
                LOG.error((Object)("report id=" + this.report.getId() + ", caseValue=" + caseValue + ":failed to compile Jasper file."));
            }
            return;
        }
    }

    private boolean needRebuildJasper() {
        if (!this.report.isBuildJasper()) {
            return false;
        }
        IRSwitchOption switchOption = this.report.getIRSwitchOption();
        if (null == switchOption) {
            if (this.needRebuildJasper("")) {
                return true;
            }
        } else {
            for (String caseValue : switchOption.getCaseValueList()) {
                boolean needRebuildJasper = this.needRebuildJasper(caseValue);
                if (!needRebuildJasper) continue;
                return true;
            }
        }
        return false;
    }

    private boolean needRebuildJasper(String caseValue) {
        if (!this.report.isBuildJasper()) {
            return false;
        }
        long timeJasper = 0L;
        String filePath = JasperDefinitionParser.createJasperFilePath(caseValue, this.report, "jasper");
        File file = new File(filePath);
        timeJasper = file.lastModified();
        long timeReport = 0L;
        filePath = IReportUtil.getPluginPath() + this.report.getId() + "/report.xml";
        file = new File(filePath);
        timeReport = file.lastModified();
        long timeTemplate = 0L;
        filePath = this.getXmlFileName(caseValue);
        file = new File(filePath);
        timeTemplate = file.lastModified();
        long timeStyle = 0L;
        file = new File(IReportUtil.getJasperTemplatePath() + "ReportStyle.jrtx");
        timeStyle = file.lastModified();
        return timeReport > timeJasper || timeTemplate > timeJasper || timeStyle > timeJasper;
    }

    private boolean notNeedStart() {
        boolean notNeed = true;
        List<IRTable> iRtables = this.report.getIRTableList();
        if (null != iRtables && !iRtables.isEmpty()) {
            IRTable iRTable = iRtables.get(0);
            IRColumn iRColumn = null;
            List<IRColumn> iRColumns = iRTable.getIRColumnList();
            if (null != iRColumns && !iRColumns.isEmpty() && !(iRColumn = iRColumns.get(0)).isJasperWidthEmpty()) {
                notNeed = false;
            }
        }
        return notNeed;
    }

    private void setHeaderDetailCell(Element headerDetailCell) {
        headerDetailCell.element("textElement").addAttribute("textAlignment", "Center");
        headerDetailCell.element("textElement").addAttribute("verticalAlignment", "Middle");
    }

    private Element addTableCellImage(String imagePath, String style, String printWhenExpression, int left, int top, int width, int height) {
        Document document = DocumentHelper.createDocument();
        Element image = document.addElement("image");
        image.addAttribute("scaleImage", "RealHeight");
        image.addAttribute("hAlign", "Center");
        image.addAttribute("vAlign", "Middle");
        image.add(this.createReportElement(style, "RelativeToBandHeight", printWhenExpression, left, top, width, height));
        Element imageExpression = image.addElement("imageExpression");
        imageExpression.addCDATA("$F{" + imagePath + "}");
        return image;
    }

    public static String createJasperReportFileName(String caseValue, IReport report, String suffix, int jasperFileIndex) {
        String tempFileName = null;
        StringBuilder fileNameBuilder = new StringBuilder();
        fileNameBuilder.append(JasperDefinitionParser.createJasperFileName(caseValue, report));
        if (jasperFileIndex != 0) {
            fileNameBuilder.append('-').append(jasperFileIndex);
        }
        tempFileName = fileNameBuilder.toString();
        fileNameBuilder.delete(0, fileNameBuilder.length());
        fileNameBuilder.append(IReportUtil.getPluginPath()).append(report.getId()).append('/').append(tempFileName).append('.').append(suffix);
        return fileNameBuilder.toString();
    }

    private void cleanJasperFile(String path) {
        File tempPath = new File(path);
        if (tempPath.exists() && tempPath.isDirectory()) {
            String[] children = tempPath.list();
            if (null != children) {
                String[] stringArray = children;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String childTemp;
                    String child = childTemp = stringArray[i];
                    if (!(child = Normalizer.normalize(child, Normalizer.Form.NFKC)).endsWith(".jrxml") && !child.endsWith(".jasper")) continue;
                    IReportUtil.deleteFile(path + File.separator + child);
                }
            } else {
                LOG.error((Object)"children is null.");
            }
        }
    }

    public class JasperReportBuilderImpl
    implements IJasperReportBuilder {
        protected String caseValue;
        protected int columnNumber;
        protected int column = 0;
        protected int row = 0;

        @Override
        public void builderJasperReport(String caseValueNew) {
            this.init(caseValueNew);
            try {
                JasperDefinitionParser.this.addReportTitle(JasperDefinitionParser.this.report.getIRDefine(caseValueNew));
                JasperDefinitionParser.this.addConditionElement();
                JasperDefinitionParser.this.elementWidth = JasperDefinitionParser.this.report.getPageWidth() / this.columnNumber;
                for (ComponentElement componentElement : JasperDefinitionParser.this.report.getElementList(caseValueNew)) {
                    this.handleComponentElement(componentElement);
                }
                this.buildJasperReportFile();
            }
            catch (IOException err) {
                LOG.error((Object)("build " + JasperDefinitionParser.this.report.getId() + " JasperReport failed"));
            }
        }

        private void handleComponentElement(ComponentElement componentElement) {
            if (componentElement.getColspan() > this.columnNumber) {
                componentElement.setColspan(this.columnNumber);
            }
            if (this.columnNumber < this.column + componentElement.getColspan() && JasperDefinitionParser.this.summaryBandHeight > 0) {
                JasperDefinitionParser.this.addComponentInterval();
                ++this.row;
                this.column = 0;
            }
            if (componentElement instanceof IRChart) {
                IRChart iChart = (IRChart)componentElement;
                boolean isFourCol = this.columnNumber == iChart.getColspan();
                JasperDefinitionParser.this.addChart(iChart, this.row, this.column, iChart.getColspan());
                if (iChart.isLegend()) {
                    JasperDefinitionParser.this.addChartLegend(iChart, this.column, iChart.getColspan(), isFourCol);
                }
            } else if (componentElement instanceof IRTable) {
                IRTable iTable = (IRTable)componentElement;
                JasperDefinitionParser.this.addTable(iTable, this.row, this.column, iTable.getColspan(), this.caseValue);
            } else if (componentElement instanceof IRTextField) {
                IRTextField iTextField = (IRTextField)componentElement;
                JasperDefinitionParser.this.addIRTextField(iTextField, this.row, this.column, iTextField.getColspan());
            }
            this.column += componentElement.getColspan().intValue();
        }

        private void writeJasperReportToFile(String templateXml, Writer jasperReportWrite) throws IOException {
            int pageHeight = JasperDefinitionParser.this.summaryBandHeight + 120;
            templateXml = templateXml.replace("${summaryHeight}", String.valueOf(JasperDefinitionParser.this.summaryBandHeight));
            pageHeight = pageHeight > 842 ? pageHeight : 842;
            templateXml = templateXml.replace("${pageHeight}", String.valueOf(pageHeight));
            StringBuilder commonStringBuilder = new StringBuilder();
            for (Element element : JasperDefinitionParser.this.subDatasetList) {
                commonStringBuilder.append(element.asXML());
            }
            templateXml = templateXml.replace("${subDataset}", commonStringBuilder.toString());
            commonStringBuilder.delete(0, commonStringBuilder.length());
            for (Element element : JasperDefinitionParser.this.parameterList) {
                commonStringBuilder.append(element.asXML());
            }
            templateXml = templateXml.replace("${parameter}", commonStringBuilder.toString());
            commonStringBuilder.delete(0, commonStringBuilder.length());
            for (Element element : JasperDefinitionParser.this.componentElementList) {
                commonStringBuilder.append(element.asXML());
            }
            templateXml = templateXml.replace("${componentElement}", commonStringBuilder.toString());
            jasperReportWrite.write(templateXml);
            jasperReportWrite.flush();
            jasperReportWrite.close();
            this.parentInit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildJasperReportFile() throws IOException {
            String jrxmlFile = JasperDefinitionParser.createJasperReportFileName(this.caseValue, JasperDefinitionParser.this.report, "jrxml", 0);
            String jasperFile = JasperDefinitionParser.createJasperReportFileName(this.caseValue, JasperDefinitionParser.this.report, "jasper", 0);
            String templateXml = JasperReportConfigFactory.getTemplateXmlByCache(JasperReportConfigFactory.TemplateFileName.TEMPLATE_FRAME);
            Writer jasperReportWrite = null;
            try {
                if (templateXml != null) {
                    jasperReportWrite = new OutputStreamWriter((OutputStream)new FileOutputStream(jrxmlFile), "UTF-8");
                    this.writeJasperReportToFile(templateXml, jasperReportWrite);
                    JasperCompileManager.compileReportToFile((String)jrxmlFile, (String)jasperFile);
                }
            }
            catch (JRException e) {
                LOG.error((Object)("build " + JasperDefinitionParser.this.report.getId() + " JasperReport failed"));
            }
            catch (RuntimeException err) {
                LOG.error((Object)("build " + JasperDefinitionParser.this.report.getId() + " JasperReport failed"));
            }
            finally {
                if (null != jasperReportWrite) {
                    try {
                        jasperReportWrite.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"close failed");
                    }
                }
            }
        }

        private void init(String caseValueNew) {
            this.caseValue = caseValueNew;
            this.columnNumber = JasperDefinitionParser.this.report.getIRDefine(caseValueNew).getColumnNumber();
            this.parentInit();
        }

        private void parentInit() {
            JasperDefinitionParser.this.rowStartHeightList.clear();
            JasperDefinitionParser.this.subDatasetList.clear();
            JasperDefinitionParser.this.parameterList.clear();
            JasperDefinitionParser.this.componentElementList.clear();
            JasperDefinitionParser.this.summaryBandHeight = 0;
            this.column = 0;
            this.row = 0;
        }
    }

    public static interface DefinitionParameters {
        public static final int JASP_TABLE_COLUMN_HEIGHT = 1;
        public static final int JASP_CHAT_LEGENT_HEIGHT = 2;
        public static final int JASP_SPACE_HEIGHT = 1;
        public static final int DEFAULT_ZERO_HEIGHT = 0;
    }
}

