/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.output;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.opensymphony.xwork2.ActionContext;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.engine.definition.ExtendAttribute;
import com.security.ireport.engine.definition.IRCover;
import com.security.ireport.engine.definition.IRFirstPage;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.output.SigExportOutput;
import com.security.ireport.engine.output.export.Exportable;
import com.security.ireport.engine.output.export.impl.ExceExport;
import com.security.ireport.engine.output.export.impl.HtmlExport;
import com.security.ireport.engine.output.export.impl.PdfExport;
import com.security.ireport.engine.output.export.impl.PrintExport;
import com.security.ireport.engine.output.export.impl.WordExport;
import com.security.ireport.model.vo.DisplayCondObj;
import com.security.ireport.model.vo.SysOptLog;
import com.security.ireport.model.vo.TableObj;
import com.security.ireport.util.CsvZipExporter;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportLogManager;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JasperReportsUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang3.StringUtils;

public class ExportReport {
    public static final int SUB_REPORTNAME = 30;
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    protected List<String> excelPageNameList = new ArrayList<String>();
    private List<ReportSession> reportSessionList = new ArrayList<ReportSession>();
    private HttpServletResponse response;

    public ExportReport(List<ReportSession> reportSessionList, HttpServletRequest request, HttpServletResponse response) {
        this.reportSessionList = reportSessionList;
        this.response = response;
        LOG.info((Object)request);
    }

    public ExportReport(List<ReportSession> reportSessionList) {
        this.reportSessionList = reportSessionList;
    }

    public static TableObj getTabObjList(ReportSession reportSession, IRTable tableDef, long pgIndex, long pgSize) throws ProviderException {
        TableObj tableObj = null;
        tableObj = ExportReport.getTableListForCommon(reportSession, tableDef, pgIndex, pgSize);
        return tableObj;
    }

    private boolean validateReports() {
        boolean bValid = true;
        int reportSize = this.reportSessionList.size();
        ReportSession reportSession = null;
        String reportId = null;
        for (int i = 0; i < reportSize; ++i) {
            reportSession = this.reportSessionList.get(i);
            reportId = reportSession.getIReport().getId();
            if (ExportReport.isValidReportId(reportId)) continue;
            bValid = false;
            break;
        }
        return bValid;
    }

    private static boolean isValidReportId(String reportId) {
        boolean bValid = false;
        if (reportId.matches("^[a-zA-Z][a-zA-Z0-9-_.]*$")) {
            bValid = true;
        }
        return bValid;
    }

    public boolean exportRest(String type, String exportName, String userName, String path, String unitText) {
        if (!this.validateReports()) {
            return false;
        }
        PdfExport exportable = null;
        boolean ret = true;
        if (type.equalsIgnoreCase("pdf")) {
            exportable = new PdfExport(this, exportName);
            ret = exportable.exportRest(userName, path, unitText);
        }
        return ret;
    }

    public boolean export(String type, String templateName, String downloadFilePath) {
        if (!this.validateReports()) {
            return false;
        }
        AbstractExportable exportable = null;
        boolean ret = true;
        if (type.equalsIgnoreCase("pdf")) {
            exportable = new PdfExport(this, templateName);
            ret = exportable.exportx(downloadFilePath);
        } else if (type.equalsIgnoreCase("excel")) {
            exportable = new ExceExport(this, templateName);
            ret = exportable.exportx(downloadFilePath);
        } else if (type.equalsIgnoreCase("html")) {
            exportable = new HtmlExport(this, templateName);
            ret = exportable.exportx(downloadFilePath);
        } else if (type.equalsIgnoreCase("csv")) {
            ret = this.exportToCsv(templateName, downloadFilePath);
        } else if (type.equalsIgnoreCase("rtf")) {
            exportable = new WordExport(this, templateName);
            ret = exportable.exportx(downloadFilePath);
        } else if (type.equalsIgnoreCase("word")) {
            exportable = new WordExport(this, templateName);
            ret = exportable.exportx(downloadFilePath);
        } else if (type.equalsIgnoreCase("print")) {
            exportable = new PrintExport(this, templateName);
            ret = exportable.exportx(downloadFilePath);
        }
        return ret;
    }

    public String timeExport(String type, String filePath, String fileName) {
        String ret = null;
        AbstractExportable exportable = null;
        if (type.equalsIgnoreCase("pdf")) {
            exportable = new PdfExport(this, null);
            ret = exportable.timeExport(filePath, fileName);
        } else if (type.equalsIgnoreCase("excel")) {
            exportable = new ExceExport(this, null);
            ret = exportable.timeExport(filePath, fileName);
        } else if (type.equalsIgnoreCase("html")) {
            exportable = new HtmlExport(this, null);
            ret = exportable.timeExport(filePath, fileName);
        } else if (type.equalsIgnoreCase("csv")) {
            ret = this.timeExportToCsv(filePath, fileName);
        } else if (type.equalsIgnoreCase("rtf")) {
            exportable = new WordExport(this, null);
            ret = exportable.timeExport(filePath, fileName);
        } else if (type.equalsIgnoreCase("word")) {
            exportable = new WordExport(this, null);
            ret = exportable.timeExport(filePath, fileName);
        }
        return ret;
    }

    private boolean exportToCsv(String templateName, String downloadFilePath) {
        return this.exportToCsvStream(templateName, true, downloadFilePath, "", Boolean.FALSE);
    }

    private String timeExportToCsv(String filePath, String fileName) {
        String ret = null;
        if (!this.exportToCsvStream("", Boolean.FALSE, filePath, fileName, Boolean.TRUE)) {
            ret = "Export to csv file failed!";
        }
        return ret;
    }

    private boolean exportToCsvStream(String templateName, boolean usedTemplate, String filePath, String fileName, boolean isTimeExport) {
        String exportName = "";
        if (usedTemplate) {
            if (null != templateName && !templateName.equals("")) {
                exportName = templateName;
            } else {
                IReport report = this.reportSessionList.get(0).getIReport();
                exportName = IReportUtil.getProperty(report.getIRDefine().getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale());
            }
        } else {
            exportName = fileName.substring(0, fileName.indexOf(".csv"));
        }
        return this.dealCsvStream(filePath, exportName, isTimeExport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dealCsvStream(String filePath, String exportName, boolean isTimeExport) {
        String tmpTime = new SimpleDateFormat("yyyyMMdd_HH_mm_ss").format(new Date());
        String optTarget = "";
        String userName = ProductFaceUtil.getInstance().getUserName();
        int level = 3;
        OutputStream outputStream = null;
        try {
            if (!IReportConfCheckUtil.isStringEmpty(filePath)) {
                if (isTimeExport) {
                    outputStream = new FileOutputStream(filePath + exportName + "_csv.zip");
                } else {
                    boolean isCreate;
                    int index = filePath.lastIndexOf(File.separator);
                    String time = filePath.substring(index + 1);
                    optTarget = exportName + "(" + time + ").csv";
                    File tempDir = new File(filePath);
                    if (!tempDir.exists() && !tempDir.mkdirs()) {
                        LOG.error((Object)"Export to csvfailed.");
                        this.printThisSysLog(optTarget, "", level);
                        boolean bl = false;
                        return bl;
                    }
                    File newFile = new File(filePath + File.separator + exportName + "(" + time + ")_csv.zip");
                    if (!newFile.exists() && !(isCreate = newFile.createNewFile())) {
                        LOG.error((Object)(exportName + "(" + time + ")_csv.zip createNewFile() failed !"));
                        this.printThisSysLog(exportName + "(" + time + ")_csv.zip", "", level);
                        boolean bl = false;
                        return bl;
                    }
                    outputStream = new FileOutputStream(newFile);
                }
            } else {
                String downloadName = exportName + "(" + tmpTime + ")";
                this.initDownloadHeader("application/zip", downloadName, ".zip", Boolean.FALSE);
                outputStream = this.response.getOutputStream();
            }
            new CsvZipExporter(outputStream, this.reportSessionList);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"dealCsvStream export dealCsvStream UnsupportedEncodingException");
            this.printThisSysLog(optTarget, userName, level);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.error((Object)"dealCsvStream export dealCsvStream IOException");
            this.printThisSysLog(optTarget, userName, level);
            boolean bl = false;
            return bl;
        }
        catch (ProviderException e) {
            LOG.error((Object)"dealCsvStream export dealCsvStream ProviderException");
            this.printThisSysLog(optTarget, userName, level);
            boolean bl = false;
            return bl;
        }
        catch (RuntimeException e) {
            LOG.error((Object)"dealCsvStream export dealCsvStream RuntimeException");
            this.printThisSysLog(optTarget, userName, level);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"close outputStream IOException");
                }
            }
        }
        IReportLogManager.getInstance().printSysLog(new SysOptLog("report.manager", "export.report", optTarget, 0, "export.report.success", userName, level));
        return true;
    }

    private void printThisSysLog(String optTarget, String name, int level) {
        IReportLogManager.getInstance().printSysLog(new SysOptLog("report.manager", "export.report", optTarget, 1, "export.report.fail", name, level));
    }

    private void initDownloadHeader(String contentType, String report, String suffix, boolean isPrint) throws UnsupportedEncodingException {
        this.response.setCharacterEncoding("UTF-8");
        this.response.setContentType(contentType);
        report = report.replaceAll("[/\\:*?\"<>|]", "-");
        report = new String(report.getBytes("gbk"), "iso-8859-1");
        String reportName = report = IReportMgrUtil.replaceAllBlank(report);
        if (!isPrint) {
            this.response.setHeader("Content-Disposition", "attachment; filename=" + reportName + suffix);
        }
    }

    private static TableObj getTableListForCommon(ReportSession reportSession, IRTable tableDef, long pgIndex, long pgSize) {
        TableObj tableObj = null;
        IReport report = reportSession.getIReport();
        if (tableDef.isShow()) {
            OrderInfo orderInfoMap = reportSession.getOrderInfoMap().get(tableDef.getId());
            tableObj = reportSession.getTableData(tableDef, pgIndex, pgSize, orderInfoMap, true);
            String tableName = IReportMgrUtil.getPluginNameFromProperty(report.getId(), Locale.ENGLISH) + "_" + tableObj.getId();
            tableObj.setId(tableName);
        } else {
            tableObj = new TableObj();
        }
        return tableObj;
    }

    private boolean getJasperPrintList4Restful(List<JasperPrint> jasperPrintList, boolean ifPaginate, String exportType) {
        boolean ret = true;
        try {
            JasperPrint temp;
            IRFirstPage firstPage;
            JasperPrint temp2;
            IRCover cover = this.reportSessionList.get(0).getIReport().getCover();
            if (cover.isShowCover() && (temp2 = this.getReportCover(cover, this.reportSessionList.get(0).getLocale())) != null) {
                jasperPrintList.add(temp2);
            }
            if ((firstPage = this.reportSessionList.get(0).getIReport().getFirstPage()).isShowFirstPage() && (temp = this.getReportFirstPage(firstPage, this.reportSessionList.get(0).getLocale())) != null) {
                jasperPrintList.add(temp);
            }
            int prevTotalPageSize = 0;
            for (ReportSession reportSession : this.reportSessionList) {
                JasperReport[] jasperReports = SigExportOutput.getJasperReportObjectArray(reportSession);
                if (jasperReports.length == 0) {
                    return false;
                }
                JasperPrint jasperPrint = null;
                Map<String, Object> paraMap = SigExportOutput.prepareJasperData(reportSession, ifPaginate, exportType, prevTotalPageSize);
                paraMap.put("_IREPORT_SEC_KEY_", exportType);
                this.removeUnuseless(paraMap);
                for (JasperReport tempJasperReport : jasperReports) {
                    paraMap.put("prevTotalPageSize", prevTotalPageSize);
                    jasperPrint = SigExportOutput.fillJasperReport(reportSession, tempJasperReport, paraMap, ifPaginate, exportType, prevTotalPageSize);
                    if (null == jasperPrint) {
                        return false;
                    }
                    prevTotalPageSize += jasperPrint.getPages().size();
                    jasperPrintList.add(jasperPrint);
                }
                if (null != paraMap.get("reportMainTitle") && !((String)paraMap.get("reportMainTitle")).isEmpty()) {
                    this.excelPageNameList.add((String)paraMap.get("reportMainTitle"));
                    continue;
                }
                if (null != paraMap.get("reportTitle") && !((String)paraMap.get("reportTitle")).isEmpty()) {
                    this.excelPageNameList.add((String)paraMap.get("reportTitle"));
                    continue;
                }
                this.excelPageNameList.add(reportSession.getIReport().getId());
            }
        }
        catch (ProviderException e) {
            LOG.error((Object)"Get JasperPrint list failed");
        }
        JasperReportsUtil.doHandleJasper(exportType, jasperPrintList);
        return ret;
    }

    private void removeUnuseless(Map<String, Object> paraMap) {
        try {
            JRBeanCollectionDataSource tmp = (JRBeanCollectionDataSource)paraMap.get("condDataset");
            if (null != tmp && null != tmp.getData()) {
                ArrayList<DisplayCondObj> ret = new ArrayList<DisplayCondObj>();
                for (Object obj : tmp.getData()) {
                    DisplayCondObj condObj;
                    if (null == obj || null == (condObj = (DisplayCondObj)obj).getKey() || condObj.getKey().trim().equals("currentLogUserId") || condObj.getKey().trim().equals("byInterface")) continue;
                    ret.add(condObj);
                }
                if (ret.size() > 0) {
                    JRBeanCollectionDataSource temp = new JRBeanCollectionDataSource(ret);
                    paraMap.put("condDataset", temp);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
    }

    private boolean getJasperPrintList(List<JasperPrint> jasperPrintList, boolean ifPaginate, String exportType) {
        boolean ret = true;
        try {
            JasperPrint temp;
            IRFirstPage firstPage;
            JasperPrint temp2;
            IRCover cover = this.reportSessionList.get(0).getIReport().getCover();
            if (cover.isShowCover() && (temp2 = this.getReportCover(cover, this.reportSessionList.get(0).getLocale())) != null) {
                jasperPrintList.add(temp2);
            }
            if ((firstPage = this.reportSessionList.get(0).getIReport().getFirstPage()).isShowFirstPage() && (temp = this.getReportFirstPage(firstPage, this.reportSessionList.get(0).getLocale())) != null) {
                jasperPrintList.add(temp);
            }
            int prevTotalPageSize = 0;
            for (ReportSession reportSession : this.reportSessionList) {
                JasperReport[] jasperReports = SigExportOutput.getJasperReportObjectArray(reportSession);
                if (jasperReports.length == 0) {
                    return false;
                }
                JasperPrint jasperPrint = null;
                Map<String, Object> paraMap = SigExportOutput.prepareJasperData(reportSession, ifPaginate, exportType, prevTotalPageSize);
                paraMap.put("_IREPORT_SEC_KEY_", exportType);
                for (JasperReport tempJasperReport : jasperReports) {
                    paraMap.put("prevTotalPageSize", prevTotalPageSize);
                    jasperPrint = SigExportOutput.fillJasperReport(reportSession, tempJasperReport, paraMap, ifPaginate, exportType, prevTotalPageSize);
                    if (null == jasperPrint) {
                        return false;
                    }
                    prevTotalPageSize += jasperPrint.getPages().size();
                    jasperPrintList.add(jasperPrint);
                }
                if (null != paraMap.get("reportMainTitle") && !((String)paraMap.get("reportMainTitle")).isEmpty()) {
                    this.excelPageNameList.add((String)paraMap.get("reportMainTitle"));
                    continue;
                }
                if (null != paraMap.get("reportTitle") && !((String)paraMap.get("reportTitle")).isEmpty()) {
                    this.excelPageNameList.add((String)paraMap.get("reportTitle"));
                    continue;
                }
                this.excelPageNameList.add(reportSession.getIReport().getId());
            }
        }
        catch (ProviderException e) {
            LOG.error((Object)"Get JasperPrint list failed");
        }
        JasperReportsUtil.doHandleJasper(exportType, jasperPrintList);
        return ret;
    }

    private JasperPrint getReportFirstPage(IRFirstPage reportFirstPage, Locale locale) {
        JasperPrint result = null;
        String firstPagePath = IReportUtil.getJasperTemplatePath();
        firstPagePath = null != reportFirstPage.getFirstPageUrl() && !reportFirstPage.getFirstPageUrl().isEmpty() ? firstPagePath + reportFirstPage.getFirstPageUrl() : firstPagePath + "firstPageTemp1.jasper";
        try {
            JasperReport firstPage = (JasperReport)JRLoader.loadObject((String)firstPagePath);
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("title", reportFirstPage.getTitle());
            paraMap.put("authorName", reportFirstPage.getAuthorName());
            paraMap.put("collectionName", reportFirstPage.getCollectionName());
            paraMap.put("createTime", reportFirstPage.getCreateTime());
            paraMap.put("dataTime", reportFirstPage.getDataTime());
            paraMap.put("reportDesc", reportFirstPage.getReportDesc());
            paraMap.put("reportType", reportFirstPage.getReportType());
            paraMap.put("reportVersion", reportFirstPage.getReportVersion());
            paraMap.put("logImageUrl", IReportUtil.getJasperTemplatePath() + reportFirstPage.getLogImageUrl());
            if (null != reportFirstPage.getExtendsAttributeList()) {
                for (ExtendAttribute tempExtendAttribute : reportFirstPage.getExtendsAttributeList()) {
                    paraMap.put(tempExtendAttribute.getName(), tempExtendAttribute.getValue());
                }
            }
            paraMap.put("firstpage.reportName", LocaleUtil.getProperty("firstpage.reportName", locale));
            paraMap.put("firstpage.authorName", LocaleUtil.getProperty("firstpage.authorName", locale));
            paraMap.put("firstpage.collectionName", LocaleUtil.getProperty("firstpage.collectionName", locale));
            paraMap.put("firstpage.createTime", LocaleUtil.getProperty("firstpage.createTime", locale));
            paraMap.put("firstpage.dataTime", LocaleUtil.getProperty("firstpage.dataTime", locale));
            paraMap.put("firstpage.reportType", LocaleUtil.getProperty("firstpage.reportType", locale));
            paraMap.put("firstpage.versionNum", LocaleUtil.getProperty("firstpage.versionNum", locale));
            result = JasperFillManager.fillReport((JasperReport)firstPage, paraMap, (JRDataSource)new JREmptyDataSource());
            if (null != reportFirstPage.getTitle() && !reportFirstPage.getTitle().isEmpty()) {
                this.excelPageNameList.add(reportFirstPage.getTitle());
            } else {
                this.excelPageNameList.add(LocaleUtil.getLocaleText(locale, "ireport.export.excel.coverFirstPage"));
            }
        }
        catch (JRException e) {
            LOG.error((Object)"get jasper failed JRException");
        }
        catch (RuntimeException e) {
            LOG.error((Object)"get jasper failed RuntimeException");
        }
        return result;
    }

    private JasperPrint getReportCover(IRCover cover, Locale locale) {
        JasperPrint result = null;
        String filePath = IReportUtil.getJasperTemplatePath() + "coverTemp1.jasper";
        String imagePath = IReportUtil.getJasperTemplatePath() + cover.getCoverImagePath();
        try {
            JasperReport reportObj = (JasperReport)JRLoader.loadObject((String)filePath);
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("coverMainTitle", cover.getCoverMainTitle());
            paraMap.put("coverTitle", cover.getCoverTitle());
            paraMap.put("coverReportCycle", cover.getCoverReportCycle());
            paraMap.put("coverReportTime", cover.getCoverReportTime());
            paraMap.put("coverImagePath", imagePath);
            result = JasperFillManager.fillReport((JasperReport)reportObj, paraMap, (JRDataSource)new JREmptyDataSource());
            if (null != cover.getCoverMainTitle() && !cover.getCoverMainTitle().trim().isEmpty()) {
                this.excelPageNameList.add(cover.getCoverMainTitle());
            } else if (null != cover.getCoverTitle() && !cover.getCoverTitle().trim().isEmpty()) {
                this.excelPageNameList.add(cover.getCoverMainTitle());
            } else {
                this.excelPageNameList.add(LocaleUtil.getLocaleText(locale, "ireport.export.excel.coverName"));
            }
        }
        catch (JRException e) {
            LOG.error((Object)"get jasper failed");
        }
        return result;
    }

    public abstract class AbstractExportable
    implements Exportable {
        protected String templateName;
        protected List<JasperPrint> printList;
        protected OutputStream outputStream;

        public AbstractExportable(String paramTemplateName) {
            this.templateName = paramTemplateName;
            this.printList = new ArrayList<JasperPrint>();
        }

        public List<String> getExcelNameList() {
            return ExportReport.this.excelPageNameList;
        }

        @Override
        public void setOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public List<JasperPrint> getPrintList() {
            return this.printList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean exportRest(String userName, String path, String unitText) {
            String exportName = "";
            if (null != this.templateName && !this.templateName.equals("")) {
                exportName = this.templateName;
                LOG.info((Object)("exportName : " + exportName));
            } else {
                IReport report = ((ReportSession)ExportReport.this.reportSessionList.get(0)).getIReport();
                exportName = IReportUtil.getProperty(report.getIRDefine().getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale());
                LOG.info((Object)("exportName is null gentrate name : " + exportName));
            }
            String tmpTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            String optTarget = exportName + "_" + unitText + "(" + tmpTime + ")." + this.getType();
            int level = 3;
            if (!ExportReport.this.getJasperPrintList4Restful(this.printList, this.isIgnorePag(), this.getType())) {
                LOG.error((Object)("Export to " + this.getType() + "failed."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                return false;
            }
            FileOutputStream fos = null;
            FilterOutputStream bos = null;
            try {
                boolean isCreate;
                File newFile = new File(path + File.separator + optTarget);
                if (!newFile.exists() && !(isCreate = newFile.createNewFile())) {
                    LOG.error((Object)"newFile.createNewFile() failed !");
                }
                fos = new FileOutputStream(newFile);
                bos = new BufferedOutputStream(fos);
                this.setOutputStream(bos);
                this.exportMode();
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            catch (ProviderException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (null != this.getOutputStream()) {
                        this.getOutputStream().close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Close out put stream failed.");
                }
                try {
                    if (null != bos) {
                        bos.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Close out put stream failed.");
                }
                try {
                    if (null != fos) {
                        fos.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Close out put stream failed.");
                }
            }
            IReportLogManager.getInstance().printSysLog(new SysOptLog("report.manager", "export.report", optTarget, 0, "export.report.success", userName, level));
            return true;
        }

        @Override
        public boolean exportx(String path) {
            String exportName = "";
            if (StringUtils.isNotEmpty((CharSequence)this.templateName)) {
                exportName = this.templateName;
                LOG.info((Object)("exportName : " + exportName));
            } else {
                IReport report = ((ReportSession)ExportReport.this.reportSessionList.get(0)).getIReport();
                exportName = IReportUtil.getProperty(report.getIRDefine().getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale());
                LOG.info((Object)("exportName is null gentrate name : " + exportName));
            }
            int index = path.lastIndexOf(File.separator);
            String tmpTime = path.substring(index + 1);
            String optTarget = exportName + "(" + tmpTime + ")" + this.getExportSuffix();
            int level = 3;
            File tempDir = new File(path);
            if (!tempDir.exists() && !tempDir.mkdirs()) {
                LOG.error((Object)("Export to " + this.getType() + "failed."));
                ExportReport.this.printThisSysLog(optTarget, "", level);
                return false;
            }
            if (!ExportReport.this.getJasperPrintList4Restful(this.printList, this.isIgnorePag(), this.getType())) {
                LOG.error((Object)("Export to " + this.getType() + "failed."));
                ExportReport.this.printThisSysLog(optTarget, "", level);
                return false;
            }
            return this.exportResult(path, optTarget, level);
        }

        /*
         * Exception decompiling
         */
        private boolean exportResult(String path, String optTarget, int level) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean export() {
            String exportName = "";
            if (null != this.templateName && !this.templateName.equals("")) {
                exportName = this.templateName;
            } else {
                IReport report = ((ReportSession)ExportReport.this.reportSessionList.get(0)).getIReport();
                exportName = IReportUtil.getProperty(report.getIRDefine().getTitle(), report.getId(), LocaleUtil.getCurrentUserLocale());
            }
            String tmpTime = new SimpleDateFormat("yyyyMMdd_HH_mm_ss").format(new Date());
            String optTarget = exportName + "(" + tmpTime + ")." + this.getType();
            String userName = ProductFaceUtil.getInstance().getUserName();
            int level = 3;
            if (!ExportReport.this.getJasperPrintList(this.printList, this.isIgnorePag(), this.getType())) {
                LOG.error((Object)("Export to " + this.getType() + "failed."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                return false;
            }
            try {
                ExportReport.this.initDownloadHeader(this.getExportSuffixType(), exportName + "(" + tmpTime + ")", this.getExportSuffix(), this.isPrint());
                this.setOutputStream((OutputStream)ExportReport.this.response.getOutputStream());
                this.exportMode();
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            catch (ProviderException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Export to " + this.getType() + "failed JRException."));
                ExportReport.this.printThisSysLog(optTarget, userName, level);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (null != this.getOutputStream()) {
                        this.getOutputStream().close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Close out put stream failed.");
                }
            }
            IReportLogManager.getInstance().printSysLog(new SysOptLog("report.manager", "export.report", optTarget, 0, "export.report.success", userName, level));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String timeExport(String filePath, String fileName) {
            String ret = null;
            if (!ExportReport.this.getJasperPrintList(this.getPrintList(), this.isIgnorePag(), this.getType())) {
                ret = "Get jasper report file failed or Fill data to jasper file failed!";
                return ret;
            }
            try {
                this.setOutputStream(new FileOutputStream(filePath + fileName));
                this.exportMode();
            }
            catch (FileNotFoundException e) {
                ret = "Export to " + this.getType() + " failed JRException!";
                LOG.error((Object)("Export report error " + ret));
                String string = ret;
                return string;
            }
            catch (ProviderException e) {
                ret = "Export to " + this.getType() + " failed JRException!";
                LOG.error((Object)ret);
                String string = ret;
                return string;
            }
            catch (RuntimeException e) {
                ret = "Export to " + this.getType() + " failed JRException!";
                LOG.error((Object)ret);
                String string = ret;
                return string;
            }
            finally {
                try {
                    if (null != this.getOutputStream()) {
                        this.getOutputStream().close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Close out put stream failed.");
                }
            }
            return ret;
        }

        protected String getExportSuffix() {
            if ("pdf".equals(this.getType()) || "print".equals(this.getType())) {
                return ".pdf";
            }
            if ("3".equals(this.getType())) {
                return ".rtf";
            }
            if ("rtf".equals(this.getType())) {
                return ".rtf";
            }
            if ("word".equals(this.getType())) {
                return ".doc";
            }
            if ("excel".equals(this.getType())) {
                return ".xls";
            }
            if ("html".equals(this.getType())) {
                return ".zip";
            }
            if ("csv".equals(this.getType())) {
                return ".zip";
            }
            if ("4".equals(this.getType())) {
                return ".zip";
            }
            return this.getType();
        }

        protected String getExportSuffixType() {
            if ("pdf".equals(this.getType()) || "print".equals(this.getType())) {
                return "application/pdf";
            }
            if ("3".equals(this.getType())) {
                return "application/pdf";
            }
            if ("rtf".equals(this.getType())) {
                return "application/rtf";
            }
            if ("word".equals(this.getType())) {
                return "application/rtf";
            }
            if ("excel".equals(this.getType())) {
                return "application/xls";
            }
            if ("html".equals(this.getType())) {
                return "application/zip";
            }
            if ("csv".equals(this.getType())) {
                return "application/zip";
            }
            if ("4".equals(this.getType())) {
                return "application/zip";
            }
            return this.getType();
        }

        @Override
        public boolean isPrint() {
            return false;
        }

        public String getCurrentUserName() {
            ActionContext ctx = ActionContext.getContext();
            String currentUserName = null;
            try {
                if (null != ctx) {
                    HttpServletRequest request;
                    User currentUser = (User)ctx.get("currentUser");
                    if (null != currentUser) {
                        currentUserName = currentUser.getUserName();
                    }
                    if (null == currentUserName && null != (request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest")) && null != request.getSession()) {
                        currentUser = (User)request.getSession().getAttribute("currentUser");
                        return currentUser.getUserName();
                    }
                }
                return currentUserName;
            }
            catch (NullPointerException e) {
                return "";
            }
        }
    }
}

