/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.engine.output.export.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ProviderException;
import com.security.ireport.engine.output.ExportReport;
import com.security.ireport.jasperreports.MyJRHtmlExporter;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.ZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;

public class HtmlExport
extends ExportReport.AbstractExportable {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int EXPORT_BUFFER_SIZE = 1024;

    public HtmlExport(ExportReport exportReport, String paramTemplateName) {
        ExportReport exportReport2 = exportReport;
        exportReport2.getClass();
        super(paramTemplateName);
        LOG.info((Object)exportReport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportMode() throws ProviderException {
        String filePath = IReportUtil.getRealPath() + "/temp/" + Thread.currentThread().getName() + "_" + System.currentTimeMillis() + File.separator;
        String zipFilePath = IReportUtil.getRealPath() + "/temp/";
        String tempZipPath = zipFilePath + Thread.currentThread().getName() + "_" + System.currentTimeMillis() + ".zip";
        try {
            File path = null;
            path = new File(filePath);
            if (path.exists()) {
                IReportUtil.deleteDirectory(filePath);
            } else if (!path.mkdirs()) {
                LOG.error((Object)("mkdirs failed " + path.getName()));
            }
            MyJRHtmlExporter exporter = new MyJRHtmlExporter();
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.ZOOM_RATIO, Float.valueOf(Float.parseFloat("1.3")));
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, this.getPrintList());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, filePath + "report.html");
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, "UTF-8");
            exporter.exportReport();
            ZipUtil.zip(filePath, tempZipPath, "report");
            try (FileInputStream in = null;){
                byte[] buffer = new byte[1024];
                in = new FileInputStream(tempZipPath);
                int totalNum = 0;
                while ((totalNum = in.read(buffer)) != -1) {
                    this.outputStream.write(buffer, 0, totalNum);
                }
            }
            this.outputStream.flush();
        }
        catch (JRException je) {
            LOG.error((Object)("exportMode Export to html stream failed JRException:" + je.getMessage()));
            throw new ProviderException((Exception)((Object)je));
        }
        catch (IOException e) {
            LOG.error((Object)("exportMode Export to html stream failed IOException:" + e.getMessage()));
            throw new ProviderException(e);
        }
        catch (RuntimeException e) {
            LOG.error((Object)("exportMode Export to html stream failed RuntimeException:" + e.getMessage()));
            throw new ProviderException(e);
        }
        catch (Exception e) {
            LOG.error((Object)("exportMode Export to html stream failed Exception:" + e.getMessage()));
            throw new ProviderException(e.getMessage());
        }
        finally {
            IReportUtil.deleteFile(tempZipPath);
            IReportUtil.deleteDirectory(filePath);
            IReportUtil.deleteFile(zipFilePath + "report" + ".zip");
        }
    }

    @Override
    public String getType() {
        return "html";
    }

    @Override
    public boolean isIgnorePag() {
        return Boolean.TRUE;
    }
}

