/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.jasperreports;

import java.io.IOException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public class MyJRHtmlExporter
extends JRHtmlExporter {
    public void exportText(JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.writeCellTDStart(gridCell);
        String verticalAlignment = "top";
        switch (text.getVerticalAlignmentValue()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        if (!verticalAlignment.equals("top")) {
            this.writer.write(" valign=\"");
            this.writer.write(verticalAlignment);
            this.writer.write("\"");
        }
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendBackcolorStyle(gridCell, styleBuffer);
        this.appendBorderStyle(gridCell.getBox(), styleBuffer);
        String horizontalAlignment = "left";
        if (textLength > 0) {
            switch (text.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    horizontalAlignment = "right";
                    break;
                }
                case CENTER: {
                    horizontalAlignment = "center";
                    break;
                }
                case JUSTIFIED: {
                    horizontalAlignment = "justify";
                    break;
                }
                default: {
                    horizontalAlignment = "left";
                }
            }
            if (text.getRunDirectionValue() == RunDirectionEnum.LTR && !horizontalAlignment.equals("left") || text.getRunDirectionValue() == RunDirectionEnum.RTL && !horizontalAlignment.equals("right")) {
                styleBuffer.append("text-align: ");
                styleBuffer.append(horizontalAlignment);
                styleBuffer.append(";");
            }
        }
        if (this.isWrapBreakWord) {
            styleBuffer.append("width: " + this.toSizeUnit(gridCell.getWidth()) + "; ");
            styleBuffer.append("word-wrap: break-word; ");
        }
        if (text.getLineSpacingValue() != LineSpacingEnum.SINGLE) {
            styleBuffer.append("line-height: " + text.getLineSpacingFactor() + "; ");
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"/>");
        }
        this.startHyperlink((JRPrintHyperlink)text);
        if (textLength > 0) {
            String textTooltip = this.hyperlinkStarted ? null : text.getHyperlinkTooltip();
            this.exportStyledText(styledText, textTooltip, this.getTextLocale(text));
        } else {
            this.writer.write(this.emptyCellStringProvider.getStringForEmptyTD((Object)this.imagesURI));
        }
        this.endHyperlink();
        this.writer.write("</td>\n");
    }
}

