/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.model.vo.BackTask;
import com.security.ireport.model.vo.OperateResult;
import com.security.ireport.model.vo.PageInfo;
import com.security.ireport.model.vo.ParamPage;
import com.security.ireport.service.BackTaskService;
import com.security.ireport.util.DBConnPool;
import com.security.ireport.util.DBSpecialCharHandleUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class BackTaskServiceImpl
implements BackTaskService {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    @Override
    public long addBackTask(BackTask backTask) throws SQLException {
        List<Object[]> backTaskCount = null;
        long count = 0L;
        String sql = "";
        try {
            Long createDate = backTask.getCreateDate() / 1000L;
            Long endDate = backTask.getEndDate() / 1000L;
            long sessionId = backTask.getSessionId();
            int state = backTask.getState();
            String reportId = backTask.getReportId();
            String reportName = backTask.getReportName();
            String reportCondition = backTask.getReportCondition();
            sql = "INSERT INTO IREPORT_BACK_TASK(CREATE_DATE,END_DATE,SESSIONID,STATE,REPORT_ID,REPORT_NAME,REPORT_CONDITION) VALUES(?,?,?,?,?,?,?)";
            Object[] psSqlArgs = new Object[]{createDate.toString(), endDate.toString(), String.valueOf(sessionId), String.valueOf(state), reportId, reportName, reportCondition};
            DBConnPool.save(sql, psSqlArgs);
            backTaskCount = DBConnPool.find("SELECT MAX(PKID) FROM IREPORT_BACK_TASK", new Object[0]);
            if (!backTaskCount.isEmpty()) {
                count = IReportConfCheckUtil.getLong(backTaskCount.get(0)[0]);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"addBackTask SQLException");
            throw e;
        }
        return count;
    }

    @Override
    public void changeFieldValue(long backTaskId, String fieldName, String value) throws SQLException {
        String regular;
        String sql = "";
        if (fieldName.equalsIgnoreCase("END_DATE")) {
            long endDate = Long.parseLong(value) / 1000L;
            value = Long.toString(endDate);
        }
        if (!Pattern.matches(regular = "^[A-Za-z0-9|_|.]+$", fieldName.trim())) {
            return;
        }
        Object[] psSqlArgs = new Object[]{value, String.valueOf(backTaskId)};
        sql = "UPDATE IREPORT_BACK_TASK SET " + fieldName + "=?  WHERE PKID=?";
        DBConnPool.update(sql, psSqlArgs);
    }

    @Override
    public List<OperateResult> delBackTask(String backTaskId) {
        ArrayList<OperateResult> result = new ArrayList<OperateResult>();
        if (null == backTaskId || backTaskId.isEmpty()) {
            return result;
        }
        List<Object[]> resultList = null;
        String[] backTaskIds = backTaskId.split(",");
        Object[] ibackTaskIds = new Integer[backTaskIds.length];
        for (int i = 0; i < ibackTaskIds.length; ++i) {
            ibackTaskIds[i] = Integer.valueOf(backTaskIds[i]);
        }
        StringBuffer ids = new StringBuffer();
        try {
            String params = DBConnPool.createInParameters(ibackTaskIds);
            String queryString = "SELECT PKID FROM IREPORT_BACK_TASK WHERE PKID IN (" + params + ")";
            resultList = DBConnPool.find(queryString, ibackTaskIds);
            if (!resultList.isEmpty()) {
                Object[] toDelBackTaskIds = new Integer[resultList.size()];
                for (int i = 0; i < resultList.size(); ++i) {
                    toDelBackTaskIds[i] = Integer.valueOf(resultList.get(i)[0].toString());
                }
                String toDelParams = DBConnPool.createInParameters(toDelBackTaskIds);
                String toDelSql = "DELETE FROM IREPORT_BACK_TASK WHERE PKID IN (" + toDelParams + ")";
                DBConnPool.delete(toDelSql, toDelBackTaskIds);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delBackTask SQLException");
            OperateResult item = new OperateResult();
            item.setObjId(ids.toString());
            item.setResult(false);
            item.setResultInfo("SQL ERROR");
            result.add(item);
        }
        return result;
    }

    @Override
    public void delBackTaskByReportId(String reportId) {
        String sql = "";
        try {
            sql = "DELETE FROM IREPORT_BACK_TASK WHERE REPORT_ID=?";
            Object[] psSqlArgs = new Object[]{reportId};
            DBConnPool.delete(sql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delBackTaskByReportId SQLException");
        }
    }

    @Override
    public BackTask getBackTask(String backTaskId) {
        BackTask backTask = null;
        String queryString = "SELECT PKID,REPORT_NAME,CREATE_DATE,END_DATE,REPORT_CONDITION,REPORT_ID,SESSIONID,STATE FROM IREPORT_BACK_TASK WHERE PKID= ? ";
        List<Object[]> resultList = DBConnPool.find(queryString, new Object[]{Integer.valueOf(backTaskId)});
        ArrayList<BackTask> list = new ArrayList<BackTask>();
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createBackTask(objs));
            }
        }
        if (!list.isEmpty()) {
            backTask = (BackTask)list.get(0);
        }
        return backTask;
    }

    @Override
    public PageInfo queryBackTask(ParamPage page, BackTask queryVO, Locale locale) {
        List<Object[]> resultList;
        String queryString = "SELECT PKID,REPORT_NAME,CREATE_DATE,END_DATE,REPORT_CONDITION,REPORT_ID,SESSIONID,STATE FROM IREPORT_BACK_TASK ";
        String whereSql = "";
        ArrayList<String> params = new ArrayList<String>();
        if (queryVO != null) {
            whereSql = " WHERE REPORT_NAME LIKE ?";
            params.add(queryVO.getReportName());
            whereSql = whereSql + DBSpecialCharHandleUtil.getEscape();
        }
        String countSql = "SELECT COUNT(0) FROM IREPORT_BACK_TASK ";
        countSql = countSql + whereSql;
        queryString = queryString + whereSql;
        int totalNum = DBConnPool.findCount(countSql, params.toArray());
        ArrayList<BackTask> list = new ArrayList<BackTask>();
        int limit = page.getLimit();
        if (totalNum < page.getStart() + limit) {
            limit = totalNum - page.getStart();
        }
        if (!(resultList = DBConnPool.find(queryString = queryString + " limit " + page.getStart() + "," + limit, params.toArray())).isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createBackTask(objs));
            }
        }
        PageInfo returnPageInfo = new PageInfo(list, page, totalNum);
        return returnPageInfo;
    }

    private BackTask createBackTask(Object[] item) {
        BackTask obj = new BackTask();
        Locale locale = ProductFaceUtil.getInstance().getUserLocale();
        int i = 0;
        obj.setBackTaskId(IReportConfCheckUtil.getInteger(item[i++]));
        obj.setReportName(IReportUtil.getProperty(IReportConfCheckUtil.getObjectStr(item[i++]), obj.getReportId(), locale));
        obj.setCreateDate(IReportConfCheckUtil.getLong(item[i++]));
        obj.setEndDate(IReportConfCheckUtil.getLong(item[i++]));
        obj.setReportCondition(IReportConfCheckUtil.getObjectStr(item[i++]));
        obj.setReportId(IReportConfCheckUtil.getObjectStr(item[i++]));
        obj.setSessionId(IReportConfCheckUtil.getLong(item[i++].toString()));
        obj.setState(IReportConfCheckUtil.getInteger(item[i++]));
        return obj;
    }
}

