/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.model.vo.PageInfo;
import com.security.ireport.model.vo.ParamPage;
import com.security.ireport.model.vo.ReportTemplate;
import com.security.ireport.model.vo.TemplateCondition;
import com.security.ireport.service.ReportTemplateService;
import com.security.ireport.service.TimeTaskService;
import com.security.ireport.service.impl.TimeTaskServiceImpl;
import com.security.ireport.util.DBConnPool;
import com.security.ireport.util.DBSpecialCharHandleUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ReportTemplateServiceImpl
implements ReportTemplateService {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private transient TimeTaskService timeTaskService = new TimeTaskServiceImpl();

    private ReportTemplate createReportTemplate(Object[] item) {
        ReportTemplate obj = new ReportTemplate();
        int i = 0;
        obj.setTemplateId(IReportConfCheckUtil.getInteger(item[i++]));
        obj.setUserName(IReportConfCheckUtil.getObjectStr(item[i++]));
        obj.setDesc(IReportConfCheckUtil.getObjectStr(item[i++]));
        obj.setName(IReportConfCheckUtil.getObjectStr(item[i++]));
        return obj;
    }

    private TemplateCondition createTemplateCondition(Object[] item) {
        TemplateCondition obj = new TemplateCondition();
        int i = 0;
        Locale locale = ProductFaceUtil.getInstance().getUserLocale();
        obj.setPkid(IReportConfCheckUtil.getInteger(item[i++]));
        obj.setReportCondition(IReportConfCheckUtil.getObjectStr(item[i++]));
        obj.setReportId(IReportConfCheckUtil.getObjectStr(item[i++]));
        obj.setTemplateId(IReportConfCheckUtil.getInteger(item[i++]));
        IReport report = PluginManager.getInstance().getReportPlugin(obj.getReportId());
        if (report != null) {
            obj.setReportName(IReportUtil.getProperty(report.getName(), obj.getReportId(), locale));
        }
        return obj;
    }

    @Override
    public PageInfo queryTemplate(ParamPage page, ReportTemplate queryVO) {
        List<Object[]> resultList;
        ArrayList<String> params = new ArrayList<String>();
        String whereSql = "";
        if (queryVO != null) {
            whereSql = "WHERE TEMPLATE_NAME LIKE ?";
            params.add("%" + queryVO.getName() + "%");
            whereSql = whereSql + DBSpecialCharHandleUtil.getEscape();
        }
        String countSQL = "SELECT COUNT(0) FROM IREPORT_TEMPLATE ";
        countSQL = countSQL + whereSql;
        int totalNum = DBConnPool.findCount(countSQL, params.toArray());
        String queryString = "SELECT PKID,USERNAME,TEMPLATE_DESC,TEMPLATE_NAME FROM IREPORT_TEMPLATE ";
        queryString = queryString + whereSql;
        queryString = queryString + " ORDER BY PKID ";
        ArrayList<ReportTemplate> list = new ArrayList<ReportTemplate>();
        int limit = page.getLimit();
        if (totalNum < page.getStart() + limit) {
            limit = totalNum - page.getStart();
        }
        if (!(resultList = DBConnPool.find(queryString = queryString + " limit " + page.getStart() + "," + limit, params.toArray())).isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createReportTemplate(objs));
            }
        }
        PageInfo returnPageInfo = new PageInfo(list, page, totalNum);
        return returnPageInfo;
    }

    @Override
    public int addTemplate(ReportTemplate reportTemplate) throws SQLException {
        Integer maxId = null;
        try {
            if (this.hasTemplateName(reportTemplate.getName())) {
                return 0;
            }
            String sql = "INSERT INTO IREPORT_TEMPLATE(TEMPLATE_NAME,USERNAME,TEMPLATE_DESC) VALUES(?,?,?)";
            String name = reportTemplate.getName();
            String userName = reportTemplate.getUserName();
            String desc = reportTemplate.getDesc();
            Object[] psSqlArgs = new Object[]{name, userName, desc};
            DBConnPool.save(sql, psSqlArgs);
            maxId = DBConnPool.findCount("SELECT MAX(PKID) FROM IREPORT_TEMPLATE", new Object[0]);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"addTemplate SQLException");
            throw e;
        }
        return maxId;
    }

    @Override
    public ReportTemplate getTemplateById(String templateId) {
        ReportTemplate reportTemplateVO = null;
        String queryString = "SELECT PKID,USERNAME,TEMPLATE_DESC,TEMPLATE_NAME FROM IREPORT_TEMPLATE WHERE PKID=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(templateId);
        ArrayList<ReportTemplate> list = new ArrayList<ReportTemplate>();
        List<Object[]> resultList = DBConnPool.find(queryString, params.toArray());
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createReportTemplate(objs));
            }
        }
        if (!list.isEmpty()) {
            reportTemplateVO = (ReportTemplate)list.get(0);
        }
        return reportTemplateVO;
    }

    @Override
    public boolean updateTemplate(ReportTemplate reportTemplate) throws SQLException {
        try {
            if (this.hasTemplateNameWithId(reportTemplate.getTemplateId(), reportTemplate.getName())) {
                return false;
            }
            String sql = "UPDATE IREPORT_TEMPLATE SET  TEMPLATE_NAME=?, TEMPLATE_DESC=?, USERNAME=? WHERE PKID=?";
            Object[] psSqlArgs = new Object[]{reportTemplate.getName(), reportTemplate.getDesc(), reportTemplate.getUserName(), reportTemplate.getTemplateId()};
            DBConnPool.update(sql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"updateTemplate SQLException");
        }
        return true;
    }

    @Override
    public String delTemplate(String templateId) throws SQLException {
        StringBuffer names = new StringBuffer();
        if (null == templateId || templateId.isEmpty()) {
            return names.toString();
        }
        List<Object[]> resultList = null;
        String delTempSql = "";
        String delTempCondSql = "";
        try {
            String[] toSelectTemplateIds = templateId.split(",");
            Object[] selectTemplateIds = new Integer[toSelectTemplateIds.length];
            for (int i = 0; i < selectTemplateIds.length; ++i) {
                selectTemplateIds[i] = Integer.valueOf(toSelectTemplateIds[i]);
            }
            String params = DBConnPool.createInParameters(selectTemplateIds);
            String queryString = "SELECT PKID,TEMPLATE_NAME FROM IREPORT_TEMPLATE WHERE PKID IN (" + params + ")";
            resultList = DBConnPool.find(queryString, selectTemplateIds);
            if (!resultList.isEmpty()) {
                Object[] toDelTemplateIds = new Integer[resultList.size()];
                for (int i = 0; i < resultList.size(); ++i) {
                    toDelTemplateIds[i] = Integer.valueOf(resultList.get(i)[0].toString());
                    names.append(resultList.get(i)[1].toString()).append(',');
                }
                String delParams = DBConnPool.createInParameters(toDelTemplateIds);
                delTempSql = "DELETE FROM IREPORT_TEMPLATE WHERE PKID IN (" + delParams + ")";
                DBConnPool.delete(delTempSql, toDelTemplateIds);
                delTempCondSql = "DELETE FROM IREPORT_TEMPLATE_CONDITION WHERE TEMPLATE_ID IN (" + delParams + ")";
                DBConnPool.delete(delTempCondSql, toDelTemplateIds);
            }
            this.timeTaskService.delTaskConditionByTemId(templateId);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delTemplate SQLException");
            throw e;
        }
        return names.substring(0, names.length() - 1);
    }

    @Override
    public List<Object[]> getTemplateIdByDeviceName(String deviceName) {
        if (null == deviceName || deviceName.isEmpty()) {
            return null;
        }
        List<Object[]> templateIdList = null;
        String queryString = "SELECT DISTINCT TEMPLATE_ID FROM IREPORT_TEMPLATE_CONDITION WHERE REPORT_CONDITION LIKE '%" + deviceName + "%'";
        templateIdList = DBConnPool.find(queryString);
        if (!templateIdList.isEmpty()) {
            return templateIdList;
        }
        return null;
    }

    @Override
    public List<Object[]> getTaskIdByTemplateId(Integer[] templateIds) {
        if (null == templateIds) {
            return null;
        }
        StringBuffer sbfParams = new StringBuffer();
        for (int i = 0; i < templateIds.length; ++i) {
            sbfParams.append(templateIds[i].toString());
            sbfParams.append(",");
        }
        String params = sbfParams.substring(0, sbfParams.length() - 1);
        List<Object[]> taskIdList = null;
        String queryString = "SELECT PKID,TASK_ID FROM IREPORT_TASK_CONDITION WHERE TEMPLATE_ID IN (" + params + ")";
        taskIdList = DBConnPool.find(queryString);
        return taskIdList;
    }

    @Override
    public void addReportCondition(TemplateCondition templateCondition) throws SQLException {
        try {
            String sql = "INSERT INTO IREPORT_TEMPLATE_CONDITION (REPORT_ID,TEMPLATE_ID,REPORT_CONDITION) VALUES (?,?,?)";
            String reportId = templateCondition.getReportId();
            Integer templateId = templateCondition.getTemplateId();
            String escapeStrForSql = this.escapeStrForSql(templateCondition.getReportCondition());
            Object[] psSqlArgs = new Object[]{reportId, String.valueOf(templateId), escapeStrForSql};
            DBConnPool.save(sql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"addReportCondition SQLException");
            throw e;
        }
    }

    @Override
    public List<TemplateCondition> getConditionByTemId(String id) {
        String fromSql = "SELECT PKID,REPORT_CONDITION,REPORT_ID,TEMPLATE_ID FROM IREPORT_TEMPLATE_CONDITION WHERE TEMPLATE_ID=? ORDER BY PKID";
        ArrayList<TemplateCondition> list = new ArrayList<TemplateCondition>();
        Object[] psSqlArgs = new Object[]{Integer.valueOf(id)};
        List<Object[]> resultList = DBConnPool.find(fromSql, psSqlArgs);
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createTemplateCondition(objs));
            }
        }
        return list;
    }

    @Override
    public String getTemNameByTemId(Integer templateId) throws SQLException {
        String templateName = "";
        String queryString = "SELECT PKID,USERNAME,TEMPLATE_DESC,TEMPLATE_NAME FROM IREPORT_TEMPLATE WHERE PKID=?";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(templateId);
        ArrayList<ReportTemplate> list = new ArrayList<ReportTemplate>();
        List<Object[]> resultList = DBConnPool.find(queryString, params.toArray());
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createReportTemplate(objs));
            }
        }
        if (!list.isEmpty()) {
            templateName = ((ReportTemplate)list.get(0)).getName();
        }
        return templateName;
    }

    @Override
    public void delConditionByTemId(String id) throws SQLException {
        try {
            String sql = "DELETE FROM IREPORT_TEMPLATE_CONDITION WHERE TEMPLATE_ID=?";
            Object[] psSqlArgs = new Object[]{Integer.valueOf(id)};
            DBConnPool.delete(sql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delConditionByTemId SQLException");
            throw e;
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)this.getcleanedMessage(e.getMessage()));
            throw e;
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void delConditionByReportId(String id) {
        List<Object[]> resultList = null;
        String templateId = "";
        String sql = "SELECT TEMPLATE_ID FROM IREPORT_TEMPLATE_CONDITION WHERE REPORT_ID=?";
        try {
            Object[] psSqlArgs = new Object[]{id};
            resultList = DBConnPool.find(sql, psSqlArgs);
            sql = "DELETE FROM IREPORT_TEMPLATE_CONDITION WHERE REPORT_ID=?";
            DBConnPool.delete(sql, psSqlArgs);
            if (resultList.isEmpty()) {
                return;
            }
            sql = "SELECT * FROM IREPORT_TEMPLATE_CONDITION WHERE TEMPLATE_ID=?";
            for (int i = 0; i < resultList.size(); ++i) {
                templateId = resultList.get(i)[0].toString();
                Object[] sqlArgs = new Object[]{Integer.valueOf(templateId)};
                List<Object[]> temp = DBConnPool.find(sql, sqlArgs);
                if (!temp.isEmpty()) continue;
                this.delTemplate(templateId);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delConditionByReportId SQLException");
        }
    }

    @Override
    public boolean hasTemplateName(String templateName) {
        String sql = "SELECT TEMPLATE_NAME FROM IREPORT_TEMPLATE WHERE TEMPLATE_NAME=?";
        Object[] psSqlArgs = new Object[]{templateName};
        List<Object[]> resultList = DBConnPool.find(sql, psSqlArgs);
        return !resultList.isEmpty();
    }

    @Override
    public List<ReportTemplate> getAllTemplate() throws SQLException {
        String queryString = "SELECT PKID,USERNAME,TEMPLATE_DESC,TEMPLATE_NAME FROM IREPORT_TEMPLATE ";
        queryString = queryString + " ORDER BY PKID ";
        ArrayList params = new ArrayList();
        ArrayList<ReportTemplate> list = new ArrayList<ReportTemplate>();
        List<Object[]> resultList = DBConnPool.find(queryString, params.toArray());
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createReportTemplate(objs));
            }
        }
        return list;
    }

    @Override
    public int deleteValidate(String templateId) throws SQLException {
        String sql = "SELECT COUNT(0) FROM IREPORT_TASK_CONDITION WHERE TEMPLATE_ID=?";
        Object[] psSqlArgs = new Object[]{Integer.valueOf(templateId)};
        return DBConnPool.findCount(sql, psSqlArgs);
    }

    private boolean hasTemplateNameWithId(Integer id, String temName) {
        String sql = "SELECT TEMPLATE_NAME FROM IREPORT_TEMPLATE WHERE TEMPLATE_NAME=? AND PKID != ?";
        List<Object[]> resultList = null;
        Object[] psSqlArgs = new Object[]{temName, id};
        resultList = DBConnPool.find(sql, psSqlArgs);
        return !resultList.isEmpty();
    }

    private String escapeStrForSql(String str) {
        String result = str.replace("'", "''");
        String dbType = IReportConfigUtil.getInstance().getDBType();
        if ("mysql".equals(dbType)) {
            result = result.replace("\\", "\\\\");
        }
        return result;
    }
}

