/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.model.vo.OperateResult;
import com.security.ireport.model.vo.PageInfo;
import com.security.ireport.model.vo.ParamPage;
import com.security.ireport.model.vo.TaskLog;
import com.security.ireport.model.vo.TaskLogVO;
import com.security.ireport.service.ResultReportService;
import com.security.ireport.util.DBConnPool;
import com.security.ireport.util.DBSpecialCharHandleUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ResultReportServiceImpl
implements ResultReportService {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    @Override
    public PageInfo queryTask(ParamPage page, TaskLogVO queryVO) {
        List<Object[]> resultList;
        String selectSql = " WHERE RESULT_INFO = '0' ";
        String orderSql = " ORDER BY PKID DESC ";
        String countSQL = "SELECT COUNT(0) FROM IREPORT_TASK_LOG WHERE RESULT_INFO = '0' ";
        String whereSql = "";
        ArrayList<String> params = new ArrayList<String>();
        if (queryVO != null) {
            if (!IReportConfCheckUtil.isStringEmpty(queryVO.getReportName())) {
                whereSql = whereSql + " AND REPORT_NAME LIKE ? ";
                params.add("%" + DBSpecialCharHandleUtil.changeSpecialCharByEscape(queryVO.getReportName()) + "%");
                whereSql = whereSql + DBSpecialCharHandleUtil.getEscape();
            }
            if (!IReportConfCheckUtil.isStringEmpty(queryVO.getUserName()) && !"admin".equalsIgnoreCase(queryVO.getUserName())) {
                whereSql = whereSql + " AND USERNAME = ? ";
                params.add(queryVO.getUserName());
            }
            if (!IReportConfCheckUtil.isStringEmpty(queryVO.getAuthId())) {
                whereSql = whereSql + " AND AUTH_ID = ? ";
                params.add(queryVO.getAuthId());
            }
        }
        selectSql = selectSql + whereSql;
        countSQL = countSQL + whereSql;
        selectSql = selectSql + orderSql;
        int totalNum = DBConnPool.findCount(countSQL, params.toArray());
        String fromSql = "SELECT PKID,REPORT_NAME,RESULT_INFO,END_TIME,RUN_TIME,RESULT_FILE,TASK_ID,AUTH_ID,USERNAME,CONDITION_ID,SCHEDULE FROM IREPORT_TASK_LOG ";
        fromSql = fromSql + selectSql;
        ArrayList<TaskLogVO> list = new ArrayList<TaskLogVO>();
        int limit = page.getLimit();
        if (totalNum < page.getStart() + limit) {
            limit = totalNum - page.getStart();
        }
        if (!(resultList = DBConnPool.find(fromSql = fromSql + " limit " + page.getStart() + "," + limit, params.toArray())).isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(ResultReportServiceImpl.createTaskLogVO(objs));
            }
        }
        PageInfo returnPageInfo = new PageInfo(list, page, totalNum);
        return returnPageInfo;
    }

    public List<TaskLog> logInfo(String taskId) {
        String fromSql = "SELECT PKID,REPORT_NAME,RESULT_INFO,END_TIME,RUN_TIME,RESULT_FILE,TASK_ID,AUTH_ID,USERNAME,CONDITION_ID,SCHEDULE FROM IREPORT_TASK_LOG  WHERE TASK_ID=?";
        ArrayList<TaskLog> list = new ArrayList<TaskLog>();
        Object[] psSqlArgs = new Object[]{taskId};
        List<Object[]> resultList = DBConnPool.find(fromSql, psSqlArgs);
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createTaskLog(objs));
            }
        }
        return list;
    }

    @Override
    public List<TaskLogVO> resultInfo(String taskId) {
        String fromSql = "SELECT PKID,REPORT_NAME,RESULT_INFO,END_TIME,RUN_TIME,RESULT_FILE,TASK_ID,AUTH_ID,USERNAME,CONDITION_ID,SCHEDULE  FROM IREPORT_TASK_LOG  WHERE TASK_ID=?";
        ArrayList<TaskLogVO> list = new ArrayList<TaskLogVO>();
        List<Object[]> resultList = DBConnPool.find(fromSql, new Object[]{Integer.valueOf(taskId)});
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(ResultReportServiceImpl.createTaskLogVO(objs));
            }
        }
        return list;
    }

    public String getTaskName(Integer taskId) {
        List<Object[]> resultState = null;
        String queryString = "SELECT TASK_NAME FROM IREPORT_TASK WHERE PKID= ?";
        resultState = DBConnPool.find(queryString, new Object[]{taskId});
        return resultState.get(0)[0].toString();
    }

    @Override
    public OperateResult delResultReport(String[] logId) {
        OperateResult delResult = new OperateResult();
        if (null == logId || logId.length == 0) {
            return delResult;
        }
        String params = DBConnPool.createInParameters(logId);
        String resultFilePath = IReportMgrUtil.getExportPath();
        List<Object[]> resultFileList = null;
        try {
            Object[] iLogIds = new Integer[logId.length];
            for (int i = 0; i < iLogIds.length; ++i) {
                iLogIds[i] = Integer.valueOf(logId[i]);
            }
            String queryString = "SELECT RESULT_FILE FROM IREPORT_TASK_LOG WHERE PKID IN (" + params + ")";
            resultFileList = DBConnPool.find(queryString, iLogIds);
            String delSql = "DELETE FROM IREPORT_TASK_LOG WHERE PKID IN (" + params + ")";
            DBConnPool.delete(delSql, iLogIds);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delResultReport failed SQLException");
            delResult.setObjId(((Object[])resultFileList.get(0))[0].toString());
            delResult.setResult(false);
            delResult.setResultInfo("DEL ERROR");
        }
        if (!resultFileList.isEmpty()) {
            for (Object[] item : resultFileList) {
                String filePath = resultFilePath + File.separator + item[0].toString();
                IReportUtil.deleteFile(filePath);
            }
        }
        return delResult;
    }

    @Override
    public void updateResultReportByTaskId(List<Integer> taskId) {
        if (null == taskId || taskId.isEmpty()) {
            return;
        }
        try {
            String delLogStrRes = DBConnPool.createInParameters(taskId.toArray());
            String sql = "UPDATE IREPORT_TASK_LOG SET TASK_ID=NULL WHERE TASK_ID IN (" + delLogStrRes + ")";
            DBConnPool.update(sql, taskId.toArray());
        }
        catch (SQLException e) {
            LOGGER.error((Object)"updateResultReportByTaskId failed SQLException");
        }
    }

    @Override
    public List<TaskLogVO> getResults(String[] logId) {
        ArrayList<TaskLogVO> retList = new ArrayList<TaskLogVO>();
        String params = DBConnPool.createInParameters(logId);
        String queryString = "SELECT PKID,REPORT_NAME,RESULT_INFO,END_TIME,RUN_TIME,RESULT_FILE,TASK_ID,AUTH_ID,USERNAME,CONDITION_ID,SCHEDULE  FROM IREPORT_TASK_LOG  WHERE PKID IN (" + params + ")";
        Object[] iLogIds = new Integer[logId.length];
        for (int i = 0; i < iLogIds.length; ++i) {
            iLogIds[i] = Integer.valueOf(logId[i]);
        }
        List<Object[]> resultList = DBConnPool.find(queryString, iLogIds);
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                retList.add(ResultReportServiceImpl.createTaskLogVO(objs));
            }
        }
        return retList;
    }

    @Override
    public TaskLogVO getResult(String logId) {
        TaskLogVO obj = null;
        String fromSql = "SELECT PKID,REPORT_NAME,RESULT_INFO,END_TIME,RUN_TIME,RESULT_FILE,TASK_ID,AUTH_ID,USERNAME,CONDITION_ID,SCHEDULE  FROM IREPORT_TASK_LOG  WHERE PKID=? ";
        ArrayList<TaskLogVO> list = new ArrayList<TaskLogVO>();
        List<Object[]> resultList = DBConnPool.find(fromSql, new Object[]{Integer.valueOf(logId)});
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(ResultReportServiceImpl.createTaskLogVO(objs));
            }
        }
        if (!list.isEmpty()) {
            obj = (TaskLogVO)list.get(0);
        }
        return obj;
    }

    @Override
    public boolean saveLogToDBFile(TaskLog taskLog) {
        boolean blOk = false;
        try {
            String authId = taskLog.getAuthId();
            String saveSQL = "INSERT INTO IREPORT_TASK_LOG(REPORT_NAME, RESULT_INFO, END_TIME, RUN_TIME, RESULT_FILE, TASK_ID, AUTH_ID, USERNAME,CONDITION_ID,SCHEDULE) VALUES(?,?,?,?,?,?,?,?,?,?)";
            String strEndTime = String.valueOf(taskLog.getEndTime());
            String strRunTime = String.valueOf(taskLog.getRunTime());
            String strTaskId = String.valueOf(taskLog.getTaskId());
            String strConditionId = String.valueOf(taskLog.getConditionId());
            String strSchedule = String.valueOf(taskLog.getSchedule());
            Object[] psSqlArgs = new Object[]{taskLog.getReportName(), taskLog.getResultInfo(), strEndTime, strRunTime, taskLog.getResultFile(), strTaskId, authId, taskLog.getUserName(), strConditionId, strSchedule};
            DBConnPool.save(saveSQL, psSqlArgs);
            blOk = true;
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Write time task log to table failed SQLException");
        }
        return blOk;
    }

    @Override
    public int deleteReportFile(long startTime, long endTime, int schedule) {
        int size = 0;
        String fromSql = "SELECT PKID,REPORT_NAME,RESULT_INFO,END_TIME,RUN_TIME,RESULT_FILE,TASK_ID,AUTH_ID,USERNAME,CONDITION_ID,SCHEDULE FROM IREPORT_TASK_LOG  WHERE END_TIME >= ? AND END_TIME <=? AND SCHEDULE=?";
        ArrayList<TaskLog> taskLogList = new ArrayList<TaskLog>();
        Object[] psSqlArgs = new Object[]{startTime, endTime, schedule};
        List<Object[]> resultList = DBConnPool.find(fromSql, psSqlArgs);
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                taskLogList.add(this.createTaskLog(objs));
            }
        }
        String basePath = IReportUtil.getRealPath() + "/iReport/iReportBiz/customReport" + "/";
        String tempPath = null;
        for (int i = 0; i < taskLogList.size(); ++i) {
            tempPath = basePath + ((TaskLog)taskLogList.get(i)).getResultFile();
            File delFile = new File(tempPath);
            boolean delResult = delFile.delete();
            if (delResult) {
                ++size;
                continue;
            }
            LOGGER.error((Object)("file del failed, fileName=" + delFile.getName()));
        }
        String delSql = "DELETE FROM IREPORT_TASK_LOG  WHERE END_TIME >= ? AND END_TIME <=? AND SCHEDULE=?";
        try {
            psSqlArgs = new Object[]{startTime, endTime, schedule};
            DBConnPool.delete(delSql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"deleteReportFile failed");
        }
        return size;
    }

    private TaskLog createTaskLog(Object[] item) {
        TaskLog taskLog = new TaskLog();
        int i = 0;
        taskLog.setPkId(IReportConfCheckUtil.getInteger(item[i++]));
        taskLog.setReportName(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setResultInfo(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setEndTime(IReportConfCheckUtil.getLong(item[i++]));
        taskLog.setRunTime(IReportConfCheckUtil.getLong(item[i++]));
        taskLog.setResultFile(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setTaskId(IReportConfCheckUtil.getInteger(item[i++]));
        taskLog.setAuthId(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setUserName(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setConditionId(IReportConfCheckUtil.getInteger(item[i++]));
        taskLog.setSchedule(IReportConfCheckUtil.getInteger(item[i++]));
        return taskLog;
    }

    public static TaskLogVO createTaskLogVO(Object[] item) {
        TaskLogVO taskLog = new TaskLogVO();
        int i = 0;
        SimpleDateFormat smpDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        taskLog.setPkId(IReportConfCheckUtil.getInteger(item[i++]));
        taskLog.setReportName(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setResultInfo(IReportConfCheckUtil.getObjectStr(item[i++]));
        long endTimeLong = IReportConfCheckUtil.getLong(item[i++]);
        String endTime = "";
        if (endTimeLong != -1L) {
            endTime = smpDateFormat.format(new Date(endTimeLong * 1000L));
        }
        taskLog.setEndTime(endTime);
        long runTimeLong = IReportConfCheckUtil.getLong(item[i++]);
        String runTime = "";
        if (runTimeLong != -1L) {
            runTime = smpDateFormat.format(new Date(runTimeLong * 1000L));
        }
        taskLog.setRunTime(runTime);
        taskLog.setResultFile(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setTaskId(IReportConfCheckUtil.getInteger(item[i++]));
        taskLog.setAuthId(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setUserName(IReportConfCheckUtil.getObjectStr(item[i++]));
        taskLog.setConditionId(IReportConfCheckUtil.getInteger(item[i++]));
        taskLog.setSchedule(IReportConfCheckUtil.getInteger(item[i++]));
        taskLog.setTaskName(IReportUtil.getTaskName(taskLog.getTaskId()));
        return taskLog;
    }

    @Override
    public boolean hasDownloadPrivilege(String userName, String fileName) {
        String fromSql = "SELECT *  FROM IREPORT_TASK_LOG WHERE userName=? AND result_file=?";
        Object[] psSqlArgs = new Object[]{userName, fileName};
        List<Object[]> resultList = DBConnPool.find(fromSql, psSqlArgs);
        return !resultList.isEmpty();
    }
}

