/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.util.CollectionUtil;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.model.vo.OperateResult;
import com.security.ireport.model.vo.PageInfo;
import com.security.ireport.model.vo.ParamPage;
import com.security.ireport.model.vo.TaskCondition;
import com.security.ireport.model.vo.TaskLogVO;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.service.IHandleResultSet;
import com.security.ireport.service.impl.AbstractTimeService;
import com.security.ireport.service.impl.ReportTemplateServiceImpl;
import com.security.ireport.service.impl.ResultReportServiceImpl;
import com.security.ireport.task.IRTimeTaskMgr;
import com.security.ireport.util.DBConnPool;
import com.security.ireport.util.DBSpecialCharHandleUtil;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class TimeTaskServiceImpl
extends AbstractTimeService {
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    @Override
    public PageInfo queryTask(ParamPage page, TimeTask queryVO) {
        List<Object[]> resultList;
        String whereSql = " WHERE (1=1) ";
        ArrayList<Object> params = new ArrayList<Object>();
        if (queryVO.getTaskName() != null && queryVO.getTaskName().length() != 0) {
            whereSql = whereSql + " AND TASK_NAME LIKE ? ";
            params.add("%" + DBSpecialCharHandleUtil.changeSpecialCharByEscape(queryVO.getTaskName()) + "%");
            whereSql = whereSql + DBSpecialCharHandleUtil.getEscape();
        }
        if (queryVO.getState() != null) {
            whereSql = whereSql + " AND STATE = ?";
            params.add(queryVO.getState());
        }
        if (queryVO.getSchedule() != null) {
            whereSql = whereSql + " AND SCHEDULE = ?";
            params.add(queryVO.getSchedule());
        }
        if (!IReportConfCheckUtil.isStringEmpty(queryVO.getUserName()) && !"admin".equalsIgnoreCase(queryVO.getUserName())) {
            whereSql = whereSql + " AND USERNAME = ? ";
            params.add(queryVO.getUserName());
        }
        if (!IReportConfCheckUtil.isStringEmpty(queryVO.getAuthId())) {
            whereSql = whereSql + " AND AUTH_ID = ? ";
            params.add(queryVO.getAuthId());
        }
        String countSQL = "SELECT COUNT(0) FROM IREPORT_TASK ";
        countSQL = countSQL + whereSql;
        String orderSql = " ORDER BY PKID DESC ";
        whereSql = whereSql + orderSql;
        int totalNum = DBConnPool.findCount(countSQL, params.toArray());
        String fromSql = "SELECT PKID,LOCALE,RESULT_TYPE,START_DATE,END_DATE,TASK_DESC,RUN_TIMING,TASK_NAME,SCHEDULE,STATE,STATISTIC_TIME,USERNAME,AUTH_ID FROM IREPORT_TASK ";
        fromSql = fromSql + whereSql;
        ArrayList<TimeTask> list = new ArrayList<TimeTask>();
        int limit = page.getLimit();
        if (totalNum < page.getStart() + limit) {
            limit = totalNum - page.getStart();
        }
        if (!(resultList = DBConnPool.find(fromSql = fromSql + " limit " + page.getStart() + "," + limit, params.toArray())).isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createTimeTask(objs));
            }
        }
        PageInfo returnPageInfo = new PageInfo(list, page, totalNum);
        return returnPageInfo;
    }

    private TimeTask createTimeTask(Object[] item) {
        TimeTask timeTaskVO = new TimeTask();
        int i = 0;
        timeTaskVO.setTaskId(IReportUtil.tranToInteger(item[i++]));
        timeTaskVO.setLocale(IReportConfCheckUtil.getObjectStr(item[i++]));
        timeTaskVO.setResultType(IReportConfCheckUtil.getObjectStr(item[i++]));
        timeTaskVO.setStartDate(Long.valueOf(item[i++].toString()));
        timeTaskVO.setEndDate(Long.valueOf(item[i++].toString()));
        timeTaskVO.setTaskDesc(IReportConfCheckUtil.getObjectStr(item[i++]));
        timeTaskVO.setRunTime(IReportConfCheckUtil.getObjectStr(item[i++]));
        timeTaskVO.setTaskName(IReportConfCheckUtil.getObjectStr(item[i++]));
        timeTaskVO.setSchedule(IReportUtil.tranToInteger(item[i++]));
        timeTaskVO.setState(IReportUtil.tranToInteger(item[i++]));
        timeTaskVO.setStatisticTime(IReportConfCheckUtil.getObjectStr(item[i++]));
        timeTaskVO.setUserName(IReportConfCheckUtil.getObjectStr(item[i++]));
        timeTaskVO.setAuthId(IReportConfCheckUtil.getObjectStr(item[i++]));
        return timeTaskVO;
    }

    public List<TimeTask> queryTask(String name, Integer state, Integer schedule) {
        String sql = " WHERE (1=1) ";
        ArrayList<String> params = new ArrayList<String>();
        if (name != null) {
            sql = sql + " AND TASK_NAME LIKE ?0 ";
            params.add("%" + name + "%");
        }
        if (state != null) {
            sql = sql + " AND STATE = " + state;
        }
        if (schedule != null) {
            sql = sql + " AND SCHEDULE = " + schedule;
        }
        String fromSql = "SELECT PKID,LOCALE,RESULT_TYPE,START_DATE,END_DATE,TASK_DESC,RUN_TIMING,TASK_NAME,SCHEDULE,STATE,STATISTIC_TIME,USERNAME,AUTH_ID FROM IREPORT_TASK ";
        fromSql = fromSql + sql;
        ArrayList<TimeTask> list = new ArrayList<TimeTask>();
        List<Object[]> resultList = DBConnPool.find(fromSql, params.toArray());
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createTimeTask(objs));
            }
        }
        return list;
    }

    @Override
    public int queryTaskNumInId(List<Integer> taskIdList) {
        ArrayList<StringBuffer> params = new ArrayList<StringBuffer>();
        StringBuffer ids = new StringBuffer();
        String sql = "select count(*) from IREPORT_TASK where pkid in (?)";
        for (Integer taskId : CollectionUtil.emptyIfNull(taskIdList)) {
            if (!StringUtils.isBlank((CharSequence)ids)) {
                ids.append(",").append(taskId);
                continue;
            }
            ids.append(taskId);
        }
        params.add(ids);
        int number = DBConnPool.findCount(sql, params.toArray());
        return number;
    }

    @Override
    public List<OperateResult> delTimeTask(List<Integer> taskIdList) {
        ArrayList<OperateResult> result = new ArrayList<OperateResult>();
        StringBuffer delIdStr = new StringBuffer();
        for (Integer id : taskIdList) {
            delIdStr.append('\'').append(id.toString()).append('\'').append(',');
            IRTimeTaskMgr.getInstance().delTimeTask(id);
        }
        OperateResult opResult = null;
        try {
            Object[] psSqlArgs = taskIdList.toArray();
            if (Boolean.TRUE.toString().equalsIgnoreCase(IReportConfigUtil.getInstance().getConfig("ireport.timetask.delete"))) {
                StringBuffer sqlLog = new StringBuffer("DELETE FROM IREPORT_TASK_LOG WHERE TASK_ID IN (?");
                for (int i = 1; i < taskIdList.size(); ++i) {
                    sqlLog.append(",?");
                }
                sqlLog.append(")");
                DBConnPool.executeUpdate(sqlLog.toString(), psSqlArgs);
            }
            StringBuffer sqlTask = new StringBuffer("DELETE FROM IREPORT_TASK WHERE PKID IN (?");
            StringBuffer sqlCondition = new StringBuffer("DELETE FROM IREPORT_TASK_CONDITION WHERE TASK_ID IN (?");
            for (int i = 1; i < taskIdList.size(); ++i) {
                sqlTask.append(",?");
                sqlCondition.append(",?");
            }
            sqlTask.append(")");
            sqlCondition.append(")");
            DBConnPool.executeUpdate(sqlTask.toString(), psSqlArgs);
            DBConnPool.executeUpdate(sqlCondition.toString(), psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delTimeTask failed SQLException");
            opResult = new OperateResult();
            opResult.setObjId(delIdStr.substring(0, delIdStr.length() - 1));
            opResult.setResult(false);
            opResult.setResultInfo("SQL ERROR");
        }
        if (opResult != null) {
            result.add(opResult);
        }
        return result;
    }

    @Override
    public OperateResult delTimeTask(Integer taskId) {
        OperateResult result = null;
        if (taskId != null) {
            Object[] psSqlArgs = new Object[]{taskId};
            try {
                String sql = "";
                if (Boolean.TRUE.toString().equalsIgnoreCase(IReportConfigUtil.getInstance().getConfig("ireport.timetask.delete"))) {
                    sql = "DELETE FROM IREPORT_TASK_LOG WHERE TASK_ID = ?";
                    DBConnPool.delete(sql, psSqlArgs);
                }
                sql = "DELETE FROM IREPORT_TASK WHERE PKID=?";
                DBConnPool.delete(sql, psSqlArgs);
                sql = "DELETE FROM IREPORT_TASK_CONDITION WHERE TASK_ID=?";
                DBConnPool.delete(sql, psSqlArgs);
                IRTimeTaskMgr.getInstance().delTimeTask(taskId);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"delTimeTask failed SQLException");
                TimeTask timeTask = this.getTimeTask(taskId);
                result = new OperateResult();
                result.setObjId(taskId.toString());
                if (null == timeTask) {
                    LOGGER.error((Object)"timeTask is null.");
                } else {
                    result.setObjName(timeTask.getTaskName());
                }
                result.setResult(false);
                result.setResultInfo("SQL ERROR");
            }
        }
        return result;
    }

    @Override
    public List<TaskLogVO> getLogInfo(Integer taskId) {
        String fromSql = "SELECT PKID,REPORT_NAME,RESULT_INFO,END_TIME,RUN_TIME,RESULT_FILE,TASK_ID,AUTH_ID,USERNAME,CONDITION_ID,SCHEDULE  FROM IREPORT_TASK_LOG  WHERE TASK_ID=? ORDER BY PKID DESC ";
        ArrayList<TaskLogVO> list = new ArrayList<TaskLogVO>();
        List<Object[]> resultList = DBConnPool.find(fromSql, new Object[]{taskId});
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(ResultReportServiceImpl.createTaskLogVO(objs));
            }
        }
        return list;
    }

    @Override
    public String changeState(Integer taskId) {
        String result = "success";
        TimeTask timeTask = this.getTimeTask(taskId);
        if (timeTask != null) {
            if (0 == timeTask.getState()) {
                try {
                    String sql = "UPDATE IREPORT_TASK SET STATE=? WHERE PKID=?";
                    Object[] psSqlArgs = new Object[]{1, taskId};
                    int i = DBConnPool.update(sql, psSqlArgs);
                    if (0 == i) {
                        result = "error";
                        return result;
                    }
                    timeTask.setState(1);
                    IRTimeTaskMgr.getInstance().addTimeTask(timeTask);
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"changeState updateTask failed");
                    result = "fail";
                }
            } else if (1 == timeTask.getState()) {
                try {
                    String sql = "UPDATE IREPORT_TASK SET STATE=? WHERE PKID=?";
                    Object[] psSqlArgs = new Object[]{0, taskId};
                    DBConnPool.update(sql, psSqlArgs);
                    IRTimeTaskMgr.getInstance().delTimeTask(taskId);
                }
                catch (SQLException e) {
                    LOGGER.error((Object)"updateTask failed");
                    result = "fail";
                }
            }
        }
        return result;
    }

    @Override
    public Integer addTimeTask(TimeTask taskAdd) {
        Integer maxID = 0;
        try {
            if (this.checkName(taskAdd.getTaskName())) {
                return 0;
            }
            String authId = taskAdd.getAuthId();
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append("INSERT INTO IREPORT_TASK(START_DATE,END_DATE,TASK_DESC,RUN_TIMING,TASK_NAME,SCHEDULE,STATE,STATISTIC_TIME,USERNAME,RESULT_TYPE,LOCALE,AUTH_ID) ");
            sqlInsert.append("VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            Long startDate = taskAdd.getStartDate();
            Long endDate = taskAdd.getEndDate();
            Integer schedule = taskAdd.getSchedule();
            Integer state = taskAdd.getState();
            String resultType = taskAdd.getResultType();
            String locale = taskAdd.getLocale();
            Object[] psSqlArgs = new Object[]{startDate, endDate, taskAdd.getTaskDesc(), taskAdd.getRunTime(), taskAdd.getTaskName(), schedule, state, taskAdd.getStatisticTime(), taskAdd.getUserName(), resultType, locale, authId};
            DBConnPool.save(sqlInsert.toString(), psSqlArgs);
            maxID = DBConnPool.findCount(" SELECT MAX(PKID) FROM IREPORT_TASK", new Object[0]);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"addTimeTask failed SQLException");
        }
        return maxID;
    }

    @Override
    public Integer addExeTimeTask(TimeTask taskAdd) {
        Integer maxID = 0;
        try {
            String authId = ProductFaceUtil.getInstance().getUserInfo().getAreaId();
            StringBuffer sqlInsert = new StringBuffer();
            sqlInsert.append("INSERT INTO IREPORT_TASK(START_DATE,END_DATE,TASK_DESC,RUN_TIMING,TASK_NAME,SCHEDULE,STATE,STATISTIC_TIME,USERNAME,RESULT_TYPE,LOCALE,AUTH_ID) ");
            sqlInsert.append("VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            Long startDate = taskAdd.getStartDate();
            Long endDate = taskAdd.getEndDate();
            Integer schedule = taskAdd.getSchedule();
            Integer state = taskAdd.getState();
            String resultType = taskAdd.getResultType();
            String locale = taskAdd.getLocale();
            Object[] psSqlArgs = new Object[]{startDate, endDate, taskAdd.getTaskDesc(), taskAdd.getRunTime(), taskAdd.getTaskName(), schedule, state, taskAdd.getStatisticTime(), taskAdd.getUserName(), resultType, locale, authId};
            DBConnPool.save(sqlInsert.toString(), psSqlArgs);
            maxID = DBConnPool.findCount(" SELECT MAX(PKID) FROM IREPORT_TASK", new Object[0]);
            this.updateExeTimeTaskName(maxID);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"addExeTimeTask failed SQLException");
        }
        return maxID;
    }

    private boolean updateExeTimeTaskName(Integer pkid) {
        boolean flag = false;
        String sql = "UPDATE IREPORT_TASK set TASK_NAME =CONCAT(TASK_NAME,'_',PKID) WHERE PKID=?";
        try {
            Object[] psSqlArgs = new Object[]{pkid};
            int result = DBConnPool.update(sql, psSqlArgs);
            if (result > 0) {
                flag = true;
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"updateExeTimeTaskName failed SQLException");
        }
        return flag;
    }

    @Override
    public String addTaskCondition(List<TaskCondition> taskCondtionList) {
        String result = "";
        int maxID = 0;
        for (TaskCondition item : taskCondtionList) {
            try {
                String sql = "INSERT INTO IREPORT_TASK_CONDITION(TASK_ID,TEMPLATE_ID,REPORT_ID,REPORT_CONDITION) VALUES(?,?,?,?)";
                Object[] psSqlArgs = new Object[]{item.getTaskId(), item.getTemplateId(), item.getReportId(), item.getReportCondition()};
                DBConnPool.save(sql, psSqlArgs);
                maxID = DBConnPool.findCount(" SELECT MAX(PKID) FROM IREPORT_TASK_CONDITION", new Object[0]);
                result = result + maxID + ",";
            }
            catch (SQLException e) {
                LOGGER.error((Object)"addTaskCondition failed SQLException");
                result = "error";
            }
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    @Override
    public TimeTask getTimeTask(Integer taskId) {
        TimeTask timeTask = null;
        String fromSql = "SELECT PKID,LOCALE,RESULT_TYPE,START_DATE,END_DATE,TASK_DESC,RUN_TIMING,TASK_NAME,SCHEDULE,STATE,STATISTIC_TIME,USERNAME,AUTH_ID FROM IREPORT_TASK WHERE PKID =? ORDER BY PKID DESC ";
        List<Object[]> resultList = DBConnPool.find(fromSql, new Object[]{taskId});
        if (!resultList.isEmpty()) {
            Object[] objs = resultList.get(0);
            timeTask = this.createTimeTask(objs);
        }
        return timeTask;
    }

    @Override
    public List<TimeTask> getTimeTasks(String batchTaskId) {
        ArrayList<TimeTask> list = new ArrayList<TimeTask>();
        if (null == batchTaskId || batchTaskId.isEmpty()) {
            return list;
        }
        String[] taskIds = batchTaskId.split(",");
        Object[] taskIdList = new Integer[taskIds.length];
        for (int i = 0; i < taskIdList.length; ++i) {
            taskIdList[i] = Integer.valueOf(taskIds[i].trim());
        }
        String params = DBConnPool.createInParameters(taskIdList);
        String fromSql = "SELECT PKID,LOCALE,RESULT_TYPE,START_DATE,END_DATE,TASK_DESC,RUN_TIMING,TASK_NAME,SCHEDULE,STATE,STATISTIC_TIME,USERNAME,AUTH_ID FROM IREPORT_TASK  WHERE PKID IN(" + params + ")";
        List<Object[]> resultList = DBConnPool.find(fromSql, taskIdList);
        if (!resultList.isEmpty()) {
            for (Object[] objs : resultList) {
                list.add(this.createTimeTask(objs));
            }
        }
        return list;
    }

    @Override
    public List<TaskCondition> getTaskCondition(Integer taskId) throws SQLException {
        List<Object[]> resultList = null;
        ArrayList<TaskCondition> result = new ArrayList<TaskCondition>();
        try {
            String queryString = "SELECT PKID,TASK_ID,TEMPLATE_ID,REPORT_ID,REPORT_CONDITION FROM IREPORT_TASK_CONDITION WHERE TASK_ID =? ORDER BY TEMPLATE_ID ";
            resultList = DBConnPool.find(queryString, new Object[]{taskId});
            for (Object[] item : resultList) {
                TaskCondition taskCondition = new TaskCondition();
                int i = 0;
                Locale locale = LocaleUtil.getCurrentUserLocale();
                taskCondition.setPkId(IReportConfCheckUtil.getInteger(item[i++]));
                taskCondition.setTaskId(IReportConfCheckUtil.getInteger(item[i++]));
                taskCondition.setTemplateId(IReportConfCheckUtil.getInteger(item[i++]));
                taskCondition.setReportId(item[i++].toString());
                taskCondition.setReportCondition(item[i++].toString());
                if (PluginManager.getInstance().getReportPlugin(taskCondition.getReportId()) != null) {
                    taskCondition.setReportName(IReportUtil.getProperty(PluginManager.getInstance().getReportPlugin(taskCondition.getReportId()).getName(), taskCondition.getReportId(), locale));
                }
                if (taskCondition.getTemplateId() != 0) {
                    ReportTemplateServiceImpl reportTemplateService = new ReportTemplateServiceImpl();
                    String templateName = reportTemplateService.getTemNameByTemId(taskCondition.getTemplateId());
                    taskCondition.setTemplateName(templateName);
                }
                result.add(taskCondition);
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)"getTaskCondition failed SQLException");
        }
        return result;
    }

    @Override
    public String updateTimeTask(TimeTask timeTask, Integer taskId) {
        String result = "success";
        try {
            if (this.checkNameWithId(taskId, timeTask.getTaskName())) {
                return "error";
            }
            StringBuffer sbUpdateSql = new StringBuffer();
            sbUpdateSql.append("UPDATE IREPORT_TASK ");
            sbUpdateSql.append(" SET START_DATE=?,END_DATE=?,TASK_DESC=?,RUN_TIMING=?,TASK_NAME=?,SCHEDULE=?,STATISTIC_TIME=?,USERNAME=?,RESULT_TYPE=?,LOCALE=?,STATE=? ");
            sbUpdateSql.append(" WHERE PKID=?");
            Long startDate = timeTask.getStartDate();
            Long endDate = timeTask.getEndDate();
            String taskDesc = timeTask.getTaskDesc();
            String runTime = timeTask.getRunTime();
            String taskName = timeTask.getTaskName();
            Integer schedule = timeTask.getSchedule();
            String statisticTime = timeTask.getStatisticTime();
            String userName = timeTask.getUserName();
            String resultType = timeTask.getResultType();
            String locale = timeTask.getLocale();
            Integer state = timeTask.getState();
            Object[] psSqlArgs = new Object[]{startDate, endDate, taskDesc, runTime, taskName, schedule, statisticTime, userName, resultType, locale, state, taskId};
            DBConnPool.update(sbUpdateSql.toString(), psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"updateTimeTask failed SQLException");
            result = "error";
        }
        return result;
    }

    @Override
    public List<TimeTask> getTaskByState(Integer state) {
        return this.queryTask(null, state, null);
    }

    @Override
    public List<OperateResult> delTaskCondition(List<Integer> taskIdList) {
        ArrayList<OperateResult> resultList = null;
        if (taskIdList != null) {
            String sql = "DELETE FROM IREPORT_TASK_CONDITION WHERE TASK_ID=?";
            for (Integer item : taskIdList) {
                try {
                    Object[] psSqlArgs = new Object[]{item};
                    DBConnPool.delete(sql, psSqlArgs);
                    IRTimeTaskMgr.getInstance().delTimeTask(item);
                }
                catch (SQLException e) {
                    resultList = new ArrayList<OperateResult>();
                    LOGGER.error((Object)"delTaskCondition failed SQLException");
                    TimeTask timeTask = this.getTimeTask(item);
                    if (null == timeTask) continue;
                    OperateResult result = new OperateResult();
                    result.setObjId(item.toString());
                    result.setObjName(timeTask.getTaskName());
                    result.setResult(false);
                    result.setResultInfo("delete condition error");
                    resultList.add(result);
                }
            }
        }
        return resultList;
    }

    @Override
    public List<OperateResult> delTaskConditionByReportId(String reportId) {
        List<OperateResult> resultList = null;
        try {
            String sql = "DELETE FROM IREPORT_TASK_CONDITION WHERE REPORT_ID=?";
            Object[] psSqlArgs = new Object[]{reportId};
            DBConnPool.delete(sql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delTaskConditionByReportId failed SQLException");
        }
        return resultList;
    }

    @Override
    public void delTaskAndLogByReportId(String reportId) {
        try {
            String delSql = "DELETE FROM IREPORT_TASK WHERE PKID IN ( SELECT TASK_ID FROM IREPORT_TASK_CONDITION WHERE REPORT_ID=?)";
            Object[] psSqlArgs = new Object[]{reportId};
            DBConnPool.delete(delSql, psSqlArgs);
            delSql = "DELETE FROM IREPORT_TASK_LOG WHERE TASK_ID IN ( SELECT TASK_ID FROM IREPORT_TASK_CONDITION WHERE REPORT_ID=?)";
            DBConnPool.delete(delSql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delTaskAndLogByReportId failed SQLException");
        }
    }

    @Override
    public List<OperateResult> delTaskConditionByTemId(String templateId) {
        List<OperateResult> resultList = null;
        try {
            String sql = "DELETE FROM IREPORT_TASK_CONDITION WHERE TEMPLATE_ID IN ( ? )";
            Object[] psSqlArgs = new Object[]{templateId};
            DBConnPool.update(sql, psSqlArgs);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"delTaskConditionByTemId failed SQLException");
        }
        return resultList;
    }

    @Override
    public boolean updateTaskState(int taskId) {
        boolean blOk = false;
        try {
            String sql = "UPDATE IREPORT_TASK SET STATE =?  WHERE PKID=?";
            Object[] psSqlArgs = new Object[]{2, taskId};
            DBConnPool.update(sql, psSqlArgs);
            blOk = true;
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Update time task state value to table failed");
        }
        return blOk;
    }

    @Override
    public boolean checkName(String taskName) {
        boolean flag = false;
        String sql = "SELECT COUNT(0) FROM IREPORT_TASK WHERE TASK_NAME=?";
        Object[] psSqlArgs = new Object[]{taskName};
        int countNum = DBConnPool.findCount(sql, psSqlArgs);
        if (countNum != 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public List<String> getLogPathInfo(List<Integer> tasksDel) {
        StringBuffer delIdStr = new StringBuffer();
        for (Integer id : tasksDel) {
            delIdStr.append(id.toString()).append(',');
        }
        String querySql = "select RESULT_FILE from ireport_task_log where TASK_ID in (" + delIdStr.substring(0, delIdStr.length() - 1) + ") and RESULT_INFO='0' and RESULT_FILE is not null ";
        ArrayList<String> resultPaths = new ArrayList<String>();
        try {
            DBConnPool.executeQueryByIHandle(querySql, new InnerClass(resultPaths), new Object[0]);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"getLogPathInfo failed");
        }
        return resultPaths;
    }

    private static class InnerClass
    implements IHandleResultSet {
        private List<String> resultPaths;

        public InnerClass(List<String> resultPaths) {
            this.resultPaths = resultPaths;
        }

        @Override
        public void handleResultSet(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
                this.resultPaths.add(resultSet.getString("RESULT_FILE"));
            }
        }
    }
}

