/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.task;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.service.TimeTaskService;
import com.security.ireport.service.impl.TimeTaskServiceImpl;
import com.security.ireport.task.ThreadPoolTask;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportMgrUtil;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class IRTimeTaskMgr {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int INTERVAL = 2000;
    private static final int DEFAULT_CORE_POOL_SIZE = 10;
    private static final int MAX_POOL_SIZE = 15;
    private static final long KEEP_ALIVE_TIME = 0L;
    private static IRTimeTaskMgr timeTaskMgr = new IRTimeTaskMgr();
    private static ConcurrentHashMap<Integer, TimeTask> myTimeTaskList = new ConcurrentHashMap();
    private transient TimeTaskService timeTaskService = new TimeTaskServiceImpl();
    private Lock allTaskLock = new ReentrantLock();
    private TimeTaskThreadPool timeTaskThreadPool = null;
    private ThreadPoolExecutor threadPoolExecutor = null;

    private IRTimeTaskMgr() {
        this.initTimeTaskPool();
    }

    private void initTimeTaskPool() {
        try {
            int defaultPoolSize = 0;
            int maxPoolSize = 0;
            int loopInterval = 0;
            defaultPoolSize = IRTimeTaskMgr.getTimeTaskValue("same.run.task.default.count", 10);
            maxPoolSize = IRTimeTaskMgr.getTimeTaskValue("same.run.task.max.count", 15);
            loopInterval = IRTimeTaskMgr.getTimeTaskValue("loop.time.task.interval", 2000);
            if (maxPoolSize < defaultPoolSize) {
                maxPoolSize = defaultPoolSize;
            }
            this.threadPoolExecutor = new ThreadPoolExecutor(defaultPoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.timeTaskThreadPool = new TimeTaskThreadPool(loopInterval);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Instance time task pool failed:" + e.getMessage()));
        }
    }

    private static int getTimeTaskValue(String key, int defaultValue) {
        int ret = defaultValue;
        try {
            int value;
            String poolSize = IReportConfigUtil.getInstance().getConfig(key);
            if (poolSize != null && (value = Integer.parseInt(poolSize)) > 0) {
                ret = value;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Configure parameters item with error,will use default value:" + e.getMessage()));
        }
        return ret;
    }

    public static IRTimeTaskMgr getInstance() {
        return timeTaskMgr;
    }

    public boolean initAllTasks() {
        boolean blOk = false;
        try {
            this.initAllTimeTasks();
            LOGGER.info((Object)"Init all time tasks OK......");
            this.timeTaskThreadPool.start();
            LOGGER.info((Object)"Start time task thread successful......");
            blOk = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Init time task list failed:" + e.getMessage()));
        }
        return blOk;
    }

    public boolean destroyTimeTaskThread() {
        boolean blOk = false;
        try {
            this.timeTaskThreadPool.stopTimeTaskThread();
            blOk = true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Init time task list failed:" + e.getMessage()));
        }
        return blOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeTask(TimeTask timeTask) {
        if (null != timeTask) {
            this.allTaskLock.lock();
            try {
                LOGGER.info((Object)("start addTimeTask, timeTask=" + timeTask.toString()));
                long sTime = 0L;
                long eTime = 0L;
                sTime = timeTask.getStartDate() * 1000L;
                eTime = timeTask.getEndDate() * 1000L;
                long nextTime = IReportMgrUtil.getTaskNextRunTime(timeTask.getSchedule(), timeTask.getRunTime(), sTime, eTime);
                this.updateTimeTaskList(timeTask, nextTime);
            }
            finally {
                this.allTaskLock.unlock();
            }
        }
    }

    public void delTimeTask(Integer taskId) {
        if (null != taskId) {
            try {
                this.allTaskLock.lock();
                myTimeTaskList.remove(taskId);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Delte time task error:" + e.getMessage()));
            }
            finally {
                this.allTaskLock.unlock();
            }
        }
    }

    private void initAllTimeTasks() {
        List<TimeTask> timeTaskList = this.timeTaskService.getTaskByState(1);
        long nextRunTime = 0L;
        long sTime = 0L;
        long eTime = 0L;
        for (TimeTask timeTask : timeTaskList) {
            sTime = timeTask.getStartDate() * 1000L;
            eTime = timeTask.getEndDate() * 1000L;
            nextRunTime = IReportMgrUtil.getTaskNextRunTime(timeTask.getSchedule(), timeTask.getRunTime(), sTime, eTime);
            this.updateTimeTaskList(timeTask, nextRunTime);
        }
    }

    private String updateTimeTaskList(TimeTask timeTask, long nextTimeValue) {
        String ret = null;
        int taskId = timeTask.getTaskId();
        if (nextTimeValue <= 0L) {
            ret = this.timeTaskService.updateTaskState(taskId) ? "The task:" + timeTask.getTaskName() + " next running time is NOT within lifecycle, can not be executed!" : "Update task:" + timeTask.getTaskName() + " status failed!";
        } else {
            try {
                timeTask.setNextRunTime(nextTimeValue);
                myTimeTaskList.put(taskId, timeTask);
            }
            catch (Exception e) {
                ret = "Update time task list error!";
                LOGGER.error((Object)(ret + e.getMessage()));
            }
        }
        if (null == ret) {
            LOGGER.info((Object)"updateTimeTaskList sucess");
        } else {
            LOGGER.info((Object)("updateTimeTaskList end for ret=" + ret));
        }
        return ret;
    }

    private class TimeTaskThreadPool
    extends Thread {
        private boolean bRunFlag;
        private int loopint;

        public TimeTaskThreadPool(int loopInt) {
            super("timeTaskMonitor");
            this.bRunFlag = true;
            this.loopint = 2000;
            this.loopint = loopInt;
        }

        public void stopTimeTaskThread() {
            this.bRunFlag = false;
            IRTimeTaskMgr.this.threadPoolExecutor.shutdown();
        }

        @Override
        public void run() {
            LOGGER.info((Object)"TimeTaskThreadPool thread start");
            while (this.bRunFlag) {
                try {
                    this.loopTimeTaskList();
                    Thread.sleep(this.loopint);
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.error((Object)"error with sleep");
                    }
                    LOGGER.error((Object)("Loop and running time task failed:" + e.getMessage()));
                }
            }
        }

        private void loopTimeTaskList() {
            Calendar cal = Calendar.getInstance();
            if (IReportMgrUtil.isIntMultipleWithFive(cal)) {
                long sysCurTime = cal.getTimeInMillis();
                Set tempTaskList = myTimeTaskList.entrySet();
                for (Map.Entry<Integer, TimeTask> entry : tempTaskList) {
                    this.compareAndDealTask(entry, sysCurTime);
                }
            }
        }

        private void compareAndDealTask(Map.Entry<Integer, TimeTask> executeTask, long sysCurTime) {
            TimeTask myTask = null;
            myTask = executeTask.getValue();
            long nextTime = myTask.getNextRunTime();
            int taskId = executeTask.getKey();
            if (sysCurTime >= nextTime) {
                this.executeTask(myTask);
                this.getAndUpdateTaskTime(myTask, taskId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getAndUpdateTaskTime(TimeTask myTask, int taskId) {
            long newNextTime = 0L;
            long sTime = myTask.getStartDate() * 1000L;
            long eTime = myTask.getEndDate() * 1000L;
            newNextTime = IReportMgrUtil.getTaskNextRunTime(myTask.getSchedule(), myTask.getRunTime(), sTime, eTime);
            try {
                IRTimeTaskMgr.this.allTaskLock.lock();
                if (newNextTime > 0L) {
                    myTask.setNextRunTime(newNextTime);
                    myTimeTaskList.put(taskId, myTask);
                    LOGGER.info((Object)("getAndUpdateTaskTime put => " + myTask.toString()));
                } else {
                    myTimeTaskList.remove(taskId);
                    LOGGER.info((Object)("getAndUpdateTaskTime remove => " + myTask.toString()));
                    if (!IRTimeTaskMgr.this.timeTaskService.updateTaskState(taskId)) {
                        LOGGER.error((Object)("Time task id:" + taskId + " overdue,but modified state value failed!"));
                    }
                }
            }
            finally {
                IRTimeTaskMgr.this.allTaskLock.unlock();
            }
        }

        private void executeTask(TimeTask myTask) {
            try {
                Calendar cal = Calendar.getInstance();
                LOGGER.info((Object)("start executeTask=" + myTask.toString() + "; cal=" + cal.getTime().toString()));
                IRTimeTaskMgr.this.threadPoolExecutor.execute(new ThreadPoolTask(myTask, cal));
                LOGGER.info((Object)("end executeTask=" + myTask.toString()));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Put task(" + myTask.getTaskId() + ")to threadPool for running failed:" + e.getMessage()));
            }
        }
    }
}

