/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.task;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.model.vo.SysOptLog;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.task.TimeTaskExportReport;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportLogManager;
import com.security.ireport.util.IReportMgrUtil;
import java.text.Normalizer;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ThreadPoolTask
implements Runnable {
    private static final long D_1000_L = 1000L;
    private static final int OPERATE_RESULT_OK = 0;
    private static final int OPERATE_RESULT_FAIL = -1;
    private static final transient Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private TimeTask myTimeTask = null;
    private String taskName = null;
    private Calendar cal;

    public ThreadPoolTask(TimeTask task, Calendar cal) {
        this.myTimeTask = task;
        this.cal = cal;
        this.taskName = task.getTaskName();
    }

    @Override
    public void run() {
        try {
            TimeTaskExportReport timeTaskExportReport = new TimeTaskExportReport(this.myTimeTask, this.cal);
            if (!timeTaskExportReport.isNeedHandle()) {
                return;
            }
            int level = 3;
            long startTime = IReportMgrUtil.getCurrentTimeMill();
            List<String[]> detail = timeTaskExportReport.exportToReportFile();
            if (IReportConfCheckUtil.isListEmpty(detail)) {
                String[] para01 = new String[]{this.taskName, String.valueOf(IReportMgrUtil.getCurrentTimeMill() - startTime)};
                this.writeOperateLog("time.task.run.havafinished", 0, level, para01);
            } else {
                this.writeOperateLog(detail, level);
            }
            timeTaskExportReport.sendEmail();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Time task export report file failed:" + e.getMessage()));
        }
        try {
            int sleepTime = IReportConfigUtil.getInstance().getIntValue("task.sleeptime", 5);
            Thread.sleep((long)sleepTime * 1000L);
        }
        catch (Exception e) {
            LOGGER.error((Object)("sleep failed:" + e.getMessage()));
        }
    }

    private void writeOperateLog(List<String[]> errorLogInfoList, int level) {
        block0: {
            Iterator<String[]> iterator = errorLogInfoList.iterator();
            if (!iterator.hasNext()) break block0;
            String[] errorLog = iterator.next();
            String[] reportfailerpara = new String[]{this.taskName};
            String failerreason = null;
            failerreason = "1".equals(errorLog[1]) ? "ireport.becauseof.create.report.failer" : ("2".equals(errorLog[1]) ? "ireport.becauseof.data.prepare.failer" : ("3".equals(errorLog[1]) ? "ireport.becauseof.canget.plugin.failer" : "ireport.becauseof.other.reason.failer"));
            this.writeOperateLog(failerreason, -1, level, reportfailerpara);
        }
    }

    private void writeOperateLog(String result, int optResult, int level, String[] para) {
        SysOptLog optLog = new SysOptLog();
        optLog.setDate(new Date());
        String taskId = String.valueOf(this.myTimeTask.getTaskId());
        taskId = Normalizer.normalize(taskId, Normalizer.Form.NFKC);
        if (taskId.matches("1|2|3|4")) {
            optLog.setOperator("system");
        } else {
            optLog.setOperator(this.myTimeTask.getUserName());
        }
        optLog.setModule("time.task.module");
        optLog.setOperation("time.task.operation");
        optLog.setDetail(result);
        optLog.setResult(optResult);
        optLog.setTarget(this.myTimeTask.getTaskName());
        optLog.setLevel(level);
        optLog.setDetailPara(para);
        IReportLogManager.getInstance().printSysLog(optLog);
    }
}

