/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.task;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AESUtil;
import com.security.ireport.engine.PluginManager;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.definition.IReport;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.engine.output.ExportReport;
import com.security.ireport.model.vo.CreateReportResult;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.model.vo.OperateResult;
import com.security.ireport.model.vo.TaskCondition;
import com.security.ireport.model.vo.TaskLog;
import com.security.ireport.model.vo.TemplateCondition;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.service.IReportProductAdapter;
import com.security.ireport.service.ReportTemplateService;
import com.security.ireport.service.ResultReportService;
import com.security.ireport.service.TimeTaskService;
import com.security.ireport.service.impl.ReportTemplateServiceImpl;
import com.security.ireport.service.impl.ResultReportServiceImpl;
import com.security.ireport.service.impl.TimeTaskServiceImpl;
import com.security.ireport.task.VsmTimerNameAdapter;
import com.security.ireport.task.adapter.ITimerNameAdapter;
import com.security.ireport.util.IReportConfCheckUtil;
import com.security.ireport.util.IReportConfigUtil;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.IReportUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.LocaleUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.io.File;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TimeTaskExportReport {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static IReportProductAdapter adapter = null;
    private static String adapterClassName = IReportConfigUtil.getInstance().getConfig("adapterClassName");
    private List<String> pluginIdList = new ArrayList<String>();
    private List<String> exportFileTypeList = new ArrayList<String>();
    private List<Integer> templateIdList = new ArrayList<Integer>();
    private Object[] templateConditionListArray = null;
    private boolean needHandle = true;
    private List<Integer> conditionIdList = new ArrayList<Integer>();
    private List<String> pluginConList = new ArrayList<String>();
    private transient TimeTaskService timeTaskService = new TimeTaskServiceImpl();
    private transient ResultReportService resultReportService = new ResultReportServiceImpl();
    private transient ReportTemplateService reportTemplateService = new ReportTemplateServiceImpl();
    private List<Object[]> sendMailList = new ArrayList<Object[]>();
    private ITimerNameAdapter vsmTimeNameAdapter = new VsmTimerNameAdapter();
    private Locale locale = null;
    private int taskId;
    private String exportFilePath;
    private String taskLocaleLang = "en";
    private TimeTask myTimeTask = null;
    private Calendar cal;

    public TimeTaskExportReport(TimeTask myTimeTask, Calendar cal) {
        this.myTimeTask = myTimeTask;
        this.cal = cal;
        if (myTimeTask.getTaskId() != null) {
            this.initTaskBaseInfo();
        }
    }

    public TimeTaskExportReport() {
        this.exportFilePath = IReportMgrUtil.getExportPath();
    }

    private void getAllTaskConditions(int tId) {
        this.pluginIdList.clear();
        this.pluginConList.clear();
        this.templateIdList.clear();
        try {
            List<TaskCondition> taskConList = this.timeTaskService.getTaskCondition(tId);
            this.getTaskConditionList(taskConList);
            this.setTemplateConditionListArray(taskConList);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"Get all task conditions error");
        }
    }

    public boolean isNeedHandle() {
        return this.needHandle;
    }

    private void setTemplateConditionListArray(List<TaskCondition> taskConditionList) {
        if (null != taskConditionList) {
            TaskCondition taskCondition = null;
            Integer tmpId = null;
            this.templateConditionListArray = new Object[taskConditionList.size()];
            List<TemplateCondition> templateConditionList = null;
            int n = taskConditionList.size();
            for (int index = 0; index < n; ++index) {
                taskCondition = taskConditionList.get(index);
                tmpId = taskCondition.getTemplateId();
                if (null == tmpId || 0 == tmpId) {
                    this.templateConditionListArray[index] = null;
                    continue;
                }
                try {
                    templateConditionList = this.reportTemplateService.getConditionByTemId("" + tmpId);
                    if (null == templateConditionList || templateConditionList.isEmpty()) {
                        this.needHandle = false;
                        break;
                    }
                    this.templateConditionListArray[index] = templateConditionList;
                    continue;
                }
                catch (SQLException e) {
                    LOGGER.error((Object)("get template condition fail:" + tmpId));
                    this.templateConditionListArray[index] = new ArrayList();
                }
            }
        }
    }

    private void getTaskConditionList(List<TaskCondition> taskConList) {
        if (null != taskConList) {
            Integer tmpId = null;
            for (TaskCondition taskCond : taskConList) {
                this.pluginIdList.add(taskCond.getReportId());
                this.pluginConList.add(taskCond.getReportCondition());
                this.conditionIdList.add(taskCond.getPkId());
                tmpId = taskCond.getTemplateId();
                if (null == tmpId || 0 == tmpId) {
                    this.templateIdList.add(0);
                    continue;
                }
                this.templateIdList.add(tmpId);
            }
        }
    }

    private void initTaskBaseInfo() {
        try {
            this.taskId = this.myTimeTask.getTaskId();
            String fileTypes = this.myTimeTask.getResultType();
            if (null != fileTypes && !fileTypes.equals("")) {
                this.exportFileTypeList = IReportMgrUtil.getList(fileTypes, ",");
            }
            this.getAllTaskConditions(this.taskId);
            if (this.pluginConList != null && this.myTimeTask.getSchedule() != 5) {
                this.pluginConList = IReportMgrUtil.changCondition(this.pluginConList, this.myTimeTask.getSchedule(), this.cal);
            }
            this.taskLocaleLang = this.myTimeTask.getLocale();
            if (null == this.taskLocaleLang) {
                this.taskLocaleLang = "en";
            }
            this.locale = this.getLocale(this.taskLocaleLang);
            this.exportFilePath = IReportMgrUtil.getExportPath();
        }
        catch (ParaException e) {
            LOGGER.error((Object)("Get time task base information failed,may task id:" + this.taskId + " has been deleted!"));
        }
    }

    private Locale getLocale(String curLang) {
        Locale ret = null;
        String normalizeCurLang = Normalizer.normalize(curLang, Normalizer.Form.NFKC);
        if (normalizeCurLang.startsWith("zh")) {
            ret = new Locale("zh", "CN");
        } else if (normalizeCurLang.startsWith("en")) {
            ret = new Locale("en", "");
        }
        return ret;
    }

    public CreateReportResult createAndExportRptFile(String reportId, String qryCondition, List<String> exportTypeList) {
        ArrayList<String> rptIdList = new ArrayList<String>();
        rptIdList.add(reportId);
        ArrayList<String> qryCondList = new ArrayList<String>();
        qryCondList.add(qryCondition);
        Locale lang = LocaleUtil.getCurrentUserLocale();
        String reportName = IReportMgrUtil.getPluginNameFromProperty(reportId, Locale.ENGLISH);
        OperateResult oprResult = this.createReportTypeFile(reportName, rptIdList, qryCondList, lang, exportTypeList, this.genUuid());
        CreateReportResult createRptResult = new CreateReportResult();
        createRptResult.setResult(oprResult.isResult());
        createRptResult.setResultInfo(oprResult.getResultInfo());
        return createRptResult;
    }

    private CreateReportResult emptyResult() {
        CreateReportResult createRptResult = new CreateReportResult();
        String retInfo = LocaleUtil.getProperty("time.task.import.param.null");
        createRptResult.setResult(Boolean.FALSE);
        createRptResult.setResultInfo(retInfo);
        return createRptResult;
    }

    public CreateReportResult createAndExportRptFile(String reportName, List<String> reportIdList, List<String> conditionList, List<String> exportTypeList) {
        CreateReportResult createRptResult = new CreateReportResult();
        if (null == reportName || reportName.isEmpty()) {
            return this.emptyResult();
        }
        if (null == reportIdList || reportIdList.isEmpty()) {
            return this.emptyResult();
        }
        if (null == conditionList || conditionList.isEmpty()) {
            return this.emptyResult();
        }
        if (null == exportTypeList || exportTypeList.isEmpty()) {
            return this.emptyResult();
        }
        Locale lang = LocaleUtil.getCurrentUserLocale();
        OperateResult oprResult = this.createReportTypeFile(reportName, reportIdList, conditionList, lang, exportTypeList, this.genUuid());
        createRptResult.setResult(oprResult.isResult());
        createRptResult.setResultInfo(oprResult.getResultInfo());
        return createRptResult;
    }

    public List<String[]> exportToReportFile() throws ParaException {
        List<String[]> result = null;
        result = null != this.pluginIdList && null != this.pluginConList && null != this.exportFileTypeList && !this.pluginIdList.isEmpty() && !this.pluginConList.isEmpty() && !this.exportFileTypeList.isEmpty() ? this.createReportFile(this.pluginIdList, this.pluginConList, this.exportFileTypeList, this.conditionIdList, this.locale, this.myTimeTask.getSchedule()) : new ArrayList<String[]>();
        return result;
    }

    public void sendEmail() {
        if (null != this.sendMailList && this.sendMailList.size() > 0) {
            for (Object[] mailInfo : this.sendMailList) {
                try {
                    adapter.notifyReport((String)mailInfo[0], (Integer)mailInfo[1], (Integer)mailInfo[2], (String)mailInfo[3], null == mailInfo[4] ? null : (String)mailInfo[4]);
                    LOGGER.debug((Object)"Send email \u2026\u2026");
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Send email fail: " + e.getMessage()));
                }
            }
        }
    }

    public long exportToSigReportFile(long sessionId, String resultPath, String pathTime) throws ParaException {
        this.exportFileTypeList = IReportMgrUtil.getList(this.myTimeTask.getResultType(), ",");
        Locale localeNew = new Locale(this.myTimeTask.getLocale());
        this.exportFilePath = resultPath;
        return this.createFileForSig(this.myTimeTask.getReportId(), this.myTimeTask.getCondition(), this.exportFileTypeList, localeNew, sessionId, resultPath, pathTime);
    }

    private List<String[]> createReportFile(List<String> reportIdList, List<String> conditionList, List<String> exportTypeList, List<Integer> conditionIdListNew, Locale lang, int schedule) throws ParaException {
        int i = 0;
        ArrayList<String[]> executeList = new ArrayList<String[]>();
        String[] tempStrs = null;
        String resultStr = null;
        for (String pluginId : reportIdList) {
            resultStr = this.createFile(i, pluginId, exportTypeList, conditionList, conditionIdListNew, lang, schedule);
            ++i;
            if (null == resultStr || resultStr.trim().length() == 0) continue;
            tempStrs = new String[]{pluginId, resultStr};
            executeList.add(tempStrs);
        }
        return executeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createFileForSig(String reportId, String reportCondition, List<String> exportFileTypeListNew, Locale localeNew, long sessionId, String resultPath, String pathTime) throws ParaException {
        long result = 0L;
        Map<String, JsonValueObj> reportCond = null;
        ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
        ReportSession reportSession = null;
        ExportReport exportReport = null;
        OperateResult optResult = null;
        String reportName = "";
        if (null != reportCondition && !reportCondition.equals("")) {
            reportCond = JSONUtil.transformKeyValueObjMap(reportCondition);
        }
        try {
            reportSession = ReportSessionManager.getInstance().getSessionBySessionId(sessionId, "iReportSessionId");
            if (null != reportCond) {
                IReport tempIreport;
                reportSession.prepare(reportCond, false);
                reportSession.setJsonValueStr(reportCondition);
                reportSession.prepareJasper();
                reportSessionList.add(reportSession);
                exportReport = new ExportReport(reportSessionList, null, null);
                if (reportId != null && null != (tempIreport = PluginManager.getInstance().getReportPlugin(this.myTimeTask.getReportId()))) {
                    reportName = IReportUtil.getProperty(tempIreport.getName(), this.myTimeTask.getReportId(), localeNew);
                }
                this.changeExportForSig(exportFileTypeListNew);
                optResult = this.exportToFileForSig(exportReport, exportFileTypeListNew, reportName, resultPath, pathTime);
            }
        }
        catch (Exception e) {
            String rt = "Create report session failed!";
            LOGGER.error((Object)(rt + e.getMessage()));
        }
        finally {
            if (null != reportSession) {
                reportSession.clean();
            }
        }
        if (optResult != null && optResult.isResult()) {
            result = Long.parseLong(optResult.getObjName());
        }
        return result;
    }

    private void changeExportForSig(List<String> exportFileTypeListNew) {
        for (int i = 0; i < exportFileTypeListNew.size(); ++i) {
            if ("3".equals(exportFileTypeListNew.get(i))) {
                exportFileTypeListNew.set(i, "pdf");
                continue;
            }
            if (!"4".equals(exportFileTypeListNew.get(i))) continue;
            exportFileTypeListNew.set(i, "csv");
        }
    }

    private String createFile(int i, String pluginId, List<String> exportTypeList, List<String> conditionList, List<Integer> conditionIdListNew, Locale lang, int schedule) throws ParaException {
        OperateResult operateResult = null;
        String ret = "";
        ArrayList<String> commonIdList = new ArrayList<String>();
        List<String> commonConditionList = new ArrayList<String>();
        long startTime = IReportMgrUtil.getCurrentTimeMill();
        Integer templateId = this.templateIdList.get(i);
        if (0 == templateId) {
            commonIdList.clear();
            commonConditionList.clear();
            commonIdList.add(pluginId);
            commonConditionList.add(conditionList.get(i));
            LOGGER.info((Object)"start to exportToFileAndWriteLog");
            ret = this.exportToFileAndWriteLog(pluginId, lang, commonIdList, commonConditionList, conditionIdListNew.get(i), exportTypeList, startTime);
            LOGGER.info((Object)"end to exportToFileAndWriteLog.");
        } else {
            List templateConditionList;
            String templateName = "";
            String tmpName = "";
            try {
                templateConditionList = (List)this.templateConditionListArray[i];
                templateName = IReportMgrUtil.getReportNameFromTemplate();
                tmpName = this.reportTemplateService.getTemNameByTemId(templateId);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"Get template name with id failed");
                ret = LocaleUtil.getProperty("error.createReportFail");
                return ret;
            }
            for (TemplateCondition tem : templateConditionList) {
                commonIdList.add(tem.getReportId());
                commonConditionList.add(tem.getReportCondition());
            }
            if (schedule != 5) {
                commonConditionList = IReportMgrUtil.changCondition(commonConditionList, schedule, this.cal);
            }
            String productName = IReportConfigUtil.getInstance().getProductName();
            templateName = this.getTemplateNameForProduct(tmpName, templateName, schedule, commonConditionList);
            LOGGER.info((Object)"start to createReportTypeFile");
            operateResult = this.createReportTypeFile(templateName, commonIdList, commonConditionList, lang, exportTypeList, this.genUuid());
            LOGGER.info((Object)"end to createReportTypeFile. ");
            TaskLog timeTaskLog = null;
            timeTaskLog = new TaskLog();
            if ("VSM V2".equalsIgnoreCase(productName)) {
                timeTaskLog.setReportName(templateName);
            } else {
                timeTaskLog.setReportName(tmpName);
            }
            timeTaskLog.setRunTime(startTime / 1000L);
            timeTaskLog.setEndTime(IReportMgrUtil.getCurrentTimeMill() / 1000L);
            timeTaskLog.setTaskId(this.taskId);
            timeTaskLog.setAuthId(this.myTimeTask.getAuthId());
            timeTaskLog.setUserName(this.myTimeTask.getUserName());
            timeTaskLog.setConditionId(conditionIdListNew.get(i));
            if (operateResult.isResult()) {
                timeTaskLog.setResultFile(operateResult.getResultInfo());
                timeTaskLog.setResultInfo("0");
                ret = "";
            } else {
                timeTaskLog.setResultFile("");
                timeTaskLog.setResultInfo(operateResult.getResultInfo());
                ret = "1";
            }
            timeTaskLog.setSchedule(this.myTimeTask.getSchedule());
            LOGGER.info((Object)"start to saveLogToDBFile ");
            this.resultReportService.saveLogToDBFile(timeTaskLog);
            LOGGER.info((Object)"end to saveLogToDBFile ");
            try {
                if (!"1".equals(ret)) {
                    String suffix = null != timeTaskLog.getResultFile() && timeTaskLog.getResultFile().contains(".") ? timeTaskLog.getResultFile().substring(timeTaskLog.getResultFile().lastIndexOf(".")) : ".zip";
                    this.makeUpMail(this.myTimeTask.getAuthId(), this.taskId, conditionIdListNew.get(i), timeTaskLog.getResultFile(), null == timeTaskLog.getReportName() ? timeTaskLog.getResultFile() : timeTaskLog.getReportName() + suffix);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Send email fail: " + e.getMessage()));
                ret = LocaleUtil.getProperty("error.sendEmailFail");
                return ret;
            }
        }
        return ret;
    }

    private String getTemplateNameForProduct(String tmpName, String templateName, int schedule, List<String> commonConditionList) throws ParaException {
        String productName = IReportConfigUtil.getInstance().getProductName();
        if ("VSM V2".equalsIgnoreCase(productName)) {
            Map<Object, Object> reportCond = null;
            ITimerNameAdapter tempTimeNameAdapter = ProductFaceUtil.getInstance().getTimerNameAdapter();
            if (null == tempTimeNameAdapter) {
                tempTimeNameAdapter = this.vsmTimeNameAdapter;
            } else {
                reportCond = !commonConditionList.isEmpty() ? JSONUtil.transformKeyValueObjMap(commonConditionList.get(0)) : new HashMap();
            }
            if (tempTimeNameAdapter.useTimeTaskTemplateName()) {
                templateName = tmpName;
            }
            templateName = templateName + tempTimeNameAdapter.productTimeName(this.locale, schedule, this.cal, reportCond);
        }
        return templateName;
    }

    private String exportToFileAndWriteLog(String pluginId, Locale lang, List<String> commonIdList, List<String> commonConditionList, Integer commonConditionId, List<String> exportTypeList, long startTime) {
        OperateResult operateResult = null;
        String ret = "";
        String reportName = IReportMgrUtil.getPluginNameFromProperty(pluginId, Locale.ENGLISH);
        String tmpName = IReportMgrUtil.getPluginNameFromProperty(pluginId, lang);
        TaskLog timeTaskLog = null;
        timeTaskLog = new TaskLog();
        timeTaskLog.setReportName(tmpName);
        timeTaskLog.setRunTime(startTime / 1000L);
        timeTaskLog.setTaskId(this.taskId);
        timeTaskLog.setAuthId(this.myTimeTask.getAuthId());
        timeTaskLog.setUserName(this.myTimeTask.getUserName());
        timeTaskLog.setConditionId(commonConditionId);
        if (IReportConfCheckUtil.isStringEmpty(reportName)) {
            ret = "Can not get plugin Id:" + pluginId + " name normaly,so can not export file!";
            timeTaskLog.setResultFile("");
            timeTaskLog.setResultInfo(ret);
            timeTaskLog.setSchedule(this.myTimeTask.getSchedule());
            this.resultReportService.saveLogToDBFile(timeTaskLog);
            return "3";
        }
        operateResult = this.createReportTypeFile(reportName, commonIdList, commonConditionList, lang, exportTypeList, this.genUuid());
        if (operateResult.isResult()) {
            timeTaskLog.setResultFile(operateResult.getResultInfo());
            timeTaskLog.setResultInfo("0");
            ret = "";
        } else {
            timeTaskLog.setResultFile("");
            timeTaskLog.setResultInfo(operateResult.getResultInfo());
            ret = "2";
        }
        timeTaskLog.setEndTime(IReportMgrUtil.getCurrentTimeMill() / 1000L);
        this.resultReportService.saveLogToDBFile(timeTaskLog);
        try {
            if (!"2".equals(ret)) {
                String suffix = null != timeTaskLog.getResultFile() && timeTaskLog.getResultFile().contains(".") ? timeTaskLog.getResultFile().substring(timeTaskLog.getResultFile().lastIndexOf(".")) : ".zip";
                this.makeUpMail(this.myTimeTask.getAuthId(), this.taskId, commonConditionId, timeTaskLog.getResultFile(), null == timeTaskLog.getReportName() ? timeTaskLog.getResultFile() : timeTaskLog.getReportName() + suffix);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Send email fail: " + e.getMessage()));
            ret = LocaleUtil.getProperty("error.sendEmailFail");
            return ret;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperateResult createReportTypeFile(String reportName, List<String> reportIdList, List<String> conditionStrList, Locale lang, List<String> exportTypeList, String securityUUID) {
        OperateResult operateResult = null;
        String ret = "";
        ArrayList<ReportSession> reportSessionList = new ArrayList<ReportSession>();
        try {
            Object exportReport = null;
            Map<String, JsonValueObj> reportCond = null;
            boolean status = true;
            int i = 0;
            for (String reportId : reportIdList) {
                if (null != conditionStrList.get(i) && !conditionStrList.get(i).equals("")) {
                    reportCond = JSONUtil.transformKeyValueObjMap(conditionStrList.get(i));
                }
                JsonValueObj tempJsonObj = new JsonValueObj("", this.locale.toString(), this.locale.toString());
                tempJsonObj.setShowInfo("false");
                if (null != reportCond) {
                    reportCond.put("ireportTaskLocale", tempJsonObj);
                    ReportSession reportSession = ReportSessionManager.getInstance().createReportSession(reportId, null, lang);
                    if (null != reportSession) {
                        status = reportSession.prepare(reportCond, true);
                        reportSession.setJsonValueStr(conditionStrList.get(i));
                        reportSession.prepareJasper();
                        reportSession.setLocale(this.locale);
                        if (!status) break;
                        reportSessionList.add(reportSession);
                    }
                }
                ++i;
            }
            if (!status) {
                ret = "Prepare data with query condition is failed!";
                LOGGER.error((Object)ret);
                ret = LocaleUtil.getProperty("time.task.prepare.data.fail");
                operateResult = IReportMgrUtil.getOperateResult(reportName, reportName, Boolean.FALSE, ret);
                OperateResult operateResult2 = operateResult;
                return operateResult2;
            }
            exportReport = new ExportReport(reportSessionList, null, null);
            operateResult = this.exportToFile((ExportReport)exportReport, exportTypeList, reportName, securityUUID);
        }
        catch (Exception e) {
            String rt = "Create report session failed!";
            LOGGER.error((Object)(rt + e.getMessage()));
            OperateResult operateResult3 = operateResult = IReportMgrUtil.getOperateResult(reportName, reportName, Boolean.FALSE, LocaleUtil.getProperty("error.createReportFail"));
            return operateResult3;
        }
        finally {
            if (!reportSessionList.isEmpty()) {
                for (ReportSession item : reportSessionList) {
                    item.clean();
                }
            }
        }
        return operateResult;
    }

    private OperateResult exportToFile(ExportReport exportReport, List<String> exportTypeList, String reportName, String securityUUID) {
        OperateResult operateResult = null;
        String rtn = "";
        String filePath = null;
        String fileName = null;
        String rptName = "";
        StringBuffer sbf = new StringBuffer();
        String pathTime = String.valueOf(IReportMgrUtil.getCurrentTimeMill());
        String reportReplacedName = IReportMgrUtil.replaceAllBlank(reportName);
        String productName = IReportConfigUtil.getInstance().getProductName();
        String rptReplacedName = null;
        if ("ATIC".equalsIgnoreCase(productName)) {
            rptReplacedName = rptName = this.myTimeTask.getTaskName() + "_" + IReportUtil.transTimeStr(IReportMgrUtil.getCurrentTimeMill(), "yyyy-MM-dd-HH-mm-ss") + "_" + this.taskId;
        } else if ("VSM V2".equalsIgnoreCase(productName)) {
            rptReplacedName = reportReplacedName;
            rptName = reportName;
        } else {
            rptReplacedName = reportReplacedName + pathTime + this.taskId;
            rptName = reportName + pathTime + this.taskId;
        }
        filePath = this.exportFilePath + File.separator + rptReplacedName + File.separator;
        if (!IReportMgrUtil.createExportPath(filePath)) {
            LOGGER.error((Object)("createExportPath error: " + rptName));
            rtn = LocaleUtil.getProperty("time.task.create.path") + ":" + filePath + LocaleUtil.getProperty("time.task.create.path.fail") + ";";
            sbf.append(rtn);
            operateResult = IReportMgrUtil.getOperateResult(reportName, reportName, Boolean.FALSE, sbf.toString());
            return operateResult;
        }
        boolean createFileOk = true;
        for (String exportType : exportTypeList) {
            fileName = rptName + this.getSuffixName(exportType);
            LOGGER.info((Object)("start to  timeExport: " + fileName));
            rtn = exportReport.timeExport(exportType, filePath, fileName);
            LOGGER.info((Object)("end to  timeExport: " + fileName));
            if (IReportConfCheckUtil.isStringEmpty(rtn)) continue;
            LOGGER.error((Object)("Create " + fileName + " report file failed:" + rtn));
            rtn = LocaleUtil.getProperty("time.task.export.to.file") + ":" + exportType + LocaleUtil.getProperty("time.task.export.file.fail") + ";";
            sbf.append(rtn);
            createFileOk = false;
            break;
        }
        if (!createFileOk) {
            IReportUtil.deleteDirectory(filePath);
            operateResult = IReportMgrUtil.getOperateResult(reportName, reportName, Boolean.FALSE, rtn);
            return operateResult;
        }
        rtn = IReportMgrUtil.exportToZipFile(this.exportFilePath + File.separator, rptReplacedName, securityUUID);
        if (!IReportConfCheckUtil.isStringEmpty(rtn)) {
            sbf.append(rtn);
            operateResult = IReportMgrUtil.getOperateResult(reportName, reportName, Boolean.FALSE, sbf.toString());
        } else {
            operateResult = IReportMgrUtil.getOperateResult("", "", Boolean.TRUE, rptReplacedName + "_" + securityUUID + ".zip");
        }
        return operateResult;
    }

    private OperateResult exportToFileForSig(ExportReport exportReport, List<String> exportTypeList, String reportName, String resultPath, String pathTime) {
        OperateResult operateResult = null;
        String rtn = "";
        String filePath = null;
        String fileName = null;
        String rptName = "";
        StringBuffer sbf = new StringBuffer();
        String reportReplacedName = IReportMgrUtil.replaceAllBlank(reportName);
        String rptReplacedName = reportReplacedName + "_" + pathTime;
        rptName = reportName + "_" + pathTime;
        filePath = resultPath + rptReplacedName + File.separator;
        if (!IReportMgrUtil.createExportPath(filePath)) {
            rtn = LocaleUtil.getProperty("time.task.create.path") + ":" + filePath + LocaleUtil.getProperty("time.task.create.path.fail") + ";";
            sbf.append(rtn);
            operateResult = IReportMgrUtil.getOperateResult(reportName, rptName, Boolean.FALSE, sbf.toString());
            return operateResult;
        }
        boolean createFileOk = true;
        for (String exportType : exportTypeList) {
            rtn = exportReport.timeExport(exportType, filePath, fileName = rptName + this.getSuffixName(exportType));
            if (IReportConfCheckUtil.isStringEmpty(rtn)) continue;
            LOGGER.error((Object)("Create " + exportType + "report file failed:" + rtn));
            rtn = LocaleUtil.getProperty("time.task.export.to.file") + ":" + exportType + LocaleUtil.getProperty("time.task.export.file.fail") + ";";
            sbf.append(rtn);
            createFileOk = false;
            break;
        }
        if (!createFileOk) {
            IReportUtil.deleteDirectory(filePath);
            operateResult = IReportMgrUtil.getOperateResult(reportName, rptName, Boolean.FALSE, rtn);
            return operateResult;
        }
        rtn = IReportMgrUtil.exportToZipFileForSig(resultPath, rptReplacedName);
        if (!IReportConfCheckUtil.isStringEmpty(rtn)) {
            sbf.append(rtn);
            operateResult = IReportMgrUtil.getOperateResult(reportName, rptName, Boolean.FALSE, sbf.toString());
        } else {
            operateResult = IReportMgrUtil.getOperateResult(reportName, pathTime, Boolean.TRUE, rptReplacedName + ".zip");
        }
        return operateResult;
    }

    private String getSuffixName(String fileType) {
        String suffixName = "";
        suffixName = "pdf".equalsIgnoreCase(fileType) ? ".pdf" : ("excel".equalsIgnoreCase(fileType) ? ".xls" : ("html".equalsIgnoreCase(fileType) ? ".zip" : ("csv".equalsIgnoreCase(fileType) ? ".csv" : ("rtf".equalsIgnoreCase(fileType) ? ".rtf" : ""))));
        return suffixName;
    }

    public List<Integer> getConditionId() {
        return this.conditionIdList;
    }

    public void setConditionId(List<Integer> conditionId) {
        this.conditionIdList = conditionId;
    }

    private void makeUpMail(Object authId, Object taskIdNew, Object condition, Object resultFile, String reportName) {
        Object[] mailObj = new Object[]{authId, taskIdNew, condition, resultFile, reportName};
        this.sendMailList.add(mailObj);
    }

    private String genUuid() {
        byte[] bytes = new byte[37];
        SecureRandom generater = new SecureRandom();
        generater.nextBytes(bytes);
        return AESUtil.parseByte2HexStr((byte[])bytes);
    }

    static {
        try {
            adapter = (IReportProductAdapter)Class.forName(adapterClassName).newInstance();
        }
        catch (Exception e) {
            LOGGER.error((Object)("initial IReportProductAdapter fail: " + e.getMessage()));
        }
    }
}

