/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.task;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.ReportSessionManager;
import com.security.ireport.engine.exception.ParaException;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.model.vo.TimeTask;
import com.security.ireport.task.TimeTaskExportReport;
import com.security.ireport.util.IReportMgrUtil;
import com.security.ireport.util.JSONUtil;
import com.security.ireport.util.ProductFaceUtil;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;

public abstract class TimeTaskSigUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    public static long createTimeReportSession(TimeTask myTimeTask) throws ParaException {
        boolean result;
        Map<String, JsonValueObj> reportCond = null;
        String condition = IReportMgrUtil.changConditionForSig(myTimeTask.getCondition(), myTimeTask.getStartTime(), myTimeTask.getEndTime());
        if (null != myTimeTask.getCondition() && !myTimeTask.getCondition().equals("")) {
            reportCond = JSONUtil.transformKeyValueObjMap(condition);
        }
        Locale locale = new Locale(myTimeTask.getLocale());
        ReportSession reportSession = ReportSessionManager.getInstance().createReportSession(myTimeTask.getReportId(), "iReportSessionId", locale);
        if (null != reportSession && (result = reportSession.splitTask(reportCond))) {
            return reportSession.getSessionId();
        }
        return 0L;
    }

    public static boolean isPrepare(long sessionId) {
        boolean status = true;
        ReportSession reportSession = ReportSessionManager.getInstance().getSessionBySessionId(sessionId, "iReportSessionId");
        status = reportSession.isShowReport(reportSession.getParameterMap());
        return status;
    }

    public static boolean isBackTaskShowReport(String reportId, String httpSessionId, long sessionId, Map<String, JsonValueObj> condParameters) {
        ReportSession reportSession = null;
        reportSession = !ReportSessionManager.getInstance().hasReportSession(sessionId, httpSessionId) ? ReportSessionManager.getInstance().createSessionForBackTask(reportId, sessionId, httpSessionId, ProductFaceUtil.getInstance().getUserLocale()) : ReportSessionManager.getInstance().getSessionBySessionId(sessionId, "iReportSessionId");
        if (null != reportSession) {
            return reportSession.isShowReport(condParameters);
        }
        return false;
    }

    public static long execTimeReport(TimeTask myTimeTask, long sessionId, String resultPath, String pathTime) {
        long result = 0L;
        try {
            Calendar cal = Calendar.getInstance();
            TimeTaskExportReport timeTaskExportReport = new TimeTaskExportReport(myTimeTask, cal);
            result = timeTaskExportReport.exportToSigReportFile(sessionId, resultPath, pathTime);
            ReportSessionManager.getInstance().removeReportSession(sessionId, "iReportSessionId");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Time task export report file failed:" + e.getMessage()));
        }
        return result;
    }
}

