/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.ReportSession;
import com.security.ireport.engine.dataset.FieldInfo;
import com.security.ireport.engine.definition.IRColumn;
import com.security.ireport.engine.definition.IRTable;
import com.security.ireport.engine.output.SigExportOutput;
import com.security.ireport.model.vo.TableCellObj;
import com.security.ireport.model.vo.group.ExportNode;
import com.security.ireport.model.vo.group.Node;
import com.security.ireport.model.vo.group.TableCellNode;
import com.security.ireport.util.IReportConfCheckUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public final class CalculateNodeUtil {
    private static final int TABLE_CELL_NODE_CONSTANT = 0;
    private static final int EXPORT_NODE_CONSTANT = 1;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);

    private CalculateNodeUtil() {
    }

    public static List<? extends Node> getTableDataByMultiGroup(ReportSession session, IRTable iRTable, boolean isExport) {
        ArrayList<Node> dataList = new ArrayList<Node>();
        List<IRColumn> columnList = iRTable.getIRColumnList();
        List<IRColumn> validColumnList = ReportSession.getValidColumnCVSList(isExport, columnList);
        long num = session.getCurPageCount(iRTable.getDataSource());
        int index = 0;
        while ((long)index < num) {
            Object[] dataSet = CalculateNodeUtil.getTableCellByMultiGroup(session, iRTable, validColumnList, index, validColumnList.size(), iRTable.getGroupNum());
            CalculateNodeUtil.insertToNode(null, dataList, dataSet, 0, iRTable.getGroupNum(), 0);
            ++index;
        }
        if (iRTable.isTotalBarShow()) {
            TableCellNode tempTableCellNode = null;
            for (Node tempNode : dataList) {
                tempTableCellNode = (TableCellNode)tempNode;
                CalculateNodeUtil.caculateTotalBar(iRTable, tempTableCellNode, validColumnList, iRTable.getGroupNum(), 0, 0);
            }
        }
        return dataList;
    }

    public static void makeUpTableDataByMultiGroup(long recCount, List<FieldInfo> fields, ReportSession reportSession, IRTable iRTable, List<Object[]> reportData) {
        ArrayList<Node> exportNodeList = new ArrayList<Node>();
        List<IRColumn> validColumnList = ReportSession.getValidColumnList(true, iRTable.getIRColumnList());
        Object[] objs = null;
        for (long index = 0L; index < recCount; ++index) {
            objs = SigExportOutput.getResultArray(fields, reportSession, index, iRTable.getDataSource(), validColumnList, iRTable);
            CalculateNodeUtil.insertToNode(null, exportNodeList, objs, 0, iRTable.getGroupNum(), 1);
        }
        if (iRTable.isTotalBarShow()) {
            ExportNode tempExportNode = null;
            for (Node exportNode : exportNodeList) {
                tempExportNode = (ExportNode)exportNode;
                CalculateNodeUtil.caculateTotalBar(iRTable, tempExportNode, validColumnList, iRTable.getGroupNum(), 0, 1);
            }
        }
        CalculateNodeUtil.fillExportDataByGroup(iRTable, exportNodeList, reportData, iRTable.getGroupNum(), 0);
    }

    private static Object[] caculateTotalBar(IRTable iRTable, Node node, List<IRColumn> validColumnList, int totalGroupNum, int currentColumn, int nodeType) {
        if (null == node.getChildNodeList()) {
            return CalculateNodeUtil.getTotalBarValue(iRTable, node, node.getExportObjList(), validColumnList, totalGroupNum, nodeType);
        }
        List<? extends Node> childExportNodeList = node.getChildNodeList();
        int firstChildLengtht = currentColumn + 1;
        int totalChildGroupLength = totalGroupNum - firstChildLengtht;
        Object[][] childNodeArray = null;
        Object[] tempChildObjs = null;
        int nodeNum = childExportNodeList.size();
        for (int index = 0; index < nodeNum; ++index) {
            tempChildObjs = CalculateNodeUtil.caculateTotalBar(iRTable, childExportNodeList.get(index), validColumnList, totalGroupNum, currentColumn + 1, nodeType);
            if (null == childNodeArray) {
                childNodeArray = new Object[childExportNodeList.size()][tempChildObjs.length];
            }
            childNodeArray[index] = tempChildObjs;
        }
        Object[] totalBarShowData = null;
        if (null == tempChildObjs) {
            return new Object[0];
        }
        totalBarShowData = 0 == nodeType ? new Object[tempChildObjs.length + totalChildGroupLength] : (Object[])tempChildObjs.clone();
        IRColumn iRcolumn = validColumnList.get(firstChildLengtht);
        String totalExpression = iRcolumn.getTotalExpression();
        String resultStr = null;
        resultStr = null != totalExpression ? totalExpression : "";
        int startIndex = 0;
        int endIndex = 0;
        if (0 == nodeType) {
            startIndex = 0;
            endIndex = totalChildGroupLength + 1;
        } else {
            startIndex = firstChildLengtht;
            endIndex = totalGroupNum;
        }
        for (int index = startIndex; index <= endIndex; ++index) {
            totalBarShowData[index] = resultStr;
        }
        if (0 == nodeType) {
            startIndex = 1;
            endIndex = tempChildObjs.length;
        } else {
            startIndex = totalGroupNum + 1;
            endIndex = tempChildObjs.length;
        }
        int tempRowSize = 0;
        for (int index = startIndex; index < endIndex; ++index) {
            iRcolumn = 0 == nodeType ? validColumnList.get(index + totalGroupNum) : validColumnList.get(index);
            totalExpression = iRcolumn.getTotalExpression();
            if (totalExpression.contains("$P{SUM}")) {
                double sum = IReportConfCheckUtil.calcSumFunction(childNodeArray, index, iRcolumn);
                childNodeArray[0][index] = sum;
                resultStr = IReportConfCheckUtil.formatObj(sum, iRcolumn);
                resultStr = totalExpression.replace("$P{SUM}", resultStr);
            } else if (totalExpression.contains("$P{ROWCOUNT}")) {
                tempRowSize = node.getRowSize();
                if (0 == nodeType) {
                    tempRowSize = ((TableCellNode)node).getTempRowSize();
                }
                childNodeArray[0][index] = tempRowSize;
                resultStr = totalExpression.replace("$P{ROWCOUNT}", tempRowSize + "");
            } else if (totalExpression.contains("$P{AVERAGE}")) {
                double avg = CalculateNodeUtil.calcAvageFunction(childNodeArray, childExportNodeList, index, iRcolumn);
                childNodeArray[0][index] = avg;
                resultStr = IReportConfCheckUtil.formatObj(avg, iRcolumn);
                resultStr = totalExpression.replace("$P{AVERAGE}", resultStr);
            } else {
                resultStr = iRcolumn.getTotalExpression();
                childNodeArray[0][index] = resultStr;
            }
            if (0 == nodeType) {
                totalBarShowData[totalChildGroupLength + index] = resultStr;
                continue;
            }
            totalBarShowData[index] = resultStr;
        }
        node.setTotalBarShowData(totalBarShowData);
        if (0 == nodeType) {
            ((TableCellNode)node).addSize(1);
        }
        return childNodeArray[0];
    }

    private static Object[] getTableCellByMultiGroup(ReportSession session, IRTable iRTable, List<IRColumn> columnList, int row, int exportColumnSize, int totalNum) {
        Object[] resultDataSet = new Object[exportColumnSize];
        IRColumn column = null;
        Object item = null;
        TableCellNode tableCellNode = null;
        String dataText = null;
        String url = null;
        for (int j = 0; j < totalNum; ++j) {
            column = columnList.get(j);
            tableCellNode = new TableCellNode();
            item = session.getValue(iRTable.getDataSource(), row, column.getField());
            dataText = IReportConfCheckUtil.formatObj(item, column);
            url = session.createUrlText(column, iRTable.getDataSource(), row);
            tableCellNode.setDataText(dataText);
            tableCellNode.setUrlText(url);
            resultDataSet[j] = tableCellNode;
        }
        TableCellObj tableCellObj = null;
        int num = columnList.size();
        for (int j = totalNum; j < num; ++j) {
            column = columnList.get(j);
            item = IReportConfCheckUtil.isSpecialField(column.getField()) ? session.getSpecialValue(resultDataSet, column) : session.getValue(iRTable.getDataSource(), row, column.getField());
            tableCellObj = new TableCellObj();
            resultDataSet[j] = tableCellObj;
            dataText = session.handleTableImageCell(column, iRTable, item, row);
            if (null == dataText || dataText.length() == 0) {
                dataText = IReportConfCheckUtil.formatObj(item, column);
            }
            tableCellObj.setDataText(dataText);
            url = session.createUrlText(column, iRTable.getDataSource(), row);
            tableCellObj.setUrlText(url);
            tableCellObj.getDataTextList().add(tableCellObj.getDataText());
            tableCellObj.getUrlTextList().add(tableCellObj.getUrlText());
            session.setSubColumnData(column, row, iRTable, tableCellObj);
        }
        return resultDataSet;
    }

    private static double calcAvageFunction(Object[][] objects, List<? extends Node> childCellNodeList, int colNum, IRColumn columnDefine) {
        double totalDouble = 0.0;
        double totalSize = 0.0;
        try {
            boolean nodeType = false;
            if (childCellNodeList.get(0) instanceof ExportNode) {
                nodeType = true;
            }
            int tempRowSize = 0;
            for (int i = 0; i < objects.length; ++i) {
                tempRowSize = childCellNodeList.get(i).getRowSize();
                if (!nodeType) {
                    tempRowSize = ((TableCellNode)childCellNodeList.get(i)).getTempRowSize();
                }
                totalSize += (double)tempRowSize;
                totalDouble += IReportConfCheckUtil.getDoubleValue(columnDefine, String.valueOf(objects[i][colNum])) * (double)tempRowSize;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("calcuate Avage Failed!" + e.getMessage()));
        }
        if (totalSize == 0.0) {
            return 0.0;
        }
        return totalDouble / totalSize;
    }

    private static void fillExportDataByGroup(IRTable iRTable, List<? extends Node> exportNodeList, List<Object[]> reportData, int num, int currentIndex) {
        List<Object> exportObjList = null;
        Object[] childObj = null;
        ExportNode tempNode = null;
        for (Node node : exportNodeList) {
            int index;
            tempNode = (ExportNode)node;
            exportObjList = tempNode.getExportObjList();
            if (null != exportObjList && !exportObjList.isEmpty()) {
                CalculateNodeUtil.addExportData((Object[])exportObjList.get(0), reportData, tempNode, currentIndex);
                int tempNum = exportObjList.size();
                for (index = 1; index < tempNum; ++index) {
                    childObj = (Object[])exportObjList.get(index);
                    for (int i = 0; i < num; ++i) {
                        childObj[i] = "";
                    }
                    reportData.add(childObj);
                }
                continue;
            }
            if (null != tempNode.getTotalBarShowData() && !iRTable.isTotalBarDown()) {
                CalculateNodeUtil.addExportData(tempNode.getTotalBarShowData(), reportData, tempNode, currentIndex);
            }
            CalculateNodeUtil.fillExportDataByGroup(iRTable, tempNode.getChildNodeList(), reportData, num, currentIndex + 1);
            if (null == tempNode.getTotalBarShowData() || !iRTable.isTotalBarDown()) continue;
            for (index = 0; index <= currentIndex; ++index) {
                childObj = tempNode.getTotalBarShowData();
                childObj[index] = "";
            }
            reportData.add(childObj);
        }
    }

    private static void addExportData(Object[] childObj, List<Object[]> reportData, ExportNode tempNode, int currentIndex) {
        ExportNode parent = tempNode;
        int tempIndex = currentIndex;
        while (null != parent) {
            if (parent.isHasRowspan()) {
                for (int index = 0; index < tempIndex + 1; ++index) {
                    childObj[index] = "";
                }
                break;
            }
            parent.setHasRowspan(Boolean.TRUE);
            parent = (ExportNode)parent.getParent();
            --tempIndex;
        }
        reportData.add(childObj);
    }

    private static void insertToNode(Node parent, List<Node> dataList, Object[] tableCellObj, int index, int num, int nodeType) {
        Node tempNode = null;
        boolean hasContain = false;
        for (Node temp : dataList) {
            if (!temp.getDataText().equals(String.valueOf(tableCellObj[index]))) continue;
            tempNode = temp;
            hasContain = true;
            break;
        }
        if (!hasContain) {
            if (nodeType == 0) {
                tempNode = (Node)tableCellObj[index];
                dataList.add(tempNode);
            } else {
                tempNode = new ExportNode();
                tempNode.setDataText(String.valueOf(tableCellObj[index]));
                dataList.add(tempNode);
            }
            tempNode.setParent(parent);
        }
        if (index == num - 1) {
            if (nodeType == 0) {
                int newSize = tableCellObj.length - num;
                TableCellObj[] newTableCellObjs = new TableCellObj[newSize];
                System.arraycopy(tableCellObj, num, newTableCellObjs, 0, newSize);
                tempNode.addExportObj(newTableCellObjs, true, true);
            } else {
                tempNode.addExportObj(tableCellObj, true, true);
            }
            return;
        }
        if (null == tempNode.getChildNodeList()) {
            tempNode.setChildNodeList(new ArrayList<Node>());
        }
        CalculateNodeUtil.insertToNode(tempNode, tempNode.getChildNodeList(), tableCellObj, index + 1, num, nodeType);
    }

    private static Object[] getTotalBarValue(IRTable iRTable, Node tableCellNode, List<Object> exportObjList, List<IRColumn> validColumnList, int num, int nodeType) {
        int tableCellLenght = Array.getLength(exportObjList.get(0));
        Object[] tempGroupData = null;
        Object[] totalBarShowData = null;
        if (nodeType == 0) {
            totalBarShowData = new TableCellObj[tableCellLenght];
            tempGroupData = new Object[tableCellLenght];
        } else {
            totalBarShowData = (Object[])((Object[])exportObjList.get(0)).clone();
            tempGroupData = (Object[])((Object[])exportObjList.get(0)).clone();
        }
        IRColumn iRcolumn = null;
        String totalExpression = null;
        String resultStr = "";
        int startIndex = num;
        TableCellObj tempTableCellObj = null;
        if (nodeType == 0) {
            startIndex = 0;
        }
        if (startIndex >= tableCellLenght) {
            return tempGroupData;
        }
        for (int index = startIndex; index < tableCellLenght; ++index) {
            iRcolumn = nodeType == 0 ? validColumnList.get(index + num) : validColumnList.get(index);
            totalExpression = iRcolumn.getTotalExpression();
            if (null != totalExpression) {
                double sum;
                if (totalExpression.contains("$P{SUM}")) {
                    sum = IReportConfCheckUtil.calcSumFunction(exportObjList, index, iRcolumn);
                    tempGroupData[index] = sum;
                    resultStr = IReportConfCheckUtil.formatObj(sum, iRcolumn);
                    resultStr = totalExpression.replace("$P{SUM}", resultStr);
                } else if (totalExpression.contains("$P{ROWCOUNT}")) {
                    tempGroupData[index] = exportObjList.size();
                    resultStr = totalExpression.replace("$P{ROWCOUNT}", exportObjList.size() + "");
                } else if (totalExpression.contains("$P{AVERAGE}")) {
                    sum = IReportConfCheckUtil.calcSumFunction(exportObjList, index, iRcolumn);
                    double avg = sum / (double)exportObjList.size();
                    tempGroupData[index] = avg;
                    resultStr = IReportConfCheckUtil.formatObj(avg, iRcolumn);
                    resultStr = totalExpression.replace("$P{AVERAGE}", resultStr);
                } else {
                    resultStr = iRcolumn.getTotalExpression();
                    tempGroupData[index] = resultStr;
                }
            }
            if (nodeType == 0) {
                tempTableCellObj = new TableCellObj();
                tempTableCellObj.setDataText(resultStr);
                totalBarShowData[index] = tempTableCellObj;
                continue;
            }
            totalBarShowData[index] = resultStr;
        }
        if (nodeType == 0) {
            ((TableCellNode)tableCellNode).savePrivateTempRowSize();
            tableCellNode.addExportObj(totalBarShowData, iRTable.isTotalBarDown(), true);
        } else {
            tableCellNode.addExportObj(totalBarShowData, iRTable.isTotalBarDown(), false);
        }
        return tempGroupData;
    }
}

