/*
 * Decompiled with CFR 0.152.
 */
package com.security.ireport.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.util.IReportUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.ReentrantLock;

public abstract class CreateReportSessionId {
    private static final ReentrantLock LOCK = new ReentrantLock(true);
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static String filePath = IReportUtil.getRealPath() + File.separator + "WEB-INF" + File.separator + "db";
    private static String fileForId = filePath + File.separator + "sessionId";
    private static long maxId = 0L;
    private static RandomAccessFile idFile = null;

    public static long getNextSessionId() {
        LOCK.lock();
        try {
            idFile.seek(0L);
            String line = idFile.readLine();
            if (null != line) {
                maxId = Long.parseLong(line);
            }
            idFile.seek(0L);
            idFile.writeBytes(String.valueOf(maxId + 1L));
        }
        catch (IOException e) {
            LOGGER.error((Object)"create sessionId failure IOException");
            maxId = -1L;
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"create sessionId failure RuntimeException");
            maxId = -1L;
        }
        finally {
            LOCK.unlock();
        }
        return ++maxId;
    }

    static {
        try {
            boolean mkdirs;
            File path = new File(filePath);
            if (!path.exists() && !(mkdirs = path.mkdirs())) {
                LOGGER.error((Object)("mkdirs : " + mkdirs));
            }
            idFile = new RandomAccessFile(fileForId, "rws");
        }
        catch (IOException e) {
            LOGGER.error((Object)"create file failed IOException");
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)"create file failed RuntimeException");
        }
    }
}

